/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;

public class NodeKindTest
extends NodeTest {
    public static final NodeKindTest DOCUMENT = new NodeKindTest(9);
    public static final NodeKindTest ELEMENT = new NodeKindTest(1);
    public static final NodeKindTest ATTRIBUTE = new NodeKindTest(2);
    public static final NodeKindTest TEXT = new NodeKindTest(3);
    public static final NodeKindTest COMMENT = new NodeKindTest(8);
    public static final NodeKindTest PROCESSING_INSTRUCTION = new NodeKindTest(7);
    public static final NodeKindTest NAMESPACE = new NodeKindTest(13);
    private int kind;

    private NodeKindTest(int n2) {
        this.kind = n2;
    }

    public static NodeTest makeNodeKindTest(int n2) {
        switch (n2) {
            case 9: {
                return DOCUMENT;
            }
            case 1: {
                return ELEMENT;
            }
            case 2: {
                return ATTRIBUTE;
            }
            case 8: {
                return COMMENT;
            }
            case 3: {
                return TEXT;
            }
            case 7: {
                return PROCESSING_INSTRUCTION;
            }
            case 13: {
                return NAMESPACE;
            }
            case 0: {
                return AnyNodeTest.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown node kind in NodeKindTest");
    }

    public boolean matches(int n2, int n3, int n4) {
        return this.kind == n2;
    }

    public boolean matches(TinyTree tinyTree, int n2) {
        return tinyTree.getNodeKind(n2) == this.kind;
    }

    public boolean matches(NodeInfo nodeInfo) {
        return nodeInfo.getNodeKind() == this.kind;
    }

    public final double getDefaultPriority() {
        return -0.5;
    }

    public int getPrimitiveType() {
        return this.kind;
    }

    public int getNodeKindMask() {
        return 1 << this.kind;
    }

    public SchemaType getContentType() {
        switch (this.kind) {
            case 9: {
                return AnyType.getInstance();
            }
            case 1: {
                return AnyType.getInstance();
            }
        }
        return AnySimpleType.getInstance();
    }

    public AtomicType getAtomizedItemType() {
        switch (this.kind) {
            case 9: {
                return Type.UNTYPED_ATOMIC_TYPE;
            }
            case 1: {
                return Type.ANY_ATOMIC_TYPE;
            }
            case 2: {
                return Type.ANY_ATOMIC_TYPE;
            }
            case 8: {
                return Type.STRING_TYPE;
            }
            case 3: {
                return Type.UNTYPED_ATOMIC_TYPE;
            }
            case 7: {
                return Type.STRING_TYPE;
            }
            case 13: {
                return Type.STRING_TYPE;
            }
        }
        throw new AssertionError((Object)"Unknown node kind");
    }

    public String toString() {
        return NodeKindTest.toString(this.kind);
    }

    public static String toString(int n2) {
        switch (n2) {
            case 9: {
                return "document-node()";
            }
            case 1: {
                return "element()";
            }
            case 2: {
                return "attribute()";
            }
            case 8: {
                return "comment()";
            }
            case 3: {
                return "text()";
            }
            case 7: {
                return "processing-instruction()";
            }
            case 13: {
                return "namespace()";
            }
        }
        return "** error **";
    }

    public int hashCode() {
        return this.kind;
    }

    public boolean equals(Object object) {
        return object instanceof NodeKindTest && ((NodeKindTest)object).kind == this.kind;
    }
}

