/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.StandardCollationURIResolver;
import net.sf.saxon.sort.SubstringMatcher;

public class RuleBasedSubstringMatcher
implements SubstringMatcher {
    private RuleBasedCollator collator;

    public RuleBasedSubstringMatcher(RuleBasedCollator ruleBasedCollator) {
        this.collator = ruleBasedCollator;
    }

    public boolean contains(String string, String string2) {
        CollationElementIterator collationElementIterator = this.collator.getCollationElementIterator(string);
        CollationElementIterator collationElementIterator2 = this.collator.getCollationElementIterator(string2);
        return this.collationContains(collationElementIterator, collationElementIterator2, null, false);
    }

    public boolean endsWith(String string, String string2) {
        CollationElementIterator collationElementIterator = this.collator.getCollationElementIterator(string);
        CollationElementIterator collationElementIterator2 = this.collator.getCollationElementIterator(string2);
        return this.collationContains(collationElementIterator, collationElementIterator2, null, true);
    }

    public boolean startsWith(String string, String string2) {
        CollationElementIterator collationElementIterator = this.collator.getCollationElementIterator(string);
        CollationElementIterator collationElementIterator2 = this.collator.getCollationElementIterator(string2);
        return this.collationStartsWith(collationElementIterator, collationElementIterator2);
    }

    public String substringAfter(String string, String string2) {
        int[] nArray;
        CollationElementIterator collationElementIterator;
        CollationElementIterator collationElementIterator2 = this.collator.getCollationElementIterator(string);
        boolean bl = this.collationContains(collationElementIterator2, collationElementIterator = this.collator.getCollationElementIterator(string2), nArray = new int[2], false);
        if (bl) {
            return string.substring(nArray[1]);
        }
        return "";
    }

    public String substringBefore(String string, String string2) {
        int[] nArray;
        CollationElementIterator collationElementIterator;
        CollationElementIterator collationElementIterator2 = this.collator.getCollationElementIterator(string);
        boolean bl = this.collationContains(collationElementIterator2, collationElementIterator = this.collator.getCollationElementIterator(string2), nArray = new int[2], false);
        if (bl) {
            return string.substring(0, nArray[0]);
        }
        return "";
    }

    public int compare(Object object, Object object2) {
        return this.collator.compare(object, object2);
    }

    private boolean collationStartsWith(CollationElementIterator collationElementIterator, CollationElementIterator collationElementIterator2) {
        while (true) {
            int n2;
            int n3;
            if ((n3 = collationElementIterator2.next()) == 0) {
                continue;
            }
            if (n3 == -1) {
                return true;
            }
            while ((n2 = collationElementIterator.next()) == 0) {
            }
            if (n2 != n3) break;
        }
        return false;
    }

    private boolean collationContains(CollationElementIterator collationElementIterator, CollationElementIterator collationElementIterator2, int[] nArray, boolean bl) {
        int n2;
        while ((n2 = collationElementIterator2.next()) == 0) {
        }
        if (n2 == -1) {
            return true;
        }
        int n3 = -1;
        while (true) {
            if (n3 != n2) {
                while ((n3 = collationElementIterator.next()) == 0) {
                }
                if (n3 != -1) continue;
                return false;
            }
            int n4 = collationElementIterator.getOffset();
            if (this.collationStartsWith(collationElementIterator, collationElementIterator2)) {
                if (bl) {
                    while ((n3 = collationElementIterator.next()) == 0) {
                    }
                    if (n3 == -1) {
                        return true;
                    }
                } else {
                    if (nArray != null) {
                        nArray[0] = n4 - 1;
                        nArray[1] = collationElementIterator.getOffset();
                    }
                    return true;
                }
            }
            collationElementIterator.setOffset(n4);
            if (collationElementIterator.getOffset() != n4) {
                collationElementIterator.next();
            }
            collationElementIterator2.reset();
            n3 = -1;
            while ((n2 = collationElementIterator2.next()) == 0) {
            }
        }
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration();
        Comparator comparator = StandardCollationURIResolver.getInstance().resolve(stringArray[0], stringArray[0], configuration);
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        if (comparator instanceof RuleBasedCollator) {
            int n2;
            CollationElementIterator collationElementIterator = ((RuleBasedCollator)comparator).getCollationElementIterator(stringArray[1]);
            while ((n2 = collationElementIterator.next()) != -1) {
                fastStringBuffer.append(n2 + " ");
            }
            System.err.println(fastStringBuffer.toString());
        }
    }
}

