/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;

class SortedTupleIterator
extends SortedIterator {
    public SortedTupleIterator(XPathContext xPathContext, SequenceIterator sequenceIterator, FixedSortKeyDefinition[] fixedSortKeyDefinitionArray) throws XPathException {
        super(xPathContext, sequenceIterator, fixedSortKeyDefinitionArray);
        this.setHostLanguage(51);
    }

    protected void buildArray() throws XPathException {
        ObjectValue objectValue;
        int n2 = 100;
        this.nodeKeys = new Object[n2 * this.recordSize];
        this.count = 0;
        while ((objectValue = (ObjectValue)this.base.next()) != null) {
            Value[] valueArray = (Value[])objectValue.getObject();
            if (this.count == n2) {
                Object[] objectArray = new Object[(n2 *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, objectArray, 0, this.count * this.recordSize);
                this.nodeKeys = objectArray;
            }
            int n3 = this.count * this.recordSize;
            this.nodeKeys[n3] = new ObjectValue(valueArray[0]);
            for (int i2 = 1; i2 <= this.sortkeys.length; ++i2) {
                Value value = valueArray[i2].reduce();
                this.nodeKeys[n3 + i2] = value instanceof EmptySequence ? null : value;
            }
            this.nodeKeys[n3 + this.sortkeys.length + 1] = new Integer(this.count);
            ++this.count;
        }
    }
}

