/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.While;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;

public class SaxonWhile
extends StyleElement {
    private Expression test;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "test") {
                string = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (string == null) {
            this.reportAbsence("test");
            return;
        }
        this.test = this.makeExpression(string);
    }

    public void validate() throws XPathException {
        this.checkWithinTemplate();
        this.test = this.typeCheck("test", this.test);
    }

    public Expression compile(Executable executable) throws XPathException {
        Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        if (expression == null) {
            expression = EmptySequence.getInstance();
        }
        While while_ = new While(this.test, expression);
        ExpressionTool.makeParentReferences(while_);
        return while_;
    }
}

