/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.om.FastStringBuffer;

public final class LargeStringBuffer
implements CharSequence,
Serializable {
    private int minAllocation;
    private int maxAllocation;
    private List segments;
    private int[] startOffsets;
    private int length;

    public LargeStringBuffer() {
        this(4096, 65536);
    }

    public LargeStringBuffer(int n2, int n3) {
        this.minAllocation = Math.min(n2, n3);
        this.maxAllocation = n3;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n2);
        this.segments = new ArrayList(4);
        this.segments.add(fastStringBuffer);
        this.startOffsets = new int[1];
        this.startOffsets[0] = 0;
        this.length = 0;
    }

    public void append(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = (FastStringBuffer)this.segments.get(this.segments.size() - 1);
        if (fastStringBuffer.length() + charSequence.length() <= this.maxAllocation) {
            fastStringBuffer.append(charSequence);
        } else {
            int[] nArray = new int[this.startOffsets.length + 1];
            System.arraycopy(this.startOffsets, 0, nArray, 0, this.startOffsets.length);
            nArray[this.startOffsets.length] = this.length;
            this.startOffsets = nArray;
            fastStringBuffer = new FastStringBuffer(Math.max(this.minAllocation, charSequence.length()));
            this.segments.add(fastStringBuffer);
            fastStringBuffer.append(charSequence);
        }
        this.length += charSequence.length();
    }

    public int length() {
        return this.length;
    }

    public char charAt(int n2) {
        if (this.startOffsets.length == 1) {
            return ((FastStringBuffer)this.segments.get(0)).charAt(n2);
        }
        if (n2 < 0 || n2 >= this.length) {
            throw new IndexOutOfBoundsException(n2 + "");
        }
        int n3 = Arrays.binarySearch(this.startOffsets, n2);
        if (n3 >= 0) {
            return ((FastStringBuffer)this.segments.get(n3)).charAt(0);
        }
        n3 = -n3 - 2;
        int n4 = n2 - this.startOffsets[n3];
        return ((FastStringBuffer)this.segments.get(n3)).charAt(n4);
    }

    public CharSequence subSequence(int n2, int n3) {
        int n4;
        int n5;
        if (this.startOffsets.length == 1) {
            return ((FastStringBuffer)this.segments.get(0)).subSequence(n2, n3);
        }
        if (n2 < 0 || n3 < 0 || n3 > this.length || n2 > n3) {
            throw new IndexOutOfBoundsException("[" + n2 + ',' + n3 + ']');
        }
        int n6 = Arrays.binarySearch(this.startOffsets, n2);
        if (n6 >= 0) {
            n5 = 0;
        } else {
            n6 = -n6 - 2;
            n5 = n2 - this.startOffsets[n6];
        }
        int n7 = Arrays.binarySearch(this.startOffsets, n3);
        if (n7 >= 0) {
            n4 = 0;
        } else {
            n7 = -n7 - 2;
            n4 = n3 - this.startOffsets[n7];
        }
        FastStringBuffer fastStringBuffer = (FastStringBuffer)this.segments.get(n6);
        if (n6 == n7) {
            return fastStringBuffer.subSequence(n5, n4);
        }
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(n3 - n2);
        fastStringBuffer2.append(fastStringBuffer.subSequence(n5, fastStringBuffer.length()));
        for (int i2 = n6 + 1; i2 < n7; ++i2) {
            fastStringBuffer2.append((FastStringBuffer)this.segments.get(i2));
        }
        if (n4 > 0) {
            fastStringBuffer2.append(((FastStringBuffer)this.segments.get(n7)).subSequence(0, n4));
        }
        return fastStringBuffer2;
    }

    public String toString() {
        if (this.startOffsets.length == 1) {
            return this.segments.get(0).toString();
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.length);
        for (int i2 = 0; i2 < this.segments.size(); ++i2) {
            fastStringBuffer.append((FastStringBuffer)this.segments.get(i2));
        }
        return fastStringBuffer.toString();
    }

    public boolean equals(Object object) {
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.segments.size(); ++i2) {
            FastStringBuffer fastStringBuffer = (FastStringBuffer)this.segments.get(i2);
            for (int i3 = 0; i3 < fastStringBuffer.length(); ++i3) {
                n2 = 31 * n2 + this.charAt(i3);
            }
        }
        return n2;
    }

    public String substring(int n2, int n3) {
        return ((Object)this.subSequence(n2, n3)).toString();
    }

    public void write(Writer writer) throws IOException {
        for (int i2 = 0; i2 < this.segments.size(); ++i2) {
            FastStringBuffer fastStringBuffer = (FastStringBuffer)this.segments.get(i2);
            fastStringBuffer.write(writer);
        }
    }
}

