/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.IdrefTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class KeyManager
implements Serializable {
    private IntHashMap keyList = new IntHashMap(10);
    private transient WeakHashMap docIndexes = new WeakHashMap(10);

    public KeyManager(Configuration configuration) {
        this.registerIdrefKey(configuration);
    }

    private void registerIdrefKey(Configuration configuration) {
        NodeTestPattern nodeTestPattern = new NodeTestPattern(new IdrefTest(2));
        NodeTestPattern nodeTestPattern2 = new NodeTestPattern(new IdrefTest(1));
        UnionPattern unionPattern = new UnionPattern(nodeTestPattern, nodeTestPattern2);
        Atomizer atomizer = new Atomizer(new ContextItemExpression(), configuration);
        Tokenize tokenize = (Tokenize)SystemFunction.makeSystemFunction("tokenize", 2, configuration.getNamePool());
        StringValue stringValue = new StringValue("\\s");
        Expression[] expressionArray = new Expression[]{atomizer, stringValue};
        tokenize.setArguments(expressionArray);
        KeyDefinition keyDefinition = new KeyDefinition(unionPattern, tokenize, null, null);
        try {
            this.addKeyDefinition(562, keyDefinition, configuration);
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)xPathException);
        }
    }

    public void addKeyDefinition(int n2, KeyDefinition keyDefinition, Configuration configuration) throws XPathException {
        int n3;
        ArrayList<KeyDefinition> arrayList = (ArrayList<KeyDefinition>)this.keyList.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList<KeyDefinition>(3);
            this.keyList.put(n2, arrayList);
        } else {
            String string = keyDefinition.getCollationName();
            if (string == null) {
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    if (((KeyDefinition)arrayList.get(n3)).getCollationName() == null) continue;
                    StaticError staticError = new StaticError("All keys with the same name must use the same collation");
                    staticError.setErrorCode("XTSE1220");
                    throw staticError;
                }
            } else {
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    if (string.equals(((KeyDefinition)arrayList.get(n3)).getCollationName())) continue;
                    StaticError staticError = new StaticError("All keys with the same name must use the same collation");
                    staticError.setErrorCode("XTSE1220");
                    throw staticError;
                }
            }
        }
        arrayList.add(keyDefinition);
        boolean bl = false;
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            if (!((KeyDefinition)arrayList.get(n3)).isBackwardsCompatible()) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                KeyDefinition keyDefinition2 = (KeyDefinition)arrayList.get(n3);
                keyDefinition2.setBackwardsCompatible(true);
                if (keyDefinition2.getBody().getItemType(configuration.getTypeHierarchy()) == Type.STRING_TYPE) continue;
                AtomicSequenceConverter atomicSequenceConverter = new AtomicSequenceConverter(keyDefinition2.getBody(), Type.STRING_TYPE);
                keyDefinition2.setBody(atomicSequenceConverter);
            }
        }
    }

    public List getKeyDefinitions(int n2) {
        return (List)this.keyList.get(n2);
    }

    private synchronized HashMap buildIndex(int n2, int n3, DocumentInfo documentInfo, XPathContext xPathContext) throws XPathException {
        List list = this.getKeyDefinitions(n2);
        if (list == null) {
            DynamicError dynamicError = new DynamicError("Key " + xPathContext.getNamePool().getDisplayName(n2) + " has not been defined");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE1260");
            throw dynamicError;
        }
        HashMap hashMap = new HashMap(100);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.constructIndex(documentInfo, hashMap, (KeyDefinition)list.get(i2), n3, xPathContext, i2 == 0);
        }
        return hashMap;
    }

    private void constructIndex(DocumentInfo documentInfo, HashMap hashMap, KeyDefinition keyDefinition, int n2, XPathContext xPathContext, boolean bl) throws XPathException {
        int n3;
        Pattern pattern = keyDefinition.getMatch();
        Expression expression = keyDefinition.getUse();
        Comparator comparator = keyDefinition.getCollation();
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(keyDefinition);
        SlotManager slotManager = keyDefinition.getStackFrameMap();
        if (slotManager != null) {
            xPathContextMajor.openStackFrame(slotManager);
        }
        if ((n3 = pattern.getNodeKind()) == 2 || n3 == 0 || n3 == 9) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)5);
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (nodeInfo.getNodeKind() == 1) {
                    NodeInfo nodeInfo2;
                    AxisIterator axisIterator2 = nodeInfo.iterateAxis((byte)2);
                    while ((nodeInfo2 = (NodeInfo)axisIterator2.next()) != null) {
                        if (!pattern.matches(nodeInfo2, xPathContextMajor)) continue;
                        this.processKeyNode(nodeInfo2, expression, n2, comparator, hashMap, xPathContextMajor, bl);
                    }
                    if (n3 != 0 || !pattern.matches(nodeInfo, xPathContextMajor)) continue;
                    this.processKeyNode(nodeInfo, expression, n2, comparator, hashMap, xPathContextMajor, bl);
                    continue;
                }
                if (!pattern.matches(nodeInfo, xPathContextMajor)) continue;
                this.processKeyNode(nodeInfo, expression, n2, comparator, hashMap, xPathContextMajor, bl);
            }
        } else {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)4, pattern.getNodeTest());
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (!(pattern instanceof NodeTestPattern) && !pattern.matches(nodeInfo, xPathContextMajor)) continue;
                this.processKeyNode(nodeInfo, expression, n2, comparator, hashMap, xPathContextMajor, bl);
            }
        }
    }

    private void processKeyNode(NodeInfo nodeInfo, Expression expression, int n2, Comparator comparator, HashMap hashMap, XPathContext xPathContext, boolean bl) throws XPathException {
        int n3;
        AtomicValue atomicValue;
        AxisIterator axisIterator = SingletonIterator.makeIterator(nodeInfo);
        axisIterator.next();
        xPathContext.setCurrentIterator(axisIterator);
        Platform platform = null;
        if (comparator != null) {
            platform = xPathContext.getConfiguration().getPlatform();
        }
        SequenceIterator sequenceIterator = expression.iterate(xPathContext);
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null && Type.isComparable(n3 = atomicValue.getItemType(null).getPrimitiveType(), n2, false)) {
            Object object;
            if (n2 == 642) {
                object = comparator == null ? atomicValue.getStringValue() : platform.getCollationKey(comparator, atomicValue.getStringValue());
            } else if (n2 == 513) {
                object = comparator == null ? atomicValue.getStringValue() : platform.getCollationKey(comparator, atomicValue.getStringValue());
            } else {
                if (atomicValue instanceof NumericValue && ((NumericValue)atomicValue).isNaN()) break;
                try {
                    object = atomicValue.convert(n2, xPathContext);
                }
                catch (XPathException xPathException) {
                    break;
                }
            }
            ArrayList<NodeInfo> arrayList = (ArrayList<NodeInfo>)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<NodeInfo>(4);
                hashMap.put(object, arrayList);
                arrayList.add(nodeInfo);
                continue;
            }
            if (bl) {
                if (arrayList.get(arrayList.size() - 1) == nodeInfo) continue;
                arrayList.add(nodeInfo);
                continue;
            }
            LocalOrderComparer localOrderComparer = LocalOrderComparer.getInstance();
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n4 = localOrderComparer.compare(nodeInfo, (NodeInfo)arrayList.get(i2));
                if (n4 > 0) continue;
                if (n4 != 0) {
                    arrayList.add(i2, nodeInfo);
                }
                return;
            }
            arrayList.add(nodeInfo);
        }
    }

    public SequenceIterator selectByKey(int n2, DocumentInfo documentInfo, AtomicValue atomicValue, XPathContext xPathContext) throws XPathException {
        Object object;
        int n3;
        boolean bl;
        List list = this.getKeyDefinitions(n2);
        if (list == null) {
            DynamicError dynamicError = new DynamicError("Key " + xPathContext.getNamePool().getDisplayName(n2) + " has not been defined");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE1260");
            throw dynamicError;
        }
        KeyDefinition keyDefinition = (KeyDefinition)list.get(0);
        Comparator comparator = keyDefinition.getCollation();
        Platform platform = null;
        if (comparator != null) {
            platform = xPathContext.getConfiguration().getPlatform();
        }
        if (bl = keyDefinition.isBackwardsCompatible()) {
            atomicValue = atomicValue.convert(513, xPathContext);
        }
        if ((n3 = atomicValue.getItemType(null).getPrimitiveType()) == 532 || n3 == 515 || n3 == 516) {
            n3 = 517;
            atomicValue = atomicValue.convert(n3, xPathContext);
        }
        if ((object = this.getIndex(documentInfo, n2, n3)) instanceof String) {
            DynamicError dynamicError = new DynamicError("Key definition is circular");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE0640");
            throw dynamicError;
        }
        HashMap hashMap = (HashMap)object;
        if (hashMap == null) {
            this.putIndex(documentInfo, n2, n3, "Under Construction", xPathContext);
            hashMap = this.buildIndex(n2, n3, documentInfo, xPathContext);
            this.putIndex(documentInfo, n2, n3, hashMap, xPathContext);
        }
        Object object2 = n3 == 513 || n3 == 642 ? (comparator == null ? atomicValue.getStringValue() : platform.getCollationKey(comparator, atomicValue.getStringValue())) : atomicValue;
        ArrayList arrayList = (ArrayList)hashMap.get(object2);
        if (arrayList == null) {
            return EmptyIterator.getInstance();
        }
        return new ListIterator(arrayList);
    }

    private synchronized void putIndex(DocumentInfo documentInfo, int n2, int n3, Object object, XPathContext xPathContext) {
        HashMap hashMap;
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null || weakReference.get() == null) {
            hashMap = new HashMap(10);
            xPathContext.getController().setUserData(documentInfo, "key-index-list", hashMap);
            this.docIndexes.put(documentInfo, new WeakReference<HashMap>(hashMap));
        } else {
            hashMap = (HashMap)weakReference.get();
        }
        hashMap.put(new Long((long)n2 << 32 | (long)n3), object);
    }

    private synchronized Object getIndex(DocumentInfo documentInfo, int n2, int n3) {
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null) {
            return null;
        }
        HashMap hashMap = (HashMap)weakReference.get();
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(new Long((long)n2 << 32 | (long)n3));
    }
}

