/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;

public class Mode
implements Serializable {
    public static final int DEFAULT_MODE = -1;
    public static final int ALL_MODES = -2;
    public static final int NAMED_MODE = -3;
    public static final int STRIPPER_MODE = -4;
    private Rule[] ruleDict = new Rule[114];
    private Rule mostRecentRule;
    private boolean isDefault;
    private boolean isStripper;

    public Mode(int n2) {
        this.isDefault = n2 == -1;
        this.isStripper = n2 == -4;
    }

    public Mode(Mode mode) {
        this.isDefault = false;
        this.isStripper = false;
        if (mode != null) {
            for (int i2 = 0; i2 < this.ruleDict.length; ++i2) {
                if (mode.ruleDict[i2] == null) continue;
                this.ruleDict[i2] = new Rule(mode.ruleDict[i2]);
            }
            this.mostRecentRule = mode.mostRecentRule;
        }
    }

    public boolean isDefaultMode() {
        return this.isDefault;
    }

    public void addRule(Pattern pattern, Object object, int n2, double d2) {
        Rule rule;
        if (pattern.getNodeTest() instanceof NoNodeTest) {
            return;
        }
        int n3 = pattern.getFingerprint();
        int n4 = pattern.getNodeKind();
        int n5 = this.getList(n3, n4);
        int n6 = this.mostRecentRule == null ? 0 : (object == this.mostRecentRule.getAction() ? this.mostRecentRule.getSequence() : this.mostRecentRule.getSequence() + 1);
        this.mostRecentRule = rule = new Rule(pattern, object, n2, d2, n6);
        Rule rule2 = this.ruleDict[n5];
        if (rule2 == null) {
            this.ruleDict[n5] = rule;
            return;
        }
        Rule rule3 = null;
        while (rule2 != null) {
            if (rule2.getPrecedence() < n2 || rule2.getPrecedence() == n2 && rule2.getPriority() <= d2) {
                rule.setNext(rule2);
                if (rule3 == null) {
                    this.ruleDict[n5] = rule;
                    break;
                }
                rule3.setNext(rule);
                break;
            }
            rule3 = rule2;
            rule2 = rule2.getNext();
        }
        if (rule2 == null) {
            rule3.setNext(rule);
            rule.setNext(null);
        }
    }

    public int getList(int n2, int n3) {
        if (n3 == 1) {
            if (n2 == -1) {
                return 0;
            }
            return 13 + n2 % 101;
        }
        return n3;
    }

    public Rule getRule(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        Rule rule;
        int n2 = nodeInfo.getFingerprint();
        int n3 = nodeInfo.getNodeKind();
        int n4 = this.getList(n2, n3);
        int n5 = xPathContext.getController().getRecoveryPolicy();
        xPathContext = this.perhapsMakeNewContext(xPathContext);
        Rule rule2 = null;
        Rule rule3 = null;
        int n6 = -1;
        double d2 = Double.NEGATIVE_INFINITY;
        if (n4 != 0) {
            for (rule = this.ruleDict[n4]; !(rule == null || rule2 != null && (rule.getPrecedence() < n6 || rule.getPrecedence() == n6 && rule.getPriority() < d2)); rule = rule.getNext()) {
                if (!rule.getPattern().matches(nodeInfo, xPathContext)) continue;
                if (rule2 != null) {
                    if (rule.getPrecedence() != n6 || rule.getPriority() != d2) break;
                    this.reportAmbiguity(nodeInfo, rule2, rule, xPathContext);
                    break;
                }
                rule2 = rule;
                n6 = rule.getPrecedence();
                d2 = rule.getPriority();
                if (n5 == 0) break;
            }
        }
        for (rule = this.ruleDict[0]; !(rule == null || rule.getPrecedence() < n6 || rule.getPrecedence() == n6 && rule.getPriority() < d2); rule = rule.getNext()) {
            if (!rule.getPattern().matches(nodeInfo, xPathContext)) continue;
            if (rule3 != null) {
                if (rule.getPrecedence() != rule3.getPrecedence() || rule.getPriority() != rule3.getPriority()) break;
                this.reportAmbiguity(nodeInfo, rule, rule3, xPathContext);
                break;
            }
            rule3 = rule;
            if (n5 == 0) break;
        }
        if (rule2 != null && rule3 == null) {
            return rule2;
        }
        if (rule2 == null && rule3 != null) {
            return rule3;
        }
        if (rule2 != null && rule3 != null) {
            if (rule2.getPrecedence() == rule3.getPrecedence() && rule2.getPriority() == rule3.getPriority()) {
                Rule rule4;
                Rule rule5 = rule4 = rule2.getSequence() > rule3.getSequence() ? rule2 : rule3;
                if (n5 != 0) {
                    this.reportAmbiguity(nodeInfo, rule2, rule3, xPathContext);
                }
                return rule4;
            }
            if (rule2.getPrecedence() > rule3.getPrecedence() || rule2.getPrecedence() == rule3.getPrecedence() && rule2.getPriority() >= rule3.getPriority()) {
                return rule2;
            }
            return rule3;
        }
        return null;
    }

    private XPathContext perhapsMakeNewContext(XPathContext xPathContext) {
        int n2 = xPathContext.getController().getExecutable().getLargestPatternStackFrame();
        if (n2 > 0) {
            xPathContext = xPathContext.newContext();
            xPathContext.setOrigin(xPathContext.getController());
            ((XPathContextMajor)xPathContext).openStackFrame(n2);
        }
        return xPathContext;
    }

    public Rule getRule(NodeInfo nodeInfo, int n2, int n3, XPathContext xPathContext) throws XPathException {
        Rule rule;
        int n4 = nodeInfo.getFingerprint();
        int n5 = nodeInfo.getNodeKind();
        int n6 = this.getList(n4, n5);
        Rule rule2 = null;
        Rule rule3 = null;
        xPathContext = this.perhapsMakeNewContext(xPathContext);
        if (n6 != 0) {
            for (rule = this.ruleDict[n6]; rule != null; rule = rule.getNext()) {
                if (rule.getPrecedence() < n2 || rule.getPrecedence() > n3 || !rule.getPattern().matches(nodeInfo, xPathContext)) continue;
                rule2 = rule;
                break;
            }
        }
        for (rule = this.ruleDict[0]; rule != null; rule = rule.getNext()) {
            if (rule.getPrecedence() < n2 || rule.getPrecedence() > n3 || !rule.getPattern().matches(nodeInfo, xPathContext)) continue;
            rule3 = rule;
            break;
        }
        if (rule2 != null && rule3 == null) {
            return rule2;
        }
        if (rule2 == null && rule3 != null) {
            return rule3;
        }
        if (rule2 != null && rule3 != null) {
            if (rule2.getPrecedence() > rule3.getPrecedence() || rule2.getPrecedence() == rule3.getPrecedence() && rule2.getPriority() >= rule3.getPriority()) {
                return rule2;
            }
            return rule3;
        }
        return null;
    }

    public Rule getNextMatchRule(NodeInfo nodeInfo, Rule rule, XPathContext xPathContext) throws XPathException {
        int n2 = nodeInfo.getFingerprint();
        int n3 = nodeInfo.getNodeKind();
        int n4 = this.getList(n2, n3);
        int n5 = xPathContext.getController().getRecoveryPolicy();
        xPathContext = this.perhapsMakeNewContext(xPathContext);
        Rule rule2 = null;
        Rule rule3 = null;
        int n6 = -1;
        double d2 = Double.NEGATIVE_INFINITY;
        if (n4 != 0) {
            for (Rule rule4 = this.ruleDict[n4]; rule4 != null; rule4 = rule4.getNext()) {
                if (rule4 == rule || rule4.getPrecedence() > rule.getPrecedence() || rule4.getPrecedence() == rule.getPrecedence() && (rule4.getPriority() > rule.getPriority() || rule4.getPriority() == rule.getPriority() && rule4.getSequence() >= rule.getSequence())) continue;
                if (rule2 != null && (rule4.getPrecedence() < n6 || rule4.getPrecedence() == n6 && rule4.getPriority() < d2)) break;
                if (!rule4.getPattern().matches(nodeInfo, xPathContext)) continue;
                if (rule2 != null) {
                    if (rule4.getPrecedence() != n6 || rule4.getPriority() != d2) break;
                    this.reportAmbiguity(nodeInfo, rule2, rule4, xPathContext);
                    break;
                }
                rule2 = rule4;
                n6 = rule4.getPrecedence();
                d2 = rule4.getPriority();
                if (n5 == 0) break;
            }
        }
        for (Rule rule5 = this.ruleDict[0]; rule5 != null; rule5 = rule5.getNext()) {
            if (rule5 == rule || rule5.getPrecedence() > rule.getPrecedence() || rule5.getPrecedence() == rule.getPrecedence() && (rule5.getPriority() > rule.getPriority() || rule5.getPriority() == rule.getPriority() && rule5.getSequence() >= rule.getSequence())) continue;
            if (rule5.getPrecedence() < n6 || rule5.getPrecedence() == n6 && rule5.getPriority() < d2) break;
            if (!rule5.getPattern().matches(nodeInfo, xPathContext)) continue;
            if (rule3 != null) {
                if (rule5.getPrecedence() != rule3.getPrecedence() || rule5.getPriority() != rule3.getPriority()) break;
                this.reportAmbiguity(nodeInfo, rule5, rule3, xPathContext);
                break;
            }
            rule3 = rule5;
            if (n5 == 0) break;
        }
        if (rule2 != null && rule3 == null) {
            return rule2;
        }
        if (rule2 == null && rule3 != null) {
            return rule3;
        }
        if (rule2 != null && rule3 != null) {
            if (rule2.getPrecedence() == rule3.getPrecedence() && rule2.getPriority() == rule3.getPriority()) {
                Rule rule6;
                Rule rule7 = rule6 = rule2.getSequence() > rule3.getSequence() ? rule2 : rule3;
                if (n5 != 0) {
                    this.reportAmbiguity(nodeInfo, rule2, rule3, xPathContext);
                }
                return rule6;
            }
            if (rule2.getPrecedence() > rule3.getPrecedence() || rule2.getPrecedence() == rule3.getPrecedence() && rule2.getPriority() >= rule3.getPriority()) {
                return rule2;
            }
            return rule3;
        }
        return null;
    }

    private void reportAmbiguity(NodeInfo nodeInfo, Rule rule, Rule rule2, XPathContext xPathContext) throws XPathException {
        String string;
        if (rule.getAction() == rule2.getAction()) {
            return;
        }
        String string2 = "XTRE0540";
        if (this.isStripper) {
            if (rule.getAction().equals(rule2.getAction())) {
                return;
            }
            string2 = "XTRE0270";
            string = "xsl:strip-space";
        } else {
            string = Navigator.getPath(nodeInfo);
        }
        Pattern pattern = rule.getPattern();
        Pattern pattern2 = rule2.getPattern();
        DynamicError dynamicError = new DynamicError("Ambiguous rule match for " + string + '\n' + "Matches both \"" + Mode.showPattern(pattern) + "\" on line " + pattern.getLineNumber() + " of " + pattern.getSystemId() + "\nand \"" + Mode.showPattern(pattern2) + "\" on line " + pattern2.getLineNumber() + " of " + pattern2.getSystemId());
        dynamicError.setErrorCode(string2);
        dynamicError.setLocator(xPathContext.getOrigin().getInstructionInfo());
        xPathContext.getController().recoverableError(dynamicError);
    }

    private static String showPattern(Pattern pattern) {
        return ((Object)NormalizeSpace.normalize(pattern.toString())).toString();
    }
}

