/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class DecimalValue
extends NumericValue {
    private static final int DIVIDE_PRECISION = 18;
    private static boolean stripTrailingZerosMethodUnavailable = false;
    private static Method stripTrailingZerosMethod = null;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private BigDecimal value;
    public static final BigDecimal ONE = BigDecimal.valueOf(1L);
    public static final BigInteger TEN = BigInteger.valueOf(10L);
    public static final BigDecimal ONE_MILLION = BigDecimal.valueOf(1000000L);
    private static final Pattern decimalPattern = Pattern.compile("(\\-|\\+)?((\\.[0-9]+)|([0-9]+(\\.[0-9]*)?))");
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DecimalValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;

    public DecimalValue(BigDecimal bigDecimal) {
        this.value = DecimalValue.stripTrailingZeros(bigDecimal);
    }

    public static AtomicValue makeDecimalValue(CharSequence charSequence, boolean bl) {
        String string = ((Object)DecimalValue.trimWhitespace(charSequence)).toString();
        try {
            if (bl && !decimalPattern.matcher(string).matches()) {
                ValidationException validationException = new ValidationException("Cannot convert string " + Err.wrap(string, 4) + " to xs:decimal");
                validationException.setErrorCode("FORG0001");
                return new ValidationErrorValue(validationException);
            }
            BigDecimal bigDecimal = new BigDecimal(string);
            bigDecimal = DecimalValue.stripTrailingZeros(bigDecimal);
            DecimalValue decimalValue = new DecimalValue(bigDecimal);
            return decimalValue;
        }
        catch (NumberFormatException numberFormatException) {
            ValidationException validationException = new ValidationException("Cannot convert string " + Err.wrap(string, 4) + " to xs:decimal");
            validationException.setErrorCode("FORG0001");
            return new ValidationErrorValue(validationException);
        }
    }

    public static boolean castableAsDecimal(CharSequence charSequence) {
        CharSequence charSequence2 = DecimalValue.trimWhitespace(charSequence);
        return decimalPattern.matcher(charSequence2).matches();
    }

    public DecimalValue(double d2) throws ValidationException {
        try {
            this.value = DecimalValue.stripTrailingZeros(new BigDecimal(d2));
        }
        catch (NumberFormatException numberFormatException) {
            ValidationException validationException = new ValidationException("Cannot convert double " + Err.wrap(d2 + "", 4) + " to decimal");
            validationException.setErrorCode("FORG0001");
            throw validationException;
        }
    }

    public DecimalValue(long l2) {
        this.value = BigDecimal.valueOf(l2);
    }

    private static BigDecimal stripTrailingZeros(BigDecimal bigDecimal) {
        if (stripTrailingZerosMethodUnavailable) {
            return DecimalValue.stripTrailingZerosFallback(bigDecimal);
        }
        try {
            Object object;
            if (stripTrailingZerosMethod == null) {
                object = new Class[]{};
                stripTrailingZerosMethod = (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DecimalValue.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getMethod("stripTrailingZeros", (Class<?>)object);
            }
            object = stripTrailingZerosMethod.invoke((Object)bigDecimal, EMPTY_OBJECT_ARRAY);
            return (BigDecimal)object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            stripTrailingZerosMethodUnavailable = true;
            return DecimalValue.stripTrailingZerosFallback(bigDecimal);
        }
        catch (IllegalAccessException illegalAccessException) {
            stripTrailingZerosMethodUnavailable = true;
            return DecimalValue.stripTrailingZerosFallback(bigDecimal);
        }
        catch (InvocationTargetException invocationTargetException) {
            stripTrailingZerosMethodUnavailable = true;
            return DecimalValue.stripTrailingZerosFallback(bigDecimal);
        }
    }

    private static BigDecimal stripTrailingZerosFallback(BigDecimal bigDecimal) {
        int n2 = bigDecimal.scale();
        if (n2 > 0) {
            BigInteger[] bigIntegerArray;
            BigInteger bigInteger = bigDecimal.unscaledValue();
            while ((bigIntegerArray = bigInteger.divideAndRemainder(TEN))[1].equals(BigInteger.ZERO)) {
                bigInteger = bigIntegerArray[0];
                if (--n2 != 0) continue;
            }
            if (n2 != bigDecimal.scale()) {
                bigDecimal = new BigDecimal(bigInteger, n2);
            }
        }
        return bigDecimal;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public int hashCode() {
        BigDecimal bigDecimal = this.value.setScale(0, 1);
        long l2 = bigDecimal.longValue();
        if (l2 > Integer.MIN_VALUE && l2 < Integer.MAX_VALUE) {
            return (int)l2;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value.signum() != 0;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 514: {
                return BooleanValue.get(this.value.signum() != 0);
            }
            case 88: 
            case 515: 
            case 643: 
            case 646: {
                return this;
            }
            case 532: {
                return BigIntegerValue.makeValue(this.value.toBigInteger());
            }
            case 517: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 516: {
                return new FloatValue(this.value.floatValue());
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert decimal to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public CharSequence getStringValueCS() {
        return DecimalValue.decimalToString(this.value);
    }

    public String getStringValue() {
        return ((Object)DecimalValue.decimalToString(this.value)).toString();
    }

    public static CharSequence decimalToString(BigDecimal bigDecimal) {
        int n2 = bigDecimal.scale();
        if (n2 == 0) {
            return bigDecimal.toString();
        }
        if (n2 < 0) {
            String string = bigDecimal.abs().unscaledValue().toString();
            FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length() + -n2 + 2);
            if (bigDecimal.signum() < 0) {
                fastStringBuffer.append('-');
            }
            fastStringBuffer.append(string);
            for (int i2 = 0; i2 < -n2; ++i2) {
                fastStringBuffer.append('0');
            }
            return fastStringBuffer;
        }
        String string = bigDecimal.abs().unscaledValue().toString();
        if (string.equals("0")) {
            return string;
        }
        int n3 = string.length();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n3 + 1);
        if (bigDecimal.signum() < 0) {
            fastStringBuffer.append('-');
        }
        if (n2 >= n3) {
            fastStringBuffer.append("0.");
            for (int i3 = n3; i3 < n2; ++i3) {
                fastStringBuffer.append('0');
            }
            fastStringBuffer.append(string);
        } else {
            fastStringBuffer.append(string.substring(0, n3 - n2));
            fastStringBuffer.append('.');
            fastStringBuffer.append(string.substring(n3 - n2));
        }
        return fastStringBuffer;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.DECIMAL_TYPE;
    }

    public NumericValue negate() {
        return new DecimalValue(this.value.negate());
    }

    public NumericValue floor() {
        return new DecimalValue(this.value.setScale(0, 3));
    }

    public NumericValue ceiling() {
        return new DecimalValue(this.value.setScale(0, 2));
    }

    public NumericValue round() {
        switch (this.value.signum()) {
            case -1: {
                return new DecimalValue(this.value.setScale(0, 5));
            }
            case 0: {
                return this;
            }
            case 1: {
                return new DecimalValue(this.value.setScale(0, 4));
            }
        }
        return this;
    }

    public NumericValue roundHalfToEven(int n2) {
        if (n2 < 0) {
            try {
                AtomicValue atomicValue = this.convert(532, null);
                if (atomicValue instanceof IntegerValue) {
                    return ((IntegerValue)atomicValue).roundHalfToEven(n2);
                }
                return ((BigIntegerValue)atomicValue).roundHalfToEven(n2);
            }
            catch (XPathException xPathException) {
                throw new IllegalArgumentException("internal error in integer-decimal conversion");
            }
        }
        return new DecimalValue(DecimalValue.stripTrailingZeros(this.value.setScale(n2, 6)));
    }

    public double signum() {
        return this.value.signum();
    }

    public boolean isWholeNumber() {
        return this.value.scale() == 0 || this.value.equals(this.value.setScale(0, 1));
    }

    public NumericValue arithmetic(int n2, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof DecimalValue) {
            try {
                switch (n2) {
                    case 15: {
                        return new DecimalValue(this.value.add(((DecimalValue)numericValue).value));
                    }
                    case 16: {
                        return new DecimalValue(this.value.subtract(((DecimalValue)numericValue).value));
                    }
                    case 17: {
                        return new DecimalValue(this.value.multiply(((DecimalValue)numericValue).value));
                    }
                    case 18: {
                        int n3 = Math.max(18, Math.max(this.value.scale(), ((DecimalValue)numericValue).value.scale()));
                        BigDecimal bigDecimal = this.value.divide(((DecimalValue)numericValue).value, n3, 5);
                        return new DecimalValue(bigDecimal);
                    }
                    case 50: {
                        if (((DecimalValue)numericValue).value.signum() == 0) {
                            DynamicError dynamicError = new DynamicError("Integer division by zero");
                            dynamicError.setErrorCode("FOAR0001");
                            dynamicError.setXPathContext(xPathContext);
                            throw dynamicError;
                        }
                        BigInteger bigInteger = this.value.divide(((DecimalValue)numericValue).value, 0, 1).toBigInteger();
                        return BigIntegerValue.makeValue(bigInteger);
                    }
                    case 19: {
                        BigDecimal bigDecimal = this.value.divide(((DecimalValue)numericValue).value, 0, 1);
                        BigDecimal bigDecimal2 = this.value.subtract(bigDecimal.multiply(((DecimalValue)numericValue).value));
                        return new DecimalValue(bigDecimal2);
                    }
                }
                throw new AssertionError((Object)"Unknown operator");
            }
            catch (ArithmeticException arithmeticException) {
                throw new DynamicError(arithmeticException);
            }
        }
        if (NumericValue.isInteger(numericValue)) {
            return this.arithmetic(n2, (DecimalValue)numericValue.convert(515, xPathContext), xPathContext);
        }
        TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
        NumericValue numericValue2 = (NumericValue)this.convert(numericValue.getItemType(typeHierarchy).getPrimitiveType(), xPathContext);
        return numericValue2.arithmetic(n2, numericValue, xPathContext);
    }

    public int compareTo(Object object) {
        if (NumericValue.isInteger((NumericValue)object)) {
            try {
                return this.compareTo(((NumericValue)object).convert(515, null));
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)"Conversion of integer to decimal should never fail");
            }
        }
        if (object instanceof DecimalValue) {
            return this.value.compareTo(((DecimalValue)object).value);
        }
        if (object instanceof FloatValue) {
            try {
                return ((FloatValue)this.convert(516, null)).compareTo(object);
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)"Conversion of decimal to float should never fail");
            }
        }
        return super.compareTo(object);
    }

    public boolean schemaEquals(Value value) {
        if (value instanceof AtomicValue) {
            value = ((AtomicValue)value).getPrimitiveValue();
        }
        try {
            if (value instanceof DecimalValue) {
                return this.value.equals(((DecimalValue)value).value);
            }
            if (value instanceof IntegerValue) {
                return this.schemaEquals(((IntegerValue)value).convert(515, null));
            }
            if (value instanceof BigIntegerValue) {
                return this.schemaEquals(((BigIntegerValue)value).convert(515, null));
            }
            return false;
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DecimalValue.class$("java.lang.Object")) : class$java$lang$Object) || clazz.isAssignableFrom(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DecimalValue.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return this.value;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DecimalValue == null ? (class$net$sf$saxon$value$DecimalValue = DecimalValue.class$("net.sf.saxon.value.DecimalValue")) : class$net$sf$saxon$value$DecimalValue)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = DecimalValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DecimalValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DecimalValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = DecimalValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.value.doubleValue());
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = DecimalValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value.floatValue());
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = DecimalValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(this.value.longValue());
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = DecimalValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(this.value.intValue());
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = DecimalValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(this.value.shortValue());
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = DecimalValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte(this.value.byteValue());
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = DecimalValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character((char)this.value.intValue());
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of decimal to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

