/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.Value;

public class IntegerRange
extends Value {
    public long start;
    public long end;

    public IntegerRange(long l2, long l3) {
        this.start = l2;
        this.end = l3;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public int getImplementationMethod() {
        return 2;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return new RangeIterator(this.start, this.end);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.INTEGER_TYPE;
    }

    public int getCardinality() {
        return 32768;
    }

    public Item itemAt(int n2) throws XPathException {
        if (n2 < 0 || (long)n2 > this.end - this.start) {
            return null;
        }
        return new IntegerValue(this.start + (long)n2);
    }

    public int getLength() throws XPathException {
        return (int)(this.end - this.start + 1L);
    }

    public void display(int n2, PrintStream printStream, Configuration configuration) {
        System.err.println(ExpressionTool.indent(n2) + this.start + " to " + this.end);
    }
}

