/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.XSCMBinOp;
import org.apache.xerces.impl.xs.models.XSCMLeaf;
import org.apache.xerces.impl.xs.models.XSCMUniOp;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSDFACM
implements XSCMValidator {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private Object[] fElemMap = null;
    private int[] fElemMapType = null;
    private int[] fElemMapId = null;
    private int fElemMapSize = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private XSCMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private static long time = 0L;

    public XSDFACM(CMNode cMNode, int n2) {
        this.fLeafCount = n2;
        this.buildDFA(cMNode);
    }

    public boolean isFinalState(int n2) {
        return n2 < 0 ? false : this.fFinalStateFlags[n2];
    }

    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler) {
        int n2 = nArray[0];
        if (n2 == -1 || n2 == -2) {
            if (n2 == -1) {
                nArray[0] = -2;
            }
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        int n3 = 0;
        int n4 = 0;
        Object object = null;
        while (n4 < this.fElemMapSize) {
            n3 = this.fTransTable[n2][n4];
            if (n3 != -1) {
                int n5 = this.fElemMapType[n4];
                if (n5 == 1) {
                    object = substitutionGroupHandler.getMatchingElemDecl(qName, (XSElementDecl)this.fElemMap[n4]);
                    if (object != null) {
                        break;
                    }
                } else if (n5 == 2 && ((XSWildcardDecl)this.fElemMap[n4]).allowNamespace(qName.uri)) {
                    object = this.fElemMap[n4];
                    break;
                }
            }
            ++n4;
        }
        if (n4 == this.fElemMapSize) {
            nArray[1] = nArray[0];
            nArray[0] = -1;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        nArray[0] = n3;
        return object;
    }

    Object findMatchingDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = null;
        int n2 = 0;
        while (n2 < this.fElemMapSize) {
            int n3 = this.fElemMapType[n2];
            if (n3 == 1) {
                xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, (XSElementDecl)this.fElemMap[n2]);
                if (xSElementDecl != null) {
                    return xSElementDecl;
                }
            } else if (n3 == 2 && ((XSWildcardDecl)this.fElemMap[n2]).allowNamespace(qName.uri)) {
                return this.fElemMap[n2];
            }
            ++n2;
        }
        return null;
    }

    public int[] startContentModel() {
        int[] nArray = new int[2];
        nArray[0] = 0;
        return nArray;
    }

    public boolean endContentModel(int[] nArray) {
        return this.fFinalStateFlags[nArray[0]];
    }

    private void buildDFA(CMNode cMNode) {
        int n2;
        int n3;
        int n4 = this.fLeafCount;
        XSCMLeaf xSCMLeaf = new XSCMLeaf(1, null, -1, this.fLeafCount++);
        this.fHeadNode = new XSCMBinOp(102, cMNode, xSCMLeaf);
        this.fLeafList = new XSCMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int n5 = 0;
        while (n5 < this.fLeafCount) {
            this.fFollowList[n5] = new CMStateSet(this.fLeafCount);
            ++n5;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new Object[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapId = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        int n6 = 0;
        while (n6 < this.fLeafCount) {
            this.fElemMap[n6] = null;
            int n7 = 0;
            n3 = this.fLeafList[n6].getParticleId();
            while (n7 < this.fElemMapSize) {
                if (n3 == this.fElemMapId[n7]) break;
                ++n7;
            }
            if (n7 == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize] = this.fLeafList[n6].getLeaf();
                this.fElemMapType[this.fElemMapSize] = this.fLeafListType[n6];
                this.fElemMapId[this.fElemMapSize] = n3;
                ++this.fElemMapSize;
            }
            ++n6;
        }
        --this.fElemMapSize;
        int[] nArray = new int[this.fLeafCount + this.fElemMapSize];
        n3 = 0;
        int n8 = 0;
        while (n8 < this.fElemMapSize) {
            n2 = this.fElemMapId[n8];
            int n9 = 0;
            while (n9 < this.fLeafCount) {
                if (n2 == this.fLeafList[n9].getParticleId()) {
                    nArray[n3++] = n9;
                }
                ++n9;
            }
            nArray[n3++] = -1;
            ++n8;
        }
        n2 = this.fLeafCount * 4;
        CMStateSet[] cMStateSetArray = new CMStateSet[n2];
        this.fFinalStateFlags = new boolean[n2];
        this.fTransTable = new int[n2][];
        CMStateSet cMStateSet = this.fHeadNode.firstPos();
        int n10 = 0;
        int n11 = 0;
        this.fTransTable[n11] = this.makeDefStateList();
        cMStateSetArray[n11] = cMStateSet;
        ++n11;
        Hashtable<CMStateSet, Integer> hashtable = new Hashtable<CMStateSet, Integer>();
        while (n10 < n11) {
            cMStateSet = cMStateSetArray[n10];
            int[] nArray2 = this.fTransTable[n10];
            this.fFinalStateFlags[n10] = cMStateSet.getBit(n4);
            ++n10;
            CMStateSet cMStateSet2 = null;
            int n12 = 0;
            int n13 = 0;
            while (n13 < this.fElemMapSize) {
                if (cMStateSet2 == null) {
                    cMStateSet2 = new CMStateSet(this.fLeafCount);
                } else {
                    cMStateSet2.zeroBits();
                }
                int n14 = nArray[n12++];
                while (n14 != -1) {
                    if (cMStateSet.getBit(n14)) {
                        cMStateSet2.union(this.fFollowList[n14]);
                    }
                    n14 = nArray[n12++];
                }
                if (!cMStateSet2.isEmpty()) {
                    int n15;
                    Integer n16 = (Integer)hashtable.get(cMStateSet2);
                    int n17 = n15 = n16 == null ? n11 : n16;
                    if (n15 == n11) {
                        cMStateSetArray[n11] = cMStateSet2;
                        this.fTransTable[n11] = this.makeDefStateList();
                        hashtable.put(cMStateSet2, new Integer(n11));
                        ++n11;
                        cMStateSet2 = null;
                    }
                    nArray2[n13] = n15;
                    if (n11 == n2) {
                        int n18 = (int)((double)n2 * 1.5);
                        CMStateSet[] cMStateSetArray2 = new CMStateSet[n18];
                        boolean[] blArray = new boolean[n18];
                        int[][] nArrayArray = new int[n18][];
                        int n19 = 0;
                        while (n19 < n2) {
                            cMStateSetArray2[n19] = cMStateSetArray[n19];
                            blArray[n19] = this.fFinalStateFlags[n19];
                            nArrayArray[n19] = this.fTransTable[n19];
                            ++n19;
                        }
                        n2 = n18;
                        cMStateSetArray = cMStateSetArray2;
                        this.fFinalStateFlags = blArray;
                        this.fTransTable = nArrayArray;
                    }
                }
                ++n13;
            }
        }
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
        this.fLeafListType = null;
        this.fElemMapId = null;
    }

    private void calcFollowList(CMNode cMNode) {
        if (cMNode.type() == 101) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 102) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((XSCMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((XSCMBinOp)cMNode).getRight().firstPos();
            int n2 = 0;
            while (n2 < this.fLeafCount) {
                if (cMStateSet.getBit(n2)) {
                    this.fFollowList[n2].union(cMStateSet2);
                }
                ++n2;
            }
        } else if (cMNode.type() == 4 || cMNode.type() == 6) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            int n3 = 0;
            while (n3 < this.fLeafCount) {
                if (cMStateSet3.getBit(n3)) {
                    this.fFollowList[n3].union(cMStateSet);
                }
                ++n3;
            }
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
        }
    }

    private void dumpTree(CMNode cMNode, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            System.out.print("   ");
            ++n3;
        }
        int n4 = cMNode.type();
        switch (n4) {
            case 101: 
            case 102: {
                if (n4 == 101) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMBinOp)cMNode).getLeft(), n2 + 1);
                this.dumpTree(((XSCMBinOp)cMNode).getRight(), n2 + 1);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                System.out.print("Rep Node ");
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMUniOp)cMNode).getChild(), n2 + 1);
                break;
            }
            case 1: {
                System.out.print("Leaf: (pos=" + ((XSCMLeaf)cMNode).getPosition() + "), " + "(elemIndex=" + ((XSCMLeaf)cMNode).getLeaf() + ") ");
                if (cMNode.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            case 2: {
                System.out.print("Any Node: ");
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_NIICM");
            }
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        int n2 = 0;
        while (n2 < this.fElemMapSize) {
            nArray[n2] = -1;
            ++n2;
        }
        return nArray;
    }

    private void postTreeBuildInit(CMNode cMNode) throws RuntimeException {
        cMNode.setMaxStates(this.fLeafCount);
        XSCMLeaf xSCMLeaf = null;
        int n2 = 0;
        if (cMNode.type() == 2) {
            xSCMLeaf = (XSCMLeaf)cMNode;
            n2 = xSCMLeaf.getPosition();
            this.fLeafList[n2] = xSCMLeaf;
            this.fLeafListType[n2] = 2;
        } else if (cMNode.type() == 101 || cMNode.type() == 102) {
            this.postTreeBuildInit(((XSCMBinOp)cMNode).getLeft());
            this.postTreeBuildInit(((XSCMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 4 || cMNode.type() == 6 || cMNode.type() == 5) {
            this.postTreeBuildInit(((XSCMUniOp)cMNode).getChild());
        } else if (cMNode.type() == 1) {
            xSCMLeaf = (XSCMLeaf)cMNode;
            n2 = xSCMLeaf.getPosition();
            this.fLeafList[n2] = xSCMLeaf;
            this.fLeafListType[n2] = 1;
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        int n2;
        int n3;
        byte[][] byArray = new byte[this.fElemMapSize][this.fElemMapSize];
        int n4 = 0;
        while (n4 < this.fTransTable.length && this.fTransTable[n4] != null) {
            n3 = 0;
            while (n3 < this.fElemMapSize) {
                n2 = n3 + 1;
                while (n2 < this.fElemMapSize) {
                    if (this.fTransTable[n4][n3] != -1 && this.fTransTable[n4][n2] != -1 && byArray[n3][n2] == 0) {
                        byArray[n3][n2] = XSConstraints.overlapUPA(this.fElemMap[n3], this.fElemMap[n2], substitutionGroupHandler) ? 1 : -1;
                    }
                    ++n2;
                }
                ++n3;
            }
            ++n4;
        }
        n3 = 0;
        while (n3 < this.fElemMapSize) {
            n2 = 0;
            while (n2 < this.fElemMapSize) {
                if (byArray[n3][n2] == 1) {
                    throw new XMLSchemaException("cos-nonambig", new Object[]{this.fElemMap[n3].toString(), this.fElemMap[n2].toString()});
                }
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.fElemMapSize) {
            if (this.fElemMapType[n2] == 2) {
                XSWildcardDecl xSWildcardDecl = (XSWildcardDecl)this.fElemMap[n2];
                if (xSWildcardDecl.fType == 3 || xSWildcardDecl.fType == 2) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public Vector whatCanGoHere(int[] nArray) {
        int n2 = nArray[0];
        if (n2 < 0) {
            n2 = nArray[1];
        }
        Vector<Object> vector = new Vector<Object>();
        int n3 = 0;
        while (n3 < this.fElemMapSize) {
            if (this.fTransTable[n2][n3] != -1) {
                vector.addElement(this.fElemMap[n3]);
            }
            ++n3;
        }
        return vector;
    }
}

