/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.File;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class Folder
extends Container
implements IFolder {
    protected Folder(IPath path, Workspace container) {
        super(path, container);
    }

    protected void assertCreateRequirements(IPath location, int updateFlags) throws CoreException {
        boolean force;
        this.checkDoesNotExist();
        Container parent = (Container)this.getParent();
        ResourceInfo info = parent.getResourceInfo(false, false);
        parent.checkAccessible(this.getFlags(info));
        if (location == null) {
            String message = NLS.bind(Messages.localstore_locationUndefined, this.getFullPath());
            throw new ResourceException(272, this.getFullPath(), message, null);
        }
        File localFile = location.toFile();
        boolean bl = force = (updateFlags & 1) != 0;
        if (!force && localFile.exists()) {
            String name;
            if (!CoreFileSystemLibrary.isCaseSensitive() && (name = this.getLocalManager().getLocalName(localFile)) != null && !localFile.getName().equals(name)) {
                String msg = NLS.bind(Messages.resources_existsLocalDifferentCase, location.removeLastSegments(1).append(name).toOSString());
                throw new ResourceException(275, this.getFullPath(), msg, null);
            }
            String msg = NLS.bind(Messages.resources_fileExists, localFile.getAbsolutePath());
            throw new ResourceException(272, this.getFullPath(), msg, null);
        }
    }

    public IFile changeToFile() throws CoreException {
        this.getPropertyManager().deleteProperties(this, 2);
        IFile result = this.workspace.getRoot().getFile(this.path);
        if (this.isLinked()) {
            IPath location = this.getRawLocation();
            this.delete(0, null);
            result.createLink(location, 16, null);
        } else {
            this.workspace.deleteResource(this);
            this.workspace.createResource(result, false);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(int updateFlags, boolean local, IProgressMonitor monitor) throws CoreException {
        boolean force = (updateFlags & 1) != 0;
        monitor = Policy.monitorFor(monitor);
        try {
            String message = NLS.bind(Messages.resources_creating, this.getFullPath());
            monitor.beginTask(message, 100);
            this.checkValidPath(this.path, 2, true);
            ISchedulingRule rule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    IPath location = this.getLocalManager().locationFor(this);
                    this.assertCreateRequirements(location, updateFlags);
                    this.workspace.beginOperation(true);
                    File localFile = location.toFile();
                    if (force && !CoreFileSystemLibrary.isCaseSensitive() && localFile.exists()) {
                        String name = this.getLocalManager().getLocalName(localFile);
                        if (name != null && !localFile.getName().equals(name)) {
                            String msg = NLS.bind(Messages.resources_existsLocalDifferentCase, location.removeLastSegments(1).append(name).toOSString());
                            throw new ResourceException(275, this.getFullPath(), msg, null);
                        }
                        this.delete(true, null);
                    }
                    this.internalCreate(force, local, Policy.subMonitorFor(monitor, Policy.opWork));
                    this.workspace.getAliasManager().updateAliases(this, this.getLocation(), 0, monitor);
                }
                catch (OperationCanceledException e2) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var11_14 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var13_17 = null;
            monitor.done();
            return;
        }
    }

    public void create(boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        this.create(force ? 1 : 0, local, monitor);
    }

    public void ensureExists(IProgressMonitor monitor) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        if (this.exists(flags, true)) {
            return;
        }
        if (this.exists(flags, false)) {
            String message = NLS.bind(Messages.resources_folderOverFile, this.getFullPath());
            throw new ResourceException(366, this.getFullPath(), message, null);
        }
        Container parent = (Container)this.getParent();
        if (parent.getType() == 4) {
            info = parent.getResourceInfo(false, false);
            parent.checkExists(this.getFlags(info), true);
        } else {
            ((Folder)parent).ensureExists(monitor);
        }
        this.internalCreate(true, true, monitor);
    }

    public String getDefaultCharset(boolean checkImplicit) {
        if (!this.exists()) {
            return checkImplicit ? this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true) : null;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), checkImplicit);
    }

    public int getType() {
        return 2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void internalCreate(boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = NLS.bind(Messages.resources_creating, this.getFullPath());
            monitor.beginTask(message, 100);
            this.workspace.createResource(this, false);
            if (local) {
                try {
                    this.getLocalManager().write(this, force, Policy.subMonitorFor(monitor, 75));
                }
                catch (CoreException e2) {
                    this.workspace.deleteResource(this);
                    throw e2;
                }
            }
            this.setLocal(local, 0, Policy.subMonitorFor(monitor, 25));
            if (!local) {
                this.getResourceInfo(true, true).clearModificationStamp();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
            monitor.done();
            return;
        }
    }
}

