/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ProjectNatureDescriptor;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class NatureManager
implements ILifecycleListener,
IManager {
    protected Map descriptors;
    protected Map natureEnablements;
    protected Map buildersToNatures = null;
    private static final byte WHITE = 0;
    private static final byte GREY = 1;
    private static final byte BLACK = 2;

    protected NatureManager() {
    }

    protected String[] computeNatureEnablements(Project project) {
        String[] natureIds = project.internalGetDescription().getNatureIds();
        int count = natureIds.length;
        if (count == 0) {
            return natureIds;
        }
        HashSet<String> candidates = new HashSet<String>(count * 2);
        HashMap<String, ArrayList<String>> setsToNatures = new HashMap<String, ArrayList<String>>(count);
        int i2 = 0;
        while (i2 < count) {
            String id = natureIds[i2];
            ProjectNatureDescriptor desc = (ProjectNatureDescriptor)this.getNatureDescriptor(id);
            if (desc != null) {
                if (!desc.hasCycle) {
                    candidates.add(id);
                }
                String[] setIds = desc.getNatureSetIds();
                int j2 = 0;
                while (j2 < setIds.length) {
                    String set = setIds[j2];
                    ArrayList<String> current = (ArrayList<String>)setsToNatures.get(set);
                    if (current == null) {
                        current = new ArrayList<String>(5);
                        setsToNatures.put(set, current);
                    }
                    current.add(id);
                    ++j2;
                }
            }
            ++i2;
        }
        Iterator it = setsToNatures.values().iterator();
        while (it.hasNext()) {
            ArrayList setMembers = (ArrayList)it.next();
            if (setMembers.size() <= 1) continue;
            candidates.removeAll(setMembers);
        }
        String[] orderedCandidates = candidates.toArray(new String[candidates.size()]);
        orderedCandidates = this.sortNatureSet(orderedCandidates);
        int i3 = 0;
        while (i3 < orderedCandidates.length) {
            String id = orderedCandidates[i3];
            IProjectNatureDescriptor desc = this.getNatureDescriptor(id);
            String[] required = desc.getRequiredNatureIds();
            int j3 = 0;
            while (j3 < required.length) {
                if (!candidates.contains(required[j3])) {
                    candidates.remove(id);
                    break;
                }
                ++j3;
            }
            ++i3;
        }
        return candidates.toArray(new String[candidates.size()]);
    }

    public IProjectNatureDescriptor getNatureDescriptor(String natureId) {
        this.lazyInitialize();
        return (IProjectNatureDescriptor)this.descriptors.get(natureId);
    }

    public IProjectNatureDescriptor[] getNatureDescriptors() {
        this.lazyInitialize();
        Collection values = this.descriptors.values();
        return values.toArray(new IProjectNatureDescriptor[values.size()]);
    }

    public void handleEvent(LifecycleEvent event) {
        switch (event.kind) {
            case 1: 
            case 2: 
            case 16: 
            case 32: 
            case 64: {
                this.flushEnablements((IProject)event.resource);
            }
        }
    }

    protected void configureNature(final Project project, final String natureID, final MultiStatus errors) {
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                IProjectNature nature = NatureManager.this.createNature(project, natureID);
                nature.configure();
                ProjectInfo info = (ProjectInfo)project.getResourceInfo(false, true);
                info.setNature(natureID, nature);
            }

            public void handleException(Throwable exception) {
                if (exception instanceof CoreException) {
                    errors.add(((CoreException)exception).getStatus());
                } else {
                    errors.add(new ResourceStatus(566, project.getFullPath(), NLS.bind(Messages.resources_errorNature, natureID), exception));
                }
            }
        };
        if (Policy.DEBUG_NATURES) {
            System.out.println("Configuring nature: " + natureID + " on project: " + project.getName());
        }
        Platform.run(code);
    }

    public void configureNatures(Project project, ProjectDescription oldDescription, ProjectDescription newDescription, MultiStatus status) {
        int i2;
        HashSet<String> newNatures;
        HashSet<String> oldNatures = new HashSet<String>(Arrays.asList(oldDescription.getNatureIds(false)));
        if (oldNatures.equals(newNatures = new HashSet<String>(Arrays.asList(newDescription.getNatureIds(false))))) {
            return;
        }
        HashSet deletions = (HashSet)oldNatures.clone();
        HashSet additions = (HashSet)newNatures.clone();
        additions.removeAll(oldNatures);
        deletions.removeAll(newNatures);
        IStatus result = this.validateAdditions(newNatures, additions, project);
        if (!result.isOK()) {
            status.merge(result);
            return;
        }
        result = this.validateRemovals(newNatures, deletions);
        if (!result.isOK()) {
            status.merge(result);
            return;
        }
        oldDescription.setNatureIds(newDescription.getNatureIds(true));
        this.flushEnablements(project);
        String[] ordered = null;
        if (deletions.size() > 0) {
            ordered = this.sortNatureSet(deletions.toArray(new String[deletions.size()]));
            i2 = ordered.length;
            while (--i2 >= 0) {
                this.deconfigureNature(project, ordered[i2], status);
            }
        }
        if (additions.size() > 0) {
            ordered = this.sortNatureSet(additions.toArray(new String[additions.size()]));
            i2 = 0;
            while (i2 < ordered.length) {
                this.configureNature(project, ordered[i2], status);
                ++i2;
            }
        }
    }

    protected IProjectNature createNature(Project project, String natureID) throws CoreException {
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "natures", natureID);
        if (extension == null) {
            String message = NLS.bind(Messages.resources_natureExtension, natureID);
            throw new ResourceException(2, project.getFullPath(), message, null);
        }
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length < 1) {
            String message = NLS.bind(Messages.resources_natureClass, natureID);
            throw new ResourceException(2, project.getFullPath(), message, null);
        }
        IConfigurationElement config = null;
        int i2 = 0;
        while (config == null && i2 < configs.length) {
            if ("runtime".equalsIgnoreCase(configs[i2].getName())) {
                config = configs[i2];
            }
            ++i2;
        }
        if (config == null) {
            String message = NLS.bind(Messages.resources_natureFormat, natureID);
            throw new ResourceException(2, project.getFullPath(), message, null);
        }
        try {
            IProjectNature nature = (IProjectNature)config.createExecutableExtension("run");
            nature.setProject(project);
            return nature;
        }
        catch (ClassCastException e2) {
            String message = NLS.bind(Messages.resources_natureImplement, natureID);
            throw new ResourceException(2, project.getFullPath(), message, e2);
        }
    }

    protected void deconfigureNature(final Project project, final String natureID, final MultiStatus status) {
        final ProjectInfo info = (ProjectInfo)project.getResourceInfo(false, true);
        IProjectNature existingNature = info.getNature(natureID);
        if (existingNature == null) {
            try {
                existingNature = this.createNature(project, natureID);
            }
            catch (CoreException e2) {
                ResourcesPlugin.getPlugin().getLog().log(e2.getStatus());
                return;
            }
        }
        final IProjectNature nature = existingNature;
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                nature.deconfigure();
                info.setNature(natureID, null);
            }

            public void handleException(Throwable exception) {
                if (exception instanceof CoreException) {
                    status.add(((CoreException)exception).getStatus());
                } else {
                    status.add(new ResourceStatus(566, project.getFullPath(), NLS.bind(Messages.resources_natureDeconfig, natureID), exception));
                }
            }
        };
        if (Policy.DEBUG_NATURES) {
            System.out.println("Deconfiguring nature: " + natureID + " on project: " + project.getName());
        }
        Platform.run(code);
    }

    protected void detectCycles() {
        Collection values = this.descriptors.values();
        ProjectNatureDescriptor[] natures = values.toArray(new ProjectNatureDescriptor[values.size()]);
        int i2 = 0;
        while (i2 < natures.length) {
            if (natures[i2].colour == 0) {
                this.hasCycles(natures[i2]);
            }
            ++i2;
        }
    }

    protected IStatus failure(String reason) {
        return new ResourceStatus(35, reason);
    }

    public String findNatureForBuilder(String builderID) {
        if (this.buildersToNatures == null) {
            this.buildersToNatures = new HashMap(10);
            IProjectNatureDescriptor[] descs = this.getNatureDescriptors();
            int i2 = 0;
            while (i2 < descs.length) {
                String natureId = descs[i2].getNatureId();
                String[] builders = ((ProjectNatureDescriptor)descs[i2]).getBuilderIds();
                int j2 = 0;
                while (j2 < builders.length) {
                    this.buildersToNatures.put(builders[j2], natureId);
                    ++j2;
                }
                ++i2;
            }
        }
        return (String)this.buildersToNatures.get(builderID);
    }

    protected void flushEnablements(IProject project) {
        if (this.natureEnablements != null) {
            this.natureEnablements.remove(project);
            if (this.natureEnablements.size() == 0) {
                this.natureEnablements = null;
            }
        }
    }

    protected String[] getEnabledNatures(Project project) {
        String[] enabled;
        if (this.natureEnablements != null && (enabled = (String[])this.natureEnablements.get(project)) != null) {
            return enabled;
        }
        enabled = this.computeNatureEnablements(project);
        this.setEnabledNatures(project, enabled);
        return enabled;
    }

    protected boolean hasCycles(ProjectNatureDescriptor desc) {
        if (desc.colour == 2) {
            return desc.hasCycle;
        }
        if (desc.colour == 1) {
            desc.hasCycle = true;
            desc.colour = (byte)2;
            return true;
        }
        desc.colour = 1;
        String[] required = desc.getRequiredNatureIds();
        int i2 = 0;
        while (i2 < required.length) {
            ProjectNatureDescriptor dependency = (ProjectNatureDescriptor)this.getNatureDescriptor(required[i2]);
            if (dependency != null && this.hasCycles(dependency)) {
                desc.hasCycle = true;
                desc.colour = (byte)2;
                return true;
            }
            ++i2;
        }
        desc.hasCycle = false;
        desc.colour = (byte)2;
        return false;
    }

    protected boolean hasLinks(IProject project) {
        try {
            IResource[] children = project.members();
            int i2 = 0;
            while (i2 < children.length) {
                if (children[i2].isLinked()) {
                    return true;
                }
                ++i2;
            }
        }
        catch (CoreException e2) {
            ResourcesPlugin.getPlugin().getLog().log(e2.getStatus());
        }
        return false;
    }

    protected String hasSetOverlap(IProjectNatureDescriptor one, IProjectNatureDescriptor two) {
        if (one == null || two == null) {
            return null;
        }
        String[] setsOne = one.getNatureSetIds();
        String[] setsTwo = two.getNatureSetIds();
        int iOne = 0;
        while (iOne < setsOne.length) {
            int iTwo = 0;
            while (iTwo < setsTwo.length) {
                if (setsOne[iOne].equals(setsTwo[iTwo])) {
                    return setsOne[iOne];
                }
                ++iTwo;
            }
            ++iOne;
        }
        return null;
    }

    protected void insert(ArrayList list, Set seen, String id) {
        if (seen.contains(id)) {
            return;
        }
        seen.add(id);
        IProjectNatureDescriptor desc = this.getNatureDescriptor(id);
        if (desc != null) {
            String[] prereqs = desc.getRequiredNatureIds();
            int i2 = 0;
            while (i2 < prereqs.length) {
                this.insert(list, seen, prereqs[i2]);
                ++i2;
            }
        }
        list.add(id);
    }

    public boolean isNatureEnabled(Project project, String id) {
        String[] enabled = this.getEnabledNatures(project);
        int i2 = 0;
        while (i2 < enabled.length) {
            if (enabled[i2].equals(id)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    protected void lazyInitialize() {
        if (this.descriptors != null) {
            return;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "natures");
        IExtension[] extensions = point.getExtensions();
        this.descriptors = new HashMap(extensions.length * 2 + 1);
        int i2 = 0;
        int imax = extensions.length;
        while (i2 < imax) {
            ProjectNatureDescriptor desc = null;
            try {
                desc = new ProjectNatureDescriptor(extensions[i2]);
            }
            catch (CoreException e2) {
                ResourcesPlugin.getPlugin().getLog().log(e2.getStatus());
            }
            if (desc != null) {
                this.descriptors.put(desc.getNatureId(), desc);
            }
            ++i2;
        }
        this.detectCycles();
    }

    protected void setEnabledNatures(IProject project, String[] enablements) {
        if (this.natureEnablements == null) {
            this.natureEnablements = new HashMap(20);
        }
        this.natureEnablements.put(project, enablements);
    }

    public void shutdown(IProgressMonitor monitor) {
    }

    public String[] sortNatureSet(String[] natureIds) {
        int count = natureIds.length;
        if (count == 0) {
            return natureIds;
        }
        ArrayList result = new ArrayList(count);
        HashSet<String> seen = new HashSet<String>(count);
        int i2 = 0;
        while (i2 < count) {
            this.insert(result, seen, natureIds[i2]);
            ++i2;
        }
        seen.clear();
        seen.addAll(Arrays.asList(natureIds));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Object id = it.next();
            if (seen.contains(id)) continue;
            it.remove();
        }
        return result.toArray(new String[result.size()]);
    }

    public void startup(IProgressMonitor monitor) {
        ((Workspace)ResourcesPlugin.getWorkspace()).addLifecycleListener(this);
    }

    protected IStatus validateAdditions(HashSet newNatures, HashSet additions, IProject project) {
        Boolean hasLinks = null;
        Iterator added = additions.iterator();
        while (added.hasNext()) {
            String id = (String)added.next();
            IProjectNatureDescriptor desc = this.getNatureDescriptor(id);
            if (desc == null) {
                return this.failure(NLS.bind(Messages.natures_missingNature, id));
            }
            if (((ProjectNatureDescriptor)desc).hasCycle) {
                return this.failure(NLS.bind(Messages.natures_hasCycle, id));
            }
            String[] required = desc.getRequiredNatureIds();
            int i2 = 0;
            while (i2 < required.length) {
                if (!newNatures.contains(required[i2])) {
                    return this.failure(NLS.bind(Messages.natures_missingPrerequisite, id, required[i2]));
                }
                ++i2;
            }
            Iterator all = newNatures.iterator();
            while (all.hasNext()) {
                String overlap;
                String current = (String)all.next();
                if (current.equals(id) || (overlap = this.hasSetOverlap(desc, this.getNatureDescriptor(current))) == null) continue;
                return this.failure(NLS.bind(Messages.natures_multipleSetMembers, overlap));
            }
            if (desc.isLinkingAllowed()) continue;
            if (hasLinks == null) {
                Boolean bl = hasLinks = this.hasLinks(project) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!hasLinks.booleanValue()) continue;
            return this.failure(NLS.bind(Messages.links_vetoNature, project.getName(), id));
        }
        return Status.OK_STATUS;
    }

    public IStatus validateLinkCreation(String[] natureIds) {
        int i2 = 0;
        while (i2 < natureIds.length) {
            IProjectNatureDescriptor desc = this.getNatureDescriptor(natureIds[i2]);
            if (desc != null && !desc.isLinkingAllowed()) {
                String msg = NLS.bind(Messages.links_natureVeto, desc.getLabel());
                return new ResourceStatus(378, msg);
            }
            ++i2;
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateRemovals(HashSet newNatures, HashSet deletions) {
        Iterator it = newNatures.iterator();
        while (it.hasNext()) {
            String currentID = (String)it.next();
            IProjectNatureDescriptor desc = this.getNatureDescriptor(currentID);
            if (desc == null) continue;
            String[] required = desc.getRequiredNatureIds();
            int i2 = 0;
            while (i2 < required.length) {
                if (deletions.contains(required[i2])) {
                    return this.failure(NLS.bind(Messages.natures_invalidRemoval, required[i2], currentID));
                }
                ++i2;
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus validateNatureSet(String[] natureIds) {
        int count = natureIds.length;
        if (count == 0) {
            return Status.OK_STATUS;
        }
        String msg = Messages.natures_invalidSet;
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 35, msg, null);
        HashSet<String> natures = new HashSet<String>(count * 2);
        HashSet<String> sets = new HashSet<String>(count);
        int i2 = 0;
        while (i2 < count) {
            String id = natureIds[i2];
            ProjectNatureDescriptor desc = (ProjectNatureDescriptor)this.getNatureDescriptor(id);
            if (desc == null) {
                result.add(this.failure(NLS.bind(Messages.natures_missingNature, id)));
            } else {
                if (desc.hasCycle) {
                    result.add(this.failure(NLS.bind(Messages.natures_hasCycle, id)));
                }
                if (!natures.add(id)) {
                    result.add(this.failure(NLS.bind(Messages.natures_duplicateNature, id)));
                }
                String[] setIds = desc.getNatureSetIds();
                int j2 = 0;
                while (j2 < setIds.length) {
                    if (!sets.add(setIds[j2])) {
                        result.add(this.failure(NLS.bind(Messages.natures_multipleSetMembers, setIds[j2])));
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < count) {
            IProjectNatureDescriptor desc = this.getNatureDescriptor(natureIds[i2]);
            if (desc != null) {
                String[] required = desc.getRequiredNatureIds();
                int j3 = 0;
                while (j3 < required.length) {
                    if (!natures.contains(required[j3])) {
                        result.add(this.failure(NLS.bind(Messages.natures_missingPrerequisite, natureIds[i2], required[j3])));
                    }
                    ++j3;
                }
            }
            ++i2;
        }
        return result.isOK() ? Status.OK_STATUS : result;
    }
}

