/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.internal.events.PathVariableChangeEvent;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class PathVariableManager
implements IPathVariableManager,
IManager {
    private Set listeners = Collections.synchronizedSet(new HashSet());
    private Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
    static final String VARIABLE_PREFIX = "pathvariable.";

    public IPath getValue(String varName) {
        String key = this.getKeyForName(varName);
        String value = this.preferences.getString(key);
        return value.length() == 0 ? null : Path.fromPortableString(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String varName, IPath newValue) throws CoreException {
        int eventType;
        this.checkIsValidName(varName);
        if (newValue != null && newValue.isAbsolute() && newValue.getDevice() == null) {
            newValue = new Path(newValue.toFile().getAbsolutePath());
        }
        this.checkIsValidValue(newValue);
        PathVariableManager pathVariableManager = this;
        synchronized (pathVariableManager) {
            boolean variableExists;
            IPath currentValue = this.getValue(varName);
            boolean bl = variableExists = currentValue != null;
            if (!variableExists && newValue == null) {
                return;
            }
            if (variableExists && currentValue.equals(newValue)) {
                return;
            }
            if (newValue == null) {
                this.preferences.setToDefault(this.getKeyForName(varName));
                eventType = 3;
            } else {
                this.preferences.setValue(this.getKeyForName(varName), newValue.toPortableString());
                eventType = variableExists ? 1 : 2;
            }
        }
        this.fireVariableChangeEvent(varName, newValue, eventType);
    }

    private void checkIsValidValue(IPath newValue) throws CoreException {
        IStatus status = this.validateValue(newValue);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private String getKeyForName(String varName) {
        return VARIABLE_PREFIX + varName;
    }

    public IPath resolvePath(IPath path) {
        if (path == null || path.segmentCount() == 0 || path.isAbsolute() || path.getDevice() != null) {
            return path;
        }
        IPath value = this.getValue(path.segment(0));
        return value == null ? path : value.append(path.removeFirstSegments(1));
    }

    private void fireVariableChangeEvent(String name, IPath value, int type) {
        if (this.listeners.size() == 0) {
            return;
        }
        Object[] listenerArray = this.listeners.toArray();
        final PathVariableChangeEvent pve = new PathVariableChangeEvent(this, name, value, type);
        int i2 = 0;
        while (i2 < listenerArray.length) {
            final IPathVariableChangeListener l2 = (IPathVariableChangeListener)listenerArray[i2];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    l2.pathVariableChanged(pve);
                }
            };
            Platform.run(job);
            ++i2;
        }
    }

    public String[] getPathVariableNames() {
        LinkedList<String> result = new LinkedList<String>();
        String[] names = this.preferences.propertyNames();
        int i2 = 0;
        while (i2 < names.length) {
            String key;
            if (names[i2].startsWith(VARIABLE_PREFIX) && this.validateName(key = names[i2].substring(VARIABLE_PREFIX.length())).isOK() && this.validateValue(this.getValue(key)).isOK()) {
                result.add(key);
            }
            ++i2;
        }
        return result.toArray(new String[result.size()]);
    }

    public void addChangeListener(IPathVariableChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(IPathVariableChangeListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isDefined(String varName) {
        return this.getValue(varName) != null;
    }

    public IStatus validateName(String name) {
        String message = null;
        if (name.length() == 0) {
            message = Messages.pathvar_length;
            return new ResourceStatus(77, null, message);
        }
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            message = NLS.bind(Messages.pathvar_beginLetter, String.valueOf(first));
            return new ResourceStatus(77, null, message);
        }
        int i2 = 1;
        while (i2 < name.length()) {
            char following = name.charAt(i2);
            if (!Character.isLetter(following) && !Character.isDigit(following) && following != '_') {
                message = NLS.bind(Messages.pathvar_invalidChar, String.valueOf(following));
                return new ResourceStatus(77, null, message);
            }
            ++i2;
        }
        return Status.OK_STATUS;
    }

    public IStatus validateValue(IPath value) {
        if (!(value == null || value.isValidPath(value.toString()) && value.isAbsolute())) {
            String message = Messages.pathvar_invalidValue;
            return new ResourceStatus(77, null, message);
        }
        return Status.OK_STATUS;
    }

    private void checkIsValidName(String name) throws CoreException {
        IStatus status = this.validateName(name);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public void startup(IProgressMonitor monitor) {
    }

    public void shutdown(IProgressMonitor monitor) {
    }
}

