/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;

public class XMLWriter
extends PrintWriter {
    protected int tab = 0;
    protected static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public XMLWriter(OutputStream output) throws UnsupportedEncodingException {
        super(new OutputStreamWriter(output, "UTF8"));
        this.println(XML_VERSION);
    }

    public void endTag(String name) {
        --this.tab;
        this.printTag(String.valueOf('/') + name, null);
    }

    public void printSimpleTag(String name, Object value) {
        if (value != null) {
            this.printTag(name, null, true, false);
            this.print(XMLWriter.getEscaped(String.valueOf(value)));
            this.printTag(String.valueOf('/') + name, null, false, true);
        }
    }

    public void printTabulation() {
        int i2 = 0;
        while (i2 < this.tab) {
            super.print('\t');
            ++i2;
        }
    }

    public void printTag(String name, HashMap parameters) {
        this.printTag(name, parameters, true, true);
    }

    public void printTag(String name, HashMap parameters, boolean shouldTab, boolean newLine) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(name);
        if (parameters != null) {
            Iterator it = parameters.keySet().iterator();
            while (it.hasNext()) {
                sb.append(" ");
                String key = (String)it.next();
                sb.append(key);
                sb.append("=\"");
                sb.append(XMLWriter.getEscaped(String.valueOf(parameters.get(key))));
                sb.append("\"");
            }
        }
        sb.append(">");
        if (shouldTab) {
            this.printTabulation();
        }
        if (newLine) {
            this.println(sb.toString());
        } else {
            this.print(sb.toString());
        }
    }

    public void startTag(String name, HashMap parameters) {
        this.startTag(name, parameters, true);
    }

    public void startTag(String name, HashMap parameters, boolean newLine) {
        this.printTag(name, parameters, true, newLine);
        ++this.tab;
    }

    private static void appendEscapedChar(StringBuffer buffer, char c2) {
        String replacement = XMLWriter.getReplacement(c2);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c2);
        }
    }

    public static String getEscaped(String s2) {
        StringBuffer result = new StringBuffer(s2.length() + 10);
        int i2 = 0;
        while (i2 < s2.length()) {
            XMLWriter.appendEscapedChar(result, s2.charAt(i2));
            ++i2;
        }
        return result.toString();
    }

    private static String getReplacement(char c2) {
        switch (c2) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

