/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.AuthorizationHandler;
import org.eclipse.core.internal.runtime.DataArea;
import org.eclipse.core.internal.runtime.FindSupport;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.internal.runtime.Product;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProductProvider;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.adaptor.FileManager;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public final class InternalPlatform {
    private static IAdapterManager adapterManager;
    private static String[] allArgs;
    private static String[] appArgs;
    private static final String APPLICATION = "-application";
    private static final String[] ARCH_LIST;
    private static final String BOOT = "-boot";
    private static final String CLASSLOADER_PROPERTIES = "-classloaderProperties";
    public static boolean DEBUG;
    public static boolean DEBUG_CONTEXT;
    public static boolean DEBUG_PREFERENCE_GENERAL;
    public static boolean DEBUG_PREFERENCE_GET;
    public static boolean DEBUG_PREFERENCE_SET;
    public static boolean DEBUG_REGISTRY;
    public static String DEBUG_REGISTRY_DUMP;
    private static Runnable splashHandler;
    private static final String FEATURE = "-feature";
    private static final String FIRST_USE = "-firstUse";
    private static String[] frameworkArgs;
    static FrameworkLog frameworkLog;
    static EnvironmentInfo infoService;
    private static boolean initialized;
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final String KEY_PREFIX = "%";
    private static final String KEYRING = "-keyring";
    private static String keyringFile;
    private static ArrayList logListeners;
    private static Map logs;
    private static DataArea metaArea;
    private static final String NEW_UPDATES = "-newUpdates";
    private static final String NO_LAZY_REGISTRY_CACHE_LOADING = "-noLazyRegistryCacheLoading";
    private static final String NO_PACKAGE_PREFIXES = "-noPackagePrefixes";
    private static final String NO_REGISTRY_CACHE = "-noregistrycache";
    private static final String NO_UPDATE = "-noUpdate";
    private static final String[] OS_LIST;
    static PackageAdmin packageAdmin;
    private static String password;
    private static final String PASSWORD = "-password";
    private static PlatformLogWriter platformLog;
    private static final String PLUGIN_CUSTOMIZATION = "-plugincustomization";
    private static final String PLUGIN_PATH = ".plugin-path";
    public static String pluginCustomizationFile;
    private static final String PLUGINS = "-plugins";
    private static final String PRODUCT = "-product";
    public static final String PROP_ADAPTOR = "osgi.adaptor";
    public static final String PROP_APPLICATION = "eclipse.application";
    public static final String PROP_ARCH = "osgi.arch";
    public static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_CONSOLE = "osgi.console";
    public static final String PROP_CONSOLE_CLASS = "osgi.consoleClass";
    public static final String PROP_CONSOLE_LOG = "eclipse.consoleLog";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_EXITCODE = "eclipse.exitcode";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    public static final String PROP_MANIFEST_CACHE = "osgi.manifest.cache";
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_NO_LAZY_CACHE_LOADING = "eclipse.noLazyRegistryCacheLoading";
    public static final String PROP_NO_REGISTRY_CACHE = "eclipse.noRegistryCache";
    public static final String PROP_NO_REGISTRY_FLUSHING = "eclipse.noRegistryFlushing";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_PRODUCT = "eclipse.product";
    public static final String PROP_SYSPATH = "osgi.syspath";
    public static final String PROP_USER_AREA = "osgi.user.area";
    public static final String PROP_WS = "osgi.ws";
    private static final InternalPlatform singleton;
    private static final String UPDATE = "-update";
    static URLConverter urlConverter;
    private static final String[] WS_LIST;
    private Path cachedInstanceLocation;
    private ServiceTracker configurationLocation = null;
    private BundleContext context;
    private ServiceTracker debugTracker = null;
    private ArrayList groupProviders = new ArrayList(3);
    private ServiceTracker installLocation = null;
    private ServiceTracker instanceLocation = null;
    private boolean missingProductReported = false;
    private DebugOptions options = null;
    private IProduct product;
    private IExtensionRegistry registry;
    private FileManager runtimeFileManager;
    private Plugin runtimeInstance;
    private ServiceTracker userLocation = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        allArgs = new String[0];
        appArgs = new String[0];
        ARCH_LIST = new String[]{"PA_RISC", "ppc", "sparc", "x86", "x86_64", "ia64", "ia64_32"};
        DEBUG = false;
        DEBUG_CONTEXT = false;
        DEBUG_PREFERENCE_GENERAL = false;
        DEBUG_PREFERENCE_GET = false;
        DEBUG_PREFERENCE_SET = false;
        DEBUG_REGISTRY = false;
        DEBUG_REGISTRY_DUMP = null;
        splashHandler = null;
        frameworkArgs = new String[0];
        logListeners = new ArrayList(5);
        logs = new HashMap(5);
        OS_LIST = new String[]{"aix", "hpux", "linux", "macosx", "qnx", "solaris", "win32"};
        password = "";
        platformLog = null;
        pluginCustomizationFile = null;
        singleton = new InternalPlatform();
        WS_LIST = new String[]{"carbon", "gtk", "motif", "photon", "win32"};
    }

    public static InternalPlatform getDefault() {
        return singleton;
    }

    private InternalPlatform() {
    }

    public void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) throws CoreException {
        AuthorizationHandler.addAuthorizationInfo(serverUrl, realm, authScheme, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(ILogListener listener) {
        this.assertInitialized();
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            logListeners.remove(listener);
            logListeners.add(listener);
        }
    }

    public void addProtectionSpace(URL resourceUrl, String realm) throws CoreException {
        AuthorizationHandler.addProtectionSpace(resourceUrl, realm);
    }

    private URL asActualURL(URL url) throws IOException {
        if (!url.getProtocol().equals("platform")) {
            return url;
        }
        URLConnection connection = url.openConnection();
        if (connection instanceof PlatformURLConnection) {
            return ((PlatformURLConnection)connection).getResolvedURL();
        }
        return url;
    }

    public URL asLocalURL(URL url) throws IOException {
        URL result = url;
        if (result.getProtocol().equals("platform")) {
            result = this.asActualURL(url);
        }
        if (result.getProtocol().startsWith("bundle")) {
            if (urlConverter == null) {
                throw new IOException("url.noaccess");
            }
            result = urlConverter.convertToFileURL(result);
        }
        return result;
    }

    private void assertInitialized() {
        if (!initialized) {
            Assert.isTrue(false, Messages.meta_appNotInit);
        }
    }

    public void clearRegistryCache() {
        if (this.registry instanceof ExtensionRegistry) {
            ((ExtensionRegistry)this.registry).clearRegistryCache();
        }
    }

    public void endSplash() {
        final Runnable handler = splashHandler;
        if (handler == null) {
            return;
        }
        splashHandler = null;
        this.run(new ISafeRunnable(){

            public void handleException(Throwable e2) {
            }

            public void run() throws Exception {
                handler.run();
            }
        });
    }

    public URL find(Bundle b2, IPath path) {
        return FindSupport.find(b2, path);
    }

    public URL find(Bundle bundle, IPath path, Map override) {
        return FindSupport.find(bundle, path, override);
    }

    public void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        AuthorizationHandler.flushAuthorizationInfo(serverUrl, realm, authScheme);
    }

    public IAdapterManager getAdapterManager() {
        this.assertInitialized();
        if (adapterManager == null) {
            adapterManager = new AdapterManager();
        }
        return adapterManager;
    }

    public String[] getApplicationArgs() {
        return appArgs;
    }

    public Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        return AuthorizationHandler.getAuthorizationInfo(serverUrl, realm, authScheme);
    }

    public boolean getBooleanOption(String option, boolean defaultValue) {
        String value = this.getOption(option);
        if (value == null) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("true");
    }

    public Bundle getBundle(String symbolicName) {
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < bundles.length) {
            if ((bundles[i2].getState() & 3) == 0) {
                return bundles[i2];
            }
            ++i2;
        }
        return null;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public IBundleGroupProvider[] getBundleGroupProviders() {
        return this.groupProviders.toArray(new IBundleGroupProvider[this.groupProviders.size()]);
    }

    public String getBundleId(Object object) {
        if (object == null) {
            return null;
        }
        if (packageAdmin == null) {
            return null;
        }
        Bundle source = packageAdmin.getBundle(object.getClass());
        if (source != null && source.getSymbolicName() != null) {
            return source.getSymbolicName();
        }
        return null;
    }

    public Bundle[] getBundles(String symbolicName, String version) {
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, version);
        if (bundles == null) {
            return null;
        }
        if (bundles.length == 1 && (bundles[0].getState() & 3) == 0) {
            return bundles;
        }
        Bundle[] selectedBundles = new Bundle[bundles.length];
        int added = 0;
        int i2 = 0;
        while (i2 < bundles.length) {
            if ((bundles[i2].getState() & 3) == 0) {
                selectedBundles[added++] = bundles[i2];
            }
            ++i2;
        }
        if (added == 0) {
            return null;
        }
        Bundle[] results = new Bundle[added];
        System.arraycopy(selectedBundles, 0, results, 0, added);
        return results;
    }

    public String[] getCommandLineArgs() {
        return allArgs;
    }

    public Location getConfigurationLocation() {
        this.assertInitialized();
        return (Location)this.configurationLocation.getService();
    }

    public IContentTypeManager getContentTypeManager() {
        return ContentTypeManager.getInstance();
    }

    public EnvironmentInfo getEnvironmentInfoService() {
        return infoService;
    }

    public Bundle[] getFragments(Bundle bundle) {
        if (packageAdmin == null) {
            return null;
        }
        return packageAdmin.getFragments(bundle);
    }

    public FrameworkLog getFrameworkLog() {
        return frameworkLog;
    }

    public Bundle[] getHosts(Bundle bundle) {
        if (packageAdmin == null) {
            return null;
        }
        return packageAdmin.getHosts(bundle);
    }

    public Location getInstallLocation() {
        this.assertInitialized();
        return (Location)this.installLocation.getService();
    }

    public URL getInstallURL() {
        Location location = this.getInstallLocation();
        if (location == null) {
            throw new IllegalStateException("The installation location must not be null");
        }
        return location.getURL();
    }

    public Location getInstanceLocation() {
        this.assertInitialized();
        return (Location)this.instanceLocation.getService();
    }

    public int getIntegerOption(String option, int defaultValue) {
        String value = this.getOption(option);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public IJobManager getJobManager() {
        return JobManager.getInstance();
    }

    public IPath getLocation() throws IllegalStateException {
        if (this.cachedInstanceLocation == null) {
            Location location = this.getInstanceLocation();
            if (location == null) {
                return null;
            }
            File file = new File(location.getURL().getFile());
            this.cachedInstanceLocation = new Path(file.toString());
        }
        return this.cachedInstanceLocation;
    }

    public ILog getLog(Bundle bundle) {
        ILog result = (ILog)logs.get(bundle);
        if (result != null) {
            return result;
        }
        result = new Log(bundle);
        logs.put(bundle, result);
        return result;
    }

    public IPath getLogFileLocation() {
        return this.getMetaArea().getLogLocation();
    }

    public DataArea getMetaArea() {
        if (metaArea != null) {
            return metaArea;
        }
        metaArea = new DataArea();
        return metaArea;
    }

    public String getNL() {
        return System.getProperty(PROP_NL);
    }

    public String getOption(String option) {
        if (this.options != null) {
            return this.options.getOption(option);
        }
        return null;
    }

    public String getOS() {
        return System.getProperty(PROP_OS);
    }

    public String getOSArch() {
        return System.getProperty(PROP_ARCH);
    }

    public PlatformAdmin getPlatformAdmin() {
        ServiceReference platformAdminReference;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((platformAdminReference = this.context.getServiceReference(clazz.getName())) == null) {
            return null;
        }
        return (PlatformAdmin)this.context.getService(platformAdminReference);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL[] getPluginPath(URL pluginPathLocation) {
        InputStream input = null;
        if (pluginPathLocation == null) {
            return null;
        }
        try {
            input = pluginPathLocation.openStream();
        }
        catch (IOException iOException) {}
        if (input == null) {
            try {
                URL url = new URL("platform:/base/.plugin-path");
                input = url.openStream();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        if (input == null) {
            return null;
        }
        URL[] result = null;
        try {
            try {
                result = this.readPluginPath(input);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                input.close();
                throw throwable;
            }
            {
                Object var4_6 = null;
                input.close();
                return result;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public IPreferencesService getPreferencesService() {
        return PreferencesService.getDefault();
    }

    public Properties getPreferenceTranslator(String uniqueIdentifier, String basePrefFileName) {
        return new Properties();
    }

    public IProduct getProduct() {
        if (this.product != null) {
            return this.product;
        }
        String productId = System.getProperty(PROP_PRODUCT);
        if (productId == null) {
            return null;
        }
        IConfigurationElement[] entries = this.getRegistry().getConfigurationElementsFor("org.eclipse.core.runtime", "products", productId);
        if (entries.length > 0) {
            this.product = new Product(productId, entries[0]);
            return this.product;
        }
        IConfigurationElement[] elements = this.getRegistry().getConfigurationElementsFor("org.eclipse.core.runtime", "products");
        ArrayList<FrameworkLogEntry> logEntries = null;
        int i2 = 0;
        while (i2 < elements.length) {
            IConfigurationElement element = elements[i2];
            if (element.getName().equalsIgnoreCase("provider")) {
                try {
                    IProductProvider provider = (IProductProvider)element.createExecutableExtension("run");
                    IProduct[] products = provider.getProducts();
                    int j2 = 0;
                    while (j2 < products.length) {
                        IProduct provided = products[j2];
                        if (provided.getId().equalsIgnoreCase(productId)) {
                            this.product = provided;
                            return this.product;
                        }
                        ++j2;
                    }
                }
                catch (CoreException e2) {
                    if (logEntries == null) {
                        logEntries = new ArrayList<FrameworkLogEntry>(3);
                    }
                    logEntries.add(new FrameworkLogEntry("org.eclipse.core.runtime", NLS.bind(Messages.provider_invalid, element.getParent().toString()), 0, e2, null));
                }
            }
            ++i2;
        }
        if (logEntries != null) {
            this.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.core.runtime", Messages.provider_invalid_general, 0, null, (FrameworkLogEntry[])logEntries.toArray()));
        }
        if (!this.missingProductReported) {
            this.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.core.runtime", NLS.bind(Messages.product_notFound, productId), 0, null, null));
            this.missingProductReported = true;
        }
        return null;
    }

    public String getProtectionSpace(URL resourceUrl) {
        return AuthorizationHandler.getProtectionSpace(resourceUrl);
    }

    public IExtensionRegistry getRegistry() {
        return this.registry;
    }

    public ResourceBundle getResourceBundle(Bundle bundle) {
        return ResourceTranslator.getResourceBundle(bundle);
    }

    public String getResourceString(Bundle bundle, String value) {
        return ResourceTranslator.getResourceString(bundle, value);
    }

    public String getResourceString(Bundle bundle, String value, ResourceBundle resourceBundle) {
        return ResourceTranslator.getResourceString(bundle, value, resourceBundle);
    }

    public FileManager getRuntimeFileManager() {
        return this.runtimeFileManager;
    }

    public Plugin getRuntimeInstance() {
        return this.runtimeInstance;
    }

    private Runnable getSplashHandler() {
        ServiceReference[] ref;
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Runnable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ref = this.context.getServiceReferences(clazz.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        int i2 = 0;
        while (i2 < ref.length) {
            String name = (String)ref[i2].getProperty("name");
            if (name != null && name.equals("splashscreen")) {
                Runnable result = (Runnable)this.context.getService(ref[i2]);
                this.context.ungetService(ref[i2]);
                return result;
            }
            ++i2;
        }
        return null;
    }

    public IPath getStateLocation(Bundle bundle) {
        return this.getStateLocation(bundle, true);
    }

    public IPath getStateLocation(Bundle bundle, boolean create) throws IllegalStateException {
        this.assertInitialized();
        IPath result = this.getMetaArea().getStateLocation(bundle);
        if (create) {
            result.toFile().mkdirs();
        }
        return result;
    }

    public long getStateTimeStamp() {
        PlatformAdmin admin = this.getPlatformAdmin();
        return admin == null ? -1L : admin.getState(false).getTimeStamp();
    }

    public URLConverter getURLConverter() {
        return urlConverter;
    }

    public Location getUserLocation() {
        this.assertInitialized();
        return (Location)this.userLocation.getService();
    }

    public String getWS() {
        return System.getProperty(PROP_WS);
    }

    private void handleException(ISafeRunnable code, Throwable e2) {
        if (!(e2 instanceof OperationCanceledException)) {
            Status status;
            String pluginId = this.getBundleId(code);
            if (pluginId == null) {
                pluginId = "org.eclipse.core.runtime";
            }
            String message = NLS.bind(Messages.meta_pluginProblems, pluginId);
            if (e2 instanceof CoreException) {
                status = new MultiStatus(pluginId, 2, message, e2);
                status.merge(((CoreException)e2).getStatus());
            } else {
                status = new Status(4, pluginId, 2, message, e2);
            }
            if (initialized) {
                this.log(status);
            } else {
                e2.printStackTrace();
            }
        }
        code.handleException(e2);
    }

    public boolean hasLogWriter() {
        return platformLog != null && logListeners.contains(platformLog);
    }

    private void initializeAuthorizationHandler() {
        AuthorizationHandler.setKeyringFile(keyringFile);
        AuthorizationHandler.setPassword(password);
    }

    void initializeDebugFlags() {
        DEBUG = this.getBooleanOption("org.eclipse.core.runtime/debug", false);
        if (DEBUG) {
            DEBUG_CONTEXT = this.getBooleanOption("org.eclipse.core.runtime/debug/context", false);
            DEBUG_REGISTRY = this.getBooleanOption("org.eclipse.core.runtime/registry/debug", false);
            DEBUG_REGISTRY_DUMP = this.getOption("org.eclipse.core.runtime/registry/debug/dump");
            DEBUG_PREFERENCE_GENERAL = this.getBooleanOption("org.eclipse.core.runtime/preferences/general", false);
            DEBUG_PREFERENCE_GET = this.getBooleanOption("org.eclipse.core.runtime/preferences/get", false);
            DEBUG_PREFERENCE_SET = this.getBooleanOption("org.eclipse.core.runtime/preferences/set", false);
        }
    }

    private void initializeLocationTrackers() {
        Filter filter = null;
        try {
            filter = this.context.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.configuration.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.configurationLocation = new ServiceTracker(this.context, filter, null);
        this.configurationLocation.open();
        try {
            filter = this.context.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.user.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.userLocation = new ServiceTracker(this.context, filter, null);
        this.userLocation.open();
        try {
            filter = this.context.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.instance.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.instanceLocation = new ServiceTracker(this.context, filter, null);
        this.instanceLocation.open();
        try {
            filter = this.context.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.install.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.installLocation = new ServiceTracker(this.context, filter, null);
        this.installLocation.open();
    }

    private void initializeRuntimeFileManager() throws IOException {
        Location configuration = this.getConfigurationLocation();
        File controlledDir = new File(String.valueOf(configuration.getURL().getPath()) + '/' + "org.eclipse.core.runtime");
        this.runtimeFileManager = new FileManager(controlledDir, configuration.isReadOnly() ? "none" : null, configuration.isReadOnly());
        this.runtimeFileManager.open(!configuration.isReadOnly());
    }

    public boolean isFragment(Bundle bundle) {
        if (packageAdmin == null) {
            return false;
        }
        return (packageAdmin.getBundleType(bundle) & 1) > 0;
    }

    public boolean isRunning() {
        try {
            return initialized && this.context.getBundle().getState() == 32;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    public String[] knownOSArchValues() {
        return ARCH_LIST;
    }

    public String[] knownOSValues() {
        return OS_LIST;
    }

    public String[] knownWSValues() {
        return WS_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(final IStatus status) {
        ILogListener[] listeners;
        if (!initialized) {
            Throwable t2 = status.getException();
            if (t2 != null) {
                t2.printStackTrace();
            }
            this.assertInitialized();
        }
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            listeners = logListeners.toArray(new ILogListener[logListeners.size()]);
        }
        int i2 = 0;
        while (i2 < listeners.length) {
            final ILogListener listener = listeners[i2];
            ISafeRunnable code = new ISafeRunnable(){

                public void handleException(Throwable e2) {
                }

                public void run() throws Exception {
                    listener.logging(status, "org.eclipse.core.runtime");
                }
            };
            this.run(code);
            ++i2;
        }
    }

    private String[] processCommandLine(String[] args) {
        if (args == null) {
            return args;
        }
        allArgs = args;
        if (args.length == 0) {
            return args;
        }
        int[] configArgs = new int[args.length];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i2 = 0;
        while (i2 < args.length) {
            boolean found = false;
            if (args[i2].equalsIgnoreCase(NO_REGISTRY_CACHE)) {
                System.getProperties().setProperty(PROP_NO_REGISTRY_CACHE, "true");
                found = true;
            }
            if (args[i2].equalsIgnoreCase(NO_LAZY_REGISTRY_CACHE_LOADING)) {
                System.getProperties().setProperty(PROP_NO_LAZY_CACHE_LOADING, "true");
                found = true;
            }
            if (args[i2].equalsIgnoreCase(CLASSLOADER_PROPERTIES)) {
                found = true;
            }
            if (args[i2].equalsIgnoreCase(NO_PACKAGE_PREFIXES)) {
                found = true;
            }
            if (args[i2].equalsIgnoreCase(PLUGINS)) {
                found = true;
            }
            if (args[i2].equalsIgnoreCase(FIRST_USE)) {
                found = true;
            }
            if (args[i2].equalsIgnoreCase(NO_UPDATE)) {
                found = true;
            }
            if (args[i2].equalsIgnoreCase(NEW_UPDATES)) {
                found = true;
            }
            if (args[i2].equalsIgnoreCase(UPDATE)) {
                found = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i2;
            } else if (i2 != args.length - 1 && !args[i2 + 1].startsWith("-")) {
                String arg = args[++i2];
                if (args[i2 - 1].equalsIgnoreCase(KEYRING)) {
                    keyringFile = arg;
                    found = true;
                }
                if (args[i2 - 1].equalsIgnoreCase(PASSWORD)) {
                    password = arg;
                    found = true;
                }
                if (args[i2 - 1].equalsIgnoreCase(PRODUCT) || args[i2 - 1].equalsIgnoreCase(FEATURE)) {
                    System.getProperties().setProperty(PROP_PRODUCT, arg);
                    found = true;
                }
                if (args[i2 - 1].equalsIgnoreCase(APPLICATION)) {
                    System.getProperties().setProperty(PROP_APPLICATION, arg);
                    found = true;
                }
                if (args[i2 - 1].equalsIgnoreCase(PLUGIN_CUSTOMIZATION)) {
                    pluginCustomizationFile = arg;
                    found = true;
                }
                if (args[i2 - 1].equalsIgnoreCase(CLASSLOADER_PROPERTIES)) {
                    found = true;
                }
                if (args[i2 - 1].equalsIgnoreCase(BOOT)) {
                    found = true;
                }
                if (found) {
                    configArgs[configArgIndex++] = i2 - 1;
                    configArgs[configArgIndex++] = i2;
                }
            }
            ++i2;
        }
        if (configArgIndex == 0) {
            appArgs = args;
            return args;
        }
        appArgs = new String[args.length - configArgIndex];
        frameworkArgs = new String[configArgIndex];
        configArgIndex = 0;
        int j2 = 0;
        int k2 = 0;
        int i3 = 0;
        while (i3 < args.length) {
            if (i3 == configArgs[configArgIndex]) {
                InternalPlatform.frameworkArgs[k2++] = args[i3];
                ++configArgIndex;
            } else {
                InternalPlatform.appArgs[j2++] = args[i3];
            }
            ++i3;
        }
        return appArgs;
    }

    private URL[] readPluginPath(InputStream input) {
        Properties ini = new Properties();
        try {
            ini.load(input);
        }
        catch (IOException iOException) {
            return null;
        }
        Vector<URL> result = new Vector<URL>(5);
        Enumeration<?> groups = ini.propertyNames();
        while (groups.hasMoreElements()) {
            String group = (String)groups.nextElement();
            StringTokenizer entries = new StringTokenizer(ini.getProperty(group), ";");
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                if (entry.equals("")) continue;
                try {
                    result.addElement(new URL(entry));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Ignoring plugin: " + entry);
                }
            }
        }
        return result.toArray(new URL[result.size()]);
    }

    public void registerBundleGroupProvider(IBundleGroupProvider provider) {
        this.groupProviders.add(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogListener(ILogListener listener) {
        this.assertInitialized();
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            logListeners.remove(listener);
        }
    }

    public URL resolve(URL url) throws IOException {
        URL result = this.asActualURL(url);
        if (!result.getProtocol().startsWith("bundle")) {
            return result;
        }
        if (urlConverter == null) {
            throw new IOException("url.noaccess");
        }
        result = urlConverter.convertToLocalURL(result);
        return result;
    }

    public void run(ISafeRunnable code) {
        Assert.isNotNull(code);
        try {
            code.run();
        }
        catch (Exception e2) {
            this.handleException(code, e2);
        }
        catch (LinkageError e3) {
            this.handleException(code, e3);
        }
    }

    public void setExtensionRegistry(IExtensionRegistry value) {
        this.registry = value;
    }

    public void setOption(String option, String value) {
        if (this.options != null) {
            this.options.setOption(option, value);
        }
    }

    public void setRuntimeInstance(Plugin runtime) {
        this.runtimeInstance = runtime;
    }

    public void start(BundleContext runtimeContext) throws IOException {
        this.context = runtimeContext;
        this.initializeLocationTrackers();
        ResourceTranslator.start();
        splashHandler = this.getSplashHandler();
        this.processCommandLine(infoService.getNonFrameworkArgs());
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.debugTracker = new ServiceTracker(this.context, clazz.getName(), null);
        this.debugTracker.open();
        this.options = (DebugOptions)this.debugTracker.getService();
        this.initializeDebugFlags();
        initialized = true;
        this.getMetaArea();
        this.initializeAuthorizationHandler();
        platformLog = new PlatformLogWriter(this.getFrameworkLog());
        this.addLogListener(platformLog);
        this.initializeRuntimeFileManager();
    }

    public void stop(BundleContext bundleContext) {
        this.assertInitialized();
        JobManager.shutdown();
        this.debugTracker.close();
        ResourceTranslator.stop();
        initialized = false;
        this.context = null;
    }

    public String translatePreference(String value, Properties props) {
        value = value.trim();
        if (props == null || value.startsWith(KEY_DOUBLE_PREFIX)) {
            return value;
        }
        if (value.startsWith(KEY_PREFIX)) {
            int ix = value.indexOf(" ");
            String key = ix == -1 ? value : value.substring(0, ix);
            String dflt = ix == -1 ? value : value.substring(ix + 1);
            return props.getProperty(key.substring(1), dflt);
        }
        return value;
    }

    public void unregisterBundleGroupProvider(IBundleGroupProvider provider) {
        this.groupProviders.remove(provider);
    }
}

