/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.NotifierImpl;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ResourceImpl
extends NotifierImpl
implements Resource,
Resource.Internal {
    private static URIConverter defaultURIConverter;
    protected Map defaultSaveOptions;
    protected Map defaultLoadOptions;
    protected ResourceSet resourceSet;
    protected URI uri;
    protected ContentsEList contents;
    protected EList errors;
    protected EList warnings;
    protected boolean isModified;
    protected boolean isLoaded;
    protected Adapter modificationTrackingAdapter;
    protected Map intrinsicIDToEObjectMap;

    protected static URIConverter getDefaultURIConverter() {
        if (defaultURIConverter == null) {
            defaultURIConverter = new URIConverterImpl();
        }
        return defaultURIConverter;
    }

    public ResourceImpl() {
    }

    public ResourceImpl(URI uri) {
        this();
        this.uri = uri;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        ResourceSet oldResourceSet = this.resourceSet;
        if (oldResourceSet != null) {
            notifications = ((InternalEList)oldResourceSet.getResources()).basicRemove(this, notifications);
        }
        this.resourceSet = resourceSet;
        if (this.eNotificationRequired()) {
            if (notifications == null) {
                notifications = new NotificationChainImpl(2);
            }
            notifications.add(new NotificationImpl(1, (Object)oldResourceSet, resourceSet){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 0;
                }
            });
        }
        return notifications;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        URI oldURI = this.uri;
        this.uri = uri;
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, (Object)oldURI, uri){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 1;
                }
            };
            this.eNotify(notification);
        }
    }

    public EList getContents() {
        if (this.contents == null) {
            this.contents = new ContentsEList();
        }
        return this.contents;
    }

    public TreeIterator getAllContents() {
        return new AbstractTreeIterator(this, false){

            public Iterator getChildren(Object object) {
                return object == ResourceImpl.this ? ResourceImpl.this.getContents().iterator() : ((EObject)object).eContents().iterator();
            }
        };
    }

    public EList getErrors() {
        if (this.errors == null) {
            this.errors = new NotifyingListImpl(){

                protected boolean isNotificationRequired() {
                    return ResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID() {
                    return 6;
                }
            };
        }
        return this.errors;
    }

    public EList getWarnings() {
        if (this.warnings == null) {
            this.warnings = new NotifyingListImpl(){

                protected boolean isNotificationRequired() {
                    return ResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID() {
                    return 7;
                }
            };
        }
        return this.warnings;
    }

    protected boolean useZip() {
        return false;
    }

    protected String getURIFragmentRootSegment(EObject eObject) {
        EList contents = this.getContents();
        return contents.size() > 1 ? Integer.toString(this.getContents().indexOf(eObject)) : "";
    }

    public String getURIFragment(EObject eObject) {
        String id = EcoreUtil.getID(eObject);
        if (id != null) {
            return id;
        }
        ArrayList<String> uriFragmentPath = new ArrayList<String>();
        EObject container = eObject.eContainer();
        while (container != null) {
            uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment(eObject.eContainingFeature(), eObject));
            eObject = container;
            container = eObject.eContainer();
        }
        StringBuffer result = new StringBuffer("/");
        result.append(this.getURIFragmentRootSegment(eObject));
        ListIterator i2 = uriFragmentPath.listIterator(uriFragmentPath.size());
        while (i2.hasPrevious()) {
            result.append('/');
            result.append((String)i2.previous());
        }
        return result.toString();
    }

    protected EObject getEObjectForURIFragmentRootSegment(String uriFragmentRootSegment) {
        EList contents;
        int position = 0;
        if (uriFragmentRootSegment.length() > 0) {
            try {
                position = Integer.parseInt(uriFragmentRootSegment);
            }
            catch (NumberFormatException exception) {
                throw new WrappedException(exception);
            }
        }
        if (position < (contents = this.getContents()).size()) {
            return (EObject)contents.get(position);
        }
        return null;
    }

    public EObject getEObject(String uriFragment) {
        int length = uriFragment.length();
        if (length > 0) {
            int index;
            if (uriFragment.charAt(0) == '/') {
                ArrayList<String> uriFragmentPath = new ArrayList<String>(4);
                int start = 1;
                for (int i2 = 1; i2 < length; ++i2) {
                    if (uriFragment.charAt(i2) != '/') continue;
                    uriFragmentPath.add(start == i2 ? "" : uriFragment.substring(start, i2));
                    start = i2 + 1;
                }
                uriFragmentPath.add(uriFragment.substring(start));
                return this.getEObject(uriFragmentPath);
            }
            if (uriFragment.charAt(length - 1) == '?' && (index = uriFragment.lastIndexOf(63, length - 2)) > 0) {
                uriFragment = uriFragment.substring(0, index);
            }
        }
        return this.getEObjectByID(uriFragment);
    }

    protected EObject getEObject(List uriFragmentPath) {
        int size = uriFragmentPath.size();
        EObject eObject = this.getEObjectForURIFragmentRootSegment(size == 0 ? "" : (String)uriFragmentPath.get(0));
        for (int i2 = 1; i2 < size && eObject != null; ++i2) {
            eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment((String)uriFragmentPath.get(i2));
        }
        return eObject;
    }

    public Map getIntrinsicIDToEObjectMap() {
        return this.intrinsicIDToEObjectMap;
    }

    public void setIntrinsicIDToEObjectMap(Map intrinsicIDToEObjectMap) {
        this.intrinsicIDToEObjectMap = intrinsicIDToEObjectMap;
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        Map map = this.getIntrinsicIDToEObjectMap();
        if (map != null && (eObject = (EObject)map.get(id)) != null) {
            return eObject;
        }
        TreeIterator i2 = this.getAllContents();
        while (i2.hasNext()) {
            EObject eObject2 = (EObject)i2.next();
            String eObjectId = EcoreUtil.getID(eObject2);
            if (eObjectId == null) continue;
            if (map != null) {
                map.put(eObjectId, eObject2);
            }
            if (!eObjectId.equals(id)) continue;
            return eObject2;
        }
        return null;
    }

    public void attached(EObject eObject) {
        if (this.isAttachedDetachedHelperRequired()) {
            this.attachedHelper(eObject);
            TreeIterator tree = eObject.eAllContents();
            while (tree.hasNext()) {
                this.attachedHelper((EObject)tree.next());
            }
        }
    }

    protected boolean isAttachedDetachedHelperRequired() {
        return this.isTrackingModification() || this.getIntrinsicIDToEObjectMap() != null;
    }

    protected void attachedHelper(EObject eObject) {
        String id;
        Map map;
        if (this.isTrackingModification()) {
            eObject.eAdapters().add(this.modificationTrackingAdapter);
        }
        if ((map = this.getIntrinsicIDToEObjectMap()) != null && (id = EcoreUtil.getID(eObject)) != null) {
            map.put(id, eObject);
        }
    }

    protected final void addModificationTrackingAdapters(EObject eObject) {
    }

    public void detached(EObject eObject) {
        if (this.isAttachedDetachedHelperRequired()) {
            this.detachedHelper(eObject);
            TreeIterator tree = eObject.eAllContents();
            while (tree.hasNext()) {
                this.detachedHelper((EObject)tree.next());
            }
        }
    }

    protected void detachedHelper(EObject eObject) {
        String id;
        Map map = this.getIntrinsicIDToEObjectMap();
        if (map != null && (id = EcoreUtil.getID(eObject)) != null) {
            map.remove(id);
        }
        if (this.isTrackingModification()) {
            eObject.eAdapters().remove(this.modificationTrackingAdapter);
        }
    }

    protected final void removeModificationTrackingAdapters(EObject eObject) {
    }

    protected URIConverter getURIConverter() {
        return this.getResourceSet() == null ? ResourceImpl.getDefaultURIConverter() : this.getResourceSet().getURIConverter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Map options) throws IOException {
        URIConverter uriConverter = this.getURIConverter();
        OutputStream outputStream = uriConverter.createOutputStream(this.getURI());
        try {
            this.save(outputStream, options);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Map options) throws IOException {
        if (!this.isLoaded) {
            URIConverter uriConverter = this.getURIConverter();
            InputStream inputStream = uriConverter.createInputStream(this.getURI());
            try {
                this.load(inputStream, options);
            }
            finally {
                inputStream.close();
            }
        }
    }

    protected ZipEntry newContentZipEntry() {
        return new ZipEntry("ResourceContents");
    }

    public final void save(OutputStream outputStream, Map options) throws IOException {
        ZipOutputStream zipOutputStream = null;
        if (this.useZip()) {
            zipOutputStream = new ZipOutputStream(outputStream){

                public void flush() {
                }

                public void close() throws IOException {
                    try {
                        super.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    super.close();
                }
            };
            zipOutputStream.putNextEntry(this.newContentZipEntry());
            outputStream = zipOutputStream;
        }
        if (this.defaultSaveOptions == null || this.defaultSaveOptions.isEmpty()) {
            this.doSave(outputStream, options);
        } else if (options == null) {
            this.doSave(outputStream, this.defaultSaveOptions);
        } else {
            HashMap mergedOptions = new HashMap(this.defaultSaveOptions);
            mergedOptions.putAll(options);
            this.doSave(outputStream, mergedOptions);
        }
        this.setModified(false);
        if (zipOutputStream != null) {
            zipOutputStream.finish();
        }
    }

    protected void doSave(OutputStream outputStream, Map options) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean isContentZipEntry(ZipEntry zipEntry) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(InputStream inputStream, Map options) throws IOException {
        if (!this.isLoaded) {
            block12: {
                Notification notification = this.setLoaded(true);
                if (this.errors != null) {
                    this.errors.clear();
                }
                if (this.warnings != null) {
                    this.warnings.clear();
                }
                if (this.useZip()) {
                    ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                    while (zipInputStream.available() != 0) {
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        if (!this.isContentZipEntry(zipEntry)) continue;
                        inputStream = zipInputStream;
                        break;
                    }
                }
                try {
                    if (this.defaultLoadOptions == null || this.defaultLoadOptions.isEmpty()) {
                        this.doLoad(inputStream, options);
                    } else if (options == null) {
                        this.doLoad(inputStream, this.defaultLoadOptions);
                    } else {
                        HashMap mergedOptions = new HashMap(this.defaultLoadOptions);
                        mergedOptions.putAll(options);
                        this.doLoad(inputStream, mergedOptions);
                    }
                    Object var7_6 = null;
                    if (notification == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (notification != null) {
                        this.eNotify(notification);
                    }
                    this.setModified(false);
                    throw throwable;
                }
                this.eNotify(notification);
            }
            this.setModified(false);
            {
            }
        }
    }

    protected void doLoad(InputStream inputStream, Map options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    protected void unloaded(InternalEObject internalEObject) {
        internalEObject.eSetProxyURI(this.uri.appendFragment(this.getURIFragment(internalEObject)));
        internalEObject.eAdapters().clear();
    }

    protected Notification setLoaded(boolean isLoaded) {
        boolean oldIsLoaded = this.isLoaded;
        this.isLoaded = isLoaded;
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsLoaded, isLoaded){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 4;
                }
            };
            return notification;
        }
        return null;
    }

    protected void doUnload() {
        TreeIterator allContents = EcoreUtil.getAllContents(new ArrayList(this.getContents()));
        if (!this.getContents().isEmpty()) {
            this.getContents().clear();
        }
        this.getErrors().clear();
        this.getWarnings().clear();
        while (allContents.hasNext()) {
            this.unloaded((InternalEObject)allContents.next());
        }
    }

    public final void unload() {
        if (this.isLoaded) {
            Notification notification = this.setLoaded(false);
            this.doUnload();
            if (notification != null) {
                this.eNotify(notification);
            }
        }
    }

    public boolean isTrackingModification() {
        return this.modificationTrackingAdapter != null;
    }

    public void setTrackingModification(boolean isTrackingModification) {
        boolean oldIsTrackingModification;
        boolean bl = oldIsTrackingModification = this.modificationTrackingAdapter != null;
        if (oldIsTrackingModification != isTrackingModification) {
            if (isTrackingModification) {
                this.modificationTrackingAdapter = this.createModificationTrackingAdapter();
                TreeIterator i2 = this.getAllContents();
                while (i2.hasNext()) {
                    EObject eObject = (EObject)i2.next();
                    eObject.eAdapters().add(this.modificationTrackingAdapter);
                }
            } else {
                Adapter oldModificationTrackingAdapter = this.modificationTrackingAdapter;
                this.modificationTrackingAdapter = null;
                TreeIterator i3 = this.getAllContents();
                while (i3.hasNext()) {
                    EObject eObject = (EObject)i3.next();
                    eObject.eAdapters().remove(oldModificationTrackingAdapter);
                }
            }
        }
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsTrackingModification, isTrackingModification){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 5;
                }
            };
            this.eNotify(notification);
        }
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ModificationTrackingAdapter();
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean isModified) {
        boolean oldIsModified = this.isModified;
        this.isModified = isModified;
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsModified, isModified){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 3;
                }
            };
            this.eNotify(notification);
        }
    }

    public String toKeyString() {
        StringBuffer result = new StringBuffer("Key type: ");
        result.append(this.getClass().toString());
        return result.toString();
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + " uri='" + this.uri + "'";
    }

    protected class ModificationTrackingAdapter
    extends AdapterImpl {
        protected ModificationTrackingAdapter() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 7: {
                    if (notification.isTouch()) break;
                    ResourceImpl.this.setModified(true);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    ResourceImpl.this.setModified(true);
                }
            }
        }
    }

    protected class ContentsEList
    extends NotifyingListImpl
    implements InternalEList {
        protected ContentsEList() {
        }

        public Object getNotifier() {
            return ResourceImpl.this;
        }

        public int getFeatureID() {
            return 2;
        }

        protected boolean isNotificationRequired() {
            return ResourceImpl.this.eNotificationRequired();
        }

        protected boolean useEquals() {
            return false;
        }

        protected boolean hasInverse() {
            return true;
        }

        protected boolean isUnique() {
            return true;
        }

        public NotificationChain inverseAdd(Object object, NotificationChain notifications) {
            InternalEObject eObject = (InternalEObject)object;
            notifications = eObject.eSetResource(ResourceImpl.this, notifications);
            ResourceImpl.this.attached(eObject);
            return notifications;
        }

        public NotificationChain inverseRemove(Object object, NotificationChain notifications) {
            InternalEObject eObject = (InternalEObject)object;
            if (ResourceImpl.this.isLoaded) {
                ResourceImpl.this.detached(eObject);
            }
            return eObject.eSetResource(null, notifications);
        }

        public Iterator basicIterator() {
            return super.basicIterator();
        }

        public ListIterator basicListIterator() {
            return super.basicListIterator();
        }

        public ListIterator basicListIterator(int index) {
            return super.basicListIterator(index);
        }

        public List basicList() {
            return super.basicList();
        }

        protected Object[] newData(int capacity) {
            return new EObject[capacity];
        }

        protected void didAdd(int index, Object object) {
            super.didAdd(index, object);
            this.loaded();
            this.modified();
        }

        protected void didRemove(int index, Object object) {
            super.didRemove(index, object);
            this.modified();
        }

        protected void didSet(int index, Object newObject, Object oldObject) {
            super.didSet(index, newObject, oldObject);
            this.modified();
        }

        protected void didClear(int oldSize, Object[] oldData) {
            if (oldSize == 0) {
                this.loaded();
            } else {
                super.didClear(oldSize, oldData);
            }
        }

        protected void loaded() {
            Notification notification;
            if (!ResourceImpl.this.isLoaded() && (notification = ResourceImpl.this.setLoaded(true)) != null) {
                ResourceImpl.this.eNotify(notification);
            }
        }

        protected void modified() {
            if (ResourceImpl.this.isTrackingModification()) {
                ResourceImpl.this.setModified(true);
            }
        }
    }
}

