/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.domain.MappingDomain;

public class PersistentCommandStack
extends BasicCommandStack {
    protected HashMap commandCreationMap = new HashMap();
    protected MappingDomain domain;
    protected ClassLoader classLoader;
    protected String encoding;
    static /* synthetic */ Class class$org$eclipse$emf$mapping$command$RestoreInitialStateCommand;

    public PersistentCommandStack(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void handleCreateCommand(Class commandClass, CommandParameter commandParameter, Command command) {
        CommandCreationRecord commandCreationRecord = new CommandCreationRecord(commandClass, commandParameter);
        this.commandCreationMap.put(command, commandCreationRecord);
    }

    protected Encoder createEncoder() {
        return new Encoder();
    }

    protected Decoder createDecoder(MappingRoot mappingRoot, ResourceSet resourceSet, ClassLoader classLoader) {
        return new Decoder(mappingRoot, resourceSet, classLoader);
    }

    public void execute(Command command) {
        CommandCreationRecord commandCreationRecord = (CommandCreationRecord)this.commandCreationMap.get(command);
        if (commandCreationRecord != null) {
            commandCreationRecord.encode(this.createEncoder());
            System.out.println("Executing Encoded Command: " + commandCreationRecord.getEncoding());
        } else {
            System.out.println("Executing Unregistered Command: " + command);
            Thread.dumpStack();
        }
        super.execute(command);
        if (this.encoding != null) {
            this.executeEncoding();
        }
    }

    public String getEncoding() {
        ArrayList<CommandCreationRecord> commandCreationRecordList = new ArrayList<CommandCreationRecord>();
        for (int i2 = 0; i2 <= this.top; ++i2) {
            CommandCreationRecord commandCreationRecord = (CommandCreationRecord)this.commandCreationMap.get(this.commandList.get(i2));
            if (commandCreationRecord == null) {
                System.out.println("UnregisteredCommand:" + this.commandList.get(i2));
                break;
            }
            if (commandCreationRecord.getCommandClass() == (class$org$eclipse$emf$mapping$command$RestoreInitialStateCommand == null ? PersistentCommandStack.class$("org.eclipse.emf.mapping.command.RestoreInitialStateCommand") : class$org$eclipse$emf$mapping$command$RestoreInitialStateCommand)) continue;
            commandCreationRecordList.add(commandCreationRecord);
        }
        Encoder encoder = this.createEncoder();
        encoder.encode(commandCreationRecordList);
        return encoder.toString();
    }

    public void setEncoding(MappingDomain domain, String encoding) {
        this.domain = domain;
        this.encoding = encoding;
    }

    protected void executeEncoding() {
        Decoder decoder = this.createDecoder(this.domain.getMappingRoot(), this.domain.getResourceSet(), this.classLoader);
        decoder.setEncoding(this.encoding);
        this.encoding = null;
        Collection commandCreationRecordList = (Collection)decoder.decode();
        if (commandCreationRecordList != null) {
            boolean failure = false;
            Iterator commandCreationRecords = commandCreationRecordList.iterator();
            while (commandCreationRecords.hasNext()) {
                CommandCreationRecord commandCreationRecord = (CommandCreationRecord)commandCreationRecords.next();
                commandCreationRecord.decode(decoder);
                Command command = this.domain.createCommand(commandCreationRecord.getCommandClass(), commandCreationRecord.getCommandParameter());
                if (command.canExecute()) {
                    System.out.println("Re-executed Command: " + command);
                    this.execute(command);
                    continue;
                }
                System.out.println("Not! Executing Command: " + command);
                command.dispose();
                failure = true;
                break;
            }
            if (!failure) {
                this.saveIsDone();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CommandCreationRecord {
        Class commandClass;
        CommandParameter commandParameter;
        String encoding;

        public CommandCreationRecord(Class commandClass, CommandParameter commandParameter) {
            this.commandClass = commandClass;
            this.commandParameter = commandParameter;
            this.encoding = null;
        }

        public CommandCreationRecord(String encoding) {
            this.encoding = encoding;
        }

        public CommandParameter getCommandParameter() {
            return this.commandParameter;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public Class getCommandClass() {
            return this.commandClass;
        }

        public void encode(Encoder encoder) {
            encoder.encode(this.commandClass);
            encoder.encode(this.commandParameter);
            this.encoding = encoder.toString();
        }

        public void decode(Decoder decoder) {
            decoder.setEncoding(this.encoding);
            this.commandClass = (Class)decoder.decode();
            this.commandParameter = (CommandParameter)decoder.decode();
        }

        public String toString() {
            return "CommandCreationRecord { commandClass=" + (this.commandClass == null ? "null" : this.commandClass.getName()) + ", commandParameter=" + this.commandParameter + " }";
        }
    }

    public static class Decoder {
        protected String string;
        protected int index = 0;
        protected ResourceSet resourceSet;
        protected ClassLoader classLoader;
        protected MappingRoot mappingRoot;

        public Decoder(MappingRoot mappingRoot, ResourceSet resourceSet, ClassLoader classLoader) {
            this.mappingRoot = mappingRoot;
            this.resourceSet = resourceSet;
            this.classLoader = classLoader;
        }

        public void setEncoding(String encoding) {
            this.string = encoding;
            this.index = 0;
        }

        protected void skipWhitespace() {
            while (this.index < this.string.length() && Character.isWhitespace(this.string.charAt(this.index))) {
                ++this.index;
            }
        }

        public Object decode() {
            Object result = null;
            this.skipWhitespace();
            if (this.index < this.string.length() && this.string.charAt(this.index) == '<') {
                ++this.index;
                this.skipWhitespace();
                int keyStartIndex = this.index;
                while (this.index < this.string.length() && !Character.isWhitespace(this.string.charAt(this.index)) && this.string.charAt(this.index) != '/' && this.string.charAt(this.index) != '>') {
                    ++this.index;
                }
                String key = this.string.substring(keyStartIndex, this.index);
                if (key.equals("null")) {
                    this.index = this.string.indexOf(">", this.index) + 1;
                    result = null;
                } else if (key.equals("class")) {
                    this.index = this.string.indexOf("\"", this.index);
                    int classIndex = ++this.index;
                    this.index = this.string.indexOf("\"", this.index);
                    String className = this.string.substring(classIndex, this.index);
                    this.index = this.string.indexOf(">", this.index) + 1;
                    try {
                        result = this.classLoader.loadClass(className);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (key.equals("drag-and-drop-detail")) {
                    this.index = this.string.indexOf(">", this.index) + 1;
                    float location = ((Float)this.decode()).floatValue();
                    int operations = (Integer)this.decode();
                    int operation = (Integer)this.decode();
                    this.index = this.string.indexOf(">", this.index) + 1;
                    result = new DragAndDropCommand.Detail(location, operations, operation);
                } else if (key.equals("command-parameter")) {
                    this.index = this.string.indexOf(">", this.index) + 1;
                    Object owner = this.decode();
                    Object feature = this.decode();
                    Collection collection = (Collection)this.decode();
                    Object value = this.decode();
                    int theIndex = (Integer)this.decode();
                    this.index = this.string.indexOf(">", this.index) + 1;
                    result = collection == null ? new CommandParameter(owner, feature, value, theIndex) : new CommandParameter(owner, feature, collection, theIndex);
                } else if (key.equals("command-creation-record")) {
                    int startIndex = this.index = this.string.indexOf(">", this.index) + 1;
                    this.index = this.string.indexOf("</command-creation-record>", this.index);
                    this.index = this.string.indexOf(">", this.index) + 1;
                    result = new CommandCreationRecord(this.string.substring(startIndex, this.index));
                } else if (key.equals("ref-object")) {
                    this.index = this.string.indexOf("\"", this.index);
                    int hrefStartIndex = ++this.index;
                    this.index = this.string.indexOf("\"", this.index);
                    String href = this.string.substring(hrefStartIndex, this.index);
                    this.index = this.string.indexOf(">", this.index) + 1;
                    result = this.resourceSet.getEObject(URI.createURI(href), true);
                } else if (key.equals("ref_structural-feature")) {
                    this.index = this.string.indexOf("\"", this.index);
                    int startIndex = ++this.index;
                    this.index = this.string.indexOf("\"", this.index);
                    String packageURI = this.string.substring(startIndex, this.index);
                    this.index = this.string.indexOf("\"", this.index + 1);
                    startIndex = ++this.index;
                    this.index = this.string.indexOf("\"", this.index);
                    String metaObjectName = this.string.substring(startIndex, this.index);
                    this.index = this.string.indexOf("\"", this.index + 1);
                    startIndex = ++this.index;
                    this.index = this.string.indexOf("\"", this.index);
                    String metaFeatureName = this.string.substring(startIndex, this.index);
                    this.index = this.string.indexOf(">", this.index) + 1;
                    EPackage refPackage = EPackage.Registry.INSTANCE.getEPackage(packageURI);
                    EClass metaObject = (EClass)refPackage.getEClassifier(metaObjectName);
                    EStructuralFeature metaFeature = metaObject.getEStructuralFeature(metaFeatureName);
                    result = metaFeature;
                } else if (key.equals("mapping")) {
                    this.index = this.string.indexOf(">", this.index) + 1;
                    Collection mappedObjects = (Collection)this.decode();
                    int value = (Integer)this.decode();
                    this.index = this.string.indexOf(">", this.index) + 1;
                    Collection collection = this.mappingRoot.getExactMappings(mappedObjects);
                    if (collection.size() > 1) {
                        TreeIterator mappings = this.mappingRoot.treeIterator();
                        while (mappings.hasNext()) {
                            Object mapping = mappings.next();
                            if (!collection.contains(mapping)) continue;
                            if (value == 0) {
                                result = mapping;
                                break;
                            }
                            --value;
                        }
                    }
                    if (result == null && !collection.isEmpty()) {
                        result = collection.iterator().next();
                    }
                } else if (key.equals("collection")) {
                    ArrayList<Object> collection = new ArrayList<Object>();
                    this.index = this.string.indexOf(">", this.index) + 1;
                    while (this.index < this.string.length() && Character.isWhitespace(this.string.charAt(this.index))) {
                        ++this.index;
                    }
                    while (this.index < this.string.length() && this.string.indexOf("</collection>", this.index) != this.index) {
                        Object object = this.decode();
                        collection.add(object);
                        while (this.index < this.string.length() && Character.isWhitespace(this.string.charAt(this.index))) {
                            ++this.index;
                        }
                    }
                    if (this.index < this.string.length()) {
                        this.index += "</collection>".length();
                    }
                    result = collection;
                } else if (key.equals("string")) {
                    this.index = this.string.indexOf("\"", this.index);
                    int startIndex = ++this.index;
                    this.index = this.string.indexOf("\"", this.index);
                    String value = this.string.substring(startIndex, this.index);
                    this.index = this.string.indexOf(">", this.index) + 1;
                    result = value;
                } else if (key.equals("int")) {
                    this.index = this.string.indexOf("\"", this.index);
                    int startIndex = ++this.index;
                    this.index = this.string.indexOf("\"", this.index);
                    String value = this.string.substring(startIndex, this.index);
                    this.index = this.string.indexOf(">", this.index) + 1;
                    result = Integer.valueOf(value);
                } else if (key.equals("float")) {
                    this.index = this.string.indexOf("\"", this.index);
                    int startIndex = ++this.index;
                    this.index = this.string.indexOf("\"", this.index);
                    String value = this.string.substring(startIndex, this.index);
                    this.index = this.string.indexOf(">", this.index) + 1;
                    result = Float.valueOf(value);
                } else {
                    this.index = this.string.indexOf("</unknown>", this.index) + "</unknown>".length();
                }
                this.skipWhitespace();
            }
            return result;
        }

        public String toString() {
            return this.index < this.string.length() ? this.string.substring(this.index) : "";
        }
    }

    public static class Encoder {
        protected StringBuffer buffer;

        public Encoder() {
            this.buffer = new StringBuffer();
        }

        public Encoder(StringBuffer buffer) {
            this.buffer = buffer;
        }

        public void setBuffer(StringBuffer buffer) {
            this.buffer = buffer;
        }

        public void encode(int value) {
            this.buffer.append("<int value=\"" + value + "\"/>");
        }

        public void encode(float value) {
            this.buffer.append("<float value=\"" + value + "\"/>");
        }

        public void encode(Object object) {
            if (object == null) {
                this.buffer.append("<null/>");
            } else if (object instanceof Class) {
                Class theClass = (Class)object;
                this.buffer.append("<class name=\"" + theClass.getName() + "\"/>");
            } else if (object instanceof CommandParameter) {
                CommandParameter commandParameter = (CommandParameter)object;
                this.buffer.append("<command-parameter>");
                this.encode(commandParameter.getOwner());
                this.encode(commandParameter.getFeature());
                this.encode(commandParameter.getCollection());
                this.encode(commandParameter.getValue());
                this.encode(commandParameter.getIndex());
                this.buffer.append("</command-parameter>");
            } else if (object instanceof EObject) {
                if (object instanceof Mapping) {
                    Mapping mapping = (Mapping)object;
                    MappingRoot mappingRoot = mapping.getMappingRoot();
                    if (mappingRoot != null) {
                        Collection mappedObjects = mapping.getMappedObjects();
                        Collection collection = mappingRoot.getExactMappings(mappedObjects);
                        int index = 0;
                        if (collection.size() > 1) {
                            Object otherMapping;
                            TreeIterator mappings = mappingRoot.treeIterator();
                            while (mappings.hasNext() && (otherMapping = mappings.next()) != mapping) {
                                if (!collection.contains(otherMapping)) continue;
                                ++index;
                            }
                        }
                        this.buffer.append("<mapping>");
                        this.encode(mappedObjects);
                        this.encode(index);
                        this.buffer.append("</mapping>");
                    } else {
                        this.buffer.append("<null/>");
                    }
                } else {
                    EObject refObject = (EObject)object;
                    String href = EcoreUtil.getURI(refObject).toString();
                    this.buffer.append("<ref-object href=\"" + href + "\"/>");
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                this.buffer.append("<collection>");
                Iterator objects = collection.iterator();
                while (objects.hasNext()) {
                    Object member = objects.next();
                    this.encode(member);
                }
                this.buffer.append("</collection>");
            } else if (object instanceof String) {
                this.buffer.append("<string value=\"" + (String)object + "\"/>");
            } else if (object instanceof DragAndDropCommand.Detail) {
                DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)object;
                this.buffer.append("<drag-and-drop-detail>");
                this.encode(detail.location);
                this.encode(detail.operations);
                this.encode(detail.operation);
                this.buffer.append("</drag-and-drop-detail>");
            } else if (object instanceof CommandCreationRecord) {
                CommandCreationRecord commandCreationRecord = (CommandCreationRecord)object;
                this.buffer.append("<command-creation-record>");
                this.buffer.append(commandCreationRecord.getEncoding());
                this.buffer.append("</command-creation-record>");
            } else {
                this.buffer.append("<unknown>" + object.toString() + "</unknown>");
            }
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

