/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.osgi.framework.Version;

public class BundleRepository {
    private ArrayList bundlesByInstallOrder;
    private KeyedHashSet bundlesById;
    private HashMap bundlesBySymbolicName;
    private PackageAdminImpl packageAdmin;

    public BundleRepository(int initialCapacity, PackageAdminImpl packageAdmin) {
        this.bundlesByInstallOrder = new ArrayList(initialCapacity);
        this.bundlesById = new KeyedHashSet(initialCapacity, true);
        this.bundlesBySymbolicName = new HashMap(initialCapacity);
        this.packageAdmin = packageAdmin;
    }

    public List getBundles() {
        return this.bundlesByInstallOrder;
    }

    public AbstractBundle getBundle(long bundleId) {
        Long key = new Long(bundleId);
        return (AbstractBundle)this.bundlesById.getByKey(key);
    }

    public AbstractBundle[] getBundles(String symbolicName) {
        if (Constants.getInternalSymbolicName().equals(symbolicName)) {
            symbolicName = "system.bundle";
        }
        return (AbstractBundle[])this.bundlesBySymbolicName.get(symbolicName);
    }

    public AbstractBundle getBundle(String symbolicName, Version version) {
        AbstractBundle[] bundles = this.getBundles(symbolicName);
        if (bundles != null && bundles.length > 0) {
            for (int i2 = 0; i2 < bundles.length; ++i2) {
                if (!bundles[i2].getVersion().equals(version)) continue;
                return bundles[i2];
            }
        }
        return null;
    }

    public void add(AbstractBundle bundle) {
        this.bundlesByInstallOrder.add(bundle);
        this.bundlesById.add(bundle);
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null) {
            AbstractBundle[] bundles = (AbstractBundle[])this.bundlesBySymbolicName.get(symbolicName);
            if (bundles == null) {
                bundles = new AbstractBundle[]{bundle};
                this.bundlesBySymbolicName.put(symbolicName, bundles);
                return;
            }
            ArrayList<AbstractBundle> list = new ArrayList<AbstractBundle>(bundles.length + 1);
            Version newVersion = bundle.getVersion();
            boolean added = false;
            for (int i2 = 0; i2 < bundles.length; ++i2) {
                AbstractBundle oldBundle = bundles[i2];
                Version oldVersion = oldBundle.getVersion();
                if (!added && newVersion.compareTo(oldVersion) >= 0) {
                    added = true;
                    list.add(bundle);
                }
                list.add(oldBundle);
            }
            if (!added) {
                list.add(bundle);
            }
            bundles = new AbstractBundle[list.size()];
            list.toArray(bundles);
            this.bundlesBySymbolicName.put(symbolicName, bundles);
        }
    }

    public boolean remove(AbstractBundle bundle) {
        boolean found = this.bundlesById.remove(bundle);
        if (!found) {
            return false;
        }
        this.bundlesByInstallOrder.remove(bundle);
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName == null) {
            return true;
        }
        AbstractBundle[] bundles = (AbstractBundle[])this.bundlesBySymbolicName.get(symbolicName);
        if (bundles == null) {
            return true;
        }
        int numRemoved = 0;
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            if (bundle != bundles[i2]) continue;
            ++numRemoved;
            bundles[i2] = null;
        }
        if (numRemoved > 0) {
            if (bundles.length - numRemoved <= 0) {
                this.bundlesBySymbolicName.remove(symbolicName);
            } else {
                AbstractBundle[] newBundles = new AbstractBundle[bundles.length - numRemoved];
                int indexCnt = 0;
                for (int i3 = 0; i3 < bundles.length; ++i3) {
                    if (bundles[i3] == null) continue;
                    newBundles[indexCnt] = bundles[i3];
                    ++indexCnt;
                }
                this.bundlesBySymbolicName.put(symbolicName, newBundles);
            }
        }
        return true;
    }

    public void removeAllBundles() {
        this.bundlesByInstallOrder.clear();
        this.bundlesById = new KeyedHashSet();
        this.bundlesBySymbolicName.clear();
    }
}

