/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.CyclicDependencyHashMap;
import org.eclipse.osgi.internal.module.GroupingChecker;
import org.eclipse.osgi.internal.module.PermissionChecker;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionHashMap;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class ResolverImpl
implements Resolver {
    private static final String RESOLVER = "org.eclipse.osgi/resolver";
    private static final String OPTION_DEBUG = "org.eclipse.osgi/resolver/debug";
    private static final String OPTION_WIRING = "org.eclipse.osgi/resolver/wiring";
    private static final String OPTION_IMPORTS = "org.eclipse.osgi/resolver/imports";
    private static final String OPTION_REQUIRES = "org.eclipse.osgi/resolver/requires";
    private static final String OPTION_GROUPING = "org.eclipse.osgi/resolver/grouping";
    private static final String OPTION_CYCLES = "org.eclipse.osgi/resolver/cycles";
    public static boolean DEBUG = false;
    public static boolean DEBUG_WIRING = false;
    public static boolean DEBUG_IMPORTS = false;
    public static boolean DEBUG_REQUIRES = false;
    public static boolean DEBUG_GROUPING = false;
    public static boolean DEBUG_CYCLES = false;
    private HashMap removalPending = new HashMap();
    private State state;
    private VersionHashMap resolverExports = null;
    private VersionHashMap resolverBundles = null;
    private ArrayList unresolvedBundles = null;
    private ArrayList resolvedBundles = null;
    private ArrayList resolvingBundles = null;
    private CyclicDependencyHashMap cyclicDependencies = null;
    private HashMap bundleMapping = null;
    private boolean initialized = false;
    private PermissionChecker permissionChecker;
    private GroupingChecker groupingChecker;
    private BundleContext context;

    public ResolverImpl(BundleContext context, boolean checkPermissions) {
        this.context = context;
        this.permissionChecker = new PermissionChecker(context, checkPermissions);
    }

    protected PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    private void initialize() {
        this.resolverExports = new VersionHashMap();
        this.resolverBundles = new VersionHashMap();
        this.unresolvedBundles = new ArrayList();
        this.bundleMapping = new HashMap();
        this.cyclicDependencies = new CyclicDependencyHashMap();
        BundleDescription[] bundles = this.state.getBundles();
        this.groupingChecker = new GroupingChecker();
        ArrayList fragmentBundles = new ArrayList();
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            this.initResolverBundle(bundles[i2], fragmentBundles, false);
        }
        BundleDescription[] removedBundles = this.getRemovalPending();
        for (int i3 = 0; i3 < removedBundles.length; ++i3) {
            this.initResolverBundle(removedBundles[i3], fragmentBundles, true);
        }
        Iterator iter = fragmentBundles.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            BundleDescription[] hosts = ((HostSpecification)fragment.getHost().getVersionConstraint()).getHosts();
            for (int i4 = 0; i4 < hosts.length; ++i4) {
                ResolverBundle host = (ResolverBundle)this.bundleMapping.get(hosts[i4]);
                if (host == null) continue;
                host.attachFragment(fragment, false);
            }
        }
        this.rewireBundles();
        this.groupingChecker.addInitialGroupingConstraints(this.bundleMapping.values().toArray(new ResolverBundle[this.bundleMapping.size()]));
        this.setDebugOptions();
        this.initialized = true;
    }

    private void initResolverBundle(BundleDescription bundleDesc, ArrayList fragmentBundles, boolean pending) {
        ResolverBundle bundle = new ResolverBundle(bundleDesc, this);
        this.bundleMapping.put(bundleDesc, bundle);
        if (pending) {
            return;
        }
        this.resolverBundles.put(bundle);
        if (bundleDesc.isResolved()) {
            bundle.setState(2);
            if (bundleDesc.getHost() != null) {
                fragmentBundles.add(bundle);
            }
        } else {
            this.unresolvedBundles.add(bundle);
        }
        this.resolverExports.put(bundle.getExportPackages());
    }

    private void rewireBundles() {
        Iterator iter = this.bundleMapping.values().iterator();
        while (iter.hasNext()) {
            ResolverBundle rb = (ResolverBundle)iter.next();
            if (!rb.getBundle().isResolved() || rb.isFragment()) continue;
            this.rewireBundle(rb);
        }
    }

    private void rewireBundle(ResolverBundle rb) {
        if (rb.isFullyWired()) {
            return;
        }
        BundleConstraint[] requires = rb.getRequires();
        for (int i2 = 0; i2 < requires.length; ++i2) {
            this.rewireRequire(requires[i2]);
        }
        ResolverImport[] imports = rb.getImportPackages();
        for (int i3 = 0; i3 < imports.length; ++i3) {
            this.rewireImport(imports[i3]);
        }
    }

    private void rewireRequire(BundleConstraint req) {
        if (req.getMatchingBundle() != null) {
            return;
        }
        ResolverBundle matchingBundle = (ResolverBundle)this.bundleMapping.get(req.getVersionConstraint().getSupplier());
        req.setMatchingBundle(matchingBundle);
        if (matchingBundle == null && !req.isOptional()) {
            System.err.println("Could not find matching bundle for " + req.getVersionConstraint());
        }
        if (matchingBundle != null) {
            this.rewireBundle(matchingBundle);
        }
    }

    private void rewireImport(ResolverImport imp) {
        if (imp.isDynamic() || imp.getMatchingExport() != null) {
            return;
        }
        ResolverExport matchingExport = null;
        ExportPackageDescription importSupplier = (ExportPackageDescription)imp.getImportPackageSpecification().getSupplier();
        ResolverBundle exporter = importSupplier == null ? null : (ResolverBundle)this.bundleMapping.get(importSupplier.getExporter());
        VersionSupplier[] matches = this.resolverExports.getArray(imp.getName());
        for (int j2 = 0; j2 < matches.length; ++j2) {
            ResolverExport export = (ResolverExport)matches[j2];
            if (export.getExporter() != exporter || !imp.isSatisfiedBy(export)) continue;
            matchingExport = export;
            break;
        }
        imp.setMatchingExport(matchingExport);
        if (matchingExport == null && exporter != null) {
            ResolverExport reprovidedExport = new ResolverExport(exporter, importSupplier);
            if (exporter.getExport(imp) == null) {
                exporter.addExport(reprovidedExport);
                this.resolverExports.put(reprovidedExport);
            }
            imp.setMatchingExport(reprovidedExport);
        }
        if (imp.getMatchingExport() == null && !imp.isOptional()) {
            System.err.println("Could not find matching export for " + imp.getImportPackageSpecification());
        }
        if (imp.getMatchingExport() != null) {
            this.rewireBundle(imp.getMatchingExport().getExporter());
        }
    }

    private boolean isResolvable(BundleDescription bundle, Dictionary[] platformProperties, ArrayList rejectedSingletons) {
        if (rejectedSingletons.contains(bundle)) {
            return false;
        }
        ImportPackageSpecification[] imports = bundle.getImportPackages();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            if (!"dynamic".equals(imports[i2].getDirective("resolution")) && imports[i2].getName().endsWith("*")) {
                return false;
            }
            for (int j2 = 0; j2 < i2; ++j2) {
                if (imports[i2] == imports[j2] || !imports[i2].getName().equals(imports[j2])) continue;
                return false;
            }
        }
        String platformFilter = bundle.getPlatformFilter();
        if (platformFilter == null) {
            return true;
        }
        if (platformProperties == null) {
            return false;
        }
        try {
            Filter filter = this.context.createFilter(platformFilter);
            for (int i3 = 0; i3 < platformProperties.length; ++i3) {
                if (!filter.match(platformProperties[i3])) continue;
                return true;
            }
        }
        catch (InvalidSyntaxException e2) {
            return false;
        }
        return false;
    }

    private void attachFragment(ResolverBundle bundle, ArrayList rejectedSingletons) {
        BundleDescription bundleDesc;
        VersionSupplier[] sameName;
        if (!bundle.isFragment() || !bundle.isResolvable() || rejectedSingletons.contains(bundle.getBundle())) {
            return;
        }
        if (bundle.getBundle().isSingleton() && (sameName = this.resolverBundles.getArray((bundleDesc = bundle.getBundle()).getName())).length > 1) {
            for (int j2 = 0; j2 < sameName.length; ++j2) {
                BundleDescription sameNameDesc = sameName[j2].getBundle();
                if (sameName[j2] == bundle || !sameNameDesc.isSingleton() || rejectedSingletons.contains(sameNameDesc)) continue;
                if (sameNameDesc.isResolved() || sameNameDesc.getVersion().compareTo(bundle.getBundle().getVersion()) > 0) {
                    rejectedSingletons.add(bundle.getBundle());
                    return;
                }
                rejectedSingletons.add(sameNameDesc);
            }
        }
        BundleConstraint hostConstraint = bundle.getHost();
        VersionSupplier[] hosts = this.resolverBundles.getArray(hostConstraint.getVersionConstraint().getName());
        for (int i2 = 0; i2 < hosts.length; ++i2) {
            if (!((ResolverBundle)hosts[i2]).isResolvable() || !hostConstraint.isSatisfiedBy((ResolverBundle)hosts[i2])) continue;
            this.resolverExports.put(((ResolverBundle)hosts[i2]).attachFragment(bundle, true));
        }
    }

    public synchronized void resolve(BundleDescription[] reRefresh, Dictionary[] platformProperties) {
        if (DEBUG) {
            ResolverImpl.log("*** BEGIN RESOLUTION ***");
        }
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (reRefresh != null) {
            for (int i2 = 0; i2 < reRefresh.length; ++i2) {
                ResolverBundle rb = (ResolverBundle)this.bundleMapping.get(reRefresh[i2]);
                if (rb == null) continue;
                this.unresolveBundle(rb, false);
            }
        }
        ArrayList rejectedSingletons = new ArrayList();
        ResolverBundle[] bundles = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
        this.resolveBundles(bundles, platformProperties, rejectedSingletons);
        if (this.selectSingletons(bundles, rejectedSingletons)) {
            bundles = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            this.resolveBundles(bundles, platformProperties, rejectedSingletons);
        }
        if (DEBUG_WIRING) {
            this.printWirings();
        }
        if (DEBUG) {
            ResolverImpl.log("*** END RESOLUTION ***");
        }
    }

    private void resolveBundles(ResolverBundle[] bundles, Dictionary[] platformProperties, ArrayList rejectedSingletons) {
        int i2;
        this.resolvingBundles = new ArrayList(this.unresolvedBundles.size());
        this.resolvedBundles = new ArrayList(this.unresolvedBundles.size());
        this.groupingChecker.addInitialGroupingConstraints(bundles);
        for (i2 = 0; i2 < bundles.length; ++i2) {
            bundles[i2].setResolvable(this.isResolvable(bundles[i2].getBundle(), platformProperties, rejectedSingletons));
        }
        for (i2 = 0; i2 < bundles.length; ++i2) {
            this.attachFragment(bundles[i2], rejectedSingletons);
        }
        for (i2 = 0; i2 < bundles.length; ++i2) {
            if (DEBUG) {
                ResolverImpl.log("** RESOLVING " + bundles[i2] + " **");
            }
            this.resolveBundle(bundles[i2]);
            while (this.resolvingBundles.size() > 0) {
                ResolverBundle rb = (ResolverBundle)this.resolvingBundles.get(0);
                ResolverImport[] imports = rb.getImportPackages();
                boolean needRewire = false;
                for (int j2 = 0; j2 < imports.length; ++j2) {
                    if (imports[j2].getMatchingExport() == null || this.resolverExports.contains(imports[j2].getMatchingExport())) continue;
                    imports[j2].setMatchingExport(null);
                    needRewire = true;
                }
                if (needRewire) {
                    this.resolveBundle(rb);
                }
                if (!rb.isFullyWired()) continue;
                if (DEBUG || DEBUG_CYCLES) {
                    ResolverImpl.log("Pushing " + rb + " to RESOLVED");
                }
                this.setBundleResolved(rb);
            }
        }
        if (this.unresolvedBundles.size() > 0) {
            bundles = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            for (i2 = 0; i2 < bundles.length; ++i2) {
                this.resolveFragment(bundles[i2]);
            }
        }
        this.stateResolveBundles();
        this.resolvingBundles = null;
        this.resolvedBundles = null;
    }

    private boolean selectSingletons(ResolverBundle[] bundles, ArrayList rejectedSingletons) {
        boolean result = false;
        block0: for (int i2 = 0; i2 < bundles.length; ++i2) {
            VersionSupplier[] sameName;
            BundleDescription bundleDesc = bundles[i2].getBundle();
            if (!bundleDesc.isSingleton() || !bundleDesc.isResolved() || rejectedSingletons.contains(bundleDesc) || (sameName = this.resolverBundles.getArray(bundleDesc.getName())).length <= 1) continue;
            int numDeps = bundleDesc.getDependents().length;
            for (int j2 = 0; j2 < sameName.length; ++j2) {
                BundleDescription sameNameDesc = sameName[j2].getBundle();
                if (sameName[j2] == bundles[i2] || !sameNameDesc.isSingleton() || !sameNameDesc.isResolved() || rejectedSingletons.contains(sameNameDesc)) continue;
                result = true;
                if (sameNameDesc.getVersion().compareTo(bundleDesc.getVersion()) > 0 && (sameNameDesc.getDependents().length > 0 || numDeps == 0)) {
                    if (rejectedSingletons.contains(bundles[i2].getBundle())) continue block0;
                    rejectedSingletons.add(bundles[i2].getBundle());
                    continue block0;
                }
                if (rejectedSingletons.contains(sameNameDesc)) continue;
                rejectedSingletons.add(sameNameDesc);
            }
        }
        Iterator rejects = rejectedSingletons.iterator();
        while (rejects.hasNext()) {
            this.unresolveBundle((ResolverBundle)this.bundleMapping.get(rejects.next()), false);
        }
        return result;
    }

    private void resolveFragment(ResolverBundle fragment) {
        if (!fragment.isFragment()) {
            return;
        }
        if (fragment.getHost().foundMatchingBundles()) {
            this.setBundleResolved(fragment);
        }
    }

    private boolean resolveBundle(ResolverBundle bundle) {
        ArrayList v2;
        int i2;
        VersionSupplier[] sameName;
        if (bundle.isFragment()) {
            return false;
        }
        if (!bundle.isResolvable()) {
            if (DEBUG) {
                ResolverImpl.log("  - " + bundle + " is unresolvable");
            }
            return false;
        }
        if (bundle.getState() == 2) {
            if (DEBUG) {
                ResolverImpl.log("  - " + bundle + " already resolved");
            }
            return true;
        }
        if (bundle.getState() == 0) {
            bundle.clearWires();
            this.setBundleResolving(bundle);
        }
        boolean failed = false;
        if (bundle.getBundle().isSingleton() && (sameName = this.resolverBundles.getArray(bundle.getName())).length > 1) {
            for (i2 = 0; i2 < sameName.length; ++i2) {
                if (sameName[i2] == bundle || !sameName[i2].getBundle().isSingleton() || !((ResolverBundle)sameName[i2]).getBundle().isResolved()) continue;
                failed = true;
                break;
            }
        }
        if (!failed) {
            BundleConstraint[] requires = bundle.getRequires();
            for (i2 = 0; i2 < requires.length; ++i2) {
                if (this.resolveRequire(requires[i2])) continue;
                if (DEBUG || DEBUG_REQUIRES) {
                    ResolverImpl.log("** REQUIRE " + requires[i2].getVersionConstraint().getName() + "[" + requires[i2].getActualBundle() + "] failed to resolve");
                }
                if (requires[i2].isFromFragment()) {
                    this.resolverExports.remove(bundle.detachFragment((ResolverBundle)this.bundleMapping.get(requires[i2].getVersionConstraint().getBundle())));
                    continue;
                }
                failed = true;
                break;
            }
        }
        if (!failed) {
            ResolverImport[] imports = bundle.getImportPackages();
            for (i2 = 0; i2 < imports.length; ++i2) {
                if (imports[i2].isDynamic() || this.resolveImport(imports[i2], true)) continue;
                if (DEBUG || DEBUG_IMPORTS) {
                    ResolverImpl.log("** IMPORT " + imports[i2].getName() + "[" + imports[i2].getActualBundle() + "] failed to resolve");
                }
                if (imports[i2].isFromFragment()) {
                    this.resolverExports.remove(bundle.detachFragment((ResolverBundle)this.bundleMapping.get(imports[i2].getImportPackageSpecification().getBundle())));
                    continue;
                }
                failed = true;
                break;
            }
        }
        boolean fullyWired = bundle.isFullyWired();
        if (!failed && fullyWired && !bundle.isDependentOnCycle()) {
            if (!this.groupingChecker.checkRequiresConstraints(bundle)) {
                this.setBundleUnresolved(bundle, false);
                if (DEBUG) {
                    ResolverImpl.log(bundle + " NOT RESOLVED due to propagation or grouping constraints");
                }
            } else {
                this.setBundleResolved(bundle);
                if (DEBUG) {
                    ResolverImpl.log(bundle + " RESOLVED");
                }
            }
        } else if (failed || !fullyWired) {
            this.setBundleUnresolved(bundle, false);
            if (DEBUG) {
                ResolverImpl.log(bundle + " NOT RESOLVED");
            }
        }
        if (!failed && fullyWired) {
            this.groupingChecker.addReExportConstraints(bundle);
            this.groupingChecker.addRequireConstraints(bundle.getExportPackages(), bundle);
        }
        if ((v2 = this.cyclicDependencies.remove(bundle)) != null) {
            for (int i3 = 0; i3 < v2.size(); ++i3) {
                ResolverBundle dependent = (ResolverBundle)v2.get(i3);
                if (bundle.isDependentOnUnresolvedFragment(dependent)) {
                    dependent.cyclicDependencyFailed(bundle);
                    this.setBundleUnresolved(dependent, false);
                    if (!DEBUG_CYCLES) continue;
                    ResolverImpl.log("Setting dependent bundle (" + dependent + ") to unresolved (due to fragment)");
                    continue;
                }
                if (bundle.getState() == 2) {
                    if (!dependent.cyclicDependencyResolved(bundle)) continue;
                    this.setBundleResolved(dependent);
                    if (!DEBUG_CYCLES) continue;
                    ResolverImpl.log("Telling dependent bundle (" + dependent + ") that " + bundle + " has resolved");
                    continue;
                }
                if (bundle.getState() != 0) continue;
                dependent.cyclicDependencyFailed(bundle);
                this.setBundleUnresolved(dependent, false);
                if (!DEBUG_CYCLES) continue;
                ResolverImpl.log("Setting dependent bundle (" + dependent + ") to unresolved");
            }
        }
        if (bundle.getState() == 0) {
            bundle.setResolvable(false);
        }
        this.stateResolveConstraints(bundle);
        return bundle.getState() != 0;
    }

    private boolean resolveRequire(BundleConstraint req) {
        if (DEBUG_REQUIRES) {
            ResolverImpl.log("Trying to resolve: " + req.getBundle() + ", " + req.getVersionConstraint());
        }
        if (req.getMatchingBundle() != null) {
            if (req.getMatchingBundle().getState() == 1) {
                this.cyclicDependencies.put(req.getMatchingBundle(), req.getBundle());
                req.getBundle().recordCyclicDependency(req.getMatchingBundle());
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        VersionSupplier[] bundles = this.resolverBundles.getArray(req.getVersionConstraint().getName());
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            ResolverBundle bundle = (ResolverBundle)bundles[i2];
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("CHECKING: " + bundle.getBundle());
            }
            if (!req.isSatisfiedBy(bundle)) continue;
            int originalState = bundle.getState();
            req.setMatchingBundle(bundle);
            if (req.getBundle() == bundle) {
                return true;
            }
            if (originalState == 0 && !this.resolveBundle(bundle)) {
                req.setMatchingBundle(null);
                continue;
            }
            if (originalState == 1) {
                this.cyclicDependencies.put(bundle, req.getBundle());
                req.getBundle().recordCyclicDependency(bundle);
            } else if (originalState == 0 && bundle.getState() == 1) {
                ArrayList exportersCyclicDependencies = bundle.getCyclicDependencies();
                for (int k2 = 0; k2 < exportersCyclicDependencies.size(); ++k2) {
                    ResolverBundle dependentOn = (ResolverBundle)exportersCyclicDependencies.get(k2);
                    if (dependentOn == req.getBundle()) continue;
                    this.cyclicDependencies.put(dependentOn, req.getBundle());
                    req.getBundle().recordCyclicDependency(dependentOn);
                }
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("Found match: " + bundle.getBundle() + ". Wiring");
            }
            return true;
        }
        return req.isOptional();
    }

    private boolean resolveImport(ResolverImport imp, boolean checkReexportsFromRequires) {
        if (DEBUG_IMPORTS) {
            ResolverImpl.log("Trying to resolve: " + imp.getBundle() + ", " + imp.getName());
        }
        if (imp.getMatchingExport() != null) {
            if (imp.getMatchingExport().getExporter().getState() == 1) {
                this.cyclicDependencies.put(imp.getMatchingExport().getExporter(), imp.getBundle());
                imp.getBundle().recordCyclicDependency(imp.getMatchingExport().getExporter());
            }
            if (DEBUG_IMPORTS) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        VersionSupplier[] exports = this.resolverExports.getArray(imp.getName());
        for (int i2 = 0; i2 < exports.length; ++i2) {
            ResolverExport export = (ResolverExport)exports[i2];
            if (DEBUG_IMPORTS) {
                ResolverImpl.log("CHECKING: " + export.getExporter().getBundle() + ", " + exports[i2].getName());
            }
            if (!imp.isSatisfiedBy(export) || !imp.isNotAnUnresolvableWiring(export)) continue;
            int originalState = export.getExporter().getState();
            if (imp.isDynamic() && originalState != 2) {
                return false;
            }
            if (imp.getBundle() == export.getExporter() && !export.getExportPackageDescription().isRoot()) continue;
            imp.setMatchingExport(export);
            if (imp.getBundle() != export.getExporter()) {
                ResolverExport exp = imp.getBundle().getExport(imp);
                if (exp != null) {
                    if (exp.getExportPackageDescription().isRoot() && !export.getExportPackageDescription().isRoot()) continue;
                    this.resolverExports.remove(exp);
                    exp.setDropped(true);
                }
                if (!((originalState != 0 && export.getExportPackageDescription().isRoot() || this.resolveBundle(export.getExporter())) && this.resolverExports.contains(export))) {
                    if (exp != null) {
                        this.resolverExports.put(exp);
                        exp.setDropped(false);
                    }
                    imp.setMatchingExport(null);
                    continue;
                }
            }
            if (!imp.getBundle().isResolvable()) {
                return false;
            }
            if (this.checkAndResolveDependencies(imp, imp.getMatchingExport())) {
                if (imp.getMatchingExport() != export) {
                    return true;
                }
                if (imp.getBundle() != export.getExporter()) {
                    if (originalState == 1) {
                        this.cyclicDependencies.put(export.getExporter(), imp.getBundle());
                        imp.getBundle().recordCyclicDependency(export.getExporter());
                    } else if (originalState == 0 && export.getExporter().getState() == 1) {
                        ArrayList exportersCyclicDependencies = export.getExporter().getCyclicDependencies();
                        for (int k2 = 0; k2 < exportersCyclicDependencies.size(); ++k2) {
                            ResolverBundle dependentOn = (ResolverBundle)exportersCyclicDependencies.get(k2);
                            if (dependentOn == imp.getBundle()) continue;
                            this.cyclicDependencies.put(dependentOn, imp.getBundle());
                            imp.getBundle().recordCyclicDependency(dependentOn);
                        }
                    }
                }
                if (DEBUG_IMPORTS) {
                    ResolverImpl.log("Found match: " + export.getExporter() + ". Wiring " + imp.getBundle() + ":" + imp.getName());
                }
                return true;
            }
            if (imp.getBundle().isResolvable()) continue;
            return false;
        }
        if (checkReexportsFromRequires && this.resolveImportReprovide(imp)) {
            return true;
        }
        return imp.isOptional();
    }

    private boolean resolveImportReprovide(ResolverImport imp) {
        String bsn = imp.getImportPackageSpecification().getBundleSymbolicName();
        if (bsn == null) {
            return false;
        }
        if (DEBUG_IMPORTS) {
            ResolverImpl.log("Checking reprovides: " + imp.getName());
        }
        Iterator iter = this.bundleMapping.values().iterator();
        while (iter.hasNext()) {
            ResolverBundle rb = (ResolverBundle)iter.next();
            if (!bsn.equals(rb.getBundle().getSymbolicName()) || rb.isFragment() || !this.resolveBundle(rb) || !this.resolveImportReprovide0(imp, rb, rb)) continue;
            return true;
        }
        return false;
    }

    private boolean resolveImportReprovide0(ResolverImport imp, ResolverBundle reexporter, ResolverBundle rb) {
        BundleConstraint[] requires = rb.getRequires();
        for (int i2 = 0; i2 < requires.length; ++i2) {
            if (!((BundleSpecification)requires[i2].getVersionConstraint()).isExported() || requires[i2].getMatchingBundle() == null) continue;
            ResolverExport[] exports = requires[i2].getMatchingBundle().getExportPackages();
            for (int j2 = 0; j2 < exports.length; ++j2) {
                if (!imp.getName().equals(exports[j2].getName())) continue;
                Map directives = exports[j2].getExportPackageDescription().getDirectives();
                directives.remove("uses");
                ExportPackageDescription epd = this.state.getFactory().createExportPackageDescription(exports[j2].getName(), exports[j2].getVersion(), directives, exports[j2].getExportPackageDescription().getAttributes(), false, reexporter.getBundle());
                if (!imp.getImportPackageSpecification().isSatisfiedBy(epd)) continue;
                if (DEBUG_IMPORTS) {
                    ResolverImpl.log(" - Creating re-export for reprovide: " + reexporter + ":" + epd.getName());
                }
                ResolverExport re = new ResolverExport(reexporter, epd, true);
                reexporter.addExport(re);
                this.groupingChecker.addReprovideConstraints(re);
                this.resolverExports.put(re);
                if (!this.resolveImport(imp, false)) continue;
                return true;
            }
            if (!this.resolveImportReprovide0(imp, reexporter, requires[i2].getMatchingBundle())) continue;
            return true;
        }
        return false;
    }

    private boolean checkAndResolveDependencies(ResolverImport imp, ResolverExport exp) {
        if (DEBUG_GROUPING) {
            ResolverImpl.log("  Checking grouping for " + imp.getBundle() + ":" + imp.getName() + " -> " + exp.getExporter() + ":" + exp.getName());
        }
        ResolverBundle importer = imp.getBundle();
        ResolverExport clash = this.groupingChecker.isConsistent(imp, exp);
        if (clash == null) {
            return true;
        }
        if (DEBUG_GROUPING) {
            ResolverImpl.log("  * grouping clash with " + clash.getExporter() + ":" + clash.getName());
        }
        imp.addUnresolvableWiring(exp.getExporter());
        imp.setMatchingExport(null);
        if (this.resolveImport(imp, false)) {
            return true;
        }
        if (imp.isDynamic()) {
            return false;
        }
        imp.clearUnresolvableWirings();
        imp.setMatchingExport(exp);
        ResolverImport[] imports = importer.getImportPackages();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            if (imports[i2].getMatchingExport() == null || !imports[i2].getMatchingExport().getName().equals(clash.getName())) continue;
            imports[i2].addUnresolvableWiring(imports[i2].getMatchingExport().getExporter());
            importer.clearWires();
            ResolverExport removed = importer.getExport(imports[i2]);
            if (removed != null) {
                this.resolverExports.put(removed);
            }
            return this.resolveBundle(importer);
        }
        return false;
    }

    private void setBundleUnresolved(ResolverBundle bundle, boolean removed) {
        if (bundle.getState() == 0) {
            return;
        }
        if (bundle.getBundle().isResolved()) {
            this.resolverExports.remove(bundle.getExportPackages());
            bundle.initialize(false);
            if (!removed) {
                this.resolverExports.put(bundle.getExportPackages());
            }
        }
        if (this.resolvingBundles != null) {
            this.resolvingBundles.remove(bundle);
        }
        if (this.resolvedBundles != null) {
            this.resolvedBundles.remove(bundle);
        }
        if (!removed) {
            this.unresolvedBundles.add(bundle);
        }
        bundle.detachAllFragments();
        bundle.setState(0);
    }

    private void setBundleResolved(ResolverBundle bundle) {
        if (bundle.getState() == 2) {
            return;
        }
        this.resolvingBundles.remove(bundle);
        this.unresolvedBundles.remove(bundle);
        this.resolvedBundles.add(bundle);
        bundle.setState(2);
    }

    private void setBundleResolving(ResolverBundle bundle) {
        if (bundle.getState() == 1) {
            return;
        }
        this.resolvedBundles.remove(bundle);
        this.unresolvedBundles.remove(bundle);
        this.resolvingBundles.add(bundle);
        bundle.setState(1);
    }

    private void stateResolveBundles() {
        for (int i2 = 0; i2 < this.resolvedBundles.size(); ++i2) {
            ResolverBundle rb = (ResolverBundle)this.resolvedBundles.get(i2);
            if (rb.getBundle().isResolved()) continue;
            this.stateResolveBundle(rb);
        }
        this.resolverExports.reorder();
        this.resolverBundles.reorder();
    }

    private void stateResolveConstraints(ResolverBundle rb) {
        ResolverImport[] imports = rb.getImportPackages();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            ResolverExport export = imports[i2].getMatchingExport();
            ExportPackageDescription supplier = export == null ? null : export.getExportPackageDescription();
            this.state.resolveConstraint(imports[i2].getImportPackageSpecification(), supplier);
        }
        BundleConstraint[] requires = rb.getRequires();
        for (int i3 = 0; i3 < requires.length; ++i3) {
            ResolverBundle bundle = requires[i3].getMatchingBundle();
            BundleDescription supplier = bundle == null ? null : bundle.getBundle();
            this.state.resolveConstraint(requires[i3].getVersionConstraint(), supplier);
        }
    }

    private void stateResolveBundle(ResolverBundle rb) {
        ResolverBundle[] matchingBundles;
        ResolverExport[] exports = rb.getSelectedExports();
        ArrayList<ExportPackageDescription> selectedExports = new ArrayList<ExportPackageDescription>(exports.length);
        for (int i2 = 0; i2 < exports.length; ++i2) {
            selectedExports.add(exports[i2].getExportPackageDescription());
        }
        ExportPackageDescription[] selectedExportsArray = selectedExports.toArray(new ExportPackageDescription[selectedExports.size()]);
        ResolverImport[] imports = rb.getImportPackages();
        ArrayList<ExportPackageDescription> exportsWiredTo = new ArrayList<ExportPackageDescription>(imports.length);
        for (int i3 = 0; i3 < imports.length; ++i3) {
            if (imports[i3].getMatchingExport() == null) continue;
            exportsWiredTo.add(imports[i3].getMatchingExport().getExportPackageDescription());
        }
        ExportPackageDescription[] exportsWiredToArray = exportsWiredTo.toArray(new ExportPackageDescription[exportsWiredTo.size()]);
        BundleConstraint[] requires = rb.getRequires();
        ArrayList<BundleDescription> bundlesWiredTo = new ArrayList<BundleDescription>(requires.length);
        for (int i4 = 0; i4 < requires.length; ++i4) {
            if (requires[i4].getMatchingBundle() == null) continue;
            bundlesWiredTo.add(requires[i4].getMatchingBundle().getBundle());
        }
        BundleDescription[] bundlesWiredToArray = bundlesWiredTo.toArray(new BundleDescription[bundlesWiredTo.size()]);
        BundleDescription[] hostBundles = null;
        if (rb.isFragment() && (matchingBundles = rb.getHost().getMatchingBundles()) != null && matchingBundles.length > 0) {
            hostBundles = new BundleDescription[matchingBundles.length];
            for (int i5 = 0; i5 < matchingBundles.length; ++i5) {
                hostBundles[i5] = matchingBundles[i5].getBundle();
                if (!rb.isNewFragmentExports()) continue;
                ResolverExport[] hostExports = matchingBundles[i5].getSelectedExports();
                ExportPackageDescription[] hostExportsArray = new ExportPackageDescription[hostExports.length];
                for (int j2 = 0; j2 < hostExports.length; ++j2) {
                    hostExportsArray[j2] = hostExports[j2].getExportPackageDescription();
                }
                this.state.resolveBundle(hostBundles[i5], true, null, hostExportsArray, hostBundles[i5].getResolvedRequires(), hostBundles[i5].getResolvedImports());
            }
        }
        this.state.resolveBundle(rb.getBundle(), true, hostBundles, selectedExportsArray, bundlesWiredToArray, exportsWiredToArray);
    }

    public synchronized ExportPackageDescription resolveDynamicImport(BundleDescription importingBundle, String requestedPackage) {
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        ResolverBundle rb = (ResolverBundle)this.bundleMapping.get(importingBundle);
        ResolverImport[] resolverImports = rb.getImportPackages();
        boolean found = false;
        for (int j2 = 0; j2 < resolverImports.length; ++j2) {
            if (!"dynamic".equals(resolverImports[j2].getImportPackageSpecification().getDirective("resolution"))) continue;
            String importName = resolverImports[j2].getName();
            if (importName.equals("*") || importName.endsWith(".*") && requestedPackage.startsWith(importName.substring(0, importName.length() - 2))) {
                resolverImports[j2].setName(requestedPackage);
            }
            if (requestedPackage.equals(resolverImports[j2].getName())) {
                found = true;
                boolean resolved = this.resolveImport(resolverImports[j2], true);
                while (resolved && !this.checkDynamicGrouping(resolverImports[j2])) {
                    resolved = this.resolveImport(resolverImports[j2], true);
                }
                if (resolved) {
                    resolverImports[j2].setName(null);
                    if (DEBUG_IMPORTS) {
                        ResolverImpl.log("Resolved dynamic import: " + rb + ":" + resolverImports[j2].getName() + " -> " + resolverImports[j2].getMatchingExport().getExporter() + ":" + requestedPackage);
                    }
                    ExportPackageDescription matchingExport = resolverImports[j2].getMatchingExport().getExportPackageDescription();
                    if (importName.endsWith("*")) {
                        resolverImports[j2].setMatchingExport(null);
                    }
                    return matchingExport;
                }
            }
            resolverImports[j2].setName(null);
        }
        if (!found) {
            HashMap<String, String> directives = new HashMap<String, String>(1);
            directives.put("resolution", "dynamic");
            ImportPackageSpecification packageSpec = this.state.getFactory().createImportPackageSpecification(requestedPackage, null, null, null, directives, null, importingBundle);
            ResolverImport newImport = new ResolverImport(rb, packageSpec);
            boolean resolved = this.resolveImport(newImport, true);
            while (resolved && !this.checkDynamicGrouping(newImport)) {
                resolved = this.resolveImport(newImport, true);
            }
            if (resolved) {
                return newImport.getMatchingExport().getExportPackageDescription();
            }
        }
        if (DEBUG || DEBUG_IMPORTS) {
            ResolverImpl.log("Failed to resolve dynamic import: " + requestedPackage);
        }
        return null;
    }

    private boolean checkDynamicGrouping(ResolverImport imp) {
        if (this.groupingChecker.isConsistent(imp, imp.getMatchingExport()) != null) {
            imp.addUnresolvableWiring(imp.getMatchingExport().getExporter());
            imp.setMatchingExport(null);
            if (DEBUG_GROUPING) {
                ResolverImpl.log("  Dynamic grouping failed: " + imp.getName());
            }
            return false;
        }
        return true;
    }

    public void bundleAdded(BundleDescription bundle) {
        if (!this.initialized) {
            return;
        }
        boolean alreadyThere = false;
        for (int i2 = 0; i2 < this.unresolvedBundles.size(); ++i2) {
            ResolverBundle rb = (ResolverBundle)this.unresolvedBundles.get(i2);
            if (rb.getBundle() != bundle) continue;
            alreadyThere = true;
        }
        if (!alreadyThere) {
            ResolverBundle rb = new ResolverBundle(bundle, this);
            this.bundleMapping.put(bundle, rb);
            this.unresolvedBundles.add(rb);
            this.resolverExports.put(rb.getExportPackages());
            this.resolverBundles.put(rb);
        }
    }

    public void bundleRemoved(BundleDescription bundle, boolean pending) {
        if (pending) {
            this.addRemovalPending(bundle);
        }
        if (!this.initialized) {
            return;
        }
        ResolverBundle rb = (ResolverBundle)this.bundleMapping.get(bundle);
        if (rb == null) {
            return;
        }
        if (!pending) {
            this.bundleMapping.remove(bundle);
            this.groupingChecker.removeAllExportConstraints(rb);
        }
        this.unresolvedBundles.remove(rb);
        this.resolverExports.remove(rb.getExportPackages());
        this.resolverBundles.remove(rb);
    }

    private void addRemovalPending(BundleDescription bundle) {
        Long id = new Long(bundle.getBundleId());
        ArrayList<BundleDescription> removedBundles = (ArrayList<BundleDescription>)this.removalPending.get(id);
        if (removedBundles == null) {
            removedBundles = new ArrayList<BundleDescription>(1);
            removedBundles.add(bundle);
            this.removalPending.put(id, removedBundles);
        } else {
            removedBundles.add(bundle);
        }
    }

    private BundleDescription[] getRemovalPending(BundleDescription bundle) {
        Long id = new Long(bundle.getBundleId());
        ArrayList removedBundles = (ArrayList)this.removalPending.remove(id);
        if (removedBundles == null) {
            return null;
        }
        return removedBundles.toArray(new BundleDescription[removedBundles.size()]);
    }

    private void unresolveBundle(ResolverBundle bundle, boolean removed) {
        if (bundle == null) {
            return;
        }
        BundleDescription[] removedBundles = null;
        removedBundles = this.getRemovalPending(bundle.getBundle());
        if (removedBundles != null) {
            for (int i2 = 0; i2 < removedBundles.length; ++i2) {
                ResolverBundle re = (ResolverBundle)this.bundleMapping.get(removedBundles[i2]);
                this.unresolveBundle(re, true);
                this.state.removeBundleComplete(removedBundles[i2]);
                this.bundleMapping.remove(removedBundles[i2]);
                this.groupingChecker.removeAllExportConstraints(re);
                if (removedBundles[i2] != bundle.getBundle()) continue;
                removed = true;
            }
        }
        if (!bundle.getBundle().isResolved()) {
            return;
        }
        this.setBundleUnresolved(bundle, removed);
        BundleDescription[] dependents = bundle.getBundle().getDependents();
        bundle.setState(0);
        this.state.resolveBundle(bundle.getBundle(), false, null, null, null, null);
        for (int i3 = 0; i3 < dependents.length; ++i3) {
            this.unresolveBundle((ResolverBundle)this.bundleMapping.get(dependents[i3]), false);
        }
    }

    public void bundleUpdated(BundleDescription newDescription, BundleDescription existingDescription, boolean pending) {
        this.bundleRemoved(existingDescription, pending);
        this.bundleAdded(newDescription);
    }

    public void flush() {
        this.resolverExports = null;
        this.resolverBundles = null;
        this.unresolvedBundles = null;
        this.bundleMapping = null;
        this.cyclicDependencies = null;
        if (this.removalPending.size() > 0) {
            BundleDescription[] pending = this.getRemovalPending();
            for (int i2 = 0; i2 < pending.length; ++i2) {
                this.state.removeBundleComplete(pending[i2]);
            }
        }
        this.removalPending.clear();
        this.initialized = false;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State newState) {
        this.state = newState;
        this.flush();
    }

    private BundleDescription[] getRemovalPending() {
        if (this.removalPending.size() == 0) {
            return new BundleDescription[0];
        }
        ArrayList results = new ArrayList(this.removalPending.size());
        Iterator iter = this.removalPending.values().iterator();
        while (iter.hasNext()) {
            ArrayList removedBundles = (ArrayList)iter.next();
            results.addAll(removedBundles);
        }
        return results.toArray(new BundleDescription[results.size()]);
    }

    private void setDebugOptions() {
        FrameworkDebugOptions options = FrameworkDebugOptions.getDefault();
        if (options == null) {
            return;
        }
        DEBUG = options.getBooleanOption(OPTION_DEBUG, false);
        DEBUG_WIRING = options.getBooleanOption(OPTION_WIRING, false);
        DEBUG_IMPORTS = options.getBooleanOption(OPTION_IMPORTS, false);
        DEBUG_REQUIRES = options.getBooleanOption(OPTION_REQUIRES, false);
        DEBUG_GROUPING = options.getBooleanOption(OPTION_GROUPING, false);
        DEBUG_CYCLES = options.getBooleanOption(OPTION_CYCLES, false);
    }

    private void printWirings() {
        for (int k2 = 0; k2 < this.resolvedBundles.size(); ++k2) {
            ResolverImport[] imports;
            int i2;
            ResolverBundle[] hosts;
            ResolverBundle rb = (ResolverBundle)this.resolvedBundles.get(k2);
            if (rb.getBundle().isResolved()) continue;
            ResolverImpl.log("    * WIRING for " + rb);
            BundleConstraint[] requireBundles = rb.getRequires();
            if (requireBundles.length == 0) {
                ResolverImpl.log("        (r) no requires");
            } else {
                for (int i3 = 0; i3 < requireBundles.length; ++i3) {
                    if (requireBundles[i3].getMatchingBundle() == null) {
                        ResolverImpl.log("        (r) " + rb.getBundle() + " -> NULL!!!");
                        continue;
                    }
                    ResolverImpl.log("        (r) " + rb.getBundle() + " -> " + requireBundles[i3].getMatchingBundle());
                }
            }
            BundleConstraint hostSpec = rb.getHost();
            if (hostSpec != null && (hosts = hostSpec.getMatchingBundles()) != null) {
                for (i2 = 0; i2 < hosts.length; ++i2) {
                    ResolverImpl.log("        (h) " + rb.getBundle() + " -> " + hosts[i2].getBundle());
                }
            }
            if ((imports = rb.getImportPackages()).length == 0) {
                ResolverImpl.log("        (w) no imports");
                continue;
            }
            for (i2 = 0; i2 < imports.length; ++i2) {
                if (imports[i2].isDynamic() && imports[i2].getMatchingExport() == null) {
                    ResolverImpl.log("        (w) " + imports[i2].getBundle() + ":" + imports[i2].getName() + " -> DYNAMIC");
                    continue;
                }
                if (imports[i2].isOptional() && imports[i2].getMatchingExport() == null) {
                    ResolverImpl.log("        (w) " + imports[i2].getBundle() + ":" + imports[i2].getName() + " -> OPTIONAL (could not be wired)");
                    continue;
                }
                if (imports[i2].getMatchingExport() == null) {
                    ResolverImpl.log("        (w) " + imports[i2].getBundle() + ":" + imports[i2].getName() + " -> NULL!!!");
                    continue;
                }
                ResolverImpl.log("        (w) " + imports[i2].getBundle() + ":" + imports[i2].getName() + " -> " + imports[i2].getMatchingExport().getExporter() + ":" + imports[i2].getMatchingExport().getName());
            }
        }
    }

    static void log(String message) {
        Debug.println(message);
    }
}

