/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDeltaImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;

public class StateDeltaImpl
implements StateDelta {
    private State state;
    private Map changes = new HashMap();

    public StateDeltaImpl(State state) {
        this.state = state;
    }

    public BundleDelta[] getChanges() {
        return this.changes.values().toArray(new BundleDelta[this.changes.size()]);
    }

    public BundleDelta[] getChanges(int mask, boolean exact) {
        ArrayList<BundleDelta> result = new ArrayList<BundleDelta>();
        Iterator changesIter = this.changes.values().iterator();
        while (changesIter.hasNext()) {
            BundleDelta change2 = (BundleDelta)changesIter.next();
            if (mask != change2.getType() && (exact || (change2.getType() & mask) != mask)) continue;
            result.add(change2);
        }
        return result.toArray(new BundleDelta[result.size()]);
    }

    public State getState() {
        return this.state;
    }

    void recordBundleAdded(BundleDescriptionImpl added) {
        BundleDeltaImpl change2 = (BundleDeltaImpl)this.changes.get(added);
        if (change2 == null) {
            this.changes.put(added, new BundleDeltaImpl(added, 1));
            return;
        }
        if (change2.getType() == 2) {
            this.changes.remove(added);
            return;
        }
        int newType = change2.getType();
        if ((newType & 2) != 0) {
            newType &= 0xFFFFFFFD;
        }
        change2.setType(newType | 1);
        change2.setBundle(added);
    }

    void recordBundleUpdated(BundleDescriptionImpl updated) {
        BundleDeltaImpl change2 = (BundleDeltaImpl)this.changes.get(updated);
        if (change2 == null) {
            this.changes.put(updated, new BundleDeltaImpl(updated, 4));
            return;
        }
        if ((change2.getType() & 3) != 0) {
            return;
        }
        change2.setType(change2.getType() | 4);
        change2.setBundle(updated);
    }

    void recordBundleRemoved(BundleDescriptionImpl removed) {
        BundleDeltaImpl change2 = (BundleDeltaImpl)this.changes.get(removed);
        if (change2 == null) {
            this.changes.put(removed, new BundleDeltaImpl(removed, 2));
            return;
        }
        if (change2.getType() == 1) {
            this.changes.remove(removed);
            return;
        }
        int newType = change2.getType();
        if ((newType & 1) != 0) {
            newType &= 0xFFFFFFFE;
        }
        change2.setType(newType | 2);
    }

    void recordBundleRemovalPending(BundleDescriptionImpl removed) {
        removed.setStateBit(4, true);
        BundleDeltaImpl change2 = (BundleDeltaImpl)this.changes.get(removed);
        if (change2 == null) {
            this.changes.put(removed, new BundleDeltaImpl(removed, 128));
            return;
        }
        int newType = change2.getType();
        if ((newType & 0x100) != 0) {
            newType &= 0xFFFFFEFF;
        }
        change2.setType(newType | 0x80);
    }

    void recordBundleRemovalComplete(BundleDescriptionImpl removed) {
        BundleDeltaImpl change2 = (BundleDeltaImpl)this.changes.get(removed);
        if (change2 == null) {
            this.changes.put(removed, new BundleDeltaImpl(removed, 256));
            return;
        }
        int newType = change2.getType();
        if ((newType & 0x80) != 0) {
            newType &= 0xFFFFFF7F;
        }
        change2.setType(newType | 0x100);
    }

    void recordBundleResolved(BundleDescriptionImpl resolved, boolean result) {
        int newType;
        if (resolved.isResolved() == result) {
            return;
        }
        BundleDeltaImpl change2 = (BundleDeltaImpl)this.changes.get(resolved);
        int n2 = newType = result ? 8 : 16;
        if (change2 == null) {
            change2 = new BundleDeltaImpl(resolved, newType);
            this.changes.put(resolved, change2);
            return;
        }
        change2.setType(newType |= change2.getType() & 0xFFFFFFE7);
        change2.setBundle(resolved);
    }
}

