/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class StateWriter {
    private Map objectTable = new HashMap();
    private ArrayList forcedWrite = new ArrayList();

    StateWriter() {
    }

    private int addToObjectTable(Object object) {
        Integer cur = (Integer)this.objectTable.get(object);
        if (cur != null) {
            return cur;
        }
        this.objectTable.put(object, new Integer(this.objectTable.size()));
        return this.objectTable.size() - 1;
    }

    private int getFromObjectTable(Object object) {
        Object objectResult;
        if (this.objectTable != null && (objectResult = this.objectTable.get(object)) != null) {
            return (Integer)objectResult;
        }
        return -1;
    }

    private boolean writePrefix(Object object, DataOutputStream out) throws IOException {
        if (this.writeIndex(object, out)) {
            return true;
        }
        int index = this.addToObjectTable(object);
        out.writeByte(1);
        out.writeInt(index);
        return false;
    }

    private void writeStateDeprecated(StateImpl state, DataOutputStream out) throws IOException {
        int i2;
        state.setSystemExports(null);
        out.write(21);
        if (this.writePrefix(state, out)) {
            return;
        }
        out.writeLong(state.getTimeStamp());
        Dictionary[] propSet = state.getPlatformProperties();
        out.writeInt(propSet.length);
        for (int i3 = 0; i3 < propSet.length; ++i3) {
            Dictionary props = propSet[i3];
            out.writeInt(StateImpl.PROPS.length);
            for (int j2 = 0; j2 < StateImpl.PROPS.length; ++j2) {
                this.writePlatformProp(props.get(StateImpl.PROPS[j2]), out);
            }
        }
        BundleDescription[] bundles = state.getBundles();
        StateHelperImpl.getInstance().sortBundles(bundles);
        out.writeInt(bundles.length);
        if (bundles.length == 0) {
            return;
        }
        for (i2 = 0; i2 < bundles.length; ++i2) {
            this.writeBundleDescription(bundles[i2], out, false);
        }
        out.writeBoolean(state.isResolved());
        out.writeInt(out.size());
        for (i2 = 0; i2 < bundles.length; ++i2) {
            this.writeBundleDescriptionLazyData(bundles[i2], out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveState(StateImpl state, File stateFile, File lazyFile) throws IOException {
        block45: {
            int i2;
            IOException e22;
            BundleDescription[] bundles;
            FileOutputStream fosState;
            FileOutputStream fosLazy;
            DataOutputStream outState;
            DataOutputStream outLazy;
            block34: {
                int i3;
                outLazy = null;
                outState = null;
                fosLazy = null;
                fosState = null;
                state.setSystemExports(null);
                bundles = state.getBundles();
                StateHelperImpl.getInstance().sortBundles(bundles);
                for (i3 = 0; i3 < bundles.length; ++i3) {
                    this.addToObjectTable(bundles[i3]);
                }
                fosLazy = new FileOutputStream(lazyFile);
                outLazy = new DataOutputStream(fosLazy);
                for (i3 = 0; i3 < bundles.length; ++i3) {
                    this.writeBundleDescriptionLazyData(bundles[i3], outLazy);
                }
                fosState = new FileOutputStream(stateFile);
                outState = new DataOutputStream(fosState);
                outState.write(21);
                if (!this.writePrefix(state, outState)) break block43;
                Object var14_11 = null;
                if (outLazy == null) break block34;
                try {
                    outLazy.flush();
                    fosLazy.getFD().sync();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            try {
                outLazy.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
            if (outState != null) {
                try {
                    outState.flush();
                    fosState.getFD().sync();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            try {
                outState.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
            {
                block43: {
                    return;
                }
                outState.writeLong(state.getTimeStamp());
                Dictionary[] propSet = state.getPlatformProperties();
                outState.writeInt(propSet.length);
                for (i2 = 0; i2 < propSet.length; ++i2) {
                    Dictionary props = propSet[i2];
                    outState.writeInt(StateImpl.PROPS.length);
                    for (int j2 = 0; j2 < StateImpl.PROPS.length; ++j2) {
                        this.writePlatformProp(props.get(StateImpl.PROPS[j2]), outState);
                    }
                }
                outState.writeInt(bundles.length);
                if (bundles.length != 0) break block44;
            }
            Object var14_12 = null;
            if (outLazy != null) {
                try {
                    outLazy.flush();
                    fosLazy.getFD().sync();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            try {
                outLazy.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
            if (outState != null) {
                try {
                    outState.flush();
                    fosState.getFD().sync();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            try {
                outState.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
            {
                block44: {
                    return;
                }
                for (i2 = 0; i2 < bundles.length; ++i2) {
                    this.writeBundleDescription(bundles[i2], outState, true);
                }
                outState.writeBoolean(state.isResolved());
            }
            Object var14_13 = null;
            if (outLazy != null) {
                try {
                    outLazy.flush();
                    fosLazy.getFD().sync();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            try {
                outLazy.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
            if (outState != null) {
                try {
                    outState.flush();
                    fosState.getFD().sync();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            try {
                outState.close();
            }
            catch (IOException e22) {}
            break block45;
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (outLazy != null) {
                    try {
                        outLazy.flush();
                        fosLazy.getFD().sync();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                try {
                    outLazy.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
                if (outState != null) {
                    try {
                        outState.flush();
                        fosState.getFD().sync();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                try {
                    outState.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void writePlatformProp(Object obj, DataOutputStream out) throws IOException {
        if (obj == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            if (obj instanceof String) {
                out.writeInt(1);
                this.writeStringOrNull((String)obj, out);
            } else {
                String[] props = (String[])obj;
                out.writeInt(props.length);
                for (int i2 = 0; i2 < props.length; ++i2) {
                    this.writeStringOrNull(props[i2], out);
                }
            }
        }
    }

    private void writeBundleDescription(BundleDescription bundle, DataOutputStream out, boolean force) throws IOException {
        if (force && !this.forcedWrite.contains(bundle)) {
            int index = this.addToObjectTable(bundle);
            out.writeByte(1);
            out.writeInt(index);
            this.forcedWrite.add(bundle);
        } else if (this.writePrefix(bundle, out)) {
            return;
        }
        out.writeLong(bundle.getBundleId());
        this.writeBaseDescription(bundle, out);
        out.writeInt(((BundleDescriptionImpl)bundle).getLazyDataOffset());
        out.writeInt(((BundleDescriptionImpl)bundle).getLazyDataSize());
        out.writeBoolean(bundle.isResolved());
        out.writeBoolean(bundle.isSingleton());
        out.writeBoolean(bundle.hasDynamicImports());
        out.writeBoolean(bundle.attachFragments());
        out.writeBoolean(bundle.dynamicFragments());
        this.writeHostSpec((HostSpecificationImpl)bundle.getHost(), out, force);
        List dependencies = ((BundleDescriptionImpl)bundle).getBundleDependencies();
        out.writeInt(dependencies.size());
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            this.writeBundleDescription((BundleDescription)iter.next(), out, force);
        }
    }

    private void writeBundleDescriptionLazyData(BundleDescription bundle, DataOutputStream out) throws IOException {
        int dataStart = out.size();
        int index = this.getFromObjectTable(bundle);
        ((BundleDescriptionImpl)bundle).setLazyDataOffset(out.size());
        out.writeInt(index);
        this.writeStringOrNull(bundle.getLocation(), out);
        this.writeStringOrNull(bundle.getPlatformFilter(), out);
        ExportPackageDescription[] exports = bundle.getExportPackages();
        out.writeInt(exports.length);
        for (int i2 = 0; i2 < exports.length; ++i2) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)exports[i2], out);
        }
        ImportPackageSpecification[] imports = bundle.getImportPackages();
        out.writeInt(imports.length);
        for (int i3 = 0; i3 < imports.length; ++i3) {
            this.writeImportPackageSpec(imports[i3], out);
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        out.writeInt(requiredBundles.length);
        for (int i4 = 0; i4 < requiredBundles.length; ++i4) {
            this.writeBundleSpec((BundleSpecificationImpl)requiredBundles[i4], out);
        }
        ExportPackageDescription[] selectedExports = bundle.getSelectedExports();
        if (selectedExports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(selectedExports.length);
            for (int i5 = 0; i5 < selectedExports.length; ++i5) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)selectedExports[i5], out);
            }
        }
        ExportPackageDescription[] resolvedImports = bundle.getResolvedImports();
        if (resolvedImports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(resolvedImports.length);
            for (int i6 = 0; i6 < resolvedImports.length; ++i6) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)resolvedImports[i6], out);
            }
        }
        BundleDescription[] resolvedRequires = bundle.getResolvedRequires();
        if (resolvedRequires == null) {
            out.writeInt(0);
        } else {
            out.writeInt(resolvedRequires.length);
            for (int i7 = 0; i7 < resolvedRequires.length; ++i7) {
                this.writeBundleDescription(resolvedRequires[i7], out, false);
            }
        }
        ((BundleDescriptionImpl)bundle).setLazyDataSize(out.size() - dataStart);
    }

    private void writeBundleSpec(BundleSpecificationImpl bundle, DataOutputStream out) throws IOException {
        this.writeVersionConstraint(bundle, out);
        this.writeBundleDescription((BundleDescription)bundle.getSupplier(), out, false);
        out.writeBoolean(bundle.isExported());
        out.writeBoolean(bundle.isOptional());
    }

    private void writeExportPackageDesc(ExportPackageDescriptionImpl exportPackageDesc, DataOutputStream out) throws IOException {
        if (this.writePrefix(exportPackageDesc, out)) {
            return;
        }
        this.writeBaseDescription(exportPackageDesc, out);
        out.writeBoolean(exportPackageDesc.isRoot());
        this.writeMap(out, exportPackageDesc.getAttributes());
        this.writeMap(out, exportPackageDesc.getDirectives());
    }

    private void writeMap(DataOutputStream out, Map source) throws IOException {
        if (source == null) {
            out.writeInt(0);
        } else {
            out.writeInt(source.size());
            Iterator iter = source.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = source.get(key);
                this.writeStringOrNull(key, out);
                if (value instanceof String) {
                    out.writeByte(0);
                    this.writeStringOrNull((String)value, out);
                    continue;
                }
                if (value instanceof String[]) {
                    out.writeByte(1);
                    this.writeList(out, (String[])value);
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                out.writeByte(2);
                out.writeBoolean((Boolean)value);
            }
        }
    }

    private void writeList(DataOutputStream out, String[] list) throws IOException {
        if (list == null) {
            out.writeInt(0);
        } else {
            out.writeInt(list.length);
            for (int i2 = 0; i2 < list.length; ++i2) {
                this.writeStringOrNull(list[i2], out);
            }
        }
    }

    private void writeBaseDescription(BaseDescription rootDesc, DataOutputStream out) throws IOException {
        this.writeStringOrNull(rootDesc.getName(), out);
        this.writeVersion(rootDesc.getVersion(), out);
    }

    private void writeImportPackageSpec(ImportPackageSpecification importPackageSpec, DataOutputStream out) throws IOException {
        this.writeVersionConstraint(importPackageSpec, out);
        if (importPackageSpec.getBundle().isResolved()) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)importPackageSpec.getSupplier(), out);
        } else {
            out.writeByte(0);
        }
        this.writeStringOrNull(importPackageSpec.getBundleSymbolicName(), out);
        this.writeVersionRange(importPackageSpec.getBundleVersionRange(), out);
        this.writeMap(out, importPackageSpec.getAttributes());
        this.writeMap(out, importPackageSpec.getDirectives());
    }

    private void writeHostSpec(HostSpecificationImpl host, DataOutputStream out, boolean force) throws IOException {
        if (host == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        this.writeVersionConstraint(host, out);
        BundleDescription[] hosts = host.getHosts();
        if (hosts == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(hosts.length);
        for (int i2 = 0; i2 < hosts.length; ++i2) {
            this.writeBundleDescription(hosts[i2], out, force);
        }
    }

    private void writeVersionConstraint(VersionConstraint constraint, DataOutputStream out) throws IOException {
        this.writeStringOrNull(constraint.getName(), out);
        this.writeVersionRange(constraint.getVersionRange(), out);
    }

    private void writeVersion(Version version, DataOutputStream out) throws IOException {
        if (version == null || version.equals(Version.emptyVersion)) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        out.writeInt(version.getMajor());
        out.writeInt(version.getMinor());
        out.writeInt(version.getMicro());
        this.writeQualifier(version.getQualifier(), out);
    }

    private void writeVersionRange(VersionRange versionRange, DataOutputStream out) throws IOException {
        if (versionRange == null || versionRange.equals(VersionRange.emptyRange)) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        this.writeVersion(versionRange.getMinimum(), out);
        out.writeBoolean(versionRange.getIncludeMinimum());
        this.writeVersion(versionRange.getMaximum(), out);
        out.writeBoolean(versionRange.getIncludeMaximum());
    }

    private boolean writeIndex(Object object, DataOutputStream out) throws IOException {
        if (object == null) {
            out.writeByte(0);
            return true;
        }
        int index = this.getFromObjectTable(object);
        if (index == -1) {
            return false;
        }
        out.writeByte(2);
        out.writeInt(index);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStateDeprecated(StateImpl state, DataOutputStream output) throws IOException {
        try {
            this.writeStateDeprecated(state, output);
        }
        finally {
            output.close();
        }
    }

    private void writeStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    private void writeQualifier(String string, DataOutputStream out) throws IOException {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.writeStringOrNull(string, out);
    }
}

