/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.math.BigDecimal;
import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFixedFacet;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.impl.XSDFixedFacetImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDFractionDigitsFacetImpl
extends XSDFixedFacetImpl
implements XSDFractionDigitsFacet {
    protected static final int VALUE_EDEFAULT = 0;
    protected int value = 0;

    public static XSDFractionDigitsFacet createFractionDigitsFacet(Node node) {
        if (XSDConstants.nodeType(node) == 15) {
            XSDFractionDigitsFacet xsdFractionDigitsFacet = XSDFactory.eINSTANCE.createXSDFractionDigitsFacet();
            xsdFractionDigitsFacet.setElement((Element)node);
            return xsdFractionDigitsFacet;
        }
        return null;
    }

    protected XSDFractionDigitsFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDFractionDigitsFacet();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int newValue) {
        int oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 11, oldValue, this.value));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove(otherEnd, msgs);
                }
                case 8: {
                    return this.basicSetAnnotation(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getLexicalValue();
            }
            case 6: {
                return this.getFacetName();
            }
            case 7: {
                return this.getEffectiveValue();
            }
            case 8: {
                return this.getAnnotation();
            }
            case 9: {
                return this.getSimpleTypeDefinition();
            }
            case 10: {
                return this.isFixed() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return new Integer(this.getValue());
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setLexicalValue((String)newValue);
                return;
            }
            case 8: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 10: {
                this.setFixed((Boolean)newValue);
                return;
            }
            case 11: {
                this.setValue((Integer)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setLexicalValue(LEXICAL_VALUE_EDEFAULT);
                return;
            }
            case 8: {
                this.setAnnotation(null);
                return;
            }
            case 10: {
                this.unsetFixed();
                return;
            }
            case 11: {
                this.setValue(0);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 6: {
                return FACET_NAME_EDEFAULT == null ? this.getFacetName() != null : !FACET_NAME_EDEFAULT.equals(this.getFacetName());
            }
            case 7: {
                return EFFECTIVE_VALUE_EDEFAULT == null ? this.getEffectiveValue() != null : !EFFECTIVE_VALUE_EDEFAULT.equals(this.getEffectiveValue());
            }
            case 8: {
                return this.annotation != null;
            }
            case 9: {
                return this.getSimpleTypeDefinition() != null;
            }
            case 10: {
                return this.isSetFixed();
            }
            case 11: {
                return this.value != 0;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = this.createElement(15);
        this.setElement(newElement);
        return newElement;
    }

    public void validate() {
        super.validate();
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getSimpleTypeDefinition();
        XSDTotalDigitsFacet xsdTotalDigitsFacet = xsdSimpleTypeDefinition.getTotalDigitsFacet();
        if (xsdTotalDigitsFacet != null && this.getValue() > xsdTotalDigitsFacet.getValue()) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "fractionDigits-less-than-equal-to-totalDigits", this.getElement(), "value", new Object[]{new Integer(this.getValue()), new Integer(xsdTotalDigitsFacet.getValue())});
            xsdDiagnostic.getComponents().add(xsdTotalDigitsFacet);
        }
    }

    protected void validateValue() {
        this.checkBuiltInTypeConstraint("nonNegativeInteger", this.getLexicalValue(), "http://www.w3.org/TR/xmlschema-2/", "element-totalDigits", this.getElement(), "value", true);
    }

    protected void validateRestriction(XSDFixedFacet xsdFixedFacet) {
        if (this.getValue() > ((XSDFractionDigitsFacet)xsdFixedFacet).getValue()) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "fractionDigits-valid-restriction", this.getElement(), "value", new Object[]{new Integer(this.getValue()), xsdFixedFacet.getEffectiveValue(), xsdFixedFacet.getSimpleTypeDefinition().getURI()});
            xsdDiagnostic.getComponents().add(xsdFixedFacet);
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (eAttribute == XSDPackage.eINSTANCE.getXSDFacet_LexicalValue()) {
            if (this.getLexicalValue() == null) {
                this.setValue(0);
            } else {
                try {
                    int newValue = Integer.parseInt(this.getLexicalValue());
                    if (newValue != this.getValue()) {
                        this.setValue(newValue);
                    }
                }
                catch (NumberFormatException exception) {
                    this.setValue(0);
                }
            }
            this.traverseToRootForAnalysis();
        }
    }

    public boolean isConstraintSatisfied(Object value) {
        return value instanceof BigDecimal && ((BigDecimal)value).scale() <= this.getValue();
    }

    public Object getEffectiveValue() {
        return new Integer(this.getValue());
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDFractionDigitsFacetImpl clonedFractionDigitsFacet = (XSDFractionDigitsFacetImpl)this.getXSDFactory().createXSDFractionDigitsFacet();
        clonedFractionDigitsFacet.isReconciling = true;
        if (this.getLexicalValue() != null) {
            clonedFractionDigitsFacet.setLexicalValue(this.getLexicalValue());
        }
        if (this.isSetFixed()) {
            clonedFractionDigitsFacet.setFixed(this.isFixed());
        }
        if (deep && this.getAnnotation() != null) {
            clonedFractionDigitsFacet.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedFractionDigitsFacet.setElement(this.getElement());
        }
        clonedFractionDigitsFacet.isReconciling = shareDOM;
        return clonedFractionDigitsFacet;
    }
}

