/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.osgi.framework.AdminPermissionCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public final class AdminPermission
extends Permission {
    static final long serialVersionUID = 207051004521261705L;
    protected Bundle bundle;
    protected boolean wildcard;
    protected String filter;
    public static final String CLASS = "class";
    public static final String EXECUTE = "execute";
    public static final String LIFECYCLE = "lifecycle";
    public static final String LISTENER = "listener";
    public static final String METADATA = "metadata";
    public static final String PERMISSION = "permission";
    public static final String RESOLVE = "resolve";
    public static final String RESOURCE = "resource";
    public static final String STARTLEVEL = "startlevel";
    public static final String EXTENSIONLIFECYCLE = "extensionLifecycle";
    private static final int ACTION_CLASS = 1;
    private static final int ACTION_EXECUTE = 2;
    private static final int ACTION_LIFECYCLE = 4;
    private static final int ACTION_LISTENER = 8;
    private static final int ACTION_METADATA = 16;
    private static final int ACTION_PERMISSION = 32;
    private static final int ACTION_RESOLVE = 64;
    private static final int ACTION_RESOURCE = 128;
    private static final int ACTION_STARTLEVEL = 256;
    private static final int ACTION_EXTENSIONLIFECYCLE = 512;
    private static final int ACTION_ALL = 1023;
    private static final int ACTION_NONE = 0;
    protected transient int action_mask = 0;
    private String actions = null;
    protected Dictionary bundleProperties;
    protected Filter filterImpl;

    public AdminPermission() {
        this("*", 1023);
    }

    public AdminPermission(String filter, String actions) {
        this(filter == null ? "*" : filter, AdminPermission.getMask(actions == null ? "*" : actions));
    }

    public AdminPermission(Bundle bundle, String actions) {
        super(bundle.toString());
        this.bundle = bundle;
        this.wildcard = false;
        this.filter = null;
        this.action_mask = AdminPermission.getMask(actions);
    }

    AdminPermission(String filter, int action_mask) {
        super(filter);
        if (filter.equals("*")) {
            this.wildcard = true;
            this.filter = null;
        } else {
            this.wildcard = false;
            this.filter = filter;
        }
        this.bundle = null;
        this.action_mask = action_mask;
    }

    /*
     * WARNING - void declaration
     */
    private static int getMask(String actions) {
        boolean seencomma = false;
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        char[] a2 = actions.toCharArray();
        int i2 = a2.length - 1;
        if (i2 < 0) {
            return mask;
        }
        while (i2 != -1) {
            void var6_6;
            int matchlen;
            char c2;
            while (i2 != -1 && ((c2 = a2[i2]) == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\t')) {
                --i2;
            }
            if (!(i2 < 4 || a2[i2 - 4] != 'c' && a2[i2 - 4] != 'C' || a2[i2 - 3] != 'l' && a2[i2 - 3] != 'L' || a2[i2 - 2] != 'a' && a2[i2 - 2] != 'A' || a2[i2 - 1] != 's' && a2[i2 - 1] != 'S' || a2[i2] != 's' && a2[i2] != 'S')) {
                matchlen = 5;
                mask |= 1;
            } else if (!(i2 < 6 || a2[i2 - 6] != 'e' && a2[i2 - 6] != 'E' || a2[i2 - 5] != 'x' && a2[i2 - 5] != 'X' || a2[i2 - 4] != 'e' && a2[i2 - 4] != 'E' || a2[i2 - 3] != 'c' && a2[i2 - 3] != 'C' || a2[i2 - 2] != 'u' && a2[i2 - 2] != 'U' || a2[i2 - 1] != 't' && a2[i2 - 1] != 'T' || a2[i2] != 'e' && a2[i2] != 'E')) {
                matchlen = 7;
                mask |= 2;
            } else if (!(i2 < 17 || a2[i2 - 17] != 'e' && a2[i2 - 17] != 'E' || a2[i2 - 16] != 'x' && a2[i2 - 16] != 'X' || a2[i2 - 15] != 't' && a2[i2 - 15] != 'T' || a2[i2 - 14] != 'e' && a2[i2 - 14] != 'E' || a2[i2 - 13] != 'n' && a2[i2 - 13] != 'N' || a2[i2 - 12] != 's' && a2[i2 - 12] != 'S' || a2[i2 - 11] != 'i' && a2[i2 - 11] != 'I' || a2[i2 - 10] != 'o' && a2[i2 - 10] != 'O' || a2[i2 - 9] != 'n' && a2[i2 - 9] != 'N' || a2[i2 - 8] != 'l' && a2[i2 - 8] != 'L' || a2[i2 - 7] != 'i' && a2[i2 - 7] != 'I' || a2[i2 - 6] != 'f' && a2[i2 - 6] != 'F' || a2[i2 - 5] != 'e' && a2[i2 - 5] != 'E' || a2[i2 - 4] != 'c' && a2[i2 - 4] != 'C' || a2[i2 - 3] != 'y' && a2[i2 - 3] != 'Y' || a2[i2 - 2] != 'c' && a2[i2 - 2] != 'C' || a2[i2 - 1] != 'l' && a2[i2 - 1] != 'L' || a2[i2] != 'e' && a2[i2] != 'E')) {
                matchlen = 18;
                mask |= 0x200;
            } else if (!(i2 < 8 || a2[i2 - 8] != 'l' && a2[i2 - 8] != 'L' || a2[i2 - 7] != 'i' && a2[i2 - 7] != 'I' || a2[i2 - 6] != 'f' && a2[i2 - 6] != 'F' || a2[i2 - 5] != 'e' && a2[i2 - 5] != 'E' || a2[i2 - 4] != 'c' && a2[i2 - 4] != 'C' || a2[i2 - 3] != 'y' && a2[i2 - 3] != 'Y' || a2[i2 - 2] != 'c' && a2[i2 - 2] != 'C' || a2[i2 - 1] != 'l' && a2[i2 - 1] != 'L' || a2[i2] != 'e' && a2[i2] != 'E')) {
                matchlen = 9;
                mask |= 4;
            } else if (!(i2 < 7 || a2[i2 - 7] != 'l' && a2[i2 - 7] != 'L' || a2[i2 - 6] != 'i' && a2[i2 - 6] != 'I' || a2[i2 - 5] != 's' && a2[i2 - 5] != 'S' || a2[i2 - 4] != 't' && a2[i2 - 4] != 'T' || a2[i2 - 3] != 'e' && a2[i2 - 3] != 'E' || a2[i2 - 2] != 'n' && a2[i2 - 2] != 'N' || a2[i2 - 1] != 'e' && a2[i2 - 1] != 'E' || a2[i2] != 'r' && a2[i2] != 'R')) {
                matchlen = 8;
                mask |= 8;
            } else if (!(i2 < 7 || a2[i2 - 7] != 'm' && a2[i2 - 7] != 'M' || a2[i2 - 6] != 'e' && a2[i2 - 6] != 'E' || a2[i2 - 5] != 't' && a2[i2 - 5] != 'T' || a2[i2 - 4] != 'a' && a2[i2 - 4] != 'A' || a2[i2 - 3] != 'd' && a2[i2 - 3] != 'D' || a2[i2 - 2] != 'a' && a2[i2 - 2] != 'A' || a2[i2 - 1] != 't' && a2[i2 - 1] != 'T' || a2[i2] != 'a' && a2[i2] != 'A')) {
                matchlen = 8;
                mask |= 0x10;
            } else if (!(i2 < 9 || a2[i2 - 9] != 'p' && a2[i2 - 9] != 'P' || a2[i2 - 8] != 'e' && a2[i2 - 8] != 'E' || a2[i2 - 7] != 'r' && a2[i2 - 7] != 'R' || a2[i2 - 6] != 'm' && a2[i2 - 6] != 'M' || a2[i2 - 5] != 'i' && a2[i2 - 5] != 'I' || a2[i2 - 4] != 's' && a2[i2 - 4] != 'S' || a2[i2 - 3] != 's' && a2[i2 - 3] != 'S' || a2[i2 - 2] != 'i' && a2[i2 - 2] != 'I' || a2[i2 - 1] != 'o' && a2[i2 - 1] != 'O' || a2[i2] != 'n' && a2[i2] != 'N')) {
                matchlen = 10;
                mask |= 0x20;
            } else if (!(i2 < 6 || a2[i2 - 6] != 'r' && a2[i2 - 6] != 'R' || a2[i2 - 5] != 'e' && a2[i2 - 5] != 'E' || a2[i2 - 4] != 's' && a2[i2 - 4] != 'S' || a2[i2 - 3] != 'o' && a2[i2 - 3] != 'O' || a2[i2 - 2] != 'l' && a2[i2 - 2] != 'L' || a2[i2 - 1] != 'v' && a2[i2 - 1] != 'V' || a2[i2] != 'e' && a2[i2] != 'E')) {
                matchlen = 7;
                mask |= 0x40;
            } else if (!(i2 < 7 || a2[i2 - 7] != 'r' && a2[i2 - 7] != 'R' || a2[i2 - 6] != 'e' && a2[i2 - 6] != 'E' || a2[i2 - 5] != 's' && a2[i2 - 5] != 'S' || a2[i2 - 4] != 'o' && a2[i2 - 4] != 'O' || a2[i2 - 3] != 'u' && a2[i2 - 3] != 'U' || a2[i2 - 2] != 'r' && a2[i2 - 2] != 'R' || a2[i2 - 1] != 'c' && a2[i2 - 1] != 'C' || a2[i2] != 'e' && a2[i2] != 'E')) {
                matchlen = 8;
                mask |= 0x80;
            } else if (!(i2 < 9 || a2[i2 - 9] != 's' && a2[i2 - 9] != 'S' || a2[i2 - 8] != 't' && a2[i2 - 8] != 'T' || a2[i2 - 7] != 'a' && a2[i2 - 7] != 'A' || a2[i2 - 6] != 'r' && a2[i2 - 6] != 'R' || a2[i2 - 5] != 't' && a2[i2 - 5] != 'T' || a2[i2 - 4] != 'l' && a2[i2 - 4] != 'L' || a2[i2 - 3] != 'e' && a2[i2 - 3] != 'E' || a2[i2 - 2] != 'v' && a2[i2 - 2] != 'V' || a2[i2 - 1] != 'e' && a2[i2 - 1] != 'E' || a2[i2] != 'l' && a2[i2] != 'L')) {
                matchlen = 10;
                mask |= 0x100;
            } else if (i2 >= 0 && a2[i2] == '*') {
                matchlen = 1;
                mask |= 0x3FF;
            } else {
                throw new IllegalArgumentException("invalid permission: " + actions);
            }
            seencomma = false;
            while (i2 >= var6_6 && !seencomma) {
                switch (a2[i2 - var6_6]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + actions);
                    }
                }
                --i2;
            }
            i2 -= var6_6;
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    private Dictionary getProperties() {
        if (this.bundleProperties == null) {
            this.bundleProperties = new Hashtable();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AdminPermission.this.bundleProperties.put("id", new Long(AdminPermission.this.bundle.getBundleId()));
                    AdminPermission.this.bundleProperties.put("location", AdminPermission.this.bundle.getLocation());
                    if (AdminPermission.this.bundle.getSymbolicName() != null) {
                        AdminPermission.this.bundleProperties.put("name", AdminPermission.this.bundle.getSymbolicName());
                    }
                    AdminPermission.this.bundleProperties.put("signer", new SignerWrapper(AdminPermission.this.bundle));
                    return null;
                }
            });
        }
        return this.bundleProperties;
    }

    private Filter getFilterImpl() {
        if (this.filterImpl == null) {
            try {
                int pos = this.filter.indexOf("signer");
                if (pos != -1) {
                    StringBuffer filterBuf = new StringBuffer(this.filter);
                    int numAsteriskFound = 0;
                    while (pos != -1) {
                        int walkbackPos;
                        for (walkbackPos = pos - 1; walkbackPos >= 0 && Character.isWhitespace(this.filter.charAt(walkbackPos)); --walkbackPos) {
                        }
                        if (walkbackPos < 0) break;
                        if (this.filter.charAt(walkbackPos) != '(' || walkbackPos > 0 && this.filter.charAt(walkbackPos - 1) == '\\') {
                            pos = this.filter.indexOf("signer", pos + 6);
                            continue;
                        }
                        pos += 6;
                        while (Character.isWhitespace(this.filter.charAt(pos))) {
                            ++pos;
                        }
                        if (this.filter.charAt(pos) != '=') {
                            pos = this.filter.indexOf("signer", pos);
                            continue;
                        }
                        ++pos;
                        while (this.filter.charAt(pos) != ')' || this.filter.charAt(pos - 1) == '\\') {
                            if (this.filter.charAt(pos) == '*') {
                                filterBuf.insert(pos + numAsteriskFound, '\\');
                                ++numAsteriskFound;
                            }
                            ++pos;
                        }
                        pos = this.filter.indexOf("signer", pos);
                    }
                    this.filter = filterBuf.toString();
                }
                this.filterImpl = new FilterImpl(this.filter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return this.filterImpl;
    }

    public boolean implies(Permission p2) {
        if (!(p2 instanceof AdminPermission)) {
            return false;
        }
        AdminPermission target = (AdminPermission)p2;
        if ((this.action_mask & target.action_mask) != target.action_mask) {
            return false;
        }
        if (target.filter != null) {
            throw new RuntimeException("Cannot imply a filter");
        }
        if (target.wildcard) {
            return this.wildcard;
        }
        if (this.filter != null) {
            Filter filterImpl = this.getFilterImpl();
            return filterImpl != null && filterImpl.match(target.getProperties());
        }
        if (this.wildcard) {
            return true;
        }
        return this.bundle.equals(target.bundle);
    }

    public String getActions() {
        if (this.actions == null) {
            if (this.action_mask == 1023) {
                this.actions = "*";
            } else {
                StringBuffer sb = new StringBuffer();
                if ((this.action_mask & 1) == 1) {
                    sb.append(CLASS);
                    sb.append(',');
                }
                if ((this.action_mask & 2) == 2) {
                    sb.append(EXECUTE);
                    sb.append(',');
                }
                if ((this.action_mask & 4) == 4) {
                    sb.append(LIFECYCLE);
                    sb.append(',');
                }
                if ((this.action_mask & 8) == 8) {
                    sb.append(LISTENER);
                    sb.append(',');
                }
                if ((this.action_mask & 0x10) == 16) {
                    sb.append(METADATA);
                    sb.append(',');
                }
                if ((this.action_mask & 0x20) == 32) {
                    sb.append(PERMISSION);
                    sb.append(',');
                }
                if ((this.action_mask & 0x40) == 64) {
                    sb.append(RESOLVE);
                    sb.append(',');
                }
                if ((this.action_mask & 0x80) == 128) {
                    sb.append(RESOURCE);
                    sb.append(',');
                }
                if ((this.action_mask & 0x100) == 256) {
                    sb.append(STARTLEVEL);
                    sb.append(',');
                }
                if ((this.action_mask & 0x200) == 512) {
                    sb.append(EXTENSIONLIFECYCLE);
                    sb.append(',');
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                this.actions = sb.toString();
            }
        }
        return this.actions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdminPermission)) {
            return false;
        }
        AdminPermission a2 = (AdminPermission)obj;
        return !(this.action_mask != a2.action_mask || this.wildcard != a2.wildcard || this.bundle == null != (a2.bundle == null) || this.bundle != null && !this.bundle.equals(a2.bundle) || this.filter == null != (a2.filter == null) || this.filter != null && !this.filter.equals(a2.filter));
    }

    public int hashCode() {
        return this.action_mask ^ (this.filter != null ? this.filter.hashCode() : this.bundle.hashCode());
    }

    public PermissionCollection newPermissionCollection() {
        return new AdminPermissionCollection();
    }

    private static class SignerWrapper {
        private Bundle bundle;
        private String pattern;

        public SignerWrapper(String pattern) {
            this.pattern = pattern;
        }

        SignerWrapper(Bundle bundle) {
            this.bundle = bundle;
        }

        public boolean equals(Object arg0) {
            return arg0 instanceof SignerWrapper && ((AbstractBundle)this.bundle).getBundleData().matchDNChain(((SignerWrapper)arg0).pattern);
        }
    }
}

