/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.protocol.jar;

import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.common.protocol.mmfile.MMFileURLConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarURLConnection
extends java.net.JarURLConnection {
    public static String PROTOCOL = "jar";
    public static URL DUMMY_URL = null;
    URL jarFileURL = null;
    String jarEntry = null;
    private static HashMap jarMap = new HashMap();

    protected JarURLConnection(URL url) throws MalformedURLException {
        super(DUMMY_URL);
        String path = url.getPath();
        int index = path.indexOf("!/");
        if (index != -1) {
            this.jarFileURL = URLHelper.buildURL(path.substring(0, index));
        }
        if (path.length() > index + 2) {
            this.jarEntry = path.substring(index + 2);
        }
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public void connect() throws IOException {
        this.connected = true;
    }

    public synchronized JarFile getJarFile() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can not open JarFile if doInput is false");
        }
        JarFile jarFile = null;
        URL jarFileURL = this.getJarFileURL();
        String protocol = jarFileURL.getProtocol();
        if (protocol.equals("file") || protocol.equals(MMFileURLConnection.PROTOCOL)) {
            jarFile = new JarFile(jarFileURL.getPath());
        } else {
            jarFile = (JarFile)jarMap.get(jarFileURL);
            if (jarFile == null) {
                URLConnection urlconn = jarFileURL.openConnection();
                InputStream is = urlconn.getInputStream();
                File tempDirectory = new File(System.getProperty("mm.io.tmpdir"));
                if (!tempDirectory.exists()) {
                    tempDirectory.mkdirs();
                }
                byte[] buf = new byte[4096];
                File f = File.createTempFile("dqp", ".jar", tempDirectory);
                FileOutputStream fos = new FileOutputStream(f);
                int len = 0;
                while ((len = is.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
                fos.close();
                jarFile = new JarFile(f, true, 1);
                jarMap.put(jarFileURL, jarFile);
                f.deleteOnExit();
            }
        }
        return jarFile;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can not open InputStream if doInput is set to false");
        }
        if (this.jarEntry == null || this.jarEntry.length() == 0) {
            throw new IOException("Entry name requested in the " + this.url + " is wrong");
        }
        JarFile jarFile = this.getJarFile();
        ZipEntry entry = jarFile.getEntry(this.jarEntry);
        if (entry != null) {
            return jarFile.getInputStream(entry);
        }
        return null;
    }

    public int getContentLength() {
        if (!this.connected) {
            return -1;
        }
        try {
            JarFile jarFile = this.getJarFile();
            ZipEntry entry = jarFile.getEntry(this.jarEntry);
            if (entry != null) {
                return (int)entry.getSize();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    public Attributes getAttributes() throws IOException {
        JarEntry e = this.getJarEntry();
        return e != null ? e.getAttributes() : null;
    }

    public Certificate[] getCertificates() throws IOException {
        JarEntry e = this.getJarEntry();
        return e != null ? e.getCertificates() : null;
    }

    public String getEntryName() {
        return this.jarEntry;
    }

    public JarEntry getJarEntry() throws IOException {
        return this.getJarFile().getJarEntry(this.jarEntry);
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest man = this.getManifest();
        return man != null ? man.getMainAttributes() : null;
    }

    public Manifest getManifest() throws IOException {
        return this.getJarFile().getManifest();
    }

    static {
        try {
            DUMMY_URL = new URL(PROTOCOL, "", -1, "file:/dummy.foo!/");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

