/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.data.api.ValueChunk;
import com.metamatrix.data.api.ValueReference;
import com.metamatrix.data.basic.BasicValueChunk;
import com.metamatrix.data.exception.ConnectorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobValueReference
implements ValueReference {
    private Object value;
    private long size;
    private InputStream in;

    public BlobValueReference(Object value, long size) {
        this.value = value;
        this.size = size;
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            try {
                this.in = blob.getBinaryStream();
            }
            catch (SQLException ie) {}
        } else {
            byte[] bytes = (byte[])value;
            this.in = new ByteArrayInputStream(bytes);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public long getSize() {
        return this.size;
    }

    public ValueChunk createChunk(long startPos, int chunkSize) throws ConnectorException {
        byte[] chunk;
        boolean isLast = false;
        if (this.size - startPos < (long)chunkSize) {
            chunk = new byte[(int)(this.size - startPos)];
            isLast = true;
        } else {
            chunk = new byte[chunkSize];
        }
        try {
            int read = this.in.read(chunk);
            if (read < 0) {
                isLast = true;
            }
        }
        catch (IOException ie) {
            throw new ConnectorException((Throwable)ie, JDBCPlugin.Util.getString("BlobValueReference.Unable_to_read_BLOB_data"));
        }
        return new BasicValueChunk((Object)chunk, true, isLast);
    }

    public boolean isBinary() {
        return true;
    }
}

