/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.mysql;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.impl.AliasModifier;
import com.metamatrix.connector.jdbc.extension.impl.BasicSQLTranslator;
import com.metamatrix.connector.jdbc.extension.impl.Concat2FunctionModifier;
import com.metamatrix.connector.jdbc.mysql.MySQLConversionVisitor;
import com.metamatrix.connector.jdbc.mysql.MySQLConvertModifier;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MySQLTranslator
extends BasicSQLTranslator {
    private Map functionModifiers;
    private Properties connectorProperties;
    private ILanguageFactory languageFactory;

    public void initialize(ConnectorEnvironment env, RuntimeMetadata metadata) throws ConnectorException {
        super.initialize(env, metadata);
        ConnectorEnvironment connEnv = this.getConnectorEnvironment();
        this.connectorProperties = connEnv.getProperties();
        this.languageFactory = connEnv.getLanguageFactory();
        this.initializeFunctionModifiers();
    }

    private void initializeFunctionModifiers() {
        this.functionModifiers = new HashMap();
        this.functionModifiers.putAll(super.getFunctionModifiers());
        this.functionModifiers.put("cast", new MySQLConvertModifier(this.languageFactory));
        this.functionModifiers.put("convert", new MySQLConvertModifier(this.languageFactory));
        this.functionModifiers.put("nvl", new AliasModifier("ifnull"));
        this.functionModifiers.put("concat2", new Concat2FunctionModifier(this.languageFactory, "concat", "ifnull"));
    }

    public Map getFunctionModifiers() {
        return this.functionModifiers;
    }

    public SQLConversionVisitor getTranslationVisitor() {
        MySQLConversionVisitor visitor = new MySQLConversionVisitor();
        visitor.setRuntimeMetadata(this.getRuntimeMetadata());
        visitor.setFunctionModifiers(this.functionModifiers);
        visitor.setProperties(this.connectorProperties);
        visitor.setLanguageFactory(this.languageFactory);
        visitor.setDatabaseTimeZone(this.getDatabaseTimeZone());
        return visitor;
    }
}

