/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.impl.AliasModifier;
import com.metamatrix.connector.jdbc.extension.impl.BasicSQLTranslator;
import com.metamatrix.connector.jdbc.extension.impl.Concat2FunctionModifier;
import com.metamatrix.connector.jdbc.oracle.DayWeekQuarterFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.ExtractFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.FormatFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.HourFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.LeftOrRightFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.LocateFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.Log10FunctionModifier;
import com.metamatrix.connector.jdbc.oracle.MonthOrDayNameFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.OracleConvertModifier;
import com.metamatrix.connector.jdbc.oracle.OracleSQLConversionVisitor;
import com.metamatrix.connector.jdbc.oracle.ParseFunctionModifier;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class OracleSQLTranslator
extends BasicSQLTranslator {
    private Map functionModifiers;
    private Properties connectorProperties;
    private ILanguageFactory languageFactory;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public void initialize(ConnectorEnvironment env, RuntimeMetadata metadata) throws ConnectorException {
        super.initialize(env, metadata);
        ConnectorEnvironment connEnv = this.getConnectorEnvironment();
        this.connectorProperties = connEnv.getProperties();
        this.languageFactory = connEnv.getLanguageFactory();
        this.initializeFunctionModifiers();
    }

    private void initializeFunctionModifiers() {
        this.functionModifiers = new HashMap();
        this.functionModifiers.putAll(super.getFunctionModifiers());
        this.functionModifiers.put("char", new AliasModifier("chr"));
        this.functionModifiers.put("lcase", new AliasModifier("lower"));
        this.functionModifiers.put("ucase", new AliasModifier("upper"));
        this.functionModifiers.put("ifnull", new AliasModifier("nvl"));
        this.functionModifiers.put("log", new AliasModifier("ln"));
        this.functionModifiers.put("concat2", new Concat2FunctionModifier(this.languageFactory, "concat", "nvl"));
        this.functionModifiers.put("log10", new Log10FunctionModifier(this.languageFactory));
        this.functionModifiers.put("convert", new OracleConvertModifier(this.languageFactory, this.getRuntimeMetadata(), this.getConnectorEnvironment().getLogger()));
        this.functionModifiers.put("cast", new OracleConvertModifier(this.languageFactory, this.getRuntimeMetadata(), this.getConnectorEnvironment().getLogger()));
        this.functionModifiers.put("hour", new HourFunctionModifier(this.languageFactory));
        this.functionModifiers.put("month", new ExtractFunctionModifier("MONTH"));
        this.functionModifiers.put("year", new ExtractFunctionModifier("YEAR"));
        this.functionModifiers.put("day", new ExtractFunctionModifier("DAY"));
        this.functionModifiers.put("minute", new DayWeekQuarterFunctionModifier(this.languageFactory, "MI"));
        this.functionModifiers.put("second", new DayWeekQuarterFunctionModifier(this.languageFactory, "SS"));
        this.functionModifiers.put("monthname", new MonthOrDayNameFunctionModifier(this.languageFactory, "Month"));
        this.functionModifiers.put("dayname", new MonthOrDayNameFunctionModifier(this.languageFactory, "Day"));
        this.functionModifiers.put("week", new DayWeekQuarterFunctionModifier(this.languageFactory, "WW"));
        this.functionModifiers.put("quarter", new DayWeekQuarterFunctionModifier(this.languageFactory, "Q"));
        this.functionModifiers.put("dayofweek", new DayWeekQuarterFunctionModifier(this.languageFactory, "D"));
        this.functionModifiers.put("dayofmonth", new DayWeekQuarterFunctionModifier(this.languageFactory, "DD"));
        this.functionModifiers.put("dayofyear", new DayWeekQuarterFunctionModifier(this.languageFactory, "DDD"));
        this.functionModifiers.put("formatdate", new FormatFunctionModifier(this.languageFactory));
        this.functionModifiers.put("formattime", new FormatFunctionModifier(this.languageFactory));
        this.functionModifiers.put("formattimestamp", new FormatFunctionModifier(this.languageFactory));
        this.functionModifiers.put("parsedate", new ParseFunctionModifier(this.languageFactory, class$java$sql$Date == null ? (class$java$sql$Date = OracleSQLTranslator.class$("java.sql.Date")) : class$java$sql$Date));
        this.functionModifiers.put("parsetime", new ParseFunctionModifier(this.languageFactory, class$java$sql$Time == null ? (class$java$sql$Time = OracleSQLTranslator.class$("java.sql.Time")) : class$java$sql$Time));
        this.functionModifiers.put("parsetimestamp", new ParseFunctionModifier(this.languageFactory, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = OracleSQLTranslator.class$("java.sql.Timestamp")) : class$java$sql$Timestamp));
        this.functionModifiers.put("locate", new LocateFunctionModifier(this.languageFactory));
        this.functionModifiers.put("substring", new AliasModifier("substr"));
        this.functionModifiers.put("left", new LeftOrRightFunctionModifier(this.languageFactory, "left"));
        this.functionModifiers.put("right", new LeftOrRightFunctionModifier(this.languageFactory, "right"));
    }

    public SQLConversionVisitor getTranslationVisitor() {
        OracleSQLConversionVisitor visitor = new OracleSQLConversionVisitor();
        visitor.setRuntimeMetadata(this.getRuntimeMetadata());
        visitor.setFunctionModifiers(this.functionModifiers);
        visitor.setProperties(this.connectorProperties);
        visitor.setLanguageFactory(this.languageFactory);
        visitor.setDatabaseTimeZone(this.getDatabaseTimeZone());
        return visitor;
    }

    public Map getFunctionModifiers() {
        return this.functionModifiers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

