/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.sqlserver;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.impl.AliasModifier;
import com.metamatrix.connector.jdbc.extension.impl.BasicSQLTranslator;
import com.metamatrix.connector.jdbc.extension.impl.Concat2FunctionModifier;
import com.metamatrix.connector.jdbc.extension.impl.SubstringFunctionModifier;
import com.metamatrix.connector.jdbc.sqlserver.SqlServerConvertModifier;
import com.metamatrix.connector.jdbc.sqlserver.SqlServerSQLConversionVisitor;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SqlServerSQLTranslator
extends BasicSQLTranslator {
    private Map functionModifiers;
    private Properties connectorProperties;
    private ILanguageFactory languageFactory;

    public void initialize(ConnectorEnvironment env, RuntimeMetadata metadata) throws ConnectorException {
        super.initialize(env, metadata);
        ConnectorEnvironment connEnv = this.getConnectorEnvironment();
        this.connectorProperties = connEnv.getProperties();
        this.languageFactory = connEnv.getLanguageFactory();
        this.initializeFunctionModifiers();
    }

    private void initializeFunctionModifiers() {
        this.functionModifiers = new HashMap();
        this.functionModifiers.putAll(super.getFunctionModifiers());
        this.functionModifiers.put("mod", new AliasModifier("%"));
        this.functionModifiers.put("chr", new AliasModifier("char"));
        this.functionModifiers.put("concat", new AliasModifier("+"));
        this.functionModifiers.put("||", new AliasModifier("+"));
        this.functionModifiers.put("concat2", new Concat2FunctionModifier(this.languageFactory, "+", "isnull"));
        this.functionModifiers.put("ifnull", new AliasModifier("isnull"));
        this.functionModifiers.put("nvl", new AliasModifier("isnull"));
        this.functionModifiers.put("lcase", new AliasModifier("lower"));
        this.functionModifiers.put("length", new AliasModifier("len"));
        this.functionModifiers.put("dayofmonth", new AliasModifier("day"));
        this.functionModifiers.put("ucase", new AliasModifier("upper"));
        this.functionModifiers.put("substring", new SubstringFunctionModifier(this.languageFactory, "substring", "len"));
        this.functionModifiers.put("cast", new SqlServerConvertModifier(this.languageFactory));
        this.functionModifiers.put("convert", new SqlServerConvertModifier(this.languageFactory));
    }

    public Map getFunctionModifiers() {
        return this.functionModifiers;
    }

    public SQLConversionVisitor getTranslationVisitor() {
        SqlServerSQLConversionVisitor visitor = new SqlServerSQLConversionVisitor();
        visitor.setRuntimeMetadata(this.getRuntimeMetadata());
        visitor.setFunctionModifiers(this.functionModifiers);
        visitor.setProperties(this.connectorProperties);
        visitor.setLanguageFactory(this.languageFactory);
        visitor.setDatabaseTimeZone(this.getDatabaseTimeZone());
        return visitor;
    }
}

