/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.xa;

import com.metamatrix.connector.jdbc.xa.JDBCSourceXAConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceWrapper
implements XAResource {
    private static Map connections = new HashMap();
    private XAResource xaResource;
    private JDBCSourceXAConnection connection;
    private String resourceName;

    XAResourceWrapper(XAResource xaResource, JDBCSourceXAConnection connection, String resourceName) {
        this.connection = connection;
        this.xaResource = xaResource;
        this.resourceName = resourceName;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.xaResource.commit(xid, onePhase);
        }
        catch (XAException xe) {
            xe.printStackTrace();
            throw xe;
        }
        finally {
            try {
                this.removeFromMap(xid);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void end(Xid xid, int flag) throws XAException {
        this.xaResource.end(xid, flag);
    }

    public void forget(Xid xid) throws XAException {
        this.xaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (resource instanceof XAResourceWrapper) {
            resource = ((XAResourceWrapper)resource).xaResource;
        }
        boolean sameRM = this.xaResource.isSameRM(resource);
        return sameRM;
    }

    public int prepare(Xid xid) throws XAException {
        int result = this.xaResource.prepare(xid);
        if (result == 3) {
            this.removeFromMap(xid);
        }
        return result;
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        try {
            this.xaResource.rollback(xid);
        }
        finally {
            this.removeFromMap(xid);
        }
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        return this.xaResource.setTransactionTimeout(timeout);
    }

    public void start(Xid xid, int flag) throws XAException {
        this.addToMap(xid);
        try {
            this.xaResource.start(xid, flag);
        }
        catch (XAException xe) {
            this.removeFromMap(xid);
            throw xe;
        }
    }

    public String toString() {
        return this.xaResource.toString() + "::" + this.resourceName;
    }

    private synchronized void removeFromMap(Xid xid) {
        Map xidToConns = (Map)connections.get(this.resourceName);
        if (xidToConns != null) {
            Set connSet = (Set)xidToConns.get(xid);
            if (connSet != null) {
                Iterator connItr = connSet.iterator();
                while (connItr.hasNext()) {
                    JDBCSourceXAConnection conn = (JDBCSourceXAConnection)connItr.next();
                    if (conn == null) continue;
                    conn.forceRelease();
                }
            }
            xidToConns.remove(xid);
            if (xidToConns.isEmpty()) {
                connections.remove(this.resourceName);
            }
        }
    }

    private synchronized void addToMap(Xid xid) {
        HashMap xidToConns = (HashMap)connections.get(this.resourceName);
        Set<JDBCSourceXAConnection> connSet = new HashSet<JDBCSourceXAConnection>();
        if (xidToConns == null) {
            xidToConns = new HashMap();
            connSet.add(this.connection);
            xidToConns.put(xid, connSet);
            connections.put(this.resourceName, xidToConns);
        } else if (!xidToConns.containsKey(xid)) {
            connSet.add(this.connection);
            xidToConns.put(xid, connSet);
        } else {
            connSet = (Set)xidToConns.get(xid);
            connSet.add(this.connection);
        }
    }
}

