/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.installer.server.release;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.ConfigurationModelContainerImpl;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.installer.log.LogWriter;
import com.metamatrix.installer.transformation.apiimpl.BaseObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class BaseConfigUpdateAdapter
extends BaseObject {
    private static final int DEFAULT_MAX_SOURCE_NAME_SIZE = 25;
    private static final String CONNCLASSPATH = "ConnectorClassPath";
    public static final String ADD_TYPE = "--- added -->";
    public static final String NO_ACTION = "           ";
    public static final String NEW_TYPE = "--- new ---";
    public static final String UPDATE_TYPE = "--- updated ---";
    private BasicConfigurationObjectEditor updateEditor;
    private ConfigurationObjectEditor noeditEditor;
    protected ConfigurationModelContainerImpl sourceCMC;
    protected ConfigurationModelContainerImpl targetCMC;
    private PrintStream reportWriter = null;
    protected boolean updateSystemProps = true;
    protected boolean updateComponentTypes = true;
    protected boolean updateConnectorBindings = true;
    protected boolean updateServices = false;
    protected boolean updateResources = false;
    protected boolean redeployHost = false;
    private boolean writeReport = false;
    private static final String TAB = "\t";
    private static final String CR = "\n";
    public int maxSourceName = 25;
    private static List excludeProps = new ArrayList();
    private static final String VM = "Process: ";
    private static final String HOST = "Host: ";
    private static final String SVCT = "Service: ";
    private static final String PROPERTY = "Property: ";
    private static final char CHAR_DEFAULT_FILL_VALUE = ' ';

    public BaseConfigUpdateAdapter(ConfigurationObjectEditor configEditor) {
        this.updateEditor = (BasicConfigurationObjectEditor)configEditor;
        this.noeditEditor = new BasicConfigurationObjectEditor(false);
    }

    public void setUpdateSystemProperties(boolean update) {
        this.updateSystemProps = update;
    }

    public void setUpdateComponentTypes(boolean update) {
        this.updateComponentTypes = update;
    }

    public void setUpdateConnectorBindings(boolean update) {
        this.updateConnectorBindings = update;
    }

    public void setRedeployHosts(boolean update) {
        this.redeployHost = update;
    }

    public void setUpdateServices(boolean update) {
        this.updateServices = update;
    }

    public void setUpdateResources(boolean update) {
        this.updateResources = update;
    }

    public PrintStream createPrintStream(String reportFile) throws Exception {
        FileOutputStream fos = null;
        PrintStream ps = null;
        fos = new FileOutputStream(new File(reportFile));
        ps = new PrintStream(fos);
        return ps;
    }

    public void init(String name, Properties props, LogWriter logwriter, ConfigurationModelContainer sourceCMC, ConfigurationModelContainer targetCMC, PrintStream reportwriter) throws MetaMatrixException {
        super.init(name, props, logwriter);
        Assertion.isNotNull((Object)sourceCMC, (String)"Source configuration must be specified");
        Assertion.isNotNull((Object)targetCMC, (String)"Target configuration must be specified");
        this.sourceCMC = (ConfigurationModelContainerImpl)sourceCMC;
        this.targetCMC = (ConfigurationModelContainerImpl)targetCMC;
        if (reportwriter != null) {
            this.reportWriter = reportwriter;
            this.writeReport = true;
        }
    }

    public void process() throws MetaMatrixException {
        this.writeReportLine("\n\t\t\t\tConfiguration Source and Target");
        this.writeReportLine("\n\t\t\t\t       Comparison Report       ");
        this.writeReportLine("\n\n\n");
        this.processComponentTypes();
        this.maxSourceName = 25;
        this.processConnectorBindings();
        this.maxSourceName = 25;
        if (this.updateServices) {
            this.processServices();
        }
        this.maxSourceName = 25;
        if (this.updateResources) {
            this.processResources();
        }
        this.maxSourceName = 25;
        this.processSystemProperties();
        this.maxSourceName = 25;
        if (this.redeployHost) {
            this.processDeployment();
        }
        this.processFooter();
    }

    public void processComponentTypes() throws MetaMatrixException {
        String sID;
        this.logInfo("***** Processing component types...");
        Map sourceMap = this.sourceCMC.getComponentTypes();
        HashMap targetMap = new HashMap(this.targetCMC.getComponentTypes());
        Iterator iterator = sourceMap.keySet().iterator();
        this.writeReportLine("\n----- Connector Types ------ ");
        while (iterator.hasNext()) {
            sID = (String)iterator.next();
            if (sID.length() <= this.maxSourceName) continue;
            this.maxSourceName = sID.length();
        }
        iterator = sourceMap.keySet().iterator();
        while (iterator.hasNext()) {
            sID = (String)iterator.next();
            ComponentType targetType = (ComponentType)targetMap.get(sID);
            if (targetType == null) {
                this.logInfo("\tAdded type: " + sID);
                this.writeComponentTypeLine(sID, ADD_TYPE, sID);
                ComponentType sourceType = (ComponentType)sourceMap.get(sID);
                ProductType pt = null;
                ComponentTypeID productType = sourceType.getParentComponentTypeID();
                if (productType == null) continue;
                pt = this.sourceCMC.getProductType(productType.getName());
                if (pt == null) {
                    throw new MetaMatrixException("Unable to find Product Type for " + productType.getName());
                }
                sourceType = this.getEditor(this.updateComponentTypes).createComponentType(sourceType, sourceType.getFullName());
                pt = this.getEditor(this.updateComponentTypes).addServiceComponentType(pt, sourceType);
                this.targetCMC.addComponentType((ComponentType)pt);
                this.targetCMC.addComponentType(sourceType);
                continue;
            }
            ComponentType sType = (ComponentType)sourceMap.get(sID);
            this.updateCompentTypeDefns(targetType, sType);
            targetMap.remove(sID);
            this.targetCMC.addComponentType(sType);
        }
        this.writeReportLine("\n\n--------------------------------\n ");
        this.logInfo("***** Completed processing component types");
    }

    private void updateCompentTypeDefns(ComponentType targetType, ComponentType sourceType) throws MetaMatrixException {
        this.writeComponentTypeLine(targetType.getFullName(), UPDATE_TYPE, targetType.getFullName());
        this.updateEditor.updateComponentType(targetType, sourceType);
        this.logInfo("\tUpdated type: " + targetType.getFullName());
    }

    public void processConnectorBindings() throws MetaMatrixException {
        this.logInfo("***** Processing connector bindings...");
        Collection sourcebindings = this.sourceCMC.getConfiguration().getConnectorBindings();
        Iterator it = sourcebindings.iterator();
        while (it.hasNext()) {
            ConnectorBinding scb = (ConnectorBinding)it.next();
            if (scb.getFullName().length() <= this.maxSourceName) continue;
            this.maxSourceName = scb.getFullName().length();
        }
        ArrayList targetBindings = new ArrayList(this.targetCMC.getConfiguration().getConnectorBindings());
        HashMap<BaseID, ConnectorBinding> targetMap = new HashMap<BaseID, ConnectorBinding>(targetBindings.size());
        Iterator tb = targetBindings.iterator();
        while (tb.hasNext()) {
            ConnectorBinding cb = (ConnectorBinding)tb.next();
            targetMap.put(cb.getID(), cb);
        }
        this.writeReportLine("\n----- Connector Bindings ------ ");
        Iterator it2 = sourcebindings.iterator();
        while (it2.hasNext()) {
            ConnectorBinding scb = (ConnectorBinding)it2.next();
            ConnectorBinding tcb = (ConnectorBinding)targetMap.get(scb.getID());
            if (tcb == null) {
                this.writeComponentTypeLine(scb.getFullName(), ADD_TYPE, scb.getFullName());
                this.logInfo("\tAdd connector binding: " + scb.getName());
                this.getEditor(this.updateConnectorBindings).createConnectorComponent(this.targetCMC.getConfigurationID(), scb, scb.getName(), scb.getRoutingUUID());
                this.targetCMC.addObject((Object)scb);
                continue;
            }
            this.writeComponentTypeLine(scb.getFullName(), NO_ACTION, tcb.getFullName());
            targetMap.remove(scb.getID());
        }
        it2 = targetBindings.iterator();
        while (it2.hasNext()) {
            ConnectorBinding tcb = (ConnectorBinding)it2.next();
            if (tcb.getProperty(CONNCLASSPATH) == null) continue;
            Properties props = PropertiesUtils.clone((Properties)tcb.getProperties(), (boolean)false);
            props.remove(CONNCLASSPATH);
            this.getEditor(this.updateConnectorBindings).modifyProperties((ComponentObject)tcb, props, 0);
            this.logInfo("\tReset connector binding classpath back to default: " + tcb.getName());
            this.writeComponentTypeLine(tcb.getFullName(), UPDATE_TYPE, tcb.getFullName());
        }
        this.writeReportLine("\n\n--------------------------------\n ");
        this.logInfo("***** Completed processing connector bindings");
    }

    private void processServices() throws MetaMatrixException {
        this.logInfo("***** Updating services...");
        Collection tgtservices = this.targetCMC.getConfiguration().getServiceComponentDefns();
        HashMap<BaseID, ServiceComponentDefn> targetMap = new HashMap<BaseID, ServiceComponentDefn>(tgtservices.size());
        Iterator it = tgtservices.iterator();
        while (it.hasNext()) {
            ServiceComponentDefn scb = (ServiceComponentDefn)it.next();
            if (scb.getFullName().length() > this.maxSourceName) {
                this.maxSourceName = scb.getFullName().length();
            }
            targetMap.put(scb.getID(), scb);
        }
        this.writeReportLine("\n----- Services ------ ");
        Collection sourceServices = this.sourceCMC.getConfiguration().getServiceComponentDefns();
        Iterator it2 = sourceServices.iterator();
        while (it2.hasNext()) {
            ServiceComponentDefn scb = (ServiceComponentDefn)it2.next();
            ServiceComponentDefn tcb = (ServiceComponentDefn)targetMap.get(scb.getID());
            Properties sourceDefaultProps = this.sourceCMC.getDefaultPropertyValues(scb.getComponentTypeID());
            if (tcb == null) continue;
            this.writeComponentTypeLine(scb.getFullName(), UPDATE_TYPE, scb.getFullName());
            this.logInfo("\tUpdate service properties: " + scb.getName());
            this.updateService(scb, tcb, sourceDefaultProps, 0);
        }
        this.writeReportLine("\n\n--------------------------------\n ");
        this.logInfo("***** Completed services");
    }

    protected void updateService(ServiceComponentDefn sourceDefn, ServiceComponentDefn targetDefn, Properties sourceDefaultProps, int action) {
        this.updateProperties(sourceDefn.getProperties(), sourceDefaultProps, targetDefn.getProperties(), (ComponentObject)targetDefn, this.updateServices, action);
    }

    public abstract void processResources() throws MetaMatrixException;

    public abstract void processDeployment() throws MetaMatrixException;

    public void processSystemProperties() throws MetaMatrixException {
        this.writeReportLine("\n----- System Properties ------\n ");
        ComponentType sourceConfigType = this.sourceCMC.getComponentType("Configuration");
        Properties sourceDefaultConfigProps = this.sourceCMC.getDefaultPropertyValues((ComponentTypeID)sourceConfigType.getID());
        Properties sourceConfigProps = this.sourceCMC.getConfiguration().getProperties();
        Properties targetProps = this.targetCMC.getConfiguration().getProperties();
        this.updateProperties(sourceConfigProps, sourceDefaultConfigProps, targetProps, (ComponentObject)this.targetCMC.getConfiguration(), this.updateSystemProps);
        this.writeReportLine("\n--------------------------------\n ");
    }

    protected void updateProperties(Properties sourceProps, Properties sourceDefaultProps, Properties targetProps, ComponentObject targetObject, boolean update) {
        Properties targetDefaults = this.targetCMC.getDefaultPropertyValues(targetObject.getComponentTypeID());
        Map defnMap = this.getDefnMap(targetObject);
        this.updateProperties(sourceProps, sourceDefaultProps, targetProps, targetDefaults, targetObject, defnMap, update, 0);
    }

    protected void updateProperties(Properties sourceProps, Properties sourceDefaultProps, Properties targetProps, ComponentObject targetObject, boolean update, int action) {
        Properties targetDefaults = this.targetCMC.getDefaultPropertyValues(targetObject.getComponentTypeID());
        Map defnMap = this.getDefnMap(targetObject);
        this.updateProperties(sourceProps, sourceDefaultProps, targetProps, targetDefaults, targetObject, defnMap, update, action);
    }

    protected void updateProperties(Properties sourceProps, Properties sourceDefaultProps, Properties targetProps, Properties targetDefaultProps, ComponentObject targetObject, Map defnMap, boolean update, int action) {
        Properties changedProps = new Properties();
        if (targetProps != null) {
            changedProps.putAll((Map<?, ?>)targetProps);
        } else {
            targetProps = new Properties();
        }
        Iterator<Object> it = sourceProps.keySet().iterator();
        while (it.hasNext()) {
            String dv;
            String k = (String)it.next();
            if (excludeProps.contains(k)) continue;
            if (defnMap.get(k) == null) {
                this.logInfo("\tProperty " + k + " is in source, but not in target " + targetObject);
                continue;
            }
            String v = sourceProps.getProperty(k);
            if (v == null || v.indexOf("(") > -1 && v.indexOf(")") > -1 || (dv = sourceDefaultProps.getProperty(k)) != null && v.equals(dv)) continue;
            String tv = targetProps.getProperty(k);
            if (tv == null) {
                tv = targetDefaultProps.getProperty(k);
            }
            if (tv != null && (tv == null || v.equals(tv))) continue;
            if (tv == null) {
                tv = "[space]";
            }
            changedProps.setProperty(k, v);
            if (update) {
                this.writePropLine(k, v, "property changed from " + tv);
                this.logInfo("\tProperty changed for " + k + " to " + v + " from " + tv);
                continue;
            }
            this.writePropLine(k, v, "property requires manual update from " + tv);
            this.logInfo("\tProperty requires manual update for " + k + " to " + v + " from " + tv);
        }
        this.getEditor(update).modifyProperties(targetObject, changedProps, action);
    }

    protected void processFooter() {
        this.writeReportLine("\n----------------------------------------------------------------- ");
        this.writeReportLine("\n----- NOTES: ------\n");
        this.writeReportLine("\n--- added -->: indicates this existed in the source configuration but not the target,");
        this.writeReportLine("\n\tand therefore is added to the target.");
        this.writeReportLine(CR);
        this.writeReportLine("\n--- updated ---: indicates the properties for this item were updated to match the source configuration");
        this.writeReportLine(CR);
        this.writeReportLine("\n----------------------------------------------------------------- ");
    }

    protected Map getDefnMap(ComponentObject targetObject) {
        ComponentType ct = this.targetCMC.getComponentType(targetObject.getComponentTypeID().getFullName());
        if (ct == null) {
            this.logError("ComponentType " + targetObject.getComponentTypeID().getFullName() + " is not found in the configuration for component " + targetObject.getFullName() + ", properties cannot be updated");
            return null;
        }
        return this.getDefnMap(targetObject, ct);
    }

    protected Map getDefnMap(ComponentObject targetObject, ComponentType type) {
        HashMap<String, ComponentTypeDefn> defnMap = null;
        Collection defns = type.getComponentTypeDefinitions();
        defnMap = new HashMap<String, ComponentTypeDefn>(defns.size());
        Iterator it = defns.iterator();
        while (it.hasNext()) {
            ComponentTypeDefn ctd = (ComponentTypeDefn)it.next();
            defnMap.put(ctd.getFullName(), ctd);
        }
        return defnMap;
    }

    void writeComponentTypeLine(String sType, String msg, String tType) {
        StringBuffer result = null;
        result = new StringBuffer(CR);
        result.append(sType);
        if (sType.length() < this.maxSourceName) {
            result.append(this.fill(this.maxSourceName - sType.length()));
        }
        result.append(this.fill(3));
        result.append(msg);
        result.append(this.fill(3));
        result.append(tType);
        this.writeReportLine(result.toString());
    }

    void writeHostLine(String sType, String msg, String tType) {
        StringBuffer result = null;
        result = new StringBuffer("\n\n");
        result.append(HOST);
        result.append(sType);
        if (sType.length() < this.maxSourceName) {
            result.append(this.fill(this.maxSourceName - sType.length()));
        }
        result.append(this.fill(3));
        result.append(msg);
        result.append(this.fill(3));
        result.append(tType);
        this.writeReportLine(result.toString());
    }

    void writeVMLine(String sType, String msg, String tType) {
        StringBuffer result = null;
        result = new StringBuffer(CR);
        result.append(TAB);
        result.append(VM);
        result.append(sType);
        if (sType.length() < this.maxSourceName) {
            result.append(this.fill(this.maxSourceName - sType.length()));
        }
        result.append(this.fill(3));
        result.append(msg);
        result.append(this.fill(3));
        result.append(tType);
        this.writeReportLine(result.toString());
    }

    void writeSVCLine(String sType, String msg, String tType) {
        StringBuffer result = null;
        result = new StringBuffer(CR);
        result.append("\t\t");
        result.append(SVCT);
        result.append(sType);
        if (sType.length() < this.maxSourceName) {
            result.append(this.fill(this.maxSourceName - sType.length()));
        }
        result.append(this.fill(3));
        result.append(msg);
        result.append(this.fill(3));
        result.append(tType);
        this.writeReportLine(result.toString());
    }

    void writePropLine(String key, String value, String msg) {
        StringBuffer result = null;
        result = new StringBuffer(CR);
        result.append(TAB);
        result.append(PROPERTY);
        result.append(key);
        if (key.length() < this.maxSourceName) {
            result.append(this.fill(this.maxSourceName - key.length()));
        }
        result.append(this.fill(3));
        result.append(value);
        result.append(this.fill(3));
        result.append(msg);
        this.writeReportLine(result.toString());
    }

    ConfigurationObjectEditor getEditor(boolean update) {
        if (update) {
            return this.updateEditor;
        }
        return this.noeditEditor;
    }

    void writeReportLine(String msg) {
        if (this.writeReport) {
            this.reportWriter.print(msg);
        }
    }

    public char[] fill(int s) {
        return this.fill(s, ' ');
    }

    public char[] fill(int s, char fillvalue) {
        char[] c = new char[s];
        for (int i = 0; i < s; ++i) {
            c[i] = fillvalue;
        }
        return c;
    }

    static {
        excludeProps.add("vm.starter.command");
    }
}

