/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.IntegerIDFactory;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.cache.CacheID;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.ResultSetCacheUtil;
import com.metamatrix.dqp.internal.process.CallableStatementRequest;
import com.metamatrix.dqp.internal.process.DQPProcessorContext;
import com.metamatrix.dqp.internal.process.PreparedPlanCache;
import com.metamatrix.dqp.internal.process.PreparedStatementRequest;
import com.metamatrix.dqp.internal.process.QueryMetadataWrapper;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.internal.process.TimeZoneVisitor;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.internal.process.capabilities.ConnectorCapabilitiesFinder;
import com.metamatrix.dqp.internal.process.capabilities.SharedCachedFinder;
import com.metamatrix.dqp.internal.process.multisource.MultiSourceCapabilitiesFinder;
import com.metamatrix.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import com.metamatrix.dqp.internal.process.multisource.MultiSourcePlanModifier;
import com.metamatrix.dqp.internal.process.validator.AuthorizationValidationVisitor;
import com.metamatrix.dqp.internal.process.validator.ModelVisibilityValidationVisitor;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.service.AuthorizationService;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.query.c.a;
import com.metamatrix.query.c.h;
import com.metamatrix.query.c.i;
import com.metamatrix.query.d.b;
import com.metamatrix.query.d.e;
import com.metamatrix.query.e.j.z;
import com.metamatrix.query.i.g;
import com.metamatrix.query.l.c;
import com.metamatrix.query.m.d;
import com.metamatrix.query.o.i.f;
import com.metamatrix.query.o.i.s;
import com.metamatrix.query.o.j.ac;
import com.metamatrix.query.o.j.af;
import com.metamatrix.query.o.j.aq;
import com.metamatrix.query.o.j.l;
import com.metamatrix.query.o.j.m;
import com.metamatrix.query.o.j.o;
import com.metamatrix.query.o.j.u;
import com.metamatrix.query.o.j.w;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.transaction.xa.XAException;

public class Request {
    private static final String SYSTEM_MODEL = "System";
    private static final String AUTO_WRAP_OPTIMISTIC = "OPTIMISTIC";
    private static TimeZone DATA_TIME_ZONE;
    public static final String TIMEZONE_PROPERTY = "DataTimeZone";
    protected RequestMessage requestMsg;
    protected String vdbName;
    protected String vdbVersion;
    protected com.metamatrix.query.m.e metadata;
    protected ApplicationEnvironment env;
    private VDBService vdbService;
    private BufferManager bufferManager;
    private com.metamatrix.query.e.d processorDataManager;
    private RequestManager requestMgr;
    private WorkerPool processWorkerPool;
    private Map connectorCapabilitiesCache;
    private TransactionService transactionService;
    private ResultSetCache rsCache;
    protected IDGenerator idGenerator;
    protected com.metamatrix.query.e.e processPlan;
    protected Collection schemas;
    private Collection multiSourceModels;
    protected boolean updatesAllowed;
    protected boolean virtualLayerAllowed;
    protected boolean xmlAllowed;
    protected com.metamatrix.query.k.b analysisRecord;
    private boolean procDebugAllowed = false;
    boolean threadSuspended;
    private g context;

    public static Request createRequest(RequestMessage requestMsg, ApplicationEnvironment env, PreparedPlanCache prepPlanCache, BufferManager bufferManager, com.metamatrix.query.e.d processorDataManager, RequestManager requestMgr, WorkerPool processWorkerPool, Map connectorCapabilitiesCache, TransactionService transactionService, boolean updatesAllowed, ResultSetCache rsCache, boolean procDebugAllowed, boolean virtualLayerAllowed, boolean xmlAllowed) {
        Object result = null;
        if (requestMsg.isCallableStatement()) {
            result = new CallableStatementRequest();
        } else if (requestMsg.isPreparedStatement()) {
            PreparedStatementRequest preparedStatementRequest = new PreparedStatementRequest();
            preparedStatementRequest.initializePreparedPlanCache(prepPlanCache);
            result = preparedStatementRequest;
        } else {
            result = new Request();
        }
        result.initialize(requestMsg, env, bufferManager, processorDataManager, requestMgr, processWorkerPool, connectorCapabilitiesCache, transactionService, updatesAllowed, rsCache, procDebugAllowed, virtualLayerAllowed, xmlAllowed);
        return result;
    }

    protected void initialize(RequestMessage requestMsg, ApplicationEnvironment env, BufferManager bufferManager, com.metamatrix.query.e.d processorDataManager, RequestManager requestMgr, WorkerPool processWorkerPool, Map connectorCapabilitiesCache, TransactionService transactionService, boolean updatesAllowed, ResultSetCache rsCache, boolean procDebugAllowed, boolean virtualLayerAllowed, boolean xmlAllowed) {
        this.requestMsg = requestMsg;
        this.vdbName = requestMsg.getVdbName();
        this.vdbVersion = requestMsg.getVdbVersion();
        this.env = env;
        this.vdbService = (VDBService)env.findService("dqp.vdb");
        this.bufferManager = bufferManager;
        this.processorDataManager = processorDataManager;
        this.requestMgr = requestMgr;
        this.processWorkerPool = processWorkerPool;
        this.connectorCapabilitiesCache = connectorCapabilitiesCache;
        this.transactionService = transactionService;
        this.updatesAllowed = updatesAllowed;
        this.rsCache = rsCache;
        this.procDebugAllowed = procDebugAllowed;
        this.virtualLayerAllowed = virtualLayerAllowed;
        this.xmlAllowed = xmlAllowed;
    }

    protected void prepareCommand() throws QueryParserException, QueryResolverException, QueryValidatorException, MetaMatrixComponentException {
        this.requestMsg.markProcessingStart();
        l command = this.getCommand();
        this.requestMsg.setCommand(command);
        List references = com.metamatrix.query.o.h.g.er((com.metamatrix.query.o.d)command);
        if (!(this.requestMsg.isCallableStatement() || this.requestMsg.isPreparedStatement() || references == null || references.isEmpty())) {
            throw new QueryValidatorException(DQPPlugin.Util.getString("Request.Invalid_character_in_query"));
        }
        this.initializeMetaData();
        this.decodeQueryOptions(command);
        if (references != null && !references.isEmpty()) {
            this.setParameterReferenceTypeHints(references);
        }
        this.resolveQuery(command, this.metadata);
        if (!this.requestMsg.isTransactional() && AUTO_WRAP_OPTIMISTIC.equals(this.requestMsg.getTxnAutoWrapMode()) && command.ge(this.metadata) > 1) {
            String msg = DQPPlugin.Util.getString("Request.txn_needed_wrong_mode", (Object)this.requestMsg.getRequestID());
            LogManager.logError((String)"DQP", (String)msg);
            throw new MetaMatrixComponentException(msg);
        }
        this.collectReferences(command, references);
        this.resolveParameterValues();
        this.validateQuery(command, this.metadata);
        this.initCommandContext();
        this.rewriteQuery(command, this.metadata);
        this.modifyTimeZones(command);
    }

    private synchronized void initializeMetaData() throws MetaMatrixComponentException {
        if (this.metadata == null) {
            this.metadata = this.getMetaData();
            this.metadata = new QueryMetadataWrapper(this.metadata, this.vdbName, this.vdbVersion, this.vdbService);
            this.multiSourceModels = this.vdbService.getMultiSourceModels(this.vdbName, this.vdbVersion);
            if (this.multiSourceModels != null && this.multiSourceModels.size() > 0) {
                this.multiSourceModels = new HashSet(this.multiSourceModels);
                this.metadata = new MultiSourceMetadataWrapper(this.metadata, this.multiSourceModels);
            } else {
                this.multiSourceModels = null;
            }
        }
    }

    private void modifyTimeZones(l command) {
        if (DATA_TIME_ZONE != null) {
            TimeZoneVisitor.modifyTimeZones((TimeZone)DATA_TIME_ZONE, (com.metamatrix.query.o.d)command);
        }
    }

    private void rewriteQuery(l command, com.metamatrix.query.m.e metadata) throws MetaMatrixComponentException, QueryValidatorException {
        try {
            this.requestMsg.setCommand(c.aq(command, null, metadata, this.context));
        }
        catch (QueryValidatorException e2) {
            LogManager.logError((String)"DQP", (Throwable)e2, (String)DQPPlugin.Util.getString("DQPCore.Unable_to_rewrite_command."));
            throw e2;
        }
        this.setRowLimit(command);
    }

    private void setRowLimit(l command) {
        aq query;
        if (this.requestMsg.getRowLimit() > 0 && command instanceof aq && (query = (aq)command).ix() == null) {
            query.iw(new m(null, (s)new com.metamatrix.query.o.i.c((Object)new Integer(this.requestMsg.getRowLimit()), DataTypeManager.DefaultDataClasses.INTEGER)));
        }
    }

    static boolean usesUpdate(l command) {
        f group;
        int type = command.gn();
        if (type == 2 || type == 3 || type == 4 || type == 9) {
            return true;
        }
        if (type == 1 && command instanceof af && ((af)command).jj() != null && !(group = ((af)command).jj().jr()).av()) {
            return true;
        }
        List subCommands = command.f6();
        if (subCommands != null && subCommands.size() > 0) {
            for (int i2 = 0; i2 < subCommands.size(); ++i2) {
                if (!Request.usesUpdate((l)subCommands.get(i2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsNonSystemVirtualTablesOrProcs(l command) throws MetaMatrixComponentException, QueryMetadataException {
        List subCommands;
        int type = command.gn();
        if (type != 7 && type != 9 && type != 8) {
            if (type == 6) {
                w proc = (w)command;
                Object procModelID = proc.hx();
                if (this.metadata.isVirtualModel(procModelID) && !this.isSystemModel(this.metadata.getFullName(procModelID))) {
                    return true;
                }
            } else {
                Collection groups = com.metamatrix.query.o.h.d.eh((com.metamatrix.query.o.d)command, (boolean)true);
                Iterator i2 = groups.iterator();
                while (i2.hasNext()) {
                    f group = (f)i2.next();
                    Object groupID = group.aq();
                    if (groupID instanceof d || !this.metadata.isVirtualGroup(group.aq()) || this.isSystemGroup(group.aq())) continue;
                    return true;
                }
            }
        }
        if ((subCommands = command.f6()) != null && subCommands.size() > 0) {
            for (int i3 = 0; i3 < subCommands.size(); ++i3) {
                if (!this.containsNonSystemVirtualTablesOrProcs((l)subCommands.get(i3))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSystemModel(String modelName) {
        return modelName.equals(SYSTEM_MODEL);
    }

    private boolean isSystemGroup(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        Object modelID = this.metadata.getModelID(metadataID);
        String fullName = this.metadata.getFullName(modelID);
        return this.isSystemModel(fullName);
    }

    private boolean containsXML(l command) throws MetaMatrixComponentException, QueryMetadataException {
        int type = command.gn();
        if (type == 8) {
            return true;
        }
        Collection groups = com.metamatrix.query.o.h.d.eh((com.metamatrix.query.o.d)command, (boolean)true);
        Iterator i2 = groups.iterator();
        while (i2.hasNext()) {
            Object metadataID = ((f)i2.next()).aq();
            if (metadataID instanceof d || !this.metadata.isXMLGroup(metadataID)) continue;
            return true;
        }
        List subCommands = command.f6();
        if (subCommands != null && subCommands.size() > 0) {
            for (int i3 = 0; i3 < subCommands.size(); ++i3) {
                if (!this.containsXML((l)subCommands.get(i3))) continue;
                return true;
            }
        }
        return false;
    }

    protected void checkUpdatesAllowed(l rootCommand) throws MetaMatrixComponentException {
        boolean usesUpdate;
        if (!this.updatesAllowed && (usesUpdate = Request.usesUpdate(rootCommand))) {
            String message = DQPPlugin.Util.getString("Request.Updates_not_allowed_due_to_license_restriction._1");
            LogManager.logError((String)"DQP", (String)message);
            throw new MetaMatrixComponentException(message);
        }
    }

    protected void checkVirtualLayerAllowed(l rootCommand) throws MetaMatrixComponentException {
        if (!this.virtualLayerAllowed) {
            try {
                boolean containsVirtualEntities = this.containsNonSystemVirtualTablesOrProcs(rootCommand);
                if (containsVirtualEntities) {
                    String message = DQPPlugin.Util.getString("Request.virtual_restricted");
                    LogManager.logError((String)"DQP", (String)message);
                    throw new MetaMatrixComponentException(message);
                }
            }
            catch (QueryMetadataException e2) {
                throw new MetaMatrixComponentException((Throwable)e2);
            }
        }
    }

    protected void checkXMLAllowed(l rootCommand) throws MetaMatrixComponentException {
        if (!this.xmlAllowed) {
            try {
                boolean containsXML = this.containsXML(rootCommand);
                if (containsXML) {
                    String message = DQPPlugin.Util.getString("Request.xml_restricted");
                    LogManager.logError((String)"DQP", (String)message);
                    throw new MetaMatrixComponentException(message);
                }
            }
            catch (QueryMetadataException e2) {
                throw new MetaMatrixComponentException((Throwable)e2);
            }
        }
    }

    private void validateQuery(l command, com.metamatrix.query.m.e metadata) throws QueryValidatorException, MetaMatrixComponentException {
        this.checkVirtualLayerAllowed(command);
        this.checkXMLAllowed(command);
        this.checkUpdatesAllowed(command);
        com.metamatrix.query.c.e visitor = new com.metamatrix.query.c.e();
        this.validateWithVisitor(visitor, metadata, command, false);
        visitor = new i();
        this.validateWithVisitor(visitor, metadata, command, true);
        visitor = new com.metamatrix.query.c.d();
        this.validateWithVisitor(visitor, metadata, command, true);
        visitor = new ModelVisibilityValidationVisitor(this.vdbService, this.vdbName, this.vdbVersion);
        this.validateWithVisitor(visitor, metadata, command, true);
        this.validateEntitlement(command);
        this.validateQueriedTableType(command, metadata);
    }

    void validateQueriedTableType(l command, com.metamatrix.query.m.e metadata) throws QueryValidatorException, MetaMatrixComponentException {
        Collection groups = com.metamatrix.query.o.h.d.eh((com.metamatrix.query.o.d)command, (boolean)true);
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            f group = (f)iter.next();
            Object metadataID = group.aq();
            if (metadataID == null || metadataID instanceof d) continue;
            try {
                if (!metadata.isTemporaryGroup(metadataID)) continue;
                throw new QueryValidatorException(DQPPlugin.Util.getString("Request.Cant_query_staging_table", (Object)group.ak()));
            }
            catch (QueryMetadataException e2) {
                throw new MetaMatrixComponentException((Throwable)e2);
            }
        }
    }

    private void resolveQuery(l command, com.metamatrix.query.m.e metadata) throws MetaMatrixComponentException, QueryResolverException {
        try {
            com.metamatrix.query.f.b.j((l)command, (com.metamatrix.query.m.e)metadata, (com.metamatrix.query.k.b)this.analysisRecord);
        }
        catch (QueryResolverException e2) {
            LogManager.logError((String)"DQP", (Throwable)e2, (String)DQPPlugin.Util.getString("DQPCore.Unable_to_resolve_command."));
            throw e2;
        }
    }

    private com.metamatrix.query.m.e getMetaData() throws MetaMatrixComponentException {
        com.metamatrix.query.m.e metadata = this.getMetadataDirect((DQPInboundMessage)this.requestMsg);
        if (metadata == null) {
            Object[] params = new Object[]{this.vdbName, this.vdbVersion};
            String msg = DQPPlugin.Util.getString("DQPCore.Unable_to_load_metadata_for_VDB_name__{0},_version__{1}", params);
            MetaMatrixComponentException e2 = new MetaMatrixComponentException(msg);
            LogManager.logError((String)"DQP", (Throwable)e2, (String)msg);
            throw e2;
        }
        return metadata;
    }

    protected l getCommand() throws MetaMatrixComponentException, QueryParserException {
        l commandObj = this.requestMsg.getCommand();
        e parseInfo = this.getParseInfo();
        if (commandObj.gn() == 5) {
            b parser = new b();
            String sql = ((ac)commandObj).ii();
            try {
                return parser.d(sql, parseInfo);
            }
            catch (QueryParserException e2) {
                LogManager.logError((String)"DQP", (Throwable)e2, (String)DQPPlugin.Util.getString("DQPCore.Unable_to_parse_command", (Object)sql));
                throw e2;
            }
        }
        if (commandObj.gn() == 9) {
            List updates = ((u)commandObj).hp();
            ArrayList<l> parsedCommands = new ArrayList<l>(updates.size());
            b parser = new b();
            ac updateCommand = null;
            for (int i2 = 0; i2 < updates.size(); ++i2) {
                updateCommand = (ac)updates.get(i2);
                String sql = updateCommand.ii();
                try {
                    parsedCommands.add(parser.d(sql, parseInfo));
                    continue;
                }
                catch (QueryParserException e3) {
                    LogManager.logError((String)"DQP", (Throwable)e3, (String)DQPPlugin.Util.getString("DQPCore.Unable_to_parse_command", (Object)sql));
                    throw e3;
                }
            }
            return new u(parsedCommands);
        }
        return null;
    }

    private e getParseInfo() {
        e info = new e();
        if (this.requestMsg.isDoubleQuotedVariableAllowed()) {
            info.b = true;
        }
        return info;
    }

    protected void setParameterReferenceTypeHints(List references) throws QueryValidatorException {
    }

    protected void resolveParameterValues() throws QueryValidatorException {
    }

    protected void collectReferences(l command, List references) {
    }

    protected void validateWithVisitor(com.metamatrix.query.c.c visitor, com.metamatrix.query.m.e metadata, l command, boolean validateOnlyEmbedded) throws QueryValidatorException, MetaMatrixComponentException {
        h report = com.metamatrix.query.c.b.b((com.metamatrix.query.o.d)command, (com.metamatrix.query.m.e)metadata, (com.metamatrix.query.c.c)visitor, (boolean)validateOnlyEmbedded);
        if (report.b()) {
            a firstFailure = (a)report.g().iterator().next();
            throw new QueryValidatorException(firstFailure.c());
        }
    }

    com.metamatrix.query.m.e getMetadataDirect(DQPInboundMessage message) throws MetaMatrixComponentException {
        MetadataService metadataService = (MetadataService)this.env.findService("dqp.metadata");
        if (metadataService == null && (metadataService = (MetadataService)this.env.findService("dqp.metadata")) == null) {
            String msg = DQPPlugin.Util.getString("Request.MetadataServiceIsNull");
            LogManager.logError((String)"DQP", (String)msg);
            throw new MetaMatrixComponentException(msg);
        }
        return metadataService.lookupMetadata(message.getVdbName(), message.getVdbVersion());
    }

    protected void processCommand() throws QueryPlannerException, MetaMatrixComponentException {
        this.context.setTupleSourceID(this.getTupleSourceID(this.requestMsg.getConnectionID()));
        com.metamatrix.query.e.f processor = new com.metamatrix.query.e.f(this.processPlan, this.context, this.bufferManager, this.processorDataManager);
        RequestID reqID = this.requestMsg.getRequestID();
        this.registerWork(this.context.getTupleSourceID(), reqID, processor);
    }

    protected void initCommandContext() throws MetaMatrixComponentException {
        o option;
        l command;
        String groupName = this.requestMsg.getConnectionID();
        RequestID reqID = this.requestMsg.getRequestID();
        Properties envProps = this.env.getApplicationProperties();
        Properties props = this.createContextProps(this.env.getApplicationProperties());
        if (this.requestMsg.getConnectionID() != null) {
            props.setProperty("sessionid", this.requestMsg.getConnectionID());
        }
        this.context = new DQPProcessorContext(this.requestMsg.getClientConnection(), this.requestMsg.getMessageKey(), (Object)reqID, groupName, null, this.requestMsg.getFetchSize(), props, this.useProcDebug(), this.collectNodeStatistics(), this.requestMsg.getExecutionPayload());
        try {
            this.context.setProcessorBatchSize(this.bufferManager.getProcessorBatchSize());
            this.context.setConnectorBatchSize(this.bufferManager.getConnectorBatchSize());
        }
        catch (RemoteException e2) {
            // empty catch block
        }
        String streamingBatchSize = null;
        if (envProps != null) {
            streamingBatchSize = envProps.getProperty("metamatrix.server.streamingBatchSize");
        }
        if (streamingBatchSize != null) {
            this.context.setStreamingBatchSize(Integer.parseInt(streamingBatchSize));
        }
        if ((command = this.requestMsg.getCommand()) != null && (option = command.f7()) != null) {
            this.context.setVirtualDependentJoinAllowed(option.ju());
        }
    }

    private boolean useProcDebug() {
        o option;
        l command;
        if (this.procDebugAllowed && (command = this.requestMsg.getCommand()) != null && (option = command.f7()) != null) {
            return option.j2();
        }
        return false;
    }

    private boolean collectNodeStatistics() {
        o option;
        if (this.requestMsg.getShowPlan()) {
            return true;
        }
        l command = this.requestMsg.getCommand();
        if (command != null && (option = command.f7()) != null) {
            return option.j2() || option.j1();
        }
        return false;
    }

    private Properties createContextProps(Properties envProps) {
        Properties contextProps = new Properties();
        return contextProps;
    }

    private void registerWork(TupleSourceID tsID, RequestID reqID, com.metamatrix.query.e.f processor) throws MetaMatrixComponentException {
        try {
            this.requestMgr.addRequest(this.requestMsg, this.requestMsg.getCommand(), processor, tsID, this.analysisRecord);
            if (this.schemas != null) {
                this.requestMgr.setSchemas(reqID, this.schemas);
            }
            this.processWorkerPool.addWork((Object)new WorkItem(reqID));
        }
        catch (QueueSuspendedException e2) {
            this.requestMgr.removeRequest(reqID);
            throw new MetaMatrixComponentException((Throwable)e2);
        }
    }

    private TupleSourceID getTupleSourceID(String groupName) throws MetaMatrixComponentException {
        try {
            List outputElements = this.processPlan.f3();
            return this.bufferManager.createTupleSource(outputElements, com.metamatrix.query.i.d.a((List)outputElements), groupName, 2);
        }
        catch (RemoteException e2) {
            throw new MetaMatrixComponentException((Throwable)e2);
        }
    }

    protected void generatePlan() throws MetaMatrixComponentException, QueryPlannerException {
        l command = this.requestMsg.getCommand();
        this.resetPlanFields();
        try {
            com.metamatrix.query.e.e plan;
            Collection procChildPlans;
            Collection childPlans;
            this.initProcessPlan(command, this.metadata);
            this.savePlanTreeIfNecessary();
            z xmlPlan = null;
            if (this.processPlan instanceof z) {
                xmlPlan = (z)this.processPlan;
            } else if (this.processPlan instanceof com.metamatrix.query.e.n.a) {
                ((com.metamatrix.query.e.n.a)this.processPlan).gz(this.requestMsg.getXMLFormat());
            } else if (command instanceof w && !(childPlans = this.processPlan.f5()).isEmpty() && (procChildPlans = (plan = (com.metamatrix.query.e.e)childPlans.iterator().next()).f5()).size() > 0) {
                Iterator iter = procChildPlans.iterator();
                com.metamatrix.query.e.e lastPlan = null;
                while (iter.hasNext()) {
                    lastPlan = (com.metamatrix.query.e.e)iter.next();
                }
                if (lastPlan instanceof z) {
                    xmlPlan = (z)lastPlan;
                }
            }
            if (xmlPlan != null) {
                this.handleXmlPlan(xmlPlan, this.metadata);
            }
            this.logRequest();
            this.addedProcessPlan();
        }
        catch (QueryMetadataException e2) {
            Object[] params = new Object[]{this.requestMsg.getRequestID()};
            String msg = DQPPlugin.Util.getString("DQPCore.Unknown_query_metadata_exception_while_registering_query__{0}.", params);
            QueryPlannerException e22 = new QueryPlannerException((Throwable)e2, msg);
            LogManager.logError((String)"DQP", (Throwable)e22, (String)msg);
            throw e22;
        }
    }

    private void resetPlanFields() {
        this.processPlan = null;
        this.schemas = null;
    }

    private void logRequest() {
        LogManager.logDetail((String)"DQP", (Object[])new Object[]{DQPPlugin.Util.getString("BasicInterceptor.ProcessTree_for__4"), this.requestMsg.getRequestID(), this.processPlan});
    }

    private void handleXmlPlan(z xmlPlan, com.metamatrix.query.m.e metadata) throws MetaMatrixComponentException, QueryMetadataException {
        boolean shouldValidate = this.requestMsg.getValidationMode();
        xmlPlan.g4(shouldValidate);
        xmlPlan.ha(this.requestMsg.getStyleSheet());
        xmlPlan.hk(this.requestMsg.getXMLFormat());
        if (shouldValidate) {
            this.validateXmlSchema(xmlPlan.hb(), metadata, xmlPlan);
        }
    }

    private void validateXmlSchema(f group, com.metamatrix.query.m.e metadata, z xmlPlan) throws MetaMatrixComponentException, QueryMetadataException {
        this.schemas = metadata.getXMLSchemas(group.aq());
        xmlPlan.g5(this.schemas);
    }

    private void savePlanTreeIfNecessary() {
        if (this.analysisRecord.d()) {
            this.analysisRecord.g(this.processPlan.a());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProcessPlan(l command, com.metamatrix.query.m.e metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        ConnectorCapabilitiesFinder baseFinder = new ConnectorCapabilitiesFinder(this.vdbService, (DataService)this.env.findService("dqp.data"), this.requestMsg);
        SharedCachedFinder cachedFinder = new SharedCachedFinder((com.metamatrix.query.j.e.c)baseFinder, this.connectorCapabilitiesCache);
        if (this.multiSourceModels != null) {
            cachedFinder = new MultiSourceCapabilitiesFinder((com.metamatrix.query.j.e.c)cachedFinder, this.multiSourceModels);
        }
        this.idGenerator = new IDGenerator();
        this.idGenerator.setDefaultFactory((ObjectIDFactory)new IntegerIDFactory());
        try {
            this.processPlan = com.metamatrix.query.j.b.e((l)command, (com.metamatrix.query.m.e)metadata, (IDGenerator)this.idGenerator, (com.metamatrix.query.j.e.c)cachedFinder, (com.metamatrix.query.k.b)this.analysisRecord, (g)this.context);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            String debugLog = this.analysisRecord.c();
            if (debugLog != null && debugLog.length() > 0) {
                System.out.println(debugLog);
            }
            throw throwable;
        }
        String debugLog = this.analysisRecord.c();
        if (debugLog != null && debugLog.length() > 0) {
            System.out.println(debugLog);
        }
        if (this.multiSourceModels != null) {
            MultiSourcePlanModifier modifier = new MultiSourcePlanModifier();
            modifier.setVdbName(this.vdbName);
            modifier.setVdbVersion(this.vdbVersion);
            modifier.setVdbService(this.vdbService);
            modifier.setIdGenerator(this.idGenerator);
            modifier.setMetadata(metadata);
            modifier.setMultiSourceModels(this.multiSourceModels);
            modifier.setProcessPlan(this.processPlan);
            modifier.expandMultiSourceModels();
        }
    }

    private void decodeQueryOptions(l command) {
        o option = command.f7();
        boolean getPlan = this.requestMsg.getShowPlan();
        boolean debug = false;
        if (option != null) {
            getPlan = getPlan || option.j1() || option.jx();
            debug = option.j2();
        }
        this.analysisRecord = new com.metamatrix.query.k.b(getPlan, getPlan, debug);
    }

    protected void addedProcessPlan() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest() throws QueryValidatorException, QueryParserException, QueryResolverException, MetaMatrixComponentException, QueryPlannerException {
        block5: {
            block4: {
                try {
                    if (this.hasResultsInCache()) {
                        this.validateEntitlement(this.requestMsg.getCommand());
                        this.useResultsInCache();
                        Object var2_1 = null;
                        break block4;
                    }
                    if (this.requestMsg.isTransactional()) {
                        this.createAndExportTxn();
                    }
                    this.prepareCommand();
                    this.generatePlan();
                    this.processCommand();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    if (!this.requestMsg.isTransactional()) throw throwable;
                    if (this.threadSuspended) throw throwable;
                    if (this.requestMsg.getTransactionContext() == null) throw throwable;
                    this.suspendTransaction();
                    throw throwable;
                }
            }
            if (!this.requestMsg.isTransactional()) return;
            if (this.threadSuspended) return;
            if (this.requestMsg.getTransactionContext() == null) return;
            this.suspendTransaction();
            return;
        }
        Object var2_2 = null;
        if (!this.requestMsg.isTransactional()) return;
        if (this.threadSuspended) return;
        if (this.requestMsg.getTransactionContext() == null) return;
        this.suspendTransaction();
    }

    protected void validateEntitlement(l command) throws QueryValidatorException, MetaMatrixComponentException {
        this.initializeMetaData();
        AuthorizationService authSvc = (AuthorizationService)this.env.findService("dqp.authorization");
        if (authSvc != null && authSvc.checkingEntitlements()) {
            AuthorizationValidationVisitor visitor = new AuthorizationValidationVisitor(this.requestMsg.getConnectionID(), authSvc);
            if (command.gn() == 8) {
                Iterator iter = command.f6().iterator();
                while (iter.hasNext()) {
                    this.validateWithVisitor((com.metamatrix.query.c.c)visitor, this.metadata, (l)iter.next(), true);
                }
            } else {
                this.validateWithVisitor((com.metamatrix.query.c.c)visitor, this.metadata, command, true);
            }
        }
    }

    protected void createAndExportTxn() throws MetaMatrixComponentException {
        TransactionContext txnContext = null;
        try {
            if (this.requestMsg.getTransactionXid() != null) {
                txnContext = this.transactionService.getXAServer().resume(this.requestMsg.getTransactionXid());
                this.threadSuspended = false;
            } else {
                txnContext = this.transactionService.getTransactionManager().resumeTransaction(this.requestMsg.getUserTransactionId());
                this.threadSuspended = false;
            }
            this.requestMsg.setTransactionContext(txnContext);
            LogManager.logDetail((String)"DQP", (Object[])new Object[]{DQPPlugin.Util.getString("Request.txn.info.resume", (Object)txnContext.toString())});
        }
        catch (XATransactionException e2) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.resume", (Object)this.requestMsg.getRequestID());
            LogManager.logError((String)"DQP", (Throwable)e2, (String)msg);
            throw new MetaMatrixComponentException((Throwable)e2, msg);
        }
        catch (XAException e3) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.resume", (Object)this.requestMsg.getRequestID());
            LogManager.logError((String)"DQP", (Throwable)e3, (String)msg);
            throw new MetaMatrixComponentException((Throwable)e3, msg);
        }
        catch (RemoteException e4) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.resume", (Object)this.requestMsg.getRequestID());
            LogManager.logError((String)"DQP", (Throwable)e4, (String)msg);
            throw new MetaMatrixComponentException((Throwable)e4, msg);
        }
        try {
            this.transactionService.getTransactionManager().exportTransaction(txnContext);
            LogManager.logDetail((String)"DQP", (Object[])new Object[]{DQPPlugin.Util.getString("Request.txn.info.export", (Object)txnContext.toString())});
        }
        catch (XATransactionException e5) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.export", (Object)this.requestMsg.getRequestID());
            LogManager.logError((String)"DQP", (Throwable)e5, (String)msg);
            throw new MetaMatrixComponentException((Throwable)e5, msg);
        }
        try {
            this.transactionService.getTransactionManager().suspendTransaction(txnContext);
            this.threadSuspended = true;
            LogManager.logDetail((String)"DQP", (Object[])new Object[]{DQPPlugin.Util.getString("Request.txn.info.suspend", (Object)txnContext.toString())});
        }
        catch (XATransactionException e6) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.suspend", (Object)this.requestMsg.getRequestID());
            LogManager.logError((String)"DQP", (Throwable)e6, (String)msg);
            throw new MetaMatrixComponentException((Throwable)e6, msg);
        }
    }

    protected void suspendTransaction() throws MetaMatrixComponentException {
        try {
            this.transactionService.getTransactionManager().suspendTransaction(this.requestMsg.getTransactionContext());
            this.threadSuspended = true;
            LogManager.logDetail((String)"DQP", (Object[])new Object[]{DQPPlugin.Util.getString("Request.txn.info.suspend", (Object)this.requestMsg.getTransactionContext().toString())});
        }
        catch (XATransactionException e2) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.suspend", (Object)this.requestMsg.getRequestID());
            LogManager.logError((String)"DQP", (Throwable)e2, (String)msg);
            throw new MetaMatrixComponentException((Throwable)e2, msg);
        }
    }

    protected boolean hasResultsInCache() {
        if (this.rsCache == null) {
            return false;
        }
        if (!this.requestMsg.useResultSetCache()) {
            return false;
        }
        CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)this.requestMsg, (ResultSetCache)this.rsCache);
        return this.rsCache.hasResults(cID);
    }

    protected void useResultsInCache() throws MetaMatrixComponentException {
        this.requestMsg.markProcessingStart();
        RequestID reqID = this.requestMsg.getRequestID();
        try {
            CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)this.requestMsg, (ResultSetCache)this.rsCache);
            l command = this.rsCache.getResults(cID, new int[]{1, 1}).getCommand();
            this.requestMgr.addRequest(this.requestMsg, command, null, null, this.analysisRecord);
            this.requestMgr.setSchemas(reqID, this.schemas);
            this.processWorkerPool.addWork((Object)new WorkItem(reqID, this.rsCache));
        }
        catch (QueueSuspendedException e2) {
            this.requestMgr.removeRequest(reqID);
            throw new MetaMatrixComponentException((Throwable)e2);
        }
    }

    static {
        String tzProp = System.getProperty(TIMEZONE_PROPERTY);
        if (tzProp != null) {
            DATA_TIME_ZONE = TimeZone.getTimeZone(tzProp);
        }
    }
}

