/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.edit.modelgen;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.Index;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.RelationalFactory;
import com.metamatrix.metamodels.relational.Schema;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.UniqueKey;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class MaterializedViewModelGenerator {
    private static String XMI = "xmi";
    private static String MV_PREFIX = "MV";
    private static int STARTING_INDEX = 1000000;
    private static String STAGING_SUFFIX = "ST";
    private static String RESULT_MSG = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.resultStr");
    private static String OK_MSG = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.success");
    private static String PHYS_SUFFIX = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.physSuffix");
    private final ModelEditor modelEditor;
    private final ResourceSet tempRsrcSet = new ResourceSetImpl();
    private final HashMap virtToPhysMappings;
    private final StringNameValidator nameValidator = new StringNameValidator();
    private Resource materializedViewModel;
    private boolean isInitialized = false;
    private int nextIndex;
    private MultiStatus result;
    private Set previousModelNames;

    public MaterializedViewModelGenerator() {
        this.modelEditor = ModelerCore.getModelEditor();
        this.virtToPhysMappings = new HashMap();
        this.previousModelNames = new HashSet();
        this.nextIndex = STARTING_INDEX + 1;
    }

    public MultiStatus execute(Resource inputResource, boolean reuseExistingMVModel, String mvModelName, URI mvModelFolderUri) {
        if (!reuseExistingMVModel) {
            this.materializedViewModel = null;
            this.virtToPhysMappings.clear();
            this.previousModelNames.clear();
            this.isInitialized = false;
        }
        if (inputResource == null) {
            String msg = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.nullInputRsrc");
            this.addStatus(4, msg, null);
            return this.result;
        }
        String inputModelName = this.modelEditor.getModelName(inputResource);
        ModelAnnotation ma = this.getModelAnnotation(inputResource);
        if (ma == null) {
            String msg = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.nullModelAnnotation");
            this.addStatus(4, msg, null);
            return this.result;
        }
        int modelType = ma.getModelType().getValue();
        String primaryMetamodel = ma.getPrimaryMetamodelUri();
        if (modelType != 1 || !"http://www.metamatrix.com/metamodels/Relational".equals(primaryMetamodel)) {
            String msg = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.wrongModelType");
            this.addStatus(0, msg, null);
            return this.result;
        }
        TreeIterator allContents = inputResource.getAllContents();
        ArrayList existingTableNames = new ArrayList();
        while (allContents.hasNext()) {
            Object next = allContents.next();
            if (!(next instanceof Table) || !((Table)next).isMaterialized()) continue;
            if (!this.isInitialized) {
                URI uri = mvModelFolderUri == null ? inputResource.getURI() : mvModelFolderUri;
                this.initialize(uri, inputModelName, mvModelName);
            }
            try {
                Schema schema = this.createSchema(inputModelName);
                this.createMaterializedView((Table)next, schema, existingTableNames);
            }
            catch (Exception err) {
                String fullName = this.modelEditor.getModelRelativePathIncludingModel((EObject)next).toString();
                String msg = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.exceptionCreatingMV", (Object)fullName);
                this.addStatus(4, msg, err);
            }
        }
        if (this.result == null) {
            this.addStatus(0, OK_MSG, null);
        }
        return this.result;
    }

    private ModelAnnotation getModelAnnotation(Resource rsrc) {
        if (rsrc instanceof MtkXmiResourceImpl) {
            return ((MtkXmiResourceImpl)rsrc).getModelAnnotation();
        }
        TreeIterator contents = rsrc.getAllContents();
        while (contents.hasNext()) {
            Object next = contents.next();
            if (!(next instanceof ModelAnnotation)) continue;
            return (ModelAnnotation)next;
        }
        return null;
    }

    private Schema createSchema(String inputModelName) {
        if (!this.isInitialized) {
            String msg = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.uninitializedError");
            throw new MetaMatrixRuntimeException(msg);
        }
        EList roots = this.materializedViewModel.getContents();
        Iterator iter = roots.iterator();
        while (iter.hasNext()) {
            Schema existingSchema;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof Schema) || !(existingSchema = (Schema)eObject).getName().equals(inputModelName)) continue;
            return existingSchema;
        }
        Schema newSchema = RelationalFactory.eINSTANCE.createSchema();
        newSchema.setName(inputModelName);
        newSchema.setNameInSource(inputModelName);
        this.materializedViewModel.getContents().add((Object)newSchema);
        return newSchema;
    }

    protected MultiStatus execute(Resource inputResource) {
        return this.execute(inputResource, false, null, null);
    }

    public HashMap getVirtToPhysMappings() {
        return this.virtToPhysMappings;
    }

    public Resource getMaterializedViewModel() {
        return this.materializedViewModel;
    }

    private void createMaterializedView(Table table, Schema owner, Collection existingNames) {
        if (!this.isInitialized) {
            String msg = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.uninitializedError");
            throw new MetaMatrixRuntimeException(msg);
        }
        Table mv = (Table)RelationalFactory.eINSTANCE.create(table.eClass());
        Table st = (Table)RelationalFactory.eINSTANCE.create(table.eClass());
        String name = table.getName();
        String tmp = this.nameValidator.createValidUniqueName(name, existingNames);
        if (tmp == null) {
            existingNames.add(name);
        } else {
            name = tmp;
            existingNames.add(name);
        }
        st.setName(name + STAGING_SUFFIX);
        mv.setName(name);
        this.copyTableValues(table, mv, false);
        this.copyTableValues(table, st, true);
        ++this.nextIndex;
        owner.getTables().add((Object)mv);
        owner.getTables().add((Object)st);
        ArrayList<Table> newTables = new ArrayList<Table>();
        newTables.add(st);
        newTables.add(mv);
        this.virtToPhysMappings.put(table, newTables);
        Iterator cols = table.getColumns().iterator();
        HashSet indexes = new HashSet();
        HashSet pks = new HashSet();
        while (cols.hasNext()) {
            Column nextCol = (Column)cols.next();
            Column newCol = RelationalFactory.eINSTANCE.createColumn();
            Column stageCol = RelationalFactory.eINSTANCE.createColumn();
            mv.getColumns().add((Object)newCol);
            st.getColumns().add((Object)stageCol);
            this.copyColValues(nextCol, newCol);
            this.copyColValues(nextCol, stageCol);
            indexes.addAll(nextCol.getIndexes());
            pks.addAll(nextCol.getUniqueKeys());
        }
        Iterator pksIt = pks.iterator();
        while (pksIt.hasNext()) {
            UniqueKey nextKey = (UniqueKey)pksIt.next();
            UniqueKey newKey = (UniqueKey)RelationalFactory.eINSTANCE.create(nextKey.eClass());
            UniqueKey stageKey = (UniqueKey)RelationalFactory.eINSTANCE.create(nextKey.eClass());
            if (nextKey instanceof PrimaryKey) {
                ((BaseTable)mv).setPrimaryKey((PrimaryKey)newKey);
                ((BaseTable)st).setPrimaryKey((PrimaryKey)stageKey);
            } else {
                ((BaseTable)mv).getUniqueConstraints().add((Object)newKey);
                ((BaseTable)st).getUniqueConstraints().add((Object)stageKey);
            }
            this.copyUniqueKeyValues(nextKey, newKey, false);
            this.copyUniqueKeyValues(nextKey, stageKey, true);
        }
        Iterator indexIt = indexes.iterator();
        while (indexIt.hasNext()) {
            Index nextIndex = (Index)indexIt.next();
            Index newIndex = RelationalFactory.eINSTANCE.createIndex();
            Index stageIndex = RelationalFactory.eINSTANCE.createIndex();
            this.copyIndexValues(nextIndex, stageIndex, true, table, st);
            this.copyIndexValues(nextIndex, newIndex, false, table, mv);
            this.materializedViewModel.getContents().add((Object)newIndex);
            this.materializedViewModel.getContents().add((Object)stageIndex);
        }
    }

    protected void copyTableValues(Table orig, Table copy, boolean isStage) {
        copy.setNameInSource(this.getUniqueNIS(isStage));
        copy.setCardinality(orig.getCardinality());
        copy.setSystem(orig.isSystem());
        copy.setSupportsUpdate(true);
    }

    private void copyColValues(Column orig, Column copy) {
        copy.setAutoIncremented(orig.isAutoIncremented());
        copy.setCaseSensitive(orig.isCaseSensitive());
        copy.setCharacterSetName(orig.getCharacterSetName());
        copy.setCollationName(orig.getCollationName());
        copy.setCurrency(copy.isCurrency());
        copy.setDefaultValue(orig.getDefaultValue());
        copy.setFixedLength(orig.isFixedLength());
        copy.setFormat(orig.getFormat());
        copy.setLength(orig.getLength());
        copy.setMaximumValue(orig.getMaximumValue());
        copy.setMinimumValue(orig.getMinimumValue());
        copy.setName(orig.getName());
        copy.setNameInSource(orig.getNameInSource());
        copy.setNativeType(orig.getNativeType());
        copy.setNullable(orig.getNullable());
        copy.setPrecision(orig.getPrecision());
        copy.setRadix(orig.getRadix());
        copy.setScale(orig.getScale());
        copy.setSearchability(orig.getSearchability());
        copy.setSelectable(orig.isSelectable());
        copy.setSigned(orig.isSigned());
        copy.setType(orig.getType());
        copy.setUpdateable(true);
    }

    private void addStatus(int severity, String msg, Exception e) {
        if (this.result == null) {
            this.result = new MultiStatus("com.metamatrix.vdb.edit", -1, RESULT_MSG, null);
        }
        this.result.add((IStatus)new Status(severity, "com.metamatrix.vdb.edit", -1, msg, (Throwable)e));
    }

    private void copyUniqueKeyValues(UniqueKey orig, UniqueKey copy, boolean isStage) {
        if (isStage) {
            copy.setName(orig.getName() + STAGING_SUFFIX);
        } else {
            copy.setName(orig.getName());
        }
        copy.setNameInSource(orig.getNameInSource());
        try {
            BaseTable copyOwner = copy.getTable();
            BaseTable origOwner = orig.getTable();
            Iterator cols = orig.getColumns().iterator();
            while (cols.hasNext()) {
                Column nextOrigCol = (Column)cols.next();
                int index = origOwner.getColumns().indexOf((Object)nextOrigCol);
                Column copyCol = (Column)copyOwner.getColumns().get(index);
                if (nextOrigCol.getName().equals(copyCol.getName())) {
                    copy.getColumns().add((Object)copyCol);
                    continue;
                }
                String msg = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.errorSettingUCvals", (Object)copy.getName());
                throw new MetaMatrixRuntimeException(msg);
            }
        }
        catch (Exception err) {
            String msg = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.errorSettingUCvals", (Object)copy.getName());
            throw new MetaMatrixRuntimeException(msg);
        }
    }

    private void copyIndexValues(Index orig, Index copy, boolean isStage, Table origTable, Table copyTable) {
        copy.setAutoUpdate(orig.isAutoUpdate());
        copy.setFilterCondition(orig.getFilterCondition());
        copy.setName(orig.getName());
        String nameInSource = orig.getNameInSource();
        copy.setNameInSource(nameInSource == null || nameInSource.length() == 0 ? orig.getName() : nameInSource);
        if (isStage) {
            copy.setName(copy.getName() + STAGING_SUFFIX);
            copy.setNameInSource(copy.getNameInSource() + STAGING_SUFFIX);
        }
        copy.setNullable(orig.isNullable());
        copy.setUnique(orig.isUnique());
        EList origTableCols = origTable.getColumns();
        EList copyTableCols = copyTable.getColumns();
        EList origIndexCols = orig.getColumns();
        EList copyIndexCols = copy.getColumns();
        int size = origIndexCols.size();
        for (int i = 0; i < size; ++i) {
            Column origCol = (Column)origIndexCols.get(i);
            int index = origTableCols.indexOf(origCol);
            if (index == -1) continue;
            copyIndexCols.add(copyTableCols.get(index));
        }
    }

    private void initialize(URI mvModelUri, String inputModelName, String mvModelName) {
        if (mvModelName == null) {
            mvModelName = inputModelName + PHYS_SUFFIX;
        }
        this.materializedViewModel = this.createResource(mvModelUri, mvModelName);
        this.isInitialized = this.materializedViewModel != null;
    }

    private Resource createResource(URI mvModelFolderUri, String name) {
        try {
            ArgCheck.isNotNull((Object)mvModelFolderUri);
            ArgCheck.isNotNull((Object)name);
            URI uri = mvModelFolderUri.appendSegment(name).appendFileExtension(XMI);
            MtkXmiResourceImpl rsrc = new MtkXmiResourceImpl(uri);
            this.tempRsrcSet.getResources().add((Object)rsrc);
            ModelContents newContents = new ModelContents((Resource)rsrc);
            ModelAnnotation ma = newContents.getModelAnnotation();
            ma.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            ma.setModelType(ModelType.MATERIALIZATION_LITERAL);
            String descr = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.physDescr");
            ma.setDescription(descr);
            return rsrc;
        }
        catch (Exception err) {
            Object[] params = new Object[]{mvModelFolderUri, name};
            String msg = VdbEditPlugin.Util.getString("MaterializedViewModelGenerator.unexpectedException1", params);
            this.addStatus(2, msg, err);
            return null;
        }
    }

    private String getUniqueNIS(boolean isST) {
        StringBuffer buffer = new StringBuffer(MV_PREFIX);
        buffer.append(this.nextIndex);
        if (isST) {
            buffer.append(STAGING_SUFFIX);
        }
        return buffer.toString();
    }
}

