/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAConstants;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDAUtil;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.sql.SQLException;

public abstract class DRDARequest
extends DRDAConstants {
    private static String footprint = "$Revision:   3.72.1.2  $";
    public DRDAUtil drdaUtil;
    public long queryDataEndPosition;
    public DRDACommunication comm;
    public DB2ImplConnection implConn;
    int severityCode;
    public boolean isCursorHeldOpen;
    String serverDiagnostics;
    public SQLException exception;
    public int numExceptions;
    public boolean hasWarnings;
    public boolean chainCommit;
    public boolean checkingForAdditionalUpdateCounts;
    public boolean continuingQuery;
    public boolean useOUTOVRlob;
    public int resultType;
    public boolean isCursorOpen;
    public boolean moreData;
    int numRowsAffected;
    int returnValueForStoredProcedure;
    boolean returnValueSet;
    int spRetVal;
    public static final short PROCESS_UNTIL_ROW_OR_UPDATECOUNT = 0;
    public static final short PROCESS_UNTIL_ROW = 1;
    public static final short PROCESS_UNTIL_END = 2;
    public static final short PROCESS_DESC_ONLY = 3;
    public static final short PROCESS_PARAM_INFO = 4;
    public int processMode;
    public DRDAByteOrderedDataReader reader;
    public DRDAByteOrderedDataWriter writer;
    public DRDAPkgNamCsn packageConsistencyToken;
    public boolean isCachedRequest;
    int sqlCode;
    byte[] sqlStateBytes;
    byte[] sqlErrProcBytes;
    byte[] errParamBytes;
    UtilTransliterator errParamsTranslit;
    public boolean isStoredProcedure;

    public DRDARequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter) {
        this.comm = dRDACommunication;
        this.numRowsAffected = 0;
        this.resultType = 0;
        this.isCursorOpen = false;
        this.moreData = false;
        this.processMode = 0;
        this.exception = null;
        this.reader = dRDAByteOrderedDataReader;
        this.writer = dRDAByteOrderedDataWriter;
        this.isCachedRequest = false;
        this.implConn = dB2ImplConnection;
        this.hasWarnings = false;
        this.checkingForAdditionalUpdateCounts = false;
        this.continuingQuery = false;
        this.drdaUtil = dRDACommunication.drdaUtil;
        this.useOUTOVRlob = false;
        this.spRetVal = 0;
        boolean bl = false;
        this.sqlStateBytes = new byte[5];
        this.sqlErrProcBytes = new byte[8];
    }

    public int getNumRowsAffected() {
        return this.numRowsAffected;
    }

    public int getReturnValueForStoredProcedure() {
        return this.returnValueForStoredProcedure;
    }

    public int getResultType() {
        return this.resultType;
    }

    public void continueQuery(BaseWarnings baseWarnings) throws SQLException {
    }

    public void closeQuery(BaseWarnings baseWarnings) throws SQLException {
        try {
            int n;
            int n2;
            this.continuingQuery = false;
            if (!this.isCursorOpen) {
                return;
            }
            int n3 = 1;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                int n4 = n3;
                n3 = (short)(n3 + 1);
                n2 = this.writer.writePacketHeader((short)1, (short)64, n4);
                n = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n);
                this.writer.writePacketLength(n2);
            }
            n2 = 0;
            if (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit) {
                int n5 = n3;
                n3 = (short)(n3 + 1);
                n2 = this.writer.writePacketHeader((short)1, (short)64, n5);
            } else {
                n2 = this.writer.writePacketHeader((short)1, (short)0, n3);
            }
            n = this.writer.writeCodePoint((short)8197);
            if (this.isStoredProcedure) {
                this.writer.writeSP_PKGNAMCSN(this.packageConsistencyToken);
            } else {
                this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            }
            if (this.comm.SQLAMLevel >= 7) {
                this.writer.writeInt16(this.packageConsistencyToken.queryInstanceId.length + 4);
                this.writer.writeInt16(8539);
                this.writer.writeBytes(this.packageConsistencyToken.queryInstanceId);
            }
            this.writer.writeCodePointLength(n);
            this.writer.writePacketLength(n2);
            if (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit) {
                if (this.implConn.isXAImplConn && this.implConn.comm.useBetaXAImplementation) {
                    int n6 = this.writer.writePacketHeader((short)1, (short)0, n3);
                    int n7 = this.writer.writeCodePoint((short)4181);
                    this.writer.writeInt16(5);
                    this.writer.writeInt16(4487);
                    this.writer.writeInt8(3);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6145);
                    this.writer.writeInt32(-1);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6403);
                    this.writer.writeInt32(0x10000000);
                    this.writer.writeCodePointLength(n7);
                    this.writer.writePacketLength(n6);
                } else {
                    int n8 = this.writer.writePacketHeader((short)1, (short)0, n3);
                    int n9 = this.writer.writeCodePoint((short)8206);
                    this.writer.writeCodePointLength(n9);
                    this.writer.writePacketLength(n8);
                }
            }
        }
        catch (Exception exception) {
            try {
                this.writer.empty();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            if (exception instanceof UtilException) {
                throw this.comm.exceptions.getException(exception);
            }
            throw (SQLException)exception;
        }
        this.isCursorOpen = false;
    }

    public final void ensureBytes(int n, BaseWarnings baseWarnings) throws SQLException {
        long l = this.reader.length - this.reader.readPosition;
        boolean bl = false;
        if (!this.reader.interpretAsBigEndian) {
            bl = true;
            this.reader.interpretAsBigEndian = true;
        }
        try {
            if (l < (long)n) {
                if (l != 0L) {
                    this.reader.cacheRemainingBytes();
                }
                this.continueQuery(baseWarnings);
                this.submitRequest();
                this.processReply(baseWarnings);
                if (l != 0L) {
                    this.reader.addBytesToCache((int)((long)n - l));
                    this.reader.setToReadFromByteArray();
                }
            } else {
                if (this.queryDataEndPosition != 0L && n != 0 && this.queryDataEndPosition - (long)this.reader.readPosition < (long)n) {
                    int n2 = (int)(this.queryDataEndPosition - (long)this.reader.readPosition);
                    if (n2 > 0) {
                        this.reader.addBytesToCache(n2);
                        this.processReply(baseWarnings);
                        this.reader.addBytesToCache(n - n2);
                        this.reader.setToReadFromByteArray();
                        return;
                    }
                    if (n2 == 0) {
                        this.processReply(baseWarnings);
                    }
                }
                this.reader.readFromByteArray = false;
            }
        }
        catch (UtilException utilException) {
            if (utilException.getReason() != 1001) {
                if (this.exception == null) {
                    throw this.comm.exceptions.getException(utilException);
                }
                throw this.exception;
            }
            this.resultType = 1;
        }
        if (bl) {
            this.reader.interpretAsBigEndian = false;
        }
    }

    public void submitRequest() throws SQLException {
        try {
            this.reader.empty();
            this.writer.send();
            this.reader.receive();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            try {
                this.writer.empty();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            throw this.comm.exceptions.getException(exception);
        }
    }

    public void submitTimedRequest(int n) throws SQLException {
        block5: {
            try {
                this.reader.empty();
                int n2 = this.reader.getTimeOutValue();
                this.reader.setTimeOutValue(n);
                this.writer.send();
                this.reader.receive();
                this.reader.setTimeOutValue(n2);
            }
            catch (Exception exception) {
                try {
                    this.writer.empty();
                }
                catch (UtilException utilException) {
                    if (utilException.getReason() == 1001) break block5;
                    if (this.exception == null) {
                        throw this.comm.exceptions.getException(utilException);
                    }
                    throw this.exception;
                }
            }
        }
    }

    public void clearExceptions() {
        this.exception = null;
        this.numExceptions = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processReply(BaseWarnings baseWarnings) throws SQLException {
        boolean bl = true;
        try {
            try {
                while (bl) {
                    if (this.reader.length - this.reader.readPosition > 4) {
                        int n = this.reader.readUnsignedInt16();
                        short s = this.reader.readInt16();
                        bl = this.processCodePoint(n -= 4, s, baseWarnings);
                        continue;
                    }
                    bl = false;
                    if (this.checkingForAdditionalUpdateCounts && this.resultType == 3) {
                        this.checkingForAdditionalUpdateCounts = false;
                        continue;
                    }
                    this.resultType = 1;
                }
            }
            catch (UtilException utilException) {
                throw this.comm.exceptions.getException(utilException);
            }
            Object var6_6 = null;
            if (this.exception == null) return;
            throw this.exception;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (this.exception == null) throw throwable;
            throw this.exception;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 53: {
                    int n3 = this.reader.readPosition + n;
                    do {
                        this.reader.readAndDiscardBytes(2);
                        short s = this.reader.readInt16();
                        short s2 = this.reader.readInt16();
                        switch (s) {
                            case 4508: {
                                if (s2 == 0) break;
                                this.comm.TempSingleByteServerTransliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(s2));
                                break;
                            }
                            case 4509: {
                                if (s2 == 0) break;
                                this.comm.TempDoubleByteServerTransliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(s2));
                                break;
                            }
                            case 4510: {
                                if (s2 == 0) break;
                                this.comm.TempMultiByteServerTransliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(s2));
                                break;
                            }
                        }
                        if (this.reader.readPosition >= n3) return true;
                    } while (this.reader.readPosition != 0);
                    return true;
                }
                case 4680: {
                    return true;
                }
                case 6404: {
                    int n4 = this.reader.readInt32();
                    if (n4 == 99) {
                        this.comm.implConn.warnings.add(7111);
                        return true;
                    }
                    if (n4 == 0) return true;
                    String[] stringArray = new String[]{Integer.toString(n4)};
                    throw this.comm.exceptions.getException(7089, stringArray);
                }
                case 8733: {
                    this.reader.readAndDiscardBytes(n);
                    return true;
                }
                case 8741: {
                    String string = null;
                    int n5 = 0;
                    int n6 = this.reader.readPosition + n;
                    do {
                        int n7 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n7 -= 4;
                        switch (s) {
                            case 8515: {
                                byte by = this.reader.readInt8();
                                if (by == 1) {
                                    string = "2D528";
                                    n5 = -426;
                                    break;
                                }
                                string = "2D529";
                                n5 = -426;
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n7);
                            }
                        }
                    } while (this.reader.readPosition < n6 && this.reader.readPosition != 0);
                    this.exception = this.comm.exceptions.getException(n5, null, string, n5);
                    return true;
                }
                case 8723: {
                    this.reader.readAndDiscardBytes(n);
                    return true;
                }
                case 8717: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7064);
                    return true;
                }
                case 9224: {
                    this.processSQLCA(baseWarnings);
                    if (!this.moreData) {
                        this.isCursorOpen = false;
                    }
                    if (this.processMode != 0 || this.numRowsAffected == 0) return true;
                    this.resultType = 3;
                    return this.checkingForAdditionalUpdateCounts;
                }
                case 4425: {
                    this.severityCode = this.reader.readInt16();
                    return true;
                }
                case 4435: {
                    this.serverDiagnostics = this.reader.readString(n);
                    return true;
                }
                case 8464: {
                    this.reader.readAndDiscardBytes(n);
                    return true;
                }
                case 4658: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7001);
                    return true;
                }
                case 4636: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7002);
                    return true;
                }
                case 4692: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7003);
                    return true;
                }
                case 4688: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7004);
                    return true;
                }
                case 4632: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7005);
                    return true;
                }
                case 4624: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7006);
                    return true;
                }
                case 4677: {
                    int n8 = this.reader.readPosition + n;
                    String[] stringArray = new String[1];
                    do {
                        int n9 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n9 -= 4;
                        switch (s) {
                            case 4415: {
                                stringArray[0] = this.drdaUtil.getNameForCPType(this.reader.readInt8());
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n9);
                            }
                        }
                    } while (this.reader.readPosition < n8 && this.reader.readPosition != 0);
                    this.exception = this.comm.exceptions.getException(7007, stringArray);
                    return true;
                }
                case 4689: {
                    int n10 = this.reader.readPosition + n;
                    String[] stringArray = new String[1];
                    do {
                        int n11 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n11 -= 4;
                        switch (s) {
                            case 12: {
                                stringArray[0] = this.drdaUtil.getNameForCPType(this.reader.readInt16());
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n11);
                            }
                        }
                    } while (this.reader.readPosition < n10 && this.reader.readPosition != 0);
                    this.exception = this.comm.exceptions.getException(7008, stringArray);
                    return true;
                }
                case 4659: {
                    int n12 = this.reader.readPosition + n;
                    String[] stringArray = new String[2];
                    do {
                        int n13 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n13 -= 4;
                        switch (s) {
                            case 4397: {
                                stringArray[0] = this.reader.readString(n13);
                                break;
                            }
                            case 4435: {
                                stringArray[1] = this.reader.readString(n13);
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n13);
                            }
                        }
                    } while (this.reader.readPosition < n12 && this.reader.readPosition != 0);
                    this.exception = this.comm.exceptions.getException(7009, stringArray);
                    return true;
                }
                case 4684: {
                    int n14 = this.reader.readPosition + n;
                    String[] stringArray = new String[2];
                    do {
                        int n15 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n15 -= 4;
                        block52 : switch (s) {
                            case 4425: {
                                this.reader.readAndDiscardBytes(n15);
                                break;
                            }
                            case 4426: {
                                byte by = this.reader.readInt8();
                                switch (by) {
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7043, null);
                                        break block52;
                                    }
                                    case 7: 
                                    case 8: 
                                    case 9: 
                                    case 10: 
                                    case 11: {
                                        if (this.comm.isUDBCompatible() && (this.comm.ServerClassName.equalsIgnoreCase("QDB2") || this.comm.ServerClassName.equalsIgnoreCase("QAS"))) {
                                            this.exception = this.comm.exceptions.getException(7085);
                                            break block52;
                                        }
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7044, null);
                                        break block52;
                                    }
                                    case 12: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7045, null);
                                        break block52;
                                    }
                                    case 13: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7046, null);
                                        break block52;
                                    }
                                    case 14: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7047, null);
                                        break block52;
                                    }
                                    case 15: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7048, null);
                                        break block52;
                                    }
                                    case 16: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7049, null);
                                        break block52;
                                    }
                                    case 17: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7050, null);
                                        break block52;
                                    }
                                    case 18: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7051, null);
                                        break block52;
                                    }
                                    case 19: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7052, null);
                                        break block52;
                                    }
                                    case 20: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7053, null);
                                        break block52;
                                    }
                                    case 21: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7054, null);
                                        break block52;
                                    }
                                    case 22: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7055, null);
                                        break block52;
                                    }
                                    case 23: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7056, null);
                                        break block52;
                                    }
                                    case 24: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7057, null);
                                        break block52;
                                    }
                                    case 25: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7058, null);
                                        break block52;
                                    }
                                    case 26: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7059, null);
                                        break block52;
                                    }
                                    case 27: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7060, null);
                                        break block52;
                                    }
                                    case 29: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7061, null);
                                        break block52;
                                    }
                                }
                                stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7062, null);
                                break;
                            }
                            case 12: {
                                stringArray[1] = ", " + Integer.toHexString(this.reader.readInt16());
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n15);
                            }
                        }
                    } while (this.reader.readPosition < n14 && this.reader.readPosition != 0);
                    if (this.exception != null) return true;
                    this.exception = this.comm.exceptions.getException(7010, stringArray, "0800");
                    return true;
                }
                case 4703: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7011);
                    return true;
                }
                case 4690: {
                    int n16 = this.reader.readPosition + n;
                    String[] stringArray = new String[1];
                    do {
                        int n17 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n17 -= 4;
                        switch (s) {
                            case 12: {
                                stringArray[0] = this.drdaUtil.getNameForCPType(this.reader.readInt16());
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n17);
                            }
                        }
                    } while (this.reader.readPosition < n16 && this.reader.readPosition != 0);
                    this.exception = this.comm.exceptions.getException(7012, stringArray);
                    return true;
                }
                case 8721: {
                    this.reader.readAndDiscardBytes(n);
                    String[] stringArray = new String[]{this.implConn.databaseName.toUpperCase()};
                    this.exception = this.comm.exceptions.getException(7015, stringArray, "08000");
                    return true;
                }
                case 8707: {
                    this.reader.readAndDiscardBytes(n);
                    String[] stringArray = new String[]{this.implConn.databaseName.toUpperCase()};
                    this.exception = this.comm.exceptions.getException(7035, stringArray, "08000");
                    return true;
                }
                case 8708: 
                case 8730: {
                    this.reader.readAndDiscardBytes(n);
                    String[] stringArray = new String[]{this.implConn.databaseName.toUpperCase()};
                    this.exception = this.comm.exceptions.getException(7036, stringArray, "08000");
                    return true;
                }
                case 4691: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7034);
                    return true;
                }
                case 8718: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7063);
                    return true;
                }
                case 8714: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7071);
                    return true;
                }
                case 8539: {
                    if (this.packageConsistencyToken.queryInstanceId == null) {
                        this.packageConsistencyToken.queryInstanceId = new byte[n];
                    }
                    this.reader.readBytes(this.packageConsistencyToken.queryInstanceId, 0, n);
                    return true;
                }
                case 4420: 
                case 4683: 
                case 5228: 
                case 8466: 
                case 8467: 
                case 8528: 
                case 8543: 
                case 8728: {
                    this.reader.readAndDiscardBytes(n);
                    return true;
                }
                default: {
                    this.reader.readAndDiscardBytes(n);
                    String[] stringArray = new String[]{this.drdaUtil.getNameForCPType(n2)};
                    if (this.exception != null) {
                        this.exception.setNextException(this.comm.exceptions.getException(7013, stringArray));
                        return false;
                    } else {
                        this.exception = this.comm.exceptions.getException(7013, stringArray);
                    }
                    return false;
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    public void discardReplyBytes() {
        try {
            this.reader.empty();
        }
        catch (UtilException utilException) {}
    }

    public final void processSQLCA(BaseWarnings baseWarnings) throws UtilException {
        try {
            if (this.reader.length - this.reader.readPosition <= 1) {
                this.ensureBytes(1, baseWarnings);
            }
            if (this.reader.readUnsignedInt8() != 255) {
                if (!this.comm.isServerBigEndianOS) {
                    this.reader.interpretAsBigEndian = false;
                }
                this.reader.readFromByteArray = false;
                if (this.reader.length - this.reader.readPosition <= 17) {
                    this.ensureBytes(17, baseWarnings);
                }
                this.sqlCode = this.reader.readInt32();
                this.reader.readBytes(this.sqlStateBytes, 0, 5);
                this.reader.readBytes(this.sqlErrProcBytes, 0, 8);
                this.reader.readFromByteArray = false;
                if (this.reader.length - this.reader.readPosition <= 1) {
                    this.ensureBytes(1, baseWarnings);
                }
                if (this.reader.readUnsignedInt8() != 255) {
                    short s;
                    this.reader.readFromByteArray = false;
                    if (this.comm.SQLAMLevel < 7) {
                        if (this.reader.length - this.reader.readPosition <= 53) {
                            this.ensureBytes(53, baseWarnings);
                        }
                    } else if (this.reader.length - this.reader.readPosition <= 35) {
                        this.ensureBytes(35, baseWarnings);
                    }
                    if (this.comm.SQLAMLevel < 7) {
                        this.reader.readAndDiscardBytes(18);
                    }
                    int n = this.reader.readInt32();
                    this.reader.readAndDiscardBytes(4);
                    int n2 = this.reader.readInt32();
                    this.reader.readAndDiscardBytes(23);
                    this.reader.readFromByteArray = false;
                    if (this.comm.SQLAMLevel >= 7) {
                        this.reader.interpretAsBigEndian = true;
                        if (this.reader.length - this.reader.readPosition <= 2) {
                            this.ensureBytes(2, baseWarnings);
                        }
                        if (this.reader.length - this.reader.readPosition <= (s = this.reader.readInt16())) {
                            this.ensureBytes(s, baseWarnings);
                        }
                        this.reader.readAndDiscardBytes(s);
                        this.reader.readFromByteArray = false;
                    }
                    this.returnValueForStoredProcedure = n;
                    if (n2 >= 0) {
                        this.numRowsAffected = n2;
                        this.resultType = 3;
                        this.checkingForAdditionalUpdateCounts = true;
                    }
                    this.reader.interpretAsBigEndian = true;
                    if (this.reader.length - this.reader.readPosition <= 2) {
                        this.ensureBytes(2, baseWarnings);
                    }
                    if ((s = this.reader.readInt16()) != 0) {
                        this.errParamsTranslit = this.comm.MultiByteServerTransliterator;
                        if (this.reader.length - this.reader.readPosition <= s + 2) {
                            this.ensureBytes(s + 2, baseWarnings);
                        }
                        this.errParamBytes = new byte[s];
                        try {
                            this.reader.readBytes(this.errParamBytes, 0, s);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.reader.readAndDiscardBytes(2);
                    } else {
                        this.errParamsTranslit = this.comm.SingleByteServerTransliterator;
                        if (this.reader.length - this.reader.readPosition <= 2) {
                            this.ensureBytes(2, baseWarnings);
                        }
                        short s2 = this.reader.readInt16();
                        this.ensureBytes(s2, baseWarnings);
                        if (s2 != 0) {
                            this.errParamBytes = new byte[s2];
                            this.reader.readBytes(this.errParamBytes, 0, s2);
                        }
                    }
                }
                if (this.comm.SQLAMLevel >= 7) {
                    if (this.reader.length - this.reader.readPosition <= 1) {
                        this.ensureBytes(1, baseWarnings);
                    }
                    if (this.reader.readUnsignedInt8() != 255 && this.sqlCode >= 0) {
                        this.exception = this.comm.exceptions.getException(7087);
                    }
                }
                if (this.sqlCode > 0) {
                    switch (this.sqlCode) {
                        case 802: {
                            this.exception = this.comm.exceptions.getException(this.sqlCode, this.drdaUtil.readDelimitedStringFromBytes(this.errParamBytes, 18, (short)255, this.errParamsTranslit), this.comm.SingleByteServerTransliterator.decode(this.sqlStateBytes, 0, 5), this.sqlCode);
                            break;
                        }
                        case 100: {
                            if (this.comm.serverType != 9 && !this.implConn.holdCursorsOverCommit) {
                                this.isCursorOpen = false;
                            }
                            this.moreData = false;
                            break;
                        }
                        case 20: {
                            this.hasWarnings = true;
                            baseWarnings.add(this.sqlCode, this.drdaUtil.readDelimitedStringFromBytes(this.errParamBytes, 18, (short)255, this.errParamsTranslit), this.comm.SingleByteServerTransliterator.decode(this.sqlStateBytes, 0, 5), this.sqlCode);
                            break;
                        }
                        default: {
                            this.hasWarnings = true;
                            baseWarnings.add(this.sqlCode, this.comm.SingleByteServerTransliterator.decode(this.sqlStateBytes, 0, 5), this.sqlCode);
                            break;
                        }
                    }
                } else if (this.sqlCode < 0) {
                    String string = this.comm.SingleByteServerTransliterator.decode(this.sqlStateBytes, 0, 5);
                    String[] stringArray = null;
                    try {
                        stringArray = this.drdaUtil.readDelimitedStringFromBytes(this.errParamBytes, 18, (short)255, this.errParamsTranslit);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SQLException sQLException = null;
                    if (string.equalsIgnoreCase("42601")) {
                        if (this.sqlCode == -7 && stringArray[0].equalsIgnoreCase("\n")) {
                            sQLException = this.comm.exceptions.getException(7086, stringArray, string, this.sqlCode);
                        }
                    } else if (string.equalsIgnoreCase("57014")) {
                        if (this.sqlCode == -952) {
                            sQLException = this.comm.exceptions.getException(6078, "HY008");
                        }
                    } else if (string.equalsIgnoreCase("57011")) {
                        if (this.sqlCode == -954) {
                            sQLException = this.comm.exceptions.getException(7105, stringArray, string, this.sqlCode);
                        } else if (this.sqlCode == -964) {
                            sQLException = this.comm.exceptions.getException(7104, stringArray, string, this.sqlCode);
                        }
                    } else if (string.equalsIgnoreCase("55006") && this.sqlCode == -950) {
                        sQLException = this.comm.exceptions.getException(7110, stringArray, string, this.sqlCode);
                    }
                    if (this.sqlCode == -440) {
                        if (stringArray[0].equalsIgnoreCase("procedure")) {
                            stringArray[0] = stringArray[1];
                        }
                        sQLException = this.comm.exceptions.getException(this.sqlCode, stringArray, string, this.sqlCode);
                    } else {
                        sQLException = this.comm.exceptions.getException(this.sqlCode, stringArray, string, this.sqlCode);
                    }
                    if (this.exception == null) {
                        this.exception = sQLException;
                    } else if (sQLException.getErrorCode() != -514 && !sQLException.getSQLState().equalsIgnoreCase("26501") && sQLException.getErrorCode() != -518 && !sQLException.getSQLState().equalsIgnoreCase("07003")) {
                        this.exception.setNextException(sQLException);
                    }
                    ++this.numExceptions;
                }
            }
            this.reader.interpretAsBigEndian = true;
        }
        catch (SQLException sQLException) {
            this.exception = sQLException;
        }
    }
}

