/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDARequest;
import com.metamatrix.jdbc.db2.drda.DRDASyncLog;
import com.metamatrix.jdbcx.db2.DB2Xid;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;
import javax.transaction.xa.XAException;

public class DRDASyncRequestMVS
extends DRDARequest {
    private static String footprint = "$Revision:   3.0.4.0  $";
    public DRDASyncLog serverSyncLog;
    public DRDASyncLog clientSyncLog;
    public boolean populateServerSyncLog = false;

    public DRDASyncRequestMVS(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter) {
        super(dB2ImplConnection, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter);
    }

    public void writeLogInfoRequest() throws XAException {
        try {
            int n = this.writer.writePacketHeader((short)1, (short)0, 1);
            int n2 = this.writer.writeCodePoint((short)4181);
            this.writer.writeInt16(5);
            this.writer.writeInt16(4487);
            this.writer.writeInt8(8);
            this.writer.writeCodePointLength(n2);
            this.writer.writePacketLength(n);
            this.populateServerSyncLog = true;
        }
        catch (Exception exception) {
            throw new XAException(exception.getMessage());
        }
    }

    public void requestNewUOW(byte[] byArray, DB2Xid dB2Xid) throws XAException {
        try {
            int n = this.writer.writePacketHeader((short)1, (short)5, 1);
            int n2 = this.writer.writeCodePoint((short)4181);
            this.writer.writeInt16(5);
            this.writer.writeInt16(4487);
            this.writer.writeInt8(9);
            this.writer.writeInt16(29);
            this.writer.writeInt16(4522);
            this.writer.writeBytes(byArray);
            this.writer.writeInt16(5);
            this.writer.writeInt16(6146);
            this.writer.writeInt8(1);
            this.writer.writeInt16(dB2Xid.formattedLen + 4);
            this.writer.writeInt16(6145);
            this.writer.writeBytes(dB2Xid.formatted);
            this.writer.writeCodePointLength(n2);
            this.writer.writePacketLength(n);
        }
        catch (Exception exception) {
            throw new XAException(exception.getMessage());
        }
    }

    public void prepareToCommit(DRDASyncLog dRDASyncLog) throws XAException {
        try {
            int n = this.writer.writePacketHeader((short)1, (short)80, 1);
            int n2 = this.writer.writeCodePoint((short)4181);
            this.writer.writeInt16(5);
            this.writer.writeInt16(4487);
            this.writer.writeInt8(1);
            this.writer.writeCodePointLength(n2);
            this.writer.writePacketLength(n);
            int n3 = this.writer.writePacketHeader((short)3, (short)0, 1);
            int n4 = this.writer.writeCodePoint((short)4207);
            this.writeSyncLog(dRDASyncLog);
            this.writer.writeCodePointLength(n3);
            this.writer.writePacketLength(n4);
        }
        catch (UtilException utilException) {
            throw new XAException(utilException.getMessage());
        }
    }

    public void commitUOW(boolean bl) throws XAException {
        try {
            if (bl) {
                int n = this.writer.writePacketHeader((short)1, (short)80, 1);
                int n2 = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(2);
                this.writer.writeCodePointLength(n2);
                this.writer.writePacketLength(n);
                int n3 = this.writer.writePacketHeader((short)1, (short)0, 2);
                int n4 = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(5);
                this.writer.writeCodePointLength(n4);
                this.writer.writePacketLength(n3);
            } else {
                int n = this.writer.writePacketHeader((short)1, (short)0, 1);
                int n5 = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(3);
                this.writer.writeCodePointLength(n5);
                this.writer.writePacketLength(n);
            }
        }
        catch (UtilException utilException) {
            throw new XAException(utilException.getMessage());
        }
    }

    public void rollBackUOW() throws XAException {
        try {
            int n = this.writer.writePacketHeader((short)1, (short)5, 1);
            int n2 = this.writer.writeCodePoint((short)4181);
            this.writer.writeInt16(5);
            this.writer.writeInt16(4487);
            this.writer.writeInt8(4);
            this.writer.writeCodePointLength(n2);
            this.writer.writePacketLength(n);
        }
        catch (UtilException utilException) {
            throw new XAException(utilException.getMessage());
        }
    }

    public void recover() throws XAException {
        throw new XAException("Recover not yet supported");
    }

    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 4207: {
                    if (this.populateServerSyncLog) {
                        this.serverSyncLog = new DRDASyncLog(this.implConn);
                        break;
                    }
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 8464: {
                    if (this.populateServerSyncLog) {
                        DRDASyncLog.RDBNAM = this.reader.readString(n);
                        break;
                    }
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 4573: {
                    if (this.populateServerSyncLog) {
                        DRDASyncLog.TCPHOST = this.reader.readString(n);
                        break;
                    }
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 4484: {
                    if (this.populateServerSyncLog) {
                        byte[] byArray = new byte[n];
                        this.reader.readBytes(byArray, 0, n);
                        DRDASyncLog.LOGNAME = byArray;
                        break;
                    }
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 4485: {
                    if (this.populateServerSyncLog) {
                        byte[] byArray = new byte[n];
                        this.reader.readBytes(byArray, 0, n);
                        DRDASyncLog.LOGTSTMP = byArray;
                        break;
                    }
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 4208: {
                    if (this.populateServerSyncLog) {
                        byte[] byArray = new byte[n];
                        this.reader.readBytes(byArray, 0, n);
                        DRDASyncLog.CNNTKN = byArray;
                        break;
                    }
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 4584: {
                    if (this.populateServerSyncLog) {
                        byte[] byArray = new byte[n];
                        this.reader.readBytes(byArray, 0, n);
                        DRDASyncLog.IPADDR = byArray;
                        break;
                    }
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 4680: {
                    break;
                }
                default: {
                    return super.processCodePoint(n, n2, baseWarnings);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
        return true;
    }

    public void writeSyncLog(DRDASyncLog dRDASyncLog) throws UtilException {
        this.writer.writeInt16(22);
        this.writer.writeInt16(8464);
        this.writer.writeString(DRDASyncLog.RDBNAM);
        this.writer.writeInt16(22);
        this.writer.writeInt16(4484);
        this.writer.writeBytes(DRDASyncLog.LOGNAME);
        this.writer.writeInt16(22);
        this.writer.writeInt16(4485);
        this.writer.writeBytes(DRDASyncLog.LOGTSTMP);
        this.writer.writeInt16(8);
        this.writer.writeInt16(4208);
        this.writer.writeBytes(DRDASyncLog.CNNTKN);
        this.writer.writeInt16(10);
        this.writer.writeInt16(4584);
        this.writer.writeBytes(DRDASyncLog.IPADDR);
        int n = this.writer.writeCodePoint((short)4573);
        this.writer.writeString(DRDASyncLog.TCPHOST);
        this.writer.writeCodePointLength(n);
    }
}

