/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.oracle.OracleImplStatement;
import com.metamatrix.jdbc.oracle.OracleInternalParameter;
import com.metamatrix.jdbc.oracle.OracleInternalParameterSet;
import com.metamatrix.jdbc.oracle.OracleVNU;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTDAPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OALL8;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OLOBOPS;
import com.metamatrix.jdbc.oracle.net8.TTIOERDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIRXDDataPacket;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class OracleImplClob
extends BaseImplClob {
    private static String footprint = "$Revision:   3.54.1.1  $";
    static final int MULTI_CHAR_BYTE = 6;
    public byte[] cloblocator;
    public int ClobcharSetForm;
    public int ClobcharSet;
    private long cachedCurrentLength;
    private boolean cachedCurrentLengthIsCorrect;
    private OracleImplStatement implstmt;
    private OracleInternalParameterSet paramSet;
    boolean useIntArrayEncoding;

    public OracleImplClob(byte[] byArray, OracleImplStatement oracleImplStatement, int n) {
        super(oracleImplStatement.comm.exceptions);
        this.ClobcharSetForm = 0;
        this.ClobcharSet = 0;
        this.cachedCurrentLength = 0L;
        this.cachedCurrentLengthIsCorrect = false;
        this.paramSet = null;
        this.implstmt = oracleImplStatement;
        this.cachedCurrentLengthIsCorrect = false;
        this.ClobcharSet = n;
        this.cloblocator = byArray;
        this.useIntArrayEncoding = (this.cloblocator[6] & 0xFFFFFF80) != 0;
    }

    /*
     * Unable to fully structure code
     */
    public OracleImplClob(OracleImplStatement var1_1, BaseParameter var2_2, int var3_3, boolean var4_4, String var5_5, byte[] var6_6) throws SQLException {
        block8: {
            block7: {
                super(var1_1.comm.exceptions);
                this.ClobcharSetForm = 0;
                this.ClobcharSet = 0;
                this.cachedCurrentLength = 0L;
                this.cachedCurrentLengthIsCorrect = false;
                this.paramSet = null;
                this.implstmt = var1_1;
                var7_7 = this.implstmt.implConn.NSPTDAPacket;
                this.ClobcharSet = var3_3;
                this.cloblocator = new byte[86];
                this.cloblocator[1] = 84;
                var8_8 = new TTIFUN_OLOBOPS(272, this.implstmt.implConn);
                var8_8.SourceLobLocator = this.cloblocator;
                var8_8.SourceOffset = var4_4 != false ? 2 : 1;
                var8_8.DestinationOffset = 112;
                var8_8.DestinationLength = 10;
                var8_8.brequestLobamt = true;
                var8_8.LobAmt = 10L;
                var8_8.brequestIfnull = true;
                var8_8.CharSet = (short)var3_3;
                var7_7.appendTTISubPacket(var8_8);
                var7_7.sendRequest();
                var7_7.receiveReply();
                var9_9 = new TTIOERDataPacket(this.implstmt.implConn);
                this.implstmt.implConn.processReply(var8_8, var9_9);
                if (var9_9.retCode != 0) {
                    var10_10 = new String[]{var9_9.errMsg};
                    var11_12 = this.implstmt.comm.exceptions.getException(6001, var10_10, var9_9.getSQLState(), (int)var9_9.retCode);
                    throw var11_12;
                }
                this.cloblocator = var8_8.SourceLobLocator;
                var10_11 = 1;
                v0 = this.useIntArrayEncoding = (this.cloblocator[6] & -128) != 0;
                if (var5_5 != null) break block7;
                var12_14 = var2_2.getType();
                if (var12_14 == 18) ** GOTO lbl-1000
                if (var12_14 == 10) ** GOTO lbl-1000
                if (var12_14 == 15) ** GOTO lbl-1000
                if (var12_14 == 2) ** GOTO lbl-1000
                if (var12_14 == 14) ** GOTO lbl-1000
                if (var12_14 == 17) ** GOTO lbl-1000
                if (var12_14 == 20) lbl-1000:
                // 7 sources

                {
                    var11_13 = var2_2.getCharacterStreamReader(-1, (BaseConnection)this.implstmt.implConn.connection, this.implstmt.comm.exceptions);
                } else {
                    var11_13 = new StringReader(var2_2.getString(-1, this.implstmt.comm.exceptions));
                }
                var13_15 = new char[(int)this.getMaxChunkSize()];
                var14_16 = 0;
                try {
                    while ((var14_16 = var11_13.read(var13_15)) > 0) {
                        this.mywriteData(var10_11, new String(var13_15, 0, var14_16), var14_16, null);
                        var10_11 += var14_16;
                    }
                }
                catch (IOException var15_17) {
                    var16_18 = this.implstmt.comm.exceptions.getException((Exception)var15_17);
                    throw var16_18;
                }
                this.cachedCurrentLengthIsCorrect = true;
                this.cachedCurrentLength = var10_11 - 1;
                break block8;
            }
            if (var5_5.length() != 0) {
                this.mywriteData(var10_11, var5_5, var5_5.length(), var6_6);
                this.cachedCurrentLength = var10_11 - 1;
                this.cachedCurrentLengthIsCorrect = true;
            }
        }
    }

    public long getMaxChunkSize() {
        return 32512L;
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(String string, long l) throws SQLException {
        byte[] byArray;
        int n = (int)l;
        int n2 = string.length();
        try {
            byArray = this.ClobcharSet == 2000 ? string.getBytes("UTF-16BE") : this.implstmt.implConn.NSPTDAPacket.writer.getTransliterator().encode(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw this.implstmt.comm.exceptions.getException((Exception)((Object)new UtilException(1009)));
        }
        catch (UtilException utilException) {
            throw this.implstmt.comm.exceptions.getException((Exception)((Object)utilException));
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this.implstmt.implConn);
        tTIFUN_OALL8.setOptions(1065);
        tTIFUN_OALL8.setCommandText("begin :rslt := dbms_lob.instr(:lctr,:ptrn,:offset,:occ); end;");
        tTIFUN_OALL8.setCursorID(this.implstmt.implConn.getCursorID());
        if (this.paramSet == null) {
            this.paramSet = new OracleInternalParameterSet();
        } else {
            this.paramSet.reset();
        }
        int n3 = 0;
        OracleInternalParameter oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(6, 0, 0, 16, 0, 0, this.implstmt.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(112, 0, 0, 86, 0, 0, this.implstmt.comm.transliterator);
        oracleInternalParameter.m_nativeDataIn = this.cloblocator;
        oracleInternalParameter.m_nativeDataInLength = this.cloblocator.length;
        oracleInternalParameter.m_direction = 32;
        int n4 = byArray.length > 4096 ? 4096 : byArray.length;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, n4, 0, 0, this.implstmt.comm.transliterator);
        oracleInternalParameter.m_nativeDataIn = byArray;
        oracleInternalParameter.m_nativeDataInLength = n4;
        oracleInternalParameter.m_direction = 32;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(6, 0, 0, 16, 0, 0, this.implstmt.comm.transliterator);
        byte[] byArray2 = new byte[22];
        n3 = OracleVNU.convertIntToVNU(byArray2, n);
        oracleInternalParameter.m_nativeDataIn = byArray2;
        oracleInternalParameter.m_nativeDataInLength = n3;
        oracleInternalParameter.m_direction = 32;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(6, 0, 0, 16, 0, 0, this.implstmt.comm.transliterator);
        byte[] byArray3 = new byte[22];
        n3 = OracleVNU.convertIntToVNU(byArray3, 1);
        oracleInternalParameter.m_nativeDataIn = byArray3;
        oracleInternalParameter.m_nativeDataInLength = n3;
        oracleInternalParameter.m_direction = 32;
        tTIFUN_OALL8.setParameters(this.paramSet);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(this.implstmt.implConn, false);
        tTIRXDDataPacket.setParameters(this.paramSet);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIRXDDataPacket);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(null, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        oracleNet8NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
        oracleInternalParameter = this.paramSet.paramSet[0];
        long l2 = OracleVNU.convertVNUToLong(oracleInternalParameter.m_nativeDataOut, oracleInternalParameter.m_nativeDataOutLength, this.implstmt.comm.exceptions);
        return l2 == 0L ? -1L : l2;
    }

    public long getLength() throws SQLException {
        if (this.cachedCurrentLengthIsCorrect) {
            return this.cachedCurrentLength;
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(1, this.cloblocator, this.implstmt.implConn);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.cachedCurrentLength = tTIFUN_OLOBOPS.LobAmt;
        this.cachedCurrentLengthIsCorrect = true;
        return this.cachedCurrentLength;
    }

    public void close() throws SQLException {
    }

    public int getCharacterEncoding() {
        if (this.ClobcharSet == 31) {
            return 1;
        }
        return 2;
    }

    public int readData(byte[] byArray, int n, long l, int n2) throws SQLException {
        int n3;
        block22: {
            String[] stringArray;
            OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
            TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(2, this.cloblocator, this.implstmt.implConn);
            tTIFUN_OLOBOPS.SourceLobLocator = this.cloblocator;
            tTIFUN_OLOBOPS.brequestLobamt = true;
            tTIFUN_OLOBOPS.LobAmt = n2;
            tTIFUN_OLOBOPS.SourceOffset = (int)l;
            oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
            oracleNet8NSPTDAPacket.sendRequest();
            oracleNet8NSPTDAPacket.receiveReply();
            TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
            int n4 = oracleNet8NSPTDAPacket.getNextTTCCode();
            if (tTIOERDataPacket.retCode != 0) {
                String[] stringArray2 = new String[]{tTIOERDataPacket.errMsg};
                SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray2, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
                throw sQLException;
            }
            byte[] byArray2 = null;
            n3 = 0;
            if (n4 == 14) {
                stringArray = new TTIRXDDataPacket(this.implstmt.implConn, false);
                oracleNet8NSPTDAPacket.getNextNextTTISubpacket((TTIDataPacket)stringArray);
                stringArray.setBaseExceptions(this.exceptions);
                byArray2 = stringArray.readRXDDataWithoutIndicator(n2, this.exceptions);
                n3 = byArray2.length;
            }
            this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
            if (tTIOERDataPacket.retCode != 0) {
                stringArray = new String[]{tTIOERDataPacket.errMsg};
                SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
                throw sQLException;
            }
            if (n3 <= 0) break block22;
            if (this.useIntArrayEncoding) {
                if (this.implstmt.implConn.oracleServerVersion != 801070000L && this.implstmt.implConn.oracleServerVersion != 801060000L) {
                    int n5 = 0;
                    int n6 = 0;
                    while (n5 < byArray2.length) {
                        switch (byArray2[n5++]) {
                            case 0: {
                                byArray[n + n6++] = 0;
                                byArray[n + n6++] = 0;
                                break;
                            }
                            case 1: {
                                byArray[n + n6++] = 0;
                                byArray[n + n6++] = byArray2[n5++];
                                break;
                            }
                            case 2: {
                                byArray[n + n6++] = byArray2[n5++];
                                byArray[n + n6++] = byArray2[n5++];
                            }
                        }
                    }
                    return n6;
                }
                if (this.implstmt.implConn.byteOrder == 256) {
                    int n7 = 0;
                    int n8 = n;
                    while (n7 + 1 < byArray2.length) {
                        byArray[n8] = byArray2[n7 + 1];
                        byArray[n8 + 1] = byArray2[n7];
                        n7 += 2;
                        n8 += 2;
                    }
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, n3);
                }
            } else if (this.ClobcharSet == 2000) {
                System.arraycopy(byArray2, 0, byArray, n, n3);
            } else if (this.ClobcharSet == 31) {
                System.arraycopy(byArray2, 0, byArray, n, n3);
            } else {
                stringArray = this.implstmt.implConn.comm.getReader().getTransliterator();
                try {
                    if (stringArray.supportByteArrayToByteArrayDecode) {
                        n3 = stringArray.decode(byArray2, 0, n3, byArray, n);
                    }
                    String string = stringArray.decode(byArray2, 0, n3);
                    byte[] byArray3 = string.getBytes("UTF-16BE");
                    System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
                    n3 = byArray3.length;
                }
                catch (Exception exception) {
                    throw this.implstmt.comm.exceptions.getException(exception);
                }
            }
        }
        return n3;
    }

    public void truncate(long l) throws SQLException {
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(32, this.cloblocator, this.implstmt.implConn);
        tTIFUN_OLOBOPS.brequestLobamt = true;
        tTIFUN_OLOBOPS.LobAmt = (int)l;
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.cachedCurrentLengthIsCorrect = false;
    }

    public int mywriteData(long l, String string, int n, byte[] byArray) throws SQLException {
        byte[] byArray2;
        block13: {
            int n2 = (int)l;
            byArray2 = null;
            try {
                if (this.useIntArrayEncoding) {
                    if (this.implstmt.implConn.oracleServerVersion != 801070000L && this.implstmt.implConn.oracleServerVersion != 801060000L) {
                        byArray2 = new byte[n * 3];
                        int n3 = 0;
                        for (int i = 0; i < n; ++i) {
                            byArray2[n3++] = 2;
                            byArray2[n3++] = (byte)(string.charAt(i) >> 8 & 0xFF);
                            byArray2[n3++] = (byte)(string.charAt(i) & 0xFF);
                        }
                        n2 = (int)((l - 1L) * 3L) + 1;
                    } else {
                        byArray2 = this.implstmt.implConn.byteOrder == 256 ? string.getBytes("UTF-16LE") : string.getBytes("UTF-16BE");
                        n2 = (int)((l - 1L) * 2L) + 1;
                    }
                    break block13;
                }
                if (this.ClobcharSet == 2000) {
                    byArray2 = string.getBytes("UTF-16BE");
                    n2 = (int)((l - 1L) * 2L) + 1;
                    break block13;
                }
                if (byArray == null) {
                    UtilTransliterator utilTransliterator = this.implstmt.implConn.comm.getReader().getTransliterator();
                    try {
                        byArray2 = utilTransliterator.encode(string);
                        break block13;
                    }
                    catch (UtilException utilException) {
                        throw this.implstmt.comm.exceptions.getException((Exception)((Object)utilException));
                    }
                }
                byArray2 = byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw this.implstmt.comm.exceptions.getException((Exception)((Object)new UtilException(1009)));
            }
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(64, this.cloblocator, this.implstmt.implConn);
        tTIFUN_OLOBOPS.SourceLobLocator = this.cloblocator;
        tTIFUN_OLOBOPS.brequestLobamt = true;
        tTIFUN_OLOBOPS.LobAmt = n;
        tTIFUN_OLOBOPS.SourceOffset = (int)l;
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        if (this.paramSet == null) {
            this.paramSet = new OracleInternalParameterSet();
        } else {
            this.paramSet.reset();
        }
        OracleInternalParameter oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(23, 0, 0, 0, 0, 0, this.implstmt.comm.transliterator);
        oracleInternalParameter.m_nativeDataIn = byArray2;
        oracleInternalParameter.m_nativeDataInLength = byArray2.length;
        oracleInternalParameter.m_direction = 32;
        TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(14, this.implstmt.implConn, false);
        tTIRXDDataPacket.setParameters(this.paramSet);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIRXDDataPacket);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.cloblocator = tTIFUN_OLOBOPS.SourceLobLocator;
        this.cachedCurrentLengthIsCorrect = false;
        return (int)tTIFUN_OLOBOPS.LobAmt;
    }

    public int writeData(long l, byte[] byArray, int n, int n2) throws SQLException {
        int n3 = (int)l;
        String string = "";
        try {
            string = new String(byArray, n, BaseImplClob.getBytesPerChar((BaseImplClob)this) * n2, OracleImplClob.getEncodingName((int)this.getCharacterEncoding()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.mywriteData(l, string, n2, null);
    }
}

