/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

public class CertID {
    BigInteger a;
    AlgorithmID d;
    byte[] c;
    byte[] b;

    public String toString() {
        return "hashAlgorithm: " + this.d + "\n" + "issuerNameHash: " + Util.toString(this.b) + "\n" + "issuerKeyHash: " + Util.toString(this.c) + "\n" + "serialNumber: " + this.a;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.d.toASN1Object());
        sEQUENCE.addComponent(new OCTET_STRING(this.b));
        sEQUENCE.addComponent(new OCTET_STRING(this.c));
        sEQUENCE.addComponent(new INTEGER(this.a));
        return sEQUENCE;
    }

    public boolean isCertIDFor(Name name, PublicKey publicKey, BigInteger bigInteger) throws NoSuchAlgorithmException {
        return this.equals(new CertID((AlgorithmID)this.d.clone(), name, publicKey, bigInteger));
    }

    public int hashCode() {
        return this.d.hashCode() + Util.calculateHashCode(this.b) + Util.calculateHashCode(this.c) + this.a.hashCode();
    }

    public BigInteger getSerialNumber() {
        return this.a;
    }

    public byte[] getIssuerNameHash() {
        return this.b;
    }

    public byte[] getIssuerKeyHash() {
        return this.c;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CertID)) {
            return false;
        }
        CertID certID = (CertID)object;
        return this.d.equals(certID.d) && CryptoUtils.equalsBlock(this.b, certID.b) && CryptoUtils.equalsBlock(this.c, certID.c) && this.a.equals(certID.a);
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        this.d = new AlgorithmID(aSN1Object.getComponentAt(0));
        if (this.d == null) {
            throw new CodingException("Cannot create CertID. Missing hash algorithm!");
        }
        this.b = (byte[])aSN1Object.getComponentAt(1).getValue();
        if (this.b == null) {
            throw new CodingException("Cannot create CertID. Missing issuerNameHash!");
        }
        this.c = (byte[])aSN1Object.getComponentAt(2).getValue();
        if (this.c == null) {
            throw new CodingException("Cannot create CertID. Missing issuerKeyHash!");
        }
        this.a = (BigInteger)aSN1Object.getComponentAt(3).getValue();
        if (this.a == null) {
            throw new CodingException("Cannot create CertID. Missing serialNumber!");
        }
    }

    public static byte[] calculateIssuerNameHash(Name name, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = algorithmID.getMessageDigestInstance();
        messageDigest.update(name.getEncoded());
        return messageDigest.digest();
    }

    public static byte[] calculateIssuerKeyHash(PublicKey publicKey, AlgorithmID algorithmID) throws CodingException, NoSuchAlgorithmException {
        byte[] byArray = publicKey.getEncoded();
        ASN1Object aSN1Object = DerCoder.decode(byArray);
        BIT_STRING bIT_STRING = (BIT_STRING)aSN1Object.getComponentAt(1);
        MessageDigest messageDigest = algorithmID.getMessageDigestInstance();
        messageDigest.update((byte[])bIT_STRING.getValue());
        return messageDigest.digest();
    }

    public CertID(AlgorithmID algorithmID, byte[] byArray, byte[] byArray2, BigInteger bigInteger) {
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing hash algorithm!");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerNameHash!");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerKeyHash!");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing serialNumber!");
        }
        this.d = algorithmID;
        this.b = byArray;
        this.c = byArray2;
        this.a = bigInteger;
    }

    public CertID(AlgorithmID algorithmID, X509Certificate x509Certificate, BigInteger bigInteger) throws NoSuchAlgorithmException {
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing hash algorithm!");
        }
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerCert!");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing serialNumber!");
        }
        try {
            this.d = algorithmID;
            this.b = CertID.calculateIssuerNameHash((Name)x509Certificate.getSubjectDN(), algorithmID);
            this.c = CertID.calculateIssuerKeyHash(x509Certificate.getPublicKey(), algorithmID);
            this.a = bigInteger;
            return;
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Cannot create CertID. Invalid key encoding format: " + codingException.getMessage());
        }
    }

    public CertID(AlgorithmID algorithmID, X509Certificate x509Certificate, X509Certificate x509Certificate2) throws NoSuchAlgorithmException {
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing hash algorithm!");
        }
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerCert!");
        }
        if (x509Certificate2 == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing targetCert!");
        }
        try {
            this.d = algorithmID;
            this.b = CertID.calculateIssuerNameHash((Name)x509Certificate.getSubjectDN(), algorithmID);
            this.c = CertID.calculateIssuerKeyHash(x509Certificate.getPublicKey(), algorithmID);
            this.a = x509Certificate2.getSerialNumber();
            return;
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Cannot create CertID. Invalid key encoding format: " + codingException.getMessage());
        }
    }

    public CertID(AlgorithmID algorithmID, Name name, PublicKey publicKey, BigInteger bigInteger) throws NoSuchAlgorithmException {
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing hash algorithm!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerName!");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerKey!");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing serialNumber!");
        }
        try {
            this.d = algorithmID;
            this.b = CertID.calculateIssuerNameHash(name, algorithmID);
            this.c = CertID.calculateIssuerKeyHash(publicKey, algorithmID);
            this.a = bigInteger;
            return;
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Cannot create CertID. Invalid key encoding format: " + codingException.getMessage());
        }
    }

    public CertID(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }
}

