/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilSnoopIndirection;
import com.metamatrix.util.UtilTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Socket;
import java.sql.SQLException;

public class DRDAByteOrderedDataWriter {
    private static String footprint = "$Revision:   3.15.2.0  $";
    private Socket socket;
    private OutputStream socketOutputStream;
    private byte[] requestBuffer;
    public int currentBufferInsertPosition;
    byte[] databaseName;
    byte[] collectionId;
    byte[] packageName;
    byte[] consistencyToken;
    boolean translated = false;
    String lastPackageName;
    private int numBytesPlacedInBuffer;
    private int bufferSizeIncrement;
    public static final int END_OF_BUFFER = Integer.MAX_VALUE;
    public DRDACommunication comm;
    private boolean encodeInBigEndian;
    protected UtilTransliterator transliterator;
    protected byte[] staticByteArray;
    private int[] returnedLength;
    private UtilTempBuffer tempBuffer;
    private int _lenBytes;

    public DRDAByteOrderedDataWriter(DRDACommunication dRDACommunication, UtilTransliterator utilTransliterator) {
        this.comm = dRDACommunication;
        this.transliterator = utilTransliterator;
        this.socket = this.comm.getSocket();
        this.encodeInBigEndian = true;
        this.staticByteArray = new byte[256];
        this.returnedLength = new int[1];
        this.currentBufferInsertPosition = 0;
        this.numBytesPlacedInBuffer = 0;
        this.bufferSizeIncrement = 4096;
        this.requestBuffer = new byte[this.bufferSizeIncrement];
        try {
            this.socketOutputStream = this.socket.getOutputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void empty() throws UtilException {
        this.currentBufferInsertPosition = 0;
        this.numBytesPlacedInBuffer = 0;
    }

    public void close() throws UtilException {
        this.currentBufferInsertPosition = 0;
        this.numBytesPlacedInBuffer = 0;
        if (this.tempBuffer != null) {
            this.tempBuffer.truncate(true);
        }
    }

    public void setToBigEndian() {
        this.encodeInBigEndian = true;
    }

    public void setToLittleEndian() {
        this.encodeInBigEndian = false;
    }

    public boolean isInBigEndian() {
        return this.encodeInBigEndian;
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }

    public final int writePacketHeader(short s, short s2, int n) throws UtilException {
        int n2 = this.currentBufferInsertPosition;
        if (this.comm.socketDebugging) {
            UtilSnoopIndirection.addTextToSendStream((Socket)this.comm.getSocket(), (int)n2, (String)"Start of Packet", (boolean)true);
        }
        this.writeFillerBytes((byte)0, 2);
        this.writeInt8(208);
        this.writeInt8(s | s2);
        this.writeInt16(n);
        return n2;
    }

    public final void writeNewPacketHeaderWithLen(int n, short s, short s2, int n2) throws UtilException {
        int n3 = this.currentBufferInsertPosition;
        this.currentBufferInsertPosition = n;
        this.writeInt16(n3 - n);
        this.writeInt8(208);
        this.writeInt8(s | s2);
        this.writeInt16(n2);
        this.currentBufferInsertPosition = n3;
    }

    public final void writePacketLength(int n) throws UtilException {
        int n2 = this.currentBufferInsertPosition;
        this.currentBufferInsertPosition = n;
        int n3 = n2 - n;
        if (n3 > Short.MAX_VALUE) {
            int n4 = n2 - n;
            this.writeInt16(65535);
            n += Short.MAX_VALUE;
            while (n < n2) {
                this.shiftRight(n, 2);
                this.currentBufferInsertPosition = n;
                n4 = (n2 += 2) - n;
                n3 = n4 > 32765 ? 65535 : n4;
                this.writeInt16(n3);
                n += Short.MAX_VALUE;
            }
        } else {
            this.writeInt16(n3);
        }
        this.currentBufferInsertPosition = n2;
    }

    public final int writeCodePoint(short s) throws UtilException {
        int n = this.currentBufferInsertPosition;
        if (this.numBytesPlacedInBuffer + 2 > this.requestBuffer.length) {
            this.writeFillerBytes((byte)0, 2);
        } else {
            this.currentBufferInsertPosition += 2;
            if (this.currentBufferInsertPosition > this.numBytesPlacedInBuffer) {
                this.numBytesPlacedInBuffer = this.currentBufferInsertPosition;
            }
        }
        this.writeInt16(s);
        return n;
    }

    public final void writeCodePointLength(int n) throws UtilException {
        int n2 = this.currentBufferInsertPosition;
        this.currentBufferInsertPosition = n;
        int n3 = n2 - n;
        if (n3 > Short.MAX_VALUE) {
            this.writeInt16(32776);
            this.currentBufferInsertPosition += 2;
            this.shiftRight(this.currentBufferInsertPosition, 4);
            this.writeInt32(n3 - 4);
            n2 += 4;
        } else {
            this.writeInt16(n2 - n);
        }
        this.currentBufferInsertPosition = n2;
    }

    public final void checkPKGBuffers(DRDAPkgNamCsn dRDAPkgNamCsn) throws UtilException {
        if (!this.translated) {
            this.databaseName = new byte[18];
            this.collectionId = new byte[18];
            this.packageName = new byte[18];
            this.consistencyToken = new byte[8];
            this.writeFixedLengthEncodedStringInBuffer(dRDAPkgNamCsn.databaseName, this.databaseName, this.comm.defaultCCSIDTransliterator, (byte)64);
            this.writeFixedLengthEncodedStringInBuffer(dRDAPkgNamCsn.collectionId, this.collectionId, this.comm.defaultCCSIDTransliterator, (byte)64);
            this.writeFixedLengthEncodedStringInBuffer(dRDAPkgNamCsn.packageName, this.packageName, this.comm.defaultCCSIDTransliterator, (byte)64);
            this.writeFixedLengthEncodedStringInBuffer(dRDAPkgNamCsn.consistencyToken, this.consistencyToken, this.comm.transliteratorPool.getTransliteratorForCodePage("1252"), (byte)64);
            this.lastPackageName = dRDAPkgNamCsn.packageName;
            this.translated = true;
        } else if (!this.lastPackageName.equals(dRDAPkgNamCsn.packageName)) {
            this.writeFixedLengthEncodedStringInBuffer(dRDAPkgNamCsn.packageName, this.packageName, this.comm.defaultCCSIDTransliterator, (byte)64);
            this.lastPackageName = dRDAPkgNamCsn.packageName;
        }
    }

    public final void writePKGNAMCSN(DRDAPkgNamCsn dRDAPkgNamCsn) throws UtilException {
        int n = this.writeCodePoint((short)8467);
        if (!this.translated || !this.lastPackageName.equals(dRDAPkgNamCsn.packageName)) {
            this.checkPKGBuffers(dRDAPkgNamCsn);
        }
        this.writeBytes(this.databaseName);
        this.writeBytes(this.collectionId);
        this.writeBytes(this.packageName);
        this.writeBytes(this.consistencyToken);
        this.writeInt16(dRDAPkgNamCsn.sectionNumber);
        this.writeCodePointLength(n);
    }

    public final void writeSP_PKGNAMCSN(DRDAPkgNamCsn dRDAPkgNamCsn) throws UtilException {
        int n = this.writeCodePoint((short)8467);
        this.writeFixedLengthEncodedString(dRDAPkgNamCsn.databaseName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        this.writeFixedLengthEncodedString(dRDAPkgNamCsn.collectionId, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        this.writeFixedLengthEncodedString(dRDAPkgNamCsn.packageName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        this.writeFixedLengthEncodedString(dRDAPkgNamCsn.consistencyToken, this.comm.transliteratorPool.getTransliteratorForCodePage("1252"), 8, (byte)64);
        this.writeInt16(dRDAPkgNamCsn.sectionNumber);
        this.writeCodePointLength(n);
    }

    public final void writePKGNAMCT(DRDAPkgNamCsn dRDAPkgNamCsn) throws UtilException {
        int n = this.writeCodePoint((short)8466);
        this.checkPKGBuffers(dRDAPkgNamCsn);
        this.writeBytes(this.databaseName);
        this.writeBytes(this.collectionId);
        this.writeBytes(this.packageName);
        this.writeBytes(this.consistencyToken);
        this.writeCodePointLength(n);
    }

    public final void writePKGNAM(DRDAPkgNamCsn dRDAPkgNamCsn) throws UtilException {
        int n = this.writeCodePoint((short)8458);
        this.checkPKGBuffers(dRDAPkgNamCsn);
        this.writeBytes(this.databaseName);
        this.writeBytes(this.collectionId);
        this.writeBytes(this.packageName);
        this.writeCodePointLength(n);
    }

    public int writeInt8(int n) throws UtilException {
        this.putByte((byte)n);
        return 1;
    }

    public int writeInt16(int n) throws UtilException {
        if (this.encodeInBigEndian) {
            this.putByte((byte)(n >>> 8));
            this.putByte((byte)n);
        } else {
            this.putByte((byte)n);
            this.putByte((byte)(n >>> 8));
        }
        return 2;
    }

    public int writeInt32(int n) throws UtilException {
        if (this.encodeInBigEndian) {
            this.putByte((byte)(n >>> 24));
            this.putByte((byte)(n >>> 16));
            this.putByte((byte)(n >>> 8));
            this.putByte((byte)n);
        } else {
            this.putByte((byte)n);
            this.putByte((byte)(n >>> 8));
            this.putByte((byte)(n >>> 16));
            this.putByte((byte)(n >>> 24));
        }
        return 4;
    }

    public int writeIEEE32BitFloat(float f) throws UtilException {
        this.writeInt32(Float.floatToIntBits(f));
        return 4;
    }

    public int writeInt64(long l) throws UtilException {
        if (this.encodeInBigEndian) {
            this.putByte((byte)(l >>> 56));
            this.putByte((byte)(l >>> 48));
            this.putByte((byte)(l >>> 40));
            this.putByte((byte)(l >>> 32));
            this.putByte((byte)(l >>> 24));
            this.putByte((byte)(l >>> 16));
            this.putByte((byte)(l >>> 8));
            this.putByte((byte)l);
        } else {
            this.putByte((byte)l);
            this.putByte((byte)(l >>> 8));
            this.putByte((byte)(l >>> 16));
            this.putByte((byte)(l >>> 24));
            this.putByte((byte)(l >>> 32));
            this.putByte((byte)(l >>> 40));
            this.putByte((byte)(l >>> 48));
            this.putByte((byte)(l >>> 56));
        }
        return 8;
    }

    public int writeIEEE64BitDouble(double d) throws UtilException {
        this.writeInt64(Double.doubleToLongBits(d));
        return 8;
    }

    public int writeString(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.putArrayOfBytes(byArray, 0, n);
        return n;
    }

    public int writeSensitiveString(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        if (this.comm.socketDebugging) {
            UtilSnoopIndirection.doNotLogBytesInSendStream((Socket)this.comm.getSocket(), (int)this.currentBufferInsertPosition, (int)byArray.length, (String)"(Sensitive Info Omitted Here)");
        }
        int n = this.returnedLength[0];
        this.putArrayOfBytes(byArray, 0, n);
        return n;
    }

    public int writeStringWithLength16(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.writeInt16(n);
        this.putArrayOfBytes(byArray, 0, n);
        return n + 2;
    }

    public int writeStringWithLength32(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.writeInt32(n);
        this.putArrayOfBytes(byArray, 0, n);
        return n + 4;
    }

    public int writeBytes(byte[] byArray) throws UtilException {
        if (byArray == null) {
            return 0;
        }
        this.putArrayOfBytes(byArray, 0, byArray.length);
        return byArray.length;
    }

    public int writeBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (byArray == null || n2 <= 0) {
            return 0;
        }
        this.putArrayOfBytes(byArray, n, n2);
        return n2;
    }

    public OutputStream getOutputStream(int n) throws UtilException {
        this._lenBytes = n;
        return new OutputStream(){
            private int totalLen;
            private int writtenSoFar;
            {
                this.totalLen = DRDAByteOrderedDataWriter.this._lenBytes;
            }

            public void write(int n) throws IOException {
                if (this.writtenSoFar >= this.totalLen) {
                    throw new IOException();
                }
                try {
                    DRDAByteOrderedDataWriter.this.writeInt8(n);
                    ++this.writtenSoFar;
                }
                catch (UtilException utilException) {
                    throw new IOException();
                }
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                int n3 = this.totalLen - this.writtenSoFar;
                try {
                    if (n2 > n3) {
                        DRDAByteOrderedDataWriter.this.writeBytes(byArray, n, n3);
                        this.writtenSoFar = this.totalLen;
                        throw new IOException();
                    }
                    DRDAByteOrderedDataWriter.this.writeBytes(byArray, n, n2);
                    this.writtenSoFar += n2;
                }
                catch (UtilException utilException) {
                    throw new IOException();
                }
            }
        };
    }

    public int writeStream(InputStream inputStream, int n) throws UtilException {
        try {
            int n2;
            for (int i = n; i > 0; i -= n2) {
                int n3 = Math.min(i, this.staticByteArray.length);
                n2 = inputStream.read(this.staticByteArray, 0, n3);
                if (n2 == -1) {
                    throw new UtilException(1002);
                }
                this.putArrayOfBytes(this.staticByteArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1000, iOException.toString());
        }
        return n;
    }

    public int writeStreamWithLength16(InputStream inputStream, int n) throws UtilException {
        this.writeInt16(n);
        try {
            int n2;
            for (int i = n; i > 0; i -= n2) {
                int n3 = Math.min(i, this.staticByteArray.length);
                n2 = inputStream.read(this.staticByteArray, 0, n3);
                if (n2 == -1) {
                    throw new UtilException(1002);
                }
                this.putArrayOfBytes(this.staticByteArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1000, iOException.toString());
        }
        return n + 2;
    }

    public int writeStreamWithLength32(InputStream inputStream, int n) throws UtilException {
        this.writeInt32(n);
        try {
            int n2;
            for (int i = n; i > 0; i -= n2) {
                int n3 = Math.min(i, this.staticByteArray.length);
                n2 = inputStream.read(this.staticByteArray, 0, n3);
                if (n2 == -1) {
                    throw new UtilException(1002);
                }
                this.putArrayOfBytes(this.staticByteArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1000, iOException.toString());
        }
        return n + 4;
    }

    public int writeFillerBytes(byte by, int n) throws UtilException {
        int n2;
        int n3 = n > this.staticByteArray.length ? this.staticByteArray.length : n;
        for (n2 = 0; n2 < n3; ++n2) {
            this.staticByteArray[n2] = by;
        }
        for (n2 = n; n2 > 0; n2 -= n3) {
            n3 = Math.min(n2, this.staticByteArray.length);
            this.putArrayOfBytes(this.staticByteArray, 0, n3);
        }
        return n;
    }

    public int writeEncodedString(String string, UtilTransliterator utilTransliterator) throws UtilException {
        if (string == null) {
            return 0;
        }
        UtilTransliterator utilTransliterator2 = this.getTransliterator();
        this.setTransliterator(utilTransliterator);
        int n = this.writeString(string);
        this.setTransliterator(utilTransliterator2);
        return n;
    }

    public int writeEncodedStringWithLength16(String string, UtilTransliterator utilTransliterator) throws UtilException {
        if (string == null) {
            return 0;
        }
        UtilTransliterator utilTransliterator2 = this.getTransliterator();
        this.setTransliterator(utilTransliterator);
        int n = this.writeStringWithLength16(string);
        this.setTransliterator(utilTransliterator2);
        return n;
    }

    public int writeEncodedStringWithLength32(String string, UtilTransliterator utilTransliterator) throws UtilException {
        if (string == null) {
            return 0;
        }
        UtilTransliterator utilTransliterator2 = this.getTransliterator();
        this.setTransliterator(utilTransliterator);
        int n = this.writeStringWithLength32(string);
        this.setTransliterator(utilTransliterator2);
        return n;
    }

    public void writeFixedLengthEncodedString(String string, UtilTransliterator utilTransliterator, int n, byte by) throws UtilException {
        UtilTransliterator utilTransliterator2 = this.getTransliterator();
        this.setTransliterator(utilTransliterator);
        if (string == null) {
            this.writeFillerBytes(by, n);
        } else {
            byte[] byArray = this.transliterator.encode(string, this.returnedLength);
            int n2 = this.returnedLength[0];
            if (n2 < n) {
                this.putArrayOfBytes(byArray, 0, n2);
                this.writeFillerBytes(by, n - n2);
            } else if (n2 == n) {
                this.putArrayOfBytes(byArray, 0, n2);
            } else {
                this.putArrayOfBytes(byArray, 0, n);
            }
        }
        this.setTransliterator(utilTransliterator2);
    }

    public void writeFixedLengthEncodedStringInBuffer(String string, byte[] byArray, UtilTransliterator utilTransliterator, byte by) throws UtilException {
        if (string == null) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = by;
            }
        } else {
            byte[] byArray2 = utilTransliterator.encode(string, this.returnedLength);
            int n = this.returnedLength[0];
            if (n < byArray.length) {
                System.arraycopy(byArray2, 0, byArray, 0, n);
                for (int i = n; i < byArray.length; ++i) {
                    byArray[i] = by;
                }
            } else if (n == byArray.length) {
                System.arraycopy(byArray2, 0, byArray, 0, n);
            } else {
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
            }
        }
    }

    public UtilTransliterator getTransliterator() {
        return this.transliterator;
    }

    public int writeReaderWithLength16(Reader reader, int n) throws UtilException {
        if (!this.transliterator.isFixedBytesPerChar()) {
            if (this.tempBuffer == null) {
                this.tempBuffer = new UtilPagedTempBuffer();
            }
            this.transliterator.encode(reader, n, this.tempBuffer.getOutputStream());
            int n2 = this.writeStreamWithLength16(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
            this.tempBuffer.truncate();
            return n2;
        }
        int n3 = n * this.transliterator.getMaxBytesPerChar();
        this.writeInt16(n3);
        this.transliterator.encode(reader, n, this.getOutputStream(n3));
        return n3 + 2;
    }

    public int writeReader(Reader reader, int n) throws UtilException {
        if (!this.transliterator.isFixedBytesPerChar()) {
            if (this.tempBuffer == null) {
                this.tempBuffer = new UtilPagedTempBuffer();
            }
            this.transliterator.encode(reader, n, this.tempBuffer.getOutputStream());
            int n2 = this.writeStream(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
            this.tempBuffer.truncate();
            return n2;
        }
        int n3 = n * this.transliterator.getMaxBytesPerChar();
        this.transliterator.encode(reader, n, this.getOutputStream(n3));
        return n3;
    }

    private void shiftRight(int n, int n2) {
        int n3;
        if (this.numBytesPlacedInBuffer + n2 > this.requestBuffer.length) {
            this.assureBufferSpace(n2);
        }
        for (n3 = this.numBytesPlacedInBuffer - 1; n3 >= n; --n3) {
            this.requestBuffer[n3 + n2] = this.requestBuffer[n3];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            this.requestBuffer[n + n3] = 0;
        }
        this.numBytesPlacedInBuffer += n2;
    }

    private void assureBufferSpace(int n) {
        int n2;
        int n3 = n2 = this.requestBuffer == null ? 0 : this.requestBuffer.length;
        if (this.currentBufferInsertPosition + n <= n2) {
            return;
        }
        int n4 = n2 + n / this.bufferSizeIncrement * this.bufferSizeIncrement + (n % this.bufferSizeIncrement == 0 ? 0 : this.bufferSizeIncrement);
        byte[] byArray = new byte[n4];
        this.bufferSizeIncrement *= 2;
        if (this.requestBuffer != null && this.numBytesPlacedInBuffer != 0) {
            System.arraycopy(this.requestBuffer, 0, byArray, 0, this.numBytesPlacedInBuffer);
        }
        this.requestBuffer = byArray;
    }

    public void putByte(byte by) throws UtilException {
        if (this.numBytesPlacedInBuffer + 1 > this.requestBuffer.length) {
            this.assureBufferSpace(1);
        }
        this.requestBuffer[this.currentBufferInsertPosition++] = by;
        if (this.currentBufferInsertPosition >= this.numBytesPlacedInBuffer) {
            this.numBytesPlacedInBuffer = this.currentBufferInsertPosition;
        }
    }

    public void putArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 <= 0) {
            return;
        }
        if (this.numBytesPlacedInBuffer + n2 > this.requestBuffer.length) {
            this.assureBufferSpace(n2);
        }
        System.arraycopy(byArray, n, this.requestBuffer, this.currentBufferInsertPosition, n2);
        this.currentBufferInsertPosition += n2;
        if (this.currentBufferInsertPosition > this.numBytesPlacedInBuffer) {
            this.numBytesPlacedInBuffer = this.currentBufferInsertPosition;
        }
    }

    public void send() throws UtilException, SQLException {
        try {
            if (this.comm.implConn.cancelPending) {
                this.comm.implConn.socketActivityPostCancel();
            }
            this.socketOutputStream.write(this.requestBuffer, 0, this.numBytesPlacedInBuffer);
            this.socketOutputStream.flush();
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new SQLException("SOCKETTIMEOUT");
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
        this.currentBufferInsertPosition = 0;
        this.numBytesPlacedInBuffer = 0;
    }
}

