/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix;

import com.metamatrix.jdbc.base.BaseCallEscape;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseFunctionEscape;
import com.metamatrix.jdbc.base.BaseJoinEscape;
import com.metamatrix.jdbc.base.BaseTimestampEscape;
import com.metamatrix.jdbc.informix.InformixImplConnection;
import com.metamatrix.jdbc.informix.InformixImplDatabaseMetaData;
import java.util.ArrayList;

public class InformixEscapeTranslator
extends BaseEscapeTranslator {
    private static String footprint = "$Revision:   3.9.1.0  $";
    InformixImplDatabaseMetaData databaseMetaData;
    InformixImplConnection implConnection;

    InformixEscapeTranslator(InformixImplConnection informixImplConnection, InformixImplDatabaseMetaData informixImplDatabaseMetaData) {
        this.implConnection = informixImplConnection;
        this.databaseMetaData = informixImplDatabaseMetaData;
    }

    public int getTranslationNeeded(int n) {
        switch (n) {
            case 8194: {
                if (this.implConnection.dbDate != null) {
                    return 2;
                }
            }
            case 8193: 
            case 8212: {
                return 1;
            }
            case 8208: {
                if (this.implConnection.versionNumber < 9020) break;
                return 1;
            }
        }
        return 2;
    }

    public String translateCallEscape(BaseCallEscape baseCallEscape) {
        return "execute procedure " + baseCallEscape.getProcedureName() + "(" + baseCallEscape.getAllParameters() + ")";
    }

    public String translateFunctionEscape(BaseFunctionEscape baseFunctionEscape) {
        String string = baseFunctionEscape.getFunctionText();
        switch (baseFunctionEscape.getFunctionType()) {
            case 11: {
                string = baseFunctionEscape.getParameter(1) + "||" + baseFunctionEscape.getParameter(2);
                break;
            }
            case 35: {
                break;
            }
            case 34: {
                string = baseFunctionEscape.getParameter(1) + "[1," + baseFunctionEscape.getParameter(2) + "]";
                break;
            }
            case 39: {
                string = "trim(leading from " + baseFunctionEscape.getParameter(1) + ")";
                break;
            }
            case 53: {
                break;
            }
            case 56: {
                string = "trim(trailing from " + baseFunctionEscape.getParameter(1) + ")";
                break;
            }
            case 63: {
                string = "substr(" + baseFunctionEscape.getParameter(1) + "," + baseFunctionEscape.getParameter(2) + "," + baseFunctionEscape.getParameter(3) + ")";
                break;
            }
            case 2: 
            case 8: 
            case 26: 
            case 32: 
            case 33: 
            case 36: 
            case 52: 
            case 54: 
            case 60: 
            case 61: 
            case 68: {
                return null;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 27: 
            case 38: 
            case 41: 
            case 55: 
            case 59: 
            case 62: 
            case 64: {
                break;
            }
            case 14: {
                string = "(1/tan(" + baseFunctionEscape.getAllParameters() + "))";
                break;
            }
            case 29: {
                string = "trunc(" + baseFunctionEscape.getParameter(1) + ",0)";
                break;
            }
            case 37: {
                string = "logn(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 48: {
                string = "pow(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 67: {
                string = "trunc(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 46: {
                string = "3.14159";
                break;
            }
            case 7: 
            case 50: 
            case 51: 
            case 58: {
                return null;
            }
            case 15: {
                string = "today";
                break;
            }
            case 19: {
                string = "current hour to second";
                break;
            }
            case 22: {
                string = "day(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 23: {
                string = "(weekday(" + baseFunctionEscape.getAllParameters() + ")+1)";
                break;
            }
            case 42: 
            case 71: {
                break;
            }
            case 44: {
                string = "current";
                break;
            }
            case 65: {
                String string2 = baseFunctionEscape.getParameter(1).toString().substring(8);
                if (!string2.equals("DAY") && !string2.equals("MONTH") && !string2.equals("YEAR")) break;
                string = "(date(" + baseFunctionEscape.getParameter(3) + ") + " + baseFunctionEscape.getParameter(2) + " units " + string2.toLowerCase() + ")";
                break;
            }
            case 66: {
                String string3 = baseFunctionEscape.getParameter(1).toString().substring(8);
                int n = 0;
                if (string3.equals("DAY")) {
                    n = 1;
                } else if (string3.equals("MONTH")) {
                    n = 30;
                } else {
                    if (!string3.equals("YEAR")) break;
                    n = 365;
                }
                string = "trunc((date(" + baseFunctionEscape.getParameter(3) + ")-date(" + baseFunctionEscape.getParameter(2) + "))/" + n + ")";
                break;
            }
            case 21: 
            case 24: 
            case 30: 
            case 40: 
            case 43: 
            case 49: 
            case 57: 
            case 70: {
                break;
            }
            case 20: {
                string = "'" + this.databaseMetaData.databaseName + "'";
                break;
            }
            case 69: {
                string = "user";
                break;
            }
            case 31: {
                break;
            }
        }
        return string + " ";
    }

    public String translateTimestampEscape(BaseTimestampEscape baseTimestampEscape) {
        if (baseTimestampEscape.getEscapeType() == 8194) {
            return this.implConnection.formatDate(null, baseTimestampEscape);
        }
        String string = baseTimestampEscape.getTimestamp();
        if (string != null) {
            String string2 = "1900-01-01 00:00:00.00000";
            int n = string.length();
            if (n == 19) {
                return "DATETIME (" + string + ") YEAR TO SECOND";
            }
            string = n < 25 ? string + string2.substring(n) : string.substring(0, 25);
            return "DATETIME (" + string + ") YEAR TO FRACTION(5)";
        }
        return string;
    }

    public String translateJoinEscapeFromClause(BaseJoinEscape baseJoinEscape) {
        boolean bl;
        ArrayList arrayList = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        while (bl = baseJoinEscape.moveToNextTableReference()) {
            int n = baseJoinEscape.getCurrentJoinOperator();
            String string = baseJoinEscape.getCurrentTableName();
            String string2 = baseJoinEscape.getCurrentCorrelationName();
            if (string2 != null) {
                string = string + " " + string2;
            }
            if (stringBuffer.length() == 0) {
                stringBuffer.append(string);
                continue;
            }
            if (n == 1035) {
                stringBuffer.append(", outer(");
                stringBuffer.append(string);
                stringBuffer.append(')');
                continue;
            }
            stringBuffer.insert(0, ", outer(");
            stringBuffer.insert(0, string);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public void insertOuterJoinOperator(StringBuffer stringBuffer, int n) {
    }
}

