/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.aspects.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.MappingClassColumn;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.metamodels.transformation.impl.MappingClassImpl;
import com.metamatrix.metamodels.xml.ChoiceOption;
import com.metamatrix.metamodels.xml.XmlAttribute;
import com.metamatrix.metamodels.xml.XmlChoice;
import com.metamatrix.metamodels.xml.XmlContainerHolder;
import com.metamatrix.metamodels.xml.XmlContainerNode;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.metamodels.xml.XmlDocumentEntity;
import com.metamatrix.metamodels.xml.XmlDocumentNode;
import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.XmlValueHolder;
import com.metamatrix.metamodels.xml.util.XmlDocumentUtil;
import com.metamatrix.metamodels.xsd.XsdUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.index.TargetLocationIndexSelector;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import com.metamatrix.modeler.internal.mapping.factory.DefaultMappableTree;
import com.metamatrix.modeler.internal.mapping.factory.TreeMappingAdapter;
import com.metamatrix.modeler.internal.xml.aspects.sql.XmlElementSqlAspect;
import com.metamatrix.modeler.mapping.factory.IMappableTree;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.metadata.QueryMetadataContext;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFactory;
import com.metamatrix.modeler.xml.PluginConstants;
import com.metamatrix.query.c.h;
import com.metamatrix.query.d.b;
import com.metamatrix.query.f.c.d;
import com.metamatrix.query.f.c.i;
import com.metamatrix.query.f.c.j;
import com.metamatrix.query.m.e;
import com.metamatrix.query.o.h.k;
import com.metamatrix.query.o.i.a;
import com.metamatrix.query.o.i.f;
import com.metamatrix.query.o.j.ap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;

public class XmlDocumentValidationRule
implements ObjectValidationRule {
    private static String RULE_NAME = (class$com$metamatrix$modeler$transformation$aspects$validation$rules$XmlDocumentValidationRule == null ? (class$com$metamatrix$modeler$transformation$aspects$validation$rules$XmlDocumentValidationRule = XmlDocumentValidationRule.class$("com.metamatrix.modeler.transformation.aspects.validation.rules.XmlDocumentValidationRule")) : class$com$metamatrix$modeler$transformation$aspects$validation$rules$XmlDocumentValidationRule).getName();
    private Map elementColumnMap = null;
    private Map elementMappingClassMap = null;
    private Preferences preferences;
    static /* synthetic */ Class class$com$metamatrix$modeler$transformation$aspects$validation$rules$XmlDocumentValidationRule;
    static /* synthetic */ Class class$com$metamatrix$metamodels$transformation$TreeMappingRoot;
    static /* synthetic */ Class class$com$metamatrix$metamodels$xml$XmlDocumentEntity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void validate(EObject eObject, ValidationContext context) {
        ArgCheck.isInstanceOf((Class)(class$com$metamatrix$metamodels$transformation$TreeMappingRoot == null ? (class$com$metamatrix$metamodels$transformation$TreeMappingRoot = XmlDocumentValidationRule.class$("com.metamatrix.metamodels.transformation.TreeMappingRoot")) : class$com$metamatrix$metamodels$transformation$TreeMappingRoot), (Object)eObject);
        TreeMappingRoot transRoot = (TreeMappingRoot)eObject;
        EObject target = transRoot.getTarget();
        if (target == null || !(target instanceof XmlDocument)) {
            return;
        }
        ValidationResultImpl validationResult = new ValidationResultImpl((Object)transRoot, (Object)target);
        XmlDocument document = (XmlDocument)target;
        TreeMappingAdapter mappingAdapter = new TreeMappingAdapter((EObject)document);
        DefaultMappableTree mappableTree = new DefaultMappableTree((EObject)document);
        Resource documentResource = document.eResource();
        this.preferences = context.getPreferences();
        if (context.hasRunRule(document.getObjectId().toString(), RULE_NAME)) {
            return;
        }
        context.recordRuleRun(document.getObjectId().toString(), RULE_NAME);
        ModelContents mdlContents = new ModelContents(documentResource);
        Iterator contentIter = mdlContents.getTransformations((EObject)document).iterator();
        if (!contentIter.hasNext()) {
            return;
        }
        try {
            this.elementColumnMap = new HashMap();
            this.elementMappingClassMap = new HashMap();
            while (contentIter.hasNext()) {
                MappingRoot mappingRoot = (MappingRoot)contentIter.next();
                if (mappingRoot == null || !(mappingRoot instanceof TreeMappingRoot)) continue;
                EList inputClasses = mappingRoot.getInputs();
                EList outputRootElements = mappingRoot.getOutputs();
                if (!outputRootElements.isEmpty() && !inputClasses.isEmpty()) {
                    Object input = inputClasses.iterator().next();
                    Iterator outputIter = outputRootElements.iterator();
                    while (outputIter.hasNext()) {
                        this.elementMappingClassMap.put(outputIter.next(), input);
                    }
                }
                Iterator mappingIter = mappingRoot.getNested().iterator();
                while (mappingIter.hasNext()) {
                    Mapping nestedMapping = (Mapping)mappingIter.next();
                    EList inputColumns = nestedMapping.getInputs();
                    EList outputElements = nestedMapping.getOutputs();
                    if (outputElements.isEmpty() || inputColumns.isEmpty()) continue;
                    Object input = inputColumns.iterator().next();
                    Iterator outputIter = outputElements.iterator();
                    while (outputIter.hasNext()) {
                        this.elementColumnMap.put(outputIter.next(), input);
                    }
                }
            }
            DocumentVisitor visitor = new DocumentVisitor();
            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
            try {
                processor.walk((EObject)document, 2);
            }
            catch (ModelerCoreException e2) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("XmlDocumentValidationRule.Error_trying_to_collect_XmlElements_in_an_XmlDocument__1") + e2.getMessage());
                validationResult.addProblem((ValidationProblem)problem);
                Object var22_22 = null;
                this.elementColumnMap = null;
                this.preferences = null;
                this.elementMappingClassMap = null;
                return;
            }
            ArrayList entities = new ArrayList();
            entities.addAll(visitor.getElements());
            entities.addAll(visitor.getAttributes());
            this.validateEntities(entities, (ValidationResult)validationResult, context);
            this.validateMappingClassRecursionAllowed((ValidationResult)validationResult, context);
            this.validateChoiceEntities(visitor.getChoices(), mappingAdapter, (IMappableTree)mappableTree, (ValidationResult)validationResult, context);
            if (!this.isLogicalModel(eObject)) {
                this.validateColumnToElementTypes((ValidationResult)validationResult, context);
            }
            context.addResult((ValidationResult)validationResult);
            Object var22_23 = null;
            this.elementColumnMap = null;
            this.preferences = null;
            this.elementMappingClassMap = null;
        }
        catch (Throwable throwable) {
            Object var22_24 = null;
            this.elementColumnMap = null;
            this.preferences = null;
            this.elementMappingClassMap = null;
            throw throwable;
        }
    }

    private boolean isLogicalModel(EObject eObject) {
        EmfResource eResource;
        ArgCheck.isNotNull((Object)eObject);
        Resource r2 = eObject.eResource();
        return r2 instanceof EmfResource && (eResource = (EmfResource)r2).getModelType() == ModelType.LOGICAL_LITERAL;
    }

    private void validateColumnToElementTypes(ValidationResult validationResult, ValidationContext context) {
        Iterator mappingIter = this.elementColumnMap.entrySet().iterator();
        while (mappingIter.hasNext()) {
            MappingClassColumn column;
            EObject columnType;
            Map.Entry entry = mappingIter.next();
            if (!(entry.getKey() instanceof XmlDocumentNode)) continue;
            XmlDocumentNode element = (XmlDocumentNode)entry.getKey();
            XSDTypeDefinition xsdType = XmlDocumentUtil.findXSDType((Object)element);
            DatatypeManager dtm = ModelerCore.getDatatypeManager((EObject)xsdType, (boolean)true);
            if (xsdType == null || !(xsdType instanceof XSDSimpleTypeDefinition) || this.isStringType((EObject)xsdType, dtm) || (columnType = (column = (MappingClassColumn)entry.getValue()).getType()) == null || !(columnType instanceof XSDSimpleTypeDefinition) || this.isStringType(columnType, dtm) || columnType == xsdType || !this.isAtomicLiteral((XSDSimpleTypeDefinition)xsdType) || !this.isAtomicLiteral((XSDSimpleTypeDefinition)columnType)) continue;
            List xsdTypeList = this.createHierarcyList((EObject)xsdType, dtm);
            List columnTypeList = this.createHierarcyList(columnType, dtm);
            if (columnTypeList.size() > 0 && xsdTypeList.size() > 0) {
                boolean compatible = false;
                boolean nonAtomicAncestor = false;
                for (int i2 = 1; i2 < xsdTypeList.size(); ++i2) {
                    XSDSimpleTypeDefinition std = (XSDSimpleTypeDefinition)xsdTypeList.get(i2);
                    if (!this.isAtomicLiteral(std)) {
                        nonAtomicAncestor = true;
                        break;
                    }
                    int index = columnTypeList.indexOf(std);
                    if (index == -1) continue;
                    if (index != 0) {
                        String msg = TransformationPlugin.Util.getString("XmlDocumentValidationRule.Column_and_element_types_possibly_not_compatible", new Object[]{column.getName(), dtm.getName(columnType), element.getName(), dtm.getName((EObject)xsdType)});
                        ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg, XmlDocumentValidationRule.getLocationPath((EObject)column), XmlDocumentValidationRule.getURIString((EObject)column));
                        validationResult.addProblem((ValidationProblem)problem);
                    }
                    compatible = true;
                    break;
                }
                if (compatible || nonAtomicAncestor) continue;
            }
            int status = context.getPreferenceStatus("xmlPreferences.incompatibleElementColumnDatatypes", 2);
            String msg = TransformationPlugin.Util.getString("XmlDocumentValidationRule.Column_and_element_types_not_compatible", new Object[]{column.getName(), dtm.getName(columnType), element.getName(), dtm.getName((EObject)xsdType)});
            ValidationProblemImpl problem = new ValidationProblemImpl(0, status, msg, XmlDocumentValidationRule.getLocationPath((EObject)column), XmlDocumentValidationRule.getURIString((EObject)column));
            validationResult.addProblem((ValidationProblem)problem);
        }
    }

    private boolean isStringType(EObject xsdType, DatatypeManager dtm) {
        EObject object = null;
        try {
            object = dtm.getDatatypeForXsdType(xsdType);
        }
        catch (ModelerCoreException err) {
            PluginConstants.Util.log((Throwable)err);
        }
        return object != null && dtm.isBuiltInDatatype(object) && "string".equals(dtm.getName(object));
    }

    private boolean isAtomicLiteral(XSDSimpleTypeDefinition type) {
        return type.getVariety() == XSDVariety.ATOMIC_LITERAL;
    }

    private List createHierarcyList(EObject type, DatatypeManager dtm) {
        EObject[] hierarchy = dtm.getTypeHierarchy(type);
        if (hierarchy.length < 2) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.addAll(Arrays.asList(hierarchy));
        result.remove(result.size() - 1);
        return result;
    }

    private boolean validateMappingClassRecursionAllowed(ValidationResult validationResult, ValidationContext context) {
        Iterator iter = this.elementMappingClassMap.entrySet().iterator();
        while (iter.hasNext()) {
            MappingClassImpl mc;
            Map.Entry entry = iter.next();
            EObject xmlNode = (EObject)entry.getKey();
            EObject mapping = (EObject)entry.getValue();
            if (!(mapping instanceof MappingClassImpl) || !(xmlNode instanceof XmlContainerNode) || !(mc = (MappingClassImpl)mapping).isRecursionAllowed() || !mc.isRecursive()) continue;
            String msg = TransformationPlugin.Util.getString("XmlDocumentValidationRule.Recursion_not_allowed_on_compositor");
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg, XmlDocumentValidationRule.getLocationPath(xmlNode), XmlDocumentValidationRule.getURIString(xmlNode));
            validationResult.addProblem((ValidationProblem)problem);
            return false;
        }
        return true;
    }

    private static String getURIString(EObject eoj) {
        return ModelerCore.getModelEditor().getUri(eoj).toString();
    }

    private static String getLocationPath(EObject eoj) {
        return ModelerCore.getModelEditor().getModelRelativePath(eoj).toString();
    }

    private boolean validateChoiceEntities(Collection choices, TreeMappingAdapter mappingAdapter, IMappableTree mappableTree, ValidationResult validationResult, ValidationContext context) {
        EmfResource emfResource;
        boolean isLogicalXMLModel = false;
        if (choices != null && choices.size() > 0 && (emfResource = (EmfResource)((EObject)choices.iterator().next()).eResource()).getModelAnnotation() != null) {
            ModelType type = emfResource.getModelAnnotation().getModelType();
            String stringURI = emfResource.getModelAnnotation().getPrimaryMetamodelUri();
            if (type.equals(ModelType.LOGICAL_LITERAL) && "http://www.metamatrix.com/metamodels/XmlDocument".equals(stringURI)) {
                isLogicalXMLModel = true;
            }
        }
        Iterator choiceIter = choices.iterator();
        while (choiceIter.hasNext()) {
            XmlChoice xmlChoice = (XmlChoice)choiceIter.next();
            ChoiceOption defaultOption = xmlChoice.getDefaultOption();
            DocumentVisitor visitor = new DocumentVisitor();
            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
            try {
                processor.walk((EObject)xmlChoice, 1);
            }
            catch (ModelerCoreException e2) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("XmlDocumentValidationRule.Error_trying_to_collect_XmlElements_in_an_XmlDocument__2") + e2.getMessage(), XmlDocumentValidationRule.getLocationPath((EObject)xmlChoice), XmlDocumentValidationRule.getURIString((EObject)xmlChoice));
                validationResult.addProblem((ValidationProblem)problem);
                return false;
            }
            if (isLogicalXMLModel) continue;
            Collection choiceContents = visitor.getEntities();
            Iterator choiceCntIter = choiceContents.iterator();
            while (choiceCntIter.hasNext()) {
                XmlDocumentNode documentNode;
                Object choiceEntity = choiceCntIter.next();
                if (choiceEntity.equals(xmlChoice) || !(choiceEntity instanceof ChoiceOption)) continue;
                ChoiceOption option = (ChoiceOption)choiceEntity;
                if (choiceEntity instanceof XmlDocumentNode && (documentNode = (XmlDocumentNode)choiceEntity).isExcludeFromDocument()) continue;
                String choiceCriteria = option.getChoiceCriteria();
                if (StringUtil.isEmpty((String)choiceCriteria)) {
                    if (ModelerCore.getModelEditor().equals((EObject)option, (EObject)defaultOption)) continue;
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_option_of_a_Choice_must_either_have_the_criteria_defined,_or_be_the_default._3"), XmlDocumentValidationRule.getLocationPath((EObject)option), XmlDocumentValidationRule.getURIString((EObject)option));
                    validationResult.addProblem((ValidationProblem)problem);
                    return false;
                }
                if (this.validateCriteria(option, xmlChoice, mappingAdapter, mappableTree, validationResult, context)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateEntities(Collection entities, ValidationResult validationResult, ValidationContext context) {
        EmfResource emfResource;
        boolean isLogicalXMLModel = false;
        if (entities != null && entities.size() > 0 && (emfResource = (EmfResource)((EObject)entities.iterator().next()).eResource()).getModelAnnotation() != null) {
            ModelType type = emfResource.getModelAnnotation().getModelType();
            String stringURI = emfResource.getModelAnnotation().getPrimaryMetamodelUri();
            if (type.equals(ModelType.LOGICAL_LITERAL) && "http://www.metamatrix.com/metamodels/XmlDocument".equals(stringURI)) {
                isLogicalXMLModel = true;
            }
        }
        Iterator entIter = entities.iterator();
        while (entIter.hasNext()) {
            int status;
            int maxOccurs;
            XSDComponent xsdComponent;
            Object entity = entIter.next();
            if (entity instanceof XmlDocument || !(entity instanceof XmlDocumentNode)) continue;
            XmlDocumentNode node = (XmlDocumentNode)entity;
            this.validateSchemaComponent(node, validationResult, context);
            if (!this.isElementOrAttribute(node)) continue;
            boolean isProcMapping = false;
            SqlAspect aspect = AspectManager.getSqlAspect((EObject)node);
            if (aspect != null && aspect instanceof XmlElementSqlAspect) {
                isProcMapping = ((XmlElementSqlAspect)aspect).isTranformationInputParameter((EObject)node);
            }
            int minOccurs = (xsdComponent = node.getXsdComponent()) != null ? XsdUtil.getMinOccurs((XSDComponent)xsdComponent) : -1;
            int n2 = maxOccurs = xsdComponent != null ? XsdUtil.getMaxOccurs((XSDComponent)xsdComponent) : -1;
            if (this.hasMappedMappingClassColumn(node)) {
                ValidationProblemImpl problem;
                int status2;
                XmlValueHolder valueHolder = (XmlValueHolder)node;
                if (valueHolder.isValueFixed() || valueHolder.isValueDefault()) {
                    status2 = context.getPreferenceStatus("xmlPreferences.fixedDefaultElementMapped", 2);
                    if (!isProcMapping && status2 != 0) {
                        problem = new ValidationProblemImpl(0, status2, TransformationPlugin.Util.getString("XmlDocumentValidationRule.This_entity_{0}_is_fixed_or_default_and_should_not_have_a_mapping_attribute_defined_in_MappingClasses_1", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                        problem.setHasPreference(this.preferences != null);
                        validationResult.addProblem((ValidationProblem)problem);
                        if (status2 == 4) {
                            return false;
                        }
                    }
                }
                if (node.isExcludeFromDocument()) {
                    status2 = context.getPreferenceStatus("xmlPreferences.excludeElementMapped", 2);
                    if (!isProcMapping && status2 != 0) {
                        problem = new ValidationProblemImpl(0, status2, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_entity_{0}_has_been_selected_to_be_excluded_from_the_Document,_but_has_a_mapping_attribute_defined_in_MappingClasses_2", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                        problem.setHasPreference(this.preferences != null);
                        validationResult.addProblem((ValidationProblem)problem);
                        if (status2 == 4) {
                            return false;
                        }
                    }
                }
                if (minOccurs == 0 && (status2 = context.getPreferenceStatus("xmlPreferences.mappedElementZeroMinOccurs", 2)) != 0) {
                    problem = new ValidationProblemImpl(0, status2, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_entity_{0}_has_a_min_occurs_of_zero,_but_has_a_mapping_attribute_defined_in_MappingClasses_3", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                    validationResult.addProblem((ValidationProblem)problem);
                    problem.setHasPreference(this.preferences != null);
                    if (status2 == 4) {
                        return false;
                    }
                }
                if (!XsdUtil.isNillable((XSDComponent)xsdComponent)) continue;
                status2 = context.getPreferenceStatus("xmlPreferences.mappedElementNillable", 2);
                if (isProcMapping || status2 == 0) continue;
                problem = new ValidationProblemImpl(0, status2, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_entity_{0}__s_schema_component_reference_is_nullable,_but_has_a_mapping_attribute_defined_in_MappingClasses._5", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                validationResult.addProblem((ValidationProblem)problem);
                problem.setHasPreference(this.preferences != null);
                if (status2 != 4) continue;
                return false;
            }
            if (!this.hasMappedMappingClass(node) || isLogicalXMLModel || maxOccurs != 1 || !(node instanceof XmlElement) || (status = context.getPreferenceStatus("xmlPreferences.mappedElementOneMaxOccurs", 2)) == 0) continue;
            ValidationProblemImpl problem = new ValidationProblemImpl(0, status, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_element_{0}_has_a_max_occurs_of_one,_but_is_mapped_to_a_MappingClass", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
            problem.setHasPreference(this.preferences != null);
            validationResult.addProblem((ValidationProblem)problem);
            if (status != 4) continue;
            return false;
        }
        return true;
    }

    private boolean validateSchemaComponent(XmlDocumentNode node, ValidationResult validationResult, ValidationContext context) {
        XSDComponent xsdComponent = node.getXsdComponent();
        if (xsdComponent == null) {
            int status;
            if (this.isElementOrAttribute(node) && (status = context.getPreferenceStatus("xmlPreferences.elementSchemaRef", 2)) != 0) {
                EObject containerNode = node.eContainer();
                ArgCheck.isInstanceOf((Class)(class$com$metamatrix$metamodels$xml$XmlDocumentEntity == null ? (class$com$metamatrix$metamodels$xml$XmlDocumentEntity = XmlDocumentValidationRule.class$("com.metamatrix.metamodels.xml.XmlDocumentEntity")) : class$com$metamatrix$metamodels$xml$XmlDocumentEntity), (Object)containerNode);
                XSDComponent containerComponent = this.getXsdComponent((XmlDocumentEntity)containerNode);
                if (containerComponent != null) {
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, status, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_document_element/attribute_{0}_doesn__t_reference_a_schema_component._10", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                    problem.setHasPreference(this.preferences != null);
                    validationResult.addProblem((ValidationProblem)problem);
                    return false;
                }
            }
            return true;
        }
        if (xsdComponent.eIsProxy()) {
            try {
                Container container = ModelerCore.getModelContainer();
                EcoreUtil.resolve((EObject)xsdComponent, (ResourceSet)container);
            }
            catch (CoreException err) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, err.getMessage());
                validationResult.addProblem((ValidationProblem)problem);
                return false;
            }
        }
        int maxOccurs = XsdUtil.getMaxOccurs((XSDComponent)xsdComponent);
        EObject parent = node.eContainer();
        if (parent != null && maxOccurs > -1) {
            int status;
            int childCount = 0;
            Iterator contentIter = parent.eContents().iterator();
            while (contentIter.hasNext()) {
                XSDComponent childComponent;
                XmlDocumentNode childNode;
                Object child = contentIter.next();
                if (!(child instanceof XmlDocumentNode) || (childNode = (XmlDocumentNode)child).isExcludeFromDocument() || (childComponent = childNode.getXsdComponent()) == null || !ModelerCore.getModelEditor().equals((EObject)xsdComponent, (EObject)childComponent)) continue;
                ++childCount;
            }
            if (childCount > maxOccurs && (status = context.getPreferenceStatus("xmlPreferences.maxOccursViolation", 2)) != 0) {
                ValidationProblemImpl problem;
                if (maxOccurs == 0 && XsdUtil.isAttribute((XSDComponent)xsdComponent)) {
                    problem = new ValidationProblemImpl(0, status, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_attribute_{0}_references_a_prohibited_schema_attribute._7", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                    problem.setHasPreference(this.preferences != null);
                    validationResult.addProblem((ValidationProblem)problem);
                } else {
                    problem = new ValidationProblemImpl(0, status, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_entity_{0},_may_be_violating_maxOccurs_specified_by_the_schema._1", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                    problem.setHasPreference(this.preferences != null);
                    validationResult.addProblem((ValidationProblem)problem);
                }
            }
        }
        if (node.isExcludeFromDocument()) {
            EObject container = node.eContainer();
            ArgCheck.isInstanceOf((Class)(class$com$metamatrix$metamodels$xml$XmlDocumentEntity == null ? (class$com$metamatrix$metamodels$xml$XmlDocumentEntity = XmlDocumentValidationRule.class$("com.metamatrix.metamodels.xml.XmlDocumentEntity")) : class$com$metamatrix$metamodels$xml$XmlDocumentEntity), (Object)container);
            XmlDocumentEntity containerNode = (XmlDocumentEntity)container;
            if (!this.isOptional((XmlDocumentEntity)node) && !this.isOptional(containerNode)) {
                boolean isProcMapping = false;
                SqlAspect aspect = AspectManager.getSqlAspect((EObject)node);
                if (aspect != null && aspect instanceof XmlElementSqlAspect) {
                    isProcMapping = ((XmlElementSqlAspect)aspect).isTranformationInputParameter((EObject)node);
                }
                int status = context.getPreferenceStatus("xmlPreferences.requiredElementExclude", 2);
                if (!isProcMapping && status != 0) {
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, status, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_entity_{0}_has_been_selected_to_be_excluded_from_the_Document,_but_the_neither_the_entity_nor_its_parent_are_optional._9", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                    problem.setHasPreference(this.preferences != null);
                    validationResult.addProblem((ValidationProblem)problem);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateCriteria(ChoiceOption option, XmlChoice xmlChoice, TreeMappingAdapter mappingAdapter, IMappableTree mappableTree, ValidationResult validationResult, ValidationContext context) {
        String choiceCriteria = option.getChoiceCriteria();
        ap criteria = null;
        Collection groups = null;
        try {
            b parser = new b();
            criteria = parser.c(choiceCriteria);
            e metadata = null;
            if (context != null && context.useServerIndexes()) {
                TargetLocationIndexSelector selector = new TargetLocationIndexSelector(context.getIndexLocation());
                QueryMetadataContext queryContext = new QueryMetadataContext((IndexSelector)selector);
                queryContext.setContainer(context.getResourceContainer());
                queryContext.setResources(Arrays.asList(context.getResourcesInScope()));
                queryContext.setRestrictedSearch(true);
                metadata = TransformationMetadataFactory.getInstance().getVdbMetadata(queryContext);
            } else {
                metadata = TransformationMetadataFactory.getInstance().getModelerMetadata((EObject)option, true);
            }
            groups = this.getGroups(criteria, metadata);
            j.cu((com.metamatrix.query.o.d)criteria, (Collection)groups, (e)metadata);
            i.co((com.metamatrix.query.o.d)criteria, (e)metadata);
            d.bz((com.metamatrix.query.o.d)criteria);
            h report = com.metamatrix.query.c.b.c((com.metamatrix.query.o.d)criteria, (e)metadata);
            if (report.b()) {
                Collection problems = this.createValidationProblems(report);
                Iterator probIter = problems.iterator();
                while (probIter.hasNext()) {
                    validationResult.addProblem((ValidationProblem)probIter.next());
                }
                return false;
            }
        }
        catch (Throwable e2) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("XmlDocumentValidationRule.Error_trying_validate_choice_criteria__14") + choiceCriteria + TransformationPlugin.Util.getString("XmlDocumentValidationRule.__15") + e2.getMessage());
            validationResult.addProblem((ValidationProblem)problem);
            return false;
        }
        MappingClass mc = mappingAdapter.getMappingClass((EObject)xmlChoice);
        if (mc == null) {
            for (XmlContainerHolder parent = xmlChoice.getParent(); parent != null && mc == null; parent = parent.eContainer()) {
                mc = mappingAdapter.getMappingClass((EObject)parent);
            }
        }
        Collection validMappingClasses = this.getParentMappingClasses(mc, mappingAdapter, mappableTree);
        if (mc != null) {
            validMappingClasses.add(mc);
        }
        Iterator grpIter = groups.iterator();
        while (grpIter.hasNext()) {
            f grpSymbol = (f)grpIter.next();
            MetadataRecord record = (MetadataRecord)grpSymbol.aq();
            EObject grpObject = (EObject)context.getResourceContainer().getEObjectFinder().find((Object)record.getUUID());
            if (validMappingClasses.contains(grpObject)) continue;
            String choicePath = ModelerCore.getModelEditor().getModelRelativePath((EObject)option).toString();
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("XmlDocumentValidationRule.0", (Object)grpSymbol, (Object)choicePath));
            validationResult.addProblem((ValidationProblem)problem);
            return false;
        }
        return true;
    }

    private Collection getParentMappingClasses(MappingClass mappingClass, TreeMappingAdapter mappingAdapter, IMappableTree mappableTree) {
        List parentMappingClasses;
        if (mappingAdapter != null && (parentMappingClasses = mappingAdapter.getParentMappingClasses(mappingClass, mappableTree, false)) != null && !parentMappingClasses.isEmpty()) {
            return parentMappingClasses;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection getGroups(ap criteria, e metadata) throws Exception {
        HashSet<f> groups = new HashSet<f>();
        Iterator elemIter = k.e7((com.metamatrix.query.o.d)criteria, (boolean)true, (boolean)true).iterator();
        while (elemIter.hasNext()) {
            a element = (a)elemIter.next();
            String groupName = metadata.getGroupName(element.ak());
            f group = new f(groupName);
            if (groups.contains(group)) continue;
            group.au(metadata.getGroupID(groupName));
            groups.add(group);
        }
        return groups;
    }

    private boolean isElementOrAttribute(Object entity) {
        return entity instanceof XmlElement || entity instanceof XmlAttribute;
    }

    private boolean isOptional(XmlDocumentEntity node) {
        if (this.isElementOrAttribute(node)) {
            XSDComponent xsdComponent = this.getXsdComponent(node);
            Assertion.isNotNull((Object)xsdComponent);
            if (XsdUtil.getMinOccurs((XSDComponent)xsdComponent) == 0) {
                return true;
            }
            if (XsdUtil.isNillable((XSDComponent)xsdComponent)) {
                return true;
            }
        }
        return false;
    }

    private XSDComponent getXsdComponent(XmlDocumentEntity node) {
        XSDComponent xsdComponent = null;
        if (node instanceof XmlDocumentNode) {
            xsdComponent = ((XmlDocumentNode)node).getXsdComponent();
        } else if (node instanceof XmlContainerNode) {
            xsdComponent = ((XmlContainerNode)node).getXsdComponent();
        }
        return xsdComponent;
    }

    private boolean hasMappedMappingClassColumn(Object entity) {
        Object mappedObj = this.elementColumnMap.get(entity);
        return mappedObj != null;
    }

    private boolean hasMappedMappingClass(Object entity) {
        Object mappedObj = this.elementMappingClassMap.get(entity);
        return mappedObj != null;
    }

    private Collection createValidationProblems(h report) {
        if (report != null && report.b()) {
            Collection items = report.g();
            ArrayList<ValidationProblemImpl> problemList = new ArrayList<ValidationProblemImpl>(items.size());
            Iterator itemIter = items.iterator();
            while (itemIter.hasNext()) {
                com.metamatrix.query.g.b item = (com.metamatrix.query.g.b)itemIter.next();
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, item.toString());
                problemList.add(problem);
            }
            return problemList;
        }
        return Collections.EMPTY_LIST;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DocumentVisitor
    implements ModelVisitor {
        Collection elements = new ArrayList();
        Collection attributes = new ArrayList();
        Collection choices = new ArrayList();
        Collection entities = new ArrayList();

        private DocumentVisitor() {
        }

        public boolean visit(EObject eObject) {
            if (eObject instanceof XmlElement) {
                this.elements.add(eObject);
            }
            if (eObject instanceof XmlAttribute) {
                this.attributes.add(eObject);
            }
            if (eObject instanceof XmlChoice) {
                this.choices.add(eObject);
            }
            this.entities.add(eObject);
            return true;
        }

        public Collection getElements() {
            return this.elements;
        }

        public Collection getEntities() {
            return this.entities;
        }

        public Collection getChoices() {
            return this.choices;
        }

        public Collection getAttributes() {
            return this.attributes;
        }

        public boolean visit(Resource resource) throws ModelerCoreException {
            return true;
        }
    }
}

