/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.util;

import java.util.Iterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLInfoImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;

public class UML2ExtendedMetaData
extends BasicExtendedMetaData {
    private final EPackage.Registry compatibilityRegistry = new EPackageRegistryImpl();
    private final XMLResource.XMLMap xmlMap = new XMLMapImpl();

    public UML2ExtendedMetaData(EPackage.Registry registry) {
        super(registry);
    }

    protected String getNsURIPattern(String nsURI) {
        StringBuffer nsURIPattern = new StringBuffer();
        int i = 0;
        while (i < nsURI.length()) {
            if (Character.isDigit(nsURI.charAt(i))) {
                nsURIPattern.append("\\d");
            } else {
                nsURIPattern.append(nsURI.charAt(i));
            }
            ++i;
        }
        return nsURIPattern.toString();
    }

    public EPackage getPackage(String namespace) {
        EPackage ePackage = super.getPackage(namespace);
        if (ePackage == null && namespace != null) {
            ePackage = this.compatibilityRegistry.getEPackage(namespace);
            if (ePackage != null) {
                return ePackage;
            }
            ePackage = this.findPackage(this.registry, this.getNsURIPattern(namespace));
            if (ePackage != null) {
                this.compatibilityRegistry.put((Object)namespace, (Object)ePackage);
                XMLInfoImpl xmlInfo = new XMLInfoImpl();
                xmlInfo.setTargetNamespace(namespace);
                this.xmlMap.add((ENamedElement)ePackage, (XMLResource.XMLInfo)xmlInfo);
            }
        }
        return ePackage;
    }

    protected EPackage findPackage(EPackage.Registry registry, String nsURIPattern) {
        Iterator nsURIs = registry.keySet().iterator();
        while (nsURIs.hasNext()) {
            String nsURI = (String)nsURIs.next();
            if (!nsURI.matches(nsURIPattern)) continue;
            return registry.getEPackage(nsURI);
        }
        return EPackage.Registry.INSTANCE != registry ? this.findPackage(EPackage.Registry.INSTANCE, nsURIPattern) : null;
    }

    public String getNamespace(EPackage ePackage) {
        String namespace;
        XMLResource.XMLInfo xmlInfo = this.xmlMap.getInfo((ENamedElement)ePackage);
        if (xmlInfo != null && (namespace = xmlInfo.getTargetNamespace()) != null) {
            return namespace;
        }
        return super.getNamespace(ePackage);
    }
}

