/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.aspects.sql;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.MappingClassColumn;
import com.metamatrix.metamodels.transformation.MappingClassSet;
import com.metamatrix.metamodels.transformation.MappingClassSetContainer;
import com.metamatrix.metamodels.transformation.RecursionErrorMode;
import com.metamatrix.metamodels.transformation.StagingTable;
import com.metamatrix.metamodels.transformation.TransformationContainer;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.metamodels.xml.ChoiceErrorMode;
import com.metamatrix.metamodels.xml.SoapEncoding;
import com.metamatrix.metamodels.xml.ValueType;
import com.metamatrix.metamodels.xml.XmlAll;
import com.metamatrix.metamodels.xml.XmlAttribute;
import com.metamatrix.metamodels.xml.XmlChoice;
import com.metamatrix.metamodels.xml.XmlComment;
import com.metamatrix.metamodels.xml.XmlContainerNode;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.metamodels.xml.XmlDocumentEntity;
import com.metamatrix.metamodels.xml.XmlDocumentFactory;
import com.metamatrix.metamodels.xml.XmlDocumentNode;
import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.XmlNamespace;
import com.metamatrix.metamodels.xml.XmlRoot;
import com.metamatrix.metamodels.xml.XmlSequence;
import com.metamatrix.metamodels.xml.XmlValueHolder;
import com.metamatrix.metamodels.xml.namespace.NamespaceContext;
import com.metamatrix.metamodels.xml.util.XmlDocumentUtil;
import com.metamatrix.metamodels.xml.util.XmlNamespaceComparator;
import com.metamatrix.metamodels.xsd.XsdUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlConverter;
import com.metamatrix.modeler.internal.xml.aspects.sql.MappingContext;
import com.metamatrix.modeler.internal.xml.aspects.sql.XmlDocumentMappingHelper;
import com.metamatrix.modeler.xml.PluginConstants;
import com.metamatrix.query.mapping.xml.MappingNode;
import com.metamatrix.query.mapping.xml.MappingNodeConstants;
import com.metamatrix.query.mapping.xml.MappingOutputter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWhiteSpace;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceImpl;

public class MappingDocumentFormatter {
    public static final String XMLNS_PREFIX = "xmlns";
    public static final String XSI_TYPE_ATTRIBUTE_NAME = "type";
    private boolean includeSoapDefaultEncoding;
    private final XmlDocument xmlDoc;
    private final MappingContext mappingContext;
    private final List treeMappingRoots;
    private final XmlDocumentMappingHelper helper;
    private boolean indent;
    private boolean newlines;
    static /* synthetic */ Class class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlAspect;

    public static MappingDocumentFormatter create(XmlDocument xmlDoc, MappingContext mappingContext) {
        MappingClassSet mappingClassSet;
        List treeMappingRoots = MappingDocumentFormatter.findTreeMappingRoot(xmlDoc);
        if (treeMappingRoots != null && treeMappingRoots.size() != 0 && (mappingClassSet = MappingDocumentFormatter.findMappingClassSet(xmlDoc)) != null) {
            MappingDocumentFormatter formatter = new MappingDocumentFormatter(xmlDoc, treeMappingRoots, mappingClassSet, mappingContext);
            return formatter;
        }
        return null;
    }

    protected static MappingClassSet findMappingClassSet(XmlDocument xmlDoc) {
        Resource resource = xmlDoc.eResource();
        if (resource == null) {
            return null;
        }
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object rootObj = iter.next();
            if (!(rootObj instanceof MappingClassSetContainer)) continue;
            MappingClassSetContainer container = (MappingClassSetContainer)rootObj;
            Iterator mcsetiter = container.getMappingClassSets().iterator();
            while (mcsetiter.hasNext()) {
                MappingClassSet mcSet = (MappingClassSet)mcsetiter.next();
                EObject target = mcSet.getTarget();
                if (target != xmlDoc) continue;
                return mcSet;
            }
        }
        return null;
    }

    protected static List findTreeMappingRoot(XmlDocument xmlDoc) {
        Resource resource = xmlDoc.eResource();
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<TransformationMappingRoot> treeMappingRoots = new LinkedList<TransformationMappingRoot>();
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object rootObj = iter.next();
            if (!(rootObj instanceof TransformationContainer)) continue;
            TransformationContainer container = (TransformationContainer)rootObj;
            Iterator transformIter = container.getTransformationMappings().iterator();
            while (transformIter.hasNext()) {
                EObject target;
                TransformationMappingRoot tmroot = (TransformationMappingRoot)transformIter.next();
                if (!(tmroot instanceof TreeMappingRoot) || (target = tmroot.getTarget()) != xmlDoc) continue;
                treeMappingRoots.add(tmroot);
            }
        }
        return treeMappingRoots;
    }

    public MappingDocumentFormatter(XmlDocument xmlDoc, List treeMappingRoots, MappingClassSet mappingClassSet, MappingContext mappingContext) {
        ArgCheck.isNotNull((Object)xmlDoc);
        ArgCheck.isNotNull((Object)treeMappingRoots);
        ArgCheck.isNotNull((Object)mappingClassSet);
        this.includeSoapDefaultEncoding = false;
        this.xmlDoc = xmlDoc;
        this.treeMappingRoots = treeMappingRoots;
        this.mappingContext = mappingContext;
        this.helper = new XmlDocumentMappingHelper(this.treeMappingRoots);
    }

    /*
     * Loose catch block
     */
    public String createMappingString() throws Exception {
        String result;
        block8: {
            MappingNode mapping = this.createMapping();
            result = null;
            ByteArrayOutputStream moStream = null;
            moStream = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(moStream, true);
            MappingOutputter outputter = new MappingOutputter(mapping);
            outputter.init();
            outputter.loadDocument();
            outputter.output(pw, this.isNewlines(), this.isIndent());
            pw.flush();
            result = ((Object)moStream).toString();
            Object var7_7 = null;
            if (moStream == null) break block8;
            try {
                ((OutputStream)moStream).close();
            }
            catch (IOException e1) {
                PluginConstants.Util.log((Throwable)e1);
            }
            moStream = null;
            {
                break block8;
                catch (Exception e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (moStream != null) {
                    try {
                        ((OutputStream)moStream).close();
                    }
                    catch (IOException e1) {
                        PluginConstants.Util.log((Throwable)e1);
                    }
                    moStream = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    public MappingNode createMapping() {
        this.helper.initialize();
        XmlRoot xmlRootElement = this.xmlDoc.getRoot();
        NamespaceContext nsContext = new NamespaceContext((XmlElement)xmlRootElement, null);
        ElementInfo elementInfo = new ElementInfo(nsContext, null);
        MappingNode docMappingNode = this.createMapping(xmlRootElement, elementInfo, this.mappingContext);
        this.processNamespaces((List)xmlRootElement.getDeclaredNamespaces(), docMappingNode, nsContext, elementInfo);
        this.processChildren((List)xmlRootElement.getAttributes(), docMappingNode, nsContext, elementInfo);
        this.processChildren((List)xmlRootElement.getComments(), docMappingNode, nsContext, elementInfo);
        this.processChildren((List)xmlRootElement.getContainers(), docMappingNode, nsContext, elementInfo);
        this.processChildren((List)xmlRootElement.getProcessingInstructions(), docMappingNode, nsContext, elementInfo);
        this.processChildren((List)xmlRootElement.getElements(), docMappingNode, nsContext, elementInfo);
        return docMappingNode;
    }

    protected void createMapping(XmlDocumentEntity entity, MappingNode parentMappingNode, NamespaceContext namespaceContext, MappingContext mappingContext, ElementInfo parentInfo) {
        int classifierId = entity.eClass().getClassifierID();
        MappingNode entityMappingNode = null;
        ElementInfo entityInfo = parentInfo;
        NamespaceContext entityNamespaceContext = namespaceContext;
        switch (classifierId) {
            case 3: {
                XmlElement element = (XmlElement)entity;
                entityNamespaceContext = new NamespaceContext(element, namespaceContext);
                entityInfo = new ElementInfo(entityNamespaceContext, parentInfo);
                entityMappingNode = this.createMappingNode(parentMappingNode, element, entityInfo, mappingContext);
                this.processNamespaces((List)element.getDeclaredNamespaces(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getAttributes(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getComments(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getContainers(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getProcessingInstructions(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getElements(), entityMappingNode, entityNamespaceContext, entityInfo);
                break;
            }
            case 4: {
                entityMappingNode = this.createMappingNode(parentMappingNode, (XmlAttribute)entity, entityInfo, mappingContext);
                break;
            }
            case 8: {
                entityMappingNode = this.createMappingNode(parentMappingNode, (XmlNamespace)entity, entityInfo);
                break;
            }
            case 10: 
            case 11: {
                XmlContainerNode container = (XmlContainerNode)entity;
                entityMappingNode = this.createMappingNode(parentMappingNode, container, entityInfo);
                EList kids = container.eContents();
                this.processChildren((List)kids, entityMappingNode, namespaceContext, parentInfo);
                break;
            }
            case 12: {
                XmlChoice choiceNode = (XmlChoice)entity;
                entityMappingNode = this.createMappingNode(parentMappingNode, (XmlContainerNode)choiceNode, entityInfo);
                List optionsInOrder = choiceNode.getOrderedChoiceOptions();
                this.processChildren(optionsInOrder, entityMappingNode, namespaceContext, parentInfo);
                break;
            }
            case 0: {
                break;
            }
            case 7: {
                entityMappingNode = this.createMappingNode(parentMappingNode, (XmlComment)entity, entityInfo);
                break;
            }
        }
    }

    protected void processNamespaces(List children, MappingNode parentMappingNode, NamespaceContext namespaceContext, ElementInfo parentInfo) {
        LinkedList orderedNamespaces = new LinkedList(children);
        XmlNamespaceComparator comparator = new XmlNamespaceComparator();
        Collections.sort(orderedNamespaces, comparator);
        this.processChildren(orderedNamespaces, parentMappingNode, namespaceContext, parentInfo);
    }

    protected void processChildren(List children, MappingNode parentMappingNode, NamespaceContext namespaceContext, ElementInfo parentInfo) {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (!(child instanceof XmlDocumentEntity)) continue;
            this.createMapping((XmlDocumentEntity)child, parentMappingNode, namespaceContext, this.mappingContext, parentInfo);
        }
    }

    protected MappingNode createMapping(XmlRoot xmlRoot, ElementInfo rootElementInfo, MappingContext mappingContext) {
        MappingNode mappingNode = new MappingNode();
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NAME, this.xmlDoc.getName());
        this.setProperty(mappingNode, MappingNodeConstants.Properties.DOCUMENT_ENCODING, this.xmlDoc.getEncoding());
        this.setProperty(mappingNode, MappingNodeConstants.Properties.FORMATTED_DOCUMENT, this.xmlDoc.isFormatted());
        SoapEncoding soapEncoding = this.xmlDoc.getSoapEncoding();
        switch (soapEncoding.getValue()) {
            case 1: {
                this.includeSoapDefaultEncoding = true;
                break;
            }
            default: {
                this.includeSoapDefaultEncoding = false;
            }
        }
        this.processMappingNode(mappingNode, (XmlElement)xmlRoot, rootElementInfo, mappingContext);
        return mappingNode;
    }

    protected MappingNode createMappingNode(MappingNode parentMappingNode, XmlElement element, ElementInfo elementInfo, MappingContext mappingContext) {
        MappingNode mappingNode = new MappingNode();
        if (parentMappingNode != null) {
            parentMappingNode.addChild(mappingNode);
        }
        this.processMappingNode(mappingNode, element, elementInfo, mappingContext);
        return mappingNode;
    }

    protected MappingNode processMappingNode(MappingNode mappingNode, XmlElement element, ElementInfo elementInfo, MappingContext mappingContext) {
        MappingClassColumn mappingClassColumn;
        String fullName;
        MappingClass mappingClass;
        String fullName2;
        StagingTable[] tempGroups;
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NODE_TYPE, "element");
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NAME, element.getName());
        String nsPrefix = MappingDocumentFormatter.getNamespacePrefix((XmlDocumentNode)element, elementInfo.getNamespaceContext(), mappingContext);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NAMESPACE_PREFIX, nsPrefix);
        this.setValueProperty(mappingNode, (XmlValueHolder)element);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.IS_EXCLUDED, element.isExcludeFromDocument());
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NORMALIZE_TEXT, this.getXsiTypeTextNormalization((XmlDocumentNode)element, mappingContext));
        String choiceCriteria = element.getChoiceCriteria();
        if (choiceCriteria != null && choiceCriteria.indexOf("mmuuid") >= 0) {
            choiceCriteria = SqlConverter.convertUUIDsToFullNames((String)choiceCriteria, (Container)((Container)element.eResource().getResourceSet()));
        }
        this.setProperty(mappingNode, MappingNodeConstants.Properties.CRITERIA, choiceCriteria);
        XmlChoice defaultFor = element.getDefaultFor();
        this.setProperty(mappingNode, MappingNodeConstants.Properties.IS_DEFAULT_CHOICE, defaultFor != null);
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent != null) {
            int minOccurs = XsdUtil.getMinOccurs((XSDComponent)xsdComponent);
            int maxOccurs = XsdUtil.getMaxOccurs((XSDComponent)xsdComponent);
            this.setProperty(mappingNode, MappingNodeConstants.Properties.CARDINALITY_MIN_BOUND, minOccurs);
            this.setUnboundProperty(mappingNode, MappingNodeConstants.Properties.CARDINALITY_MAX_BOUND, maxOccurs);
            if (xsdComponent instanceof XSDElementDeclaration) {
                XSDElementDeclaration xsdElement = (XSDElementDeclaration)xsdComponent;
                this.setProperty(mappingNode, MappingNodeConstants.Properties.IS_NILLABLE, xsdElement.isNillable());
                MappingClassColumn mappingClassColumn2 = this.helper.getMappingClassColumn((XmlDocumentEntity)element);
                if (mappingClassColumn2 != null) {
                    SqlColumnAspect columnAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)mappingClassColumn2);
                    EObject dataType = columnAspect.getDatatype((EObject)mappingClassColumn2);
                    DatatypeManager dtm = ModelerCore.getBuiltInTypesManager();
                    Assertion.isNotNull((Object)dtm);
                    try {
                        dataType = dtm.getDatatypeForXsdType(dataType);
                    }
                    catch (ModelerCoreException err) {
                        PluginConstants.Util.log((Throwable)err);
                    }
                    String name = null;
                    if (dataType != null && dtm.isBuiltInDatatype(dataType)) {
                        name = dtm.getName(dataType);
                    }
                    if (name != null) {
                        this.setProperty(mappingNode, MappingNodeConstants.Properties.BUILT_IN_TYPE, name);
                    }
                }
            }
        }
        if ((tempGroups = this.helper.getStagingTables((XmlDocumentEntity)element)) != null && tempGroups.length != 0) {
            for (int i = 0; i < tempGroups.length; ++i) {
                StagingTable st = tempGroups[i];
                fullName2 = this.getFullName((EObject)st);
                if (fullName2 == null) continue;
                ArrayList<String> tempGroupNames = new ArrayList<String>(1);
                tempGroupNames.add(fullName2);
                this.setProperty(mappingNode, MappingNodeConstants.Properties.TEMP_GROUP_NAMES, tempGroupNames);
            }
        }
        if ((mappingClass = this.helper.getMappingClass((XmlDocumentEntity)element)) != null && (fullName = this.getFullName((EObject)mappingClass)) != null) {
            this.setProperty(mappingNode, MappingNodeConstants.Properties.RESULT_SET_NAME, fullName);
        }
        if ((mappingClassColumn = this.helper.getMappingClassColumn((XmlDocumentEntity)element)) != null && (fullName2 = this.getFullName((EObject)mappingClassColumn)) != null) {
            this.setProperty(mappingNode, MappingNodeConstants.Properties.ELEMENT_NAME, fullName2);
        }
        if (mappingClass != null && mappingClass.isRecursionAllowed() && mappingClass.isRecursive()) {
            boolean isRecursive = mappingClass.isRecursive();
            String recursionCriteria = mappingClass.getRecursionCriteria();
            int recursionLimit = mappingClass.getRecursionLimit();
            RecursionErrorMode mode = mappingClass.getRecursionLimitErrorMode();
            Assertion.isNotNull((Object)mode);
            boolean exceptionUponRecursionLimit = true;
            switch (mode.getValue()) {
                case 0: {
                    exceptionUponRecursionLimit = true;
                    break;
                }
                case 1: 
                case 2: {
                    exceptionUponRecursionLimit = false;
                }
            }
            this.setProperty(mappingNode, MappingNodeConstants.Properties.IS_RECURSIVE, isRecursive);
            this.setProperty(mappingNode, MappingNodeConstants.Properties.RECURSION_CRITERIA, recursionCriteria);
            this.setProperty(mappingNode, MappingNodeConstants.Properties.RECURSION_LIMIT, recursionLimit);
            this.setProperty(mappingNode, MappingNodeConstants.Properties.EXCEPTION_ON_RECURSION_LIMIT, exceptionUponRecursionLimit);
            MappingClass rootMappingClass = this.helper.getRecusionRootMappingClass(element);
            if (rootMappingClass != null) {
                String rootPath = this.getFullName((EObject)rootMappingClass);
                this.setProperty(mappingNode, MappingNodeConstants.Properties.RECURSION_ROOT_MAPPING_CLASS, rootPath);
                if (!StringUtil.isEmpty((String)recursionCriteria)) {
                    String childPath = this.getFullName((EObject)mappingClass);
                    String rewrittenCriteria = StringUtil.replaceAll((String)recursionCriteria, (String)childPath, (String)rootPath);
                    this.setProperty(mappingNode, MappingNodeConstants.Properties.RECURSION_CRITERIA, rewrittenCriteria);
                }
            }
        }
        if (this.includeSoapDefaultEncoding) {
            boolean xsiTypeRequired;
            String soapArrayType = MappingDocumentFormatter.getSoapArrayType(element, elementInfo.getNamespaceContext(), mappingContext);
            if (soapArrayType != null) {
                elementInfo.setSoapArrayType(soapArrayType);
                this.createMappingNodeForSoapArrayType(mappingNode, elementInfo);
            }
            if (xsiTypeRequired = elementInfo.isXsiTypeRequired()) {
                String xsiTypeValue = this.getXsiType(element, elementInfo.getNamespaceContext(), mappingContext);
                elementInfo.setXsiType(xsiTypeValue);
                this.createMappingNodeForXsiType(mappingNode, elementInfo);
            }
        }
        return mappingNode;
    }

    protected MappingNode createMappingNode(MappingNode parentMappingNode, XmlContainerNode compositor, ElementInfo elementInfo) {
        String fullName;
        MappingClass mappingClass;
        MappingNode mappingNode = new MappingNode();
        if (parentMappingNode != null) {
            parentMappingNode.addChild(mappingNode);
        }
        if (compositor instanceof XmlSequence) {
            this.setProperty(mappingNode, MappingNodeConstants.Properties.NODE_TYPE, "sequence");
        } else if (compositor instanceof XmlChoice) {
            this.setProperty(mappingNode, MappingNodeConstants.Properties.NODE_TYPE, "choice");
            XmlChoice choice = (XmlChoice)compositor;
            ChoiceErrorMode errorMode = choice.getDefaultErrorMode();
            switch (errorMode.getValue()) {
                case 0: {
                    this.setProperty(mappingNode, MappingNodeConstants.Properties.EXCEPTION_ON_DEFAULT, true);
                    break;
                }
                case 1: 
                case 2: {
                    this.setProperty(mappingNode, MappingNodeConstants.Properties.EXCEPTION_ON_DEFAULT, false);
                }
            }
        } else if (compositor instanceof XmlAll) {
            this.setProperty(mappingNode, MappingNodeConstants.Properties.NODE_TYPE, "all");
        }
        this.setProperty(mappingNode, MappingNodeConstants.Properties.IS_EXCLUDED, compositor.isExcludeFromDocument());
        String choiceCriteria = compositor.getChoiceCriteria();
        if (choiceCriteria != null && choiceCriteria.indexOf("mmuuid") >= 0) {
            choiceCriteria = SqlConverter.convertUUIDsToFullNames((String)choiceCriteria, (Container)((Container)compositor.eResource().getResourceSet()));
        }
        this.setProperty(mappingNode, MappingNodeConstants.Properties.CRITERIA, choiceCriteria);
        XmlChoice defaultFor = compositor.getDefaultFor();
        this.setProperty(mappingNode, MappingNodeConstants.Properties.IS_DEFAULT_CHOICE, defaultFor != null);
        StagingTable[] tempGroups = this.helper.getStagingTables((XmlDocumentEntity)compositor);
        if (tempGroups != null && tempGroups.length != 0) {
            for (int i = 0; i < tempGroups.length; ++i) {
                StagingTable st = tempGroups[i];
                String fullName2 = this.getFullName((EObject)st);
                if (fullName2 == null) continue;
                ArrayList<String> tempGroupNames = new ArrayList<String>(1);
                tempGroupNames.add(fullName2);
                this.setProperty(mappingNode, MappingNodeConstants.Properties.TEMP_GROUP_NAMES, tempGroupNames);
            }
        }
        if ((mappingClass = this.helper.getMappingClass((XmlDocumentEntity)compositor)) != null && (fullName = this.getFullName((EObject)mappingClass)) != null) {
            this.setProperty(mappingNode, MappingNodeConstants.Properties.RESULT_SET_NAME, fullName);
        }
        return mappingNode;
    }

    protected MappingNode createMappingNode(MappingNode parentMappingNode, XmlAttribute attribute, ElementInfo elementInfo, MappingContext mappingContext) {
        String fullName;
        MappingNode mappingNode = new MappingNode();
        if (parentMappingNode != null) {
            parentMappingNode.addChild(mappingNode);
        }
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NODE_TYPE, "attribute");
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NAME, attribute.getName());
        String nsPrefix = MappingDocumentFormatter.getNamespacePrefix((XmlDocumentNode)attribute, elementInfo.getNamespaceContext(), mappingContext);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NAMESPACE_PREFIX, nsPrefix);
        this.setValueProperty(mappingNode, (XmlValueHolder)attribute);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.IS_EXCLUDED, attribute.isExcludeFromDocument());
        MappingClassColumn mappingClassColumn = this.helper.getMappingClassColumn((XmlDocumentEntity)attribute);
        if (mappingClassColumn != null && (fullName = this.getFullName((EObject)mappingClassColumn)) != null) {
            this.setProperty(mappingNode, MappingNodeConstants.Properties.ELEMENT_NAME, fullName);
        }
        return mappingNode;
    }

    protected MappingNode createMappingNode(MappingNode parentMappingNode, XmlComment comment, ElementInfo elementInfo) {
        String text = comment.getText();
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        MappingNode mappingNode = new MappingNode();
        if (parentMappingNode != null) {
            parentMappingNode.addChild(mappingNode);
        }
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NODE_TYPE, "comment");
        this.setProperty(mappingNode, MappingNodeConstants.Properties.COMMENT_TEXT, text);
        return mappingNode;
    }

    protected MappingNode createMappingNode(MappingNode parentMappingNode, XmlNamespace namespaceDeclaration, ElementInfo elementInfo) {
        MappingNode mappingNode = new MappingNode();
        parentMappingNode.addChild(mappingNode);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NODE_TYPE, "attribute");
        String prefix = namespaceDeclaration.getPrefix();
        if (prefix != null && prefix.trim().length() != 0) {
            this.setProperty(mappingNode, MappingNodeConstants.Properties.NAMESPACE_PREFIX, XMLNS_PREFIX);
            this.setProperty(mappingNode, MappingNodeConstants.Properties.NAME, prefix);
        } else {
            this.setProperty(mappingNode, MappingNodeConstants.Properties.NAME, XMLNS_PREFIX);
        }
        this.setProperty(mappingNode, MappingNodeConstants.Properties.FIXED_VALUE, namespaceDeclaration.getUri());
        this.setProperty(mappingNode, MappingNodeConstants.Properties.IS_OPTIONAL, Boolean.TRUE);
        return mappingNode;
    }

    protected MappingNode createMappingNodeForXsiType(MappingNode parentMappingNode, ElementInfo elementInfo) {
        String xsiTypeValue = elementInfo.getXsiType();
        if (xsiTypeValue == null) {
            return null;
        }
        NamespaceContext context = elementInfo.getNamespaceContext();
        String xsiPrefix = MappingDocumentFormatter.getSchemaInstanceNamespacePrefix(context);
        MappingNode mappingNode = new MappingNode();
        parentMappingNode.addChild(mappingNode);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NODE_TYPE, "attribute");
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NAMESPACE_PREFIX, xsiPrefix);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NAME, XSI_TYPE_ATTRIBUTE_NAME);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.FIXED_VALUE, xsiTypeValue);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.IS_OPTIONAL, Boolean.TRUE);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.ALWAYS_INCLUDE, Boolean.TRUE);
        return mappingNode;
    }

    protected MappingNode createMappingNodeForSoapArrayType(MappingNode parentMappingNode, ElementInfo elementInfo) {
        String soapArrayTypeValue = elementInfo.getSoapArrayType();
        if (soapArrayTypeValue == null) {
            return null;
        }
        NamespaceContext context = elementInfo.getNamespaceContext();
        String soapEncodingPrefix = MappingDocumentFormatter.getSoapEncodingNamespacePrefix(context);
        MappingNode mappingNode = new MappingNode();
        parentMappingNode.addChild(mappingNode);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NODE_TYPE, "attribute");
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NAMESPACE_PREFIX, soapEncodingPrefix);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.NAME, "arrayType");
        this.setProperty(mappingNode, MappingNodeConstants.Properties.FIXED_VALUE, soapArrayTypeValue);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.IS_OPTIONAL, Boolean.TRUE);
        this.setProperty(mappingNode, MappingNodeConstants.Properties.ALWAYS_INCLUDE, Boolean.TRUE);
        return mappingNode;
    }

    protected String getXsiType(XmlElement element, NamespaceContext context, MappingContext mappingContext) {
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent == null) {
            return null;
        }
        XSDTypeDefinition typeDefn = XsdUtil.getType((XSDComponent)xsdComponent);
        String typeName = typeDefn.getName();
        String nsPrefix = MappingDocumentFormatter.getNamespacePrefix((XSDComponent)typeDefn, context, mappingContext, null, false, true);
        return nsPrefix == null ? typeName : nsPrefix + ":" + typeName;
    }

    protected String getXsiTypeTextNormalization(XmlDocumentNode node, MappingContext mappingContext) {
        XSDWhiteSpace whiteSpaceEnum;
        XSDSimpleTypeDefinition simpleTypeDefn;
        XSDWhiteSpaceFacet facet;
        XSDComponent xsdComponent = node.getXsdComponent();
        if (xsdComponent == null) {
            return "preserve";
        }
        XSDTypeDefinition typeDefn = XsdUtil.getType((XSDComponent)xsdComponent);
        if (typeDefn instanceof XSDSimpleTypeDefinition && (facet = (simpleTypeDefn = (XSDSimpleTypeDefinition)typeDefn).getEffectiveWhiteSpaceFacet()) != null && (whiteSpaceEnum = facet.getValue()) != null) {
            switch (whiteSpaceEnum.getValue()) {
                case 0: {
                    return "preserve";
                }
                case 1: {
                    return "replace";
                }
                case 2: {
                    return "collapse";
                }
            }
        }
        return "preserve";
    }

    public static String getNamespacePrefix(XmlNamespace ns) {
        String prefix = ns.getPrefix();
        if (prefix == null || prefix.trim().length() == 0) {
            prefix = XmlDocumentUtil.createXmlPrefixFromUri((String)ns.getUri());
        }
        return prefix;
    }

    public static String getNamespacePrefix(XmlDocumentNode elementOrAttribute, NamespaceContext context, MappingContext mappingContext) {
        if (elementOrAttribute == null) {
            return null;
        }
        XSDComponent xsdComponent = elementOrAttribute.getXsdComponent();
        XSDSchema startingSchema = MappingDocumentFormatter.getTargetNamespaceSchema(xsdComponent, context, mappingContext);
        String defaultTargetNamespace = MappingDocumentFormatter.getTargetNamespace(startingSchema, elementOrAttribute, context, mappingContext);
        String prefix = MappingDocumentFormatter.getNamespacePrefix(xsdComponent, context, mappingContext, defaultTargetNamespace, true, true);
        return prefix;
    }

    private static String getNamespacePrefix(XSDComponent xsdComponent, NamespaceContext context, MappingContext mappingContext, String defaultTargetNamespace, boolean checkWhetherPrefixIsRequired, boolean addIfMissing) {
        String prefix;
        if (xsdComponent == null) {
            return null;
        }
        XSDSchema schema = MappingDocumentFormatter.getTargetNamespaceSchema(xsdComponent, context, mappingContext);
        if (schema == null) {
            return null;
        }
        String uri = schema.getTargetNamespace() == null ? defaultTargetNamespace : schema.getTargetNamespace();
        XmlNamespace namespace = context.getBestNamespace(uri);
        if (namespace == null) {
            if (XsdUtil.isBuiltInDatatype((XSDComponent)xsdComponent)) {
                String prefix2 = MappingDocumentFormatter.getSchemaNamespacePrefix(context);
                if (!checkWhetherPrefixIsRequired || MappingDocumentFormatter.isPrefixRequired(xsdComponent, schema, uri)) {
                    return prefix2;
                }
                return null;
            }
            if (uri != null && addIfMissing) {
                XmlNamespace newNs = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
                prefix = XmlDocumentUtil.createXmlPrefixFromUri((String)uri);
                if (prefix == null) {
                    prefix = "nspace";
                }
                newNs.setPrefix(prefix);
                newNs.setUri(uri);
                int counter = 0;
                while (!context.addXmlNamespace(newNs)) {
                    newNs.setPrefix(prefix + ++counter);
                }
                namespace = newNs;
            }
        }
        if (namespace != null) {
            String actualPrefix = namespace.getPrefix();
            if (actualPrefix == null || actualPrefix.trim().length() == 0) {
                return null;
            }
            prefix = MappingDocumentFormatter.getNamespacePrefix(namespace);
            if (!checkWhetherPrefixIsRequired || MappingDocumentFormatter.isPrefixRequired(xsdComponent, schema, uri)) {
                return prefix;
            }
            return null;
        }
        return null;
    }

    private static XSDSchema getTargetNamespaceSchema(XSDComponent xsdComponent, NamespaceContext context, MappingContext mappingContext) {
        XSDFeature resolvedComponent;
        if (xsdComponent == null) {
            return null;
        }
        XSDSchema schema = xsdComponent.getSchema();
        if (schema == null && xsdComponent.eIsProxy() && (schema = (xsdComponent = (XSDComponent)EcoreUtil.resolve((EObject)xsdComponent, (ResourceSet)mappingContext.getResourceSet())).getSchema()) == null) {
            URI componentURi = ModelerCore.getModelEditor().getUri((EObject)xsdComponent);
            String msg = PluginConstants.Util.getString("MappingDocumentFormatter.Unable_to_determine_schema_in_the_workspace_for_XsdComponent_{0}_when_deriving_Namespace_Prefix_1", (Object)componentURi);
            PluginConstants.Util.log(4, msg);
            return null;
        }
        if (xsdComponent instanceof XSDFeature && (resolvedComponent = XsdUtil.getResolved((XSDFeature)((XSDFeature)xsdComponent))) != null && resolvedComponent != xsdComponent) {
            XSDSchema resolvedSchema = resolvedComponent.getSchema();
            String resolvedTNS = resolvedComponent.getTargetNamespace();
            if (StringUtil.isEmpty((String)resolvedTNS)) {
                resolvedTNS = resolvedSchema.getTargetNamespace();
            }
            if (resolvedTNS != null && resolvedTNS.trim().length() != 0) {
                if (resolvedSchema != null && resolvedSchema.eIsProxy()) {
                    XSDResourceImpl resource;
                    URI proxyURI = ((InternalEObject)resolvedSchema).eProxyURI();
                    if (proxyURI != null && (resource = (XSDResourceImpl)mappingContext.getResourceSet().getResource(proxyURI.trimFragment(), true)) != null) {
                        schema = resource.getSchema();
                    }
                } else {
                    schema = resolvedSchema;
                }
            }
        }
        return schema;
    }

    private static String getTargetNamespace(XSDSchema startingSchema, XmlDocumentNode element, NamespaceContext context, MappingContext mappingContext) {
        String targetNS;
        String resolvedTNS;
        XSDFeature resolvedComponent;
        if (element == null) {
            return null;
        }
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent instanceof XSDFeature && (resolvedComponent = XsdUtil.getResolved((XSDFeature)((XSDFeature)xsdComponent))) != null && resolvedComponent != xsdComponent && !StringUtil.isEmpty((String)(resolvedTNS = resolvedComponent.getTargetNamespace()))) {
            return resolvedTNS;
        }
        XSDSchema schema = MappingDocumentFormatter.getTargetNamespaceSchema(xsdComponent, context, mappingContext);
        String string = targetNS = schema == null ? null : schema.getTargetNamespace();
        if (!StringUtil.isEmpty((String)targetNS)) {
            if (startingSchema != null && startingSchema.getTargetNamespace() == null) {
                if (MappingDocumentFormatter.hasMatchingIncludeDirective(schema, startingSchema)) {
                    return targetNS;
                }
                return null;
            }
            return targetNS;
        }
        XmlElement owner = MappingDocumentFormatter.getXmlElementContainer(element);
        return MappingDocumentFormatter.getTargetNamespace(startingSchema, (XmlDocumentNode)owner, context, mappingContext);
    }

    private static boolean hasMatchingIncludeDirective(XSDSchema schemaWithDirectives, XSDSchema schemaToCheck) {
        if (schemaWithDirectives != null && schemaToCheck != null) {
            Iterator iter = schemaWithDirectives.eContents().iterator();
            while (iter.hasNext()) {
                XSDInclude includeDeclaration;
                XSDSchema resolvedSchema;
                String includeSchemaLocation;
                Object content = iter.next();
                if (!(content instanceof XSDInclude) || (includeSchemaLocation = (resolvedSchema = (includeDeclaration = (XSDInclude)content).getResolvedSchema()).getSchemaLocation()) == null || !includeSchemaLocation.equals(schemaToCheck.getSchemaLocation())) continue;
                return true;
            }
        }
        return false;
    }

    private static XmlElement getXmlElementContainer(XmlDocumentNode element) {
        EObject owner;
        if (element == null) {
            return null;
        }
        for (owner = element.eContainer(); owner != null && !(owner instanceof XmlElement); owner = owner.eContainer()) {
        }
        return owner instanceof XmlElement ? (XmlElement)owner : null;
    }

    protected static boolean isPrefixRequired(XSDComponent component, XSDSchema schema, String schemaNamespaceUri) {
        boolean global = XsdUtil.isGlobal((XSDComponent)component);
        if (global) {
            return schemaNamespaceUri != null && schemaNamespaceUri.trim().length() != 0;
        }
        if (component instanceof XSDFeature) {
            XSDFeature feature = (XSDFeature)component;
            XSDFeature resolvedFeature = XsdUtil.getResolved((XSDFeature)feature);
            if (resolvedFeature != null && resolvedFeature != feature) {
                XSDSchema schemaForResolved = resolvedFeature.getSchema();
                String uri = schemaForResolved.getTargetNamespace();
                return MappingDocumentFormatter.isPrefixRequired((XSDComponent)resolvedFeature, resolvedFeature.getSchema(), uri);
            }
            XSDForm form = null;
            if (feature.isSetForm()) {
                form = feature.getForm();
            } else if (component instanceof XSDElementDeclaration) {
                form = schema.isSetElementFormDefault() ? schema.getElementFormDefault() : XSDForm.UNQUALIFIED_LITERAL;
            } else if (component instanceof XSDAttributeDeclaration) {
                form = schema.isSetAttributeFormDefault() ? schema.getAttributeFormDefault() : XSDForm.UNQUALIFIED_LITERAL;
            }
            if (form != null) {
                switch (form.getValue()) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected static String getSoapArrayType(XmlElement element, NamespaceContext context, MappingContext mappingContext) {
        XSDComponent xsdComponent = element.getXsdComponent();
        while (xsdComponent != null) {
            if (xsdComponent instanceof XSDComplexTypeDefinition) {
                XSDComplexTypeDefinition complexTypeDefn = (XSDComplexTypeDefinition)xsdComponent;
                if (XSDConstants.isAnyType((XSDTypeDefinition)complexTypeDefn)) {
                    return null;
                }
                String name = complexTypeDefn.getName();
                if ("Array".equals(name)) {
                    XSDSchema schema = complexTypeDefn.getSchema();
                    String targetNS = schema.getTargetNamespace();
                    if ("http://schemas.xmlsoap.org/soap/encoding/".equals(targetNS)) {
                        XSDTypeDefinition schemaCompOfChildren = XsdUtil.getCommonBaseTypeForContained((XSDComponent)element.getXsdComponent());
                        if (schemaCompOfChildren == null) {
                            String namespacePrefix = MappingDocumentFormatter.getSchemaNamespacePrefix(context);
                            return namespacePrefix + ":anyType[]";
                        }
                        String namespacePrefix = MappingDocumentFormatter.getNamespacePrefix((XSDComponent)schemaCompOfChildren, context, mappingContext, null, false, true);
                        if (namespacePrefix == null && XsdUtil.isBuiltInDatatype((XSDComponent)schemaCompOfChildren)) {
                            namespacePrefix = MappingDocumentFormatter.getSchemaNamespacePrefix(context);
                        }
                        String result = null;
                        result = namespacePrefix != null && namespacePrefix.trim().length() != 0 ? namespacePrefix + ":" + schemaCompOfChildren.getName() + "[]" : schemaCompOfChildren.getName() + "[]";
                        return result;
                    }
                } else {
                    xsdComponent = complexTypeDefn.getBaseTypeDefinition();
                }
            }
            if (xsdComponent instanceof XSDSimpleTypeDefinition) {
                return null;
            }
            if (xsdComponent instanceof XSDElementDeclaration) {
                XSDElementDeclaration elmDeclaration = (XSDElementDeclaration)xsdComponent;
                xsdComponent = elmDeclaration.getTypeDefinition();
            }
            if (xsdComponent instanceof XSDComplexTypeDefinition || xsdComponent instanceof XSDSimpleTypeDefinition || xsdComponent instanceof XSDElementDeclaration) continue;
            return null;
        }
        return null;
    }

    private static String getSoapEncodingNamespacePrefix(NamespaceContext context) {
        XmlNamespace namespace = context.getBestNamespace("http://schemas.xmlsoap.org/soap/encoding/");
        if (namespace != null) {
            String prefix = MappingDocumentFormatter.getNamespacePrefix(namespace);
            return prefix;
        }
        String defaultPrefix = "soap-enc";
        XmlNamespace newNsDecl = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
        newNsDecl.setPrefix("soap-enc");
        newNsDecl.setUri("http://schemas.xmlsoap.org/soap/encoding/");
        context.addXmlNamespace(newNsDecl);
        return "soap-enc";
    }

    private static String getSchemaInstanceNamespacePrefix(NamespaceContext context) {
        Iterator iter = context.getAllXmlNamespaces().iterator();
        while (iter.hasNext()) {
            XmlNamespace nsDecl = (XmlNamespace)iter.next();
            String uri = nsDecl.getUri();
            if (uri == null || !uri.startsWith("http://www.w3.org/") || !uri.endsWith("/XMLSchema-instance")) continue;
            return MappingDocumentFormatter.getNamespacePrefix(nsDecl);
        }
        String defaultPrefix = "xsi";
        XmlNamespace newNsDecl = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
        newNsDecl.setPrefix("xsi");
        newNsDecl.setUri("http://www.w3.org/2001/XMLSchema-instance");
        context.addXmlNamespace(newNsDecl);
        return "xsi";
    }

    public static String getSchemaNamespacePrefix(NamespaceContext context) {
        Iterator iter = context.getAllXmlNamespaces().iterator();
        while (iter.hasNext()) {
            XmlNamespace nsDecl = (XmlNamespace)iter.next();
            String uri = nsDecl.getUri();
            if (uri == null || !uri.startsWith("http://www.w3.org/") || !uri.endsWith("/XMLSchema")) continue;
            return MappingDocumentFormatter.getNamespacePrefix(nsDecl);
        }
        String defaultPrefix = "xsd";
        XmlNamespace newNsDecl = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
        newNsDecl.setPrefix("xsd");
        newNsDecl.setUri("http://www.w3.org/2001/XMLSchema");
        context.addXmlNamespace(newNsDecl);
        return "xsd";
    }

    protected String getFullName(EObject object) {
        SqlAspect sqlAspect = (SqlAspect)ModelerCore.getMetamodelRegistry().getMetamodelAspect(object, class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlAspect == null ? (class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlAspect = MappingDocumentFormatter.class$("com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect")) : class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlAspect);
        if (sqlAspect != null) {
            return sqlAspect.getFullName(object);
        }
        return null;
    }

    private void setProperty(MappingNode mappingNode, Integer name, Object value) {
        if (value != null) {
            mappingNode.setProperty(name, value);
        }
    }

    private void setProperty(MappingNode mappingNode, Integer name, boolean value) {
        mappingNode.setProperty(name, (Object)(value ? Boolean.TRUE : Boolean.FALSE));
    }

    private void setProperty(MappingNode mappingNode, Integer name, int value) {
        mappingNode.setProperty(name, (Object)new Integer(value));
    }

    private void setUnboundProperty(MappingNode mappingNode, Integer name, int value) {
        if (value == -1) {
            mappingNode.setProperty(name, (Object)MappingNodeConstants.CARDINALITY_UNBOUNDED);
        } else {
            mappingNode.setProperty(name, (Object)new Integer(value));
        }
    }

    private void setValueProperty(MappingNode mappingNode, XmlValueHolder valueHolder) {
        String value = valueHolder.getValue();
        if (value != null) {
            ValueType valueType = valueHolder.getValueType();
            switch (valueType.getValue()) {
                case 1: {
                    this.setProperty(mappingNode, MappingNodeConstants.Properties.DEFAULT_VALUE, value);
                    break;
                }
                case 2: {
                    this.setProperty(mappingNode, MappingNodeConstants.Properties.FIXED_VALUE, value);
                    break;
                }
            }
        }
    }

    public boolean isIndent() {
        return this.indent;
    }

    public boolean isNewlines() {
        return this.newlines;
    }

    public void setIndent(boolean b) {
        this.indent = b;
    }

    public void setNewlines(boolean b) {
        this.newlines = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ElementInfo {
        private String soapArrayType;
        private String xsiType;
        private final ElementInfo parentInfo;
        private final NamespaceContext namespaceContext;

        protected ElementInfo(NamespaceContext namespaceContext, ElementInfo parentInfo) {
            this.parentInfo = parentInfo;
            this.namespaceContext = namespaceContext;
        }

        public boolean isXsiTypeRequired() {
            if (this.soapArrayType != null) {
                return true;
            }
            return this.parentInfo != null && this.parentInfo.getSoapArrayType() != null;
        }

        public String getSoapArrayType() {
            return this.soapArrayType;
        }

        public String getXsiType() {
            return this.xsiType;
        }

        public void setSoapArrayType(String soapArrayType) {
            this.soapArrayType = soapArrayType;
        }

        public void setXsiType(String xsiType) {
            this.xsiType = xsiType;
        }

        public NamespaceContext getNamespaceContext() {
            return this.namespaceContext;
        }

        public XmlElement getXmlElement() {
            return this.namespaceContext.getXmlElement();
        }
    }
}

