/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.data.pool;

import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.data.DataPlugin;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.monitor.AliveStatus;
import com.metamatrix.data.monitor.ConnectionStatus;
import com.metamatrix.data.pool.ConnectionPoolException;
import com.metamatrix.data.pool.ConnectorIdentity;
import com.metamatrix.data.pool.SourceConnection;
import com.metamatrix.data.pool.SourceConnectionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConnectionPool {
    public static final String MAX_CONNECTIONS = "com.metamatrix.data.pool.max_connections";
    public static final String MAX_CONNECTIONS_FOR_EACH_ID = "com.metamatrix.data.pool.max_connections_for_each_id";
    public static final String LIVE_AND_UNUSED_TIME = "com.metamatrix.data.pool.live_and_unused_time";
    public static final String WAIT_FOR_SOURCE_TIME = "com.metamatrix.data.pool.wait_for_source_time";
    public static final String CLEANING_INTERVAL = "com.metamatrix.data.pool.cleaning_interval";
    public static final String ENABLE_SHRINKING = "com.metamatrix.data.pool.enable_shrinking";
    private static final String CTX_CONNECTOR = "CONNECTOR";
    private static final int USED = 1;
    private static final int UNUSED = 0;
    private int maxConnections = 5;
    private int maxConnectionsForEachID = 5;
    private int liveAndUnusedTime = 60;
    private int waitForSourceTime = 120000;
    private int cleaningInterval = 60;
    private boolean enableShrinking = true;
    private int testConnectInterval;
    private SourceConnectionFactory connectionFactory;
    private Map idConnections = new HashMap();
    private Map reverseIdConnections = new HashMap();
    private CleanUpThread cleaningThread;
    private Object lock;
    private int totalConnectionCount;
    private boolean shuttingDownPool;
    protected boolean lastConnectionAttemptFailed = false;
    private Exception lastConnectionAttemptException = null;
    private Date lastConnectionAttemptDate = null;
    private long lastTestConnectTime;

    public ConnectionPool(SourceConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.lock = new WriterPreferenceReadWriteLock();
        this.lastTestConnectTime = System.currentTimeMillis();
    }

    public void initialize(Properties poolProperties) throws ConnectionPoolException {
        ArgCheck.isNotNull((Object)poolProperties);
        String property = null;
        String value = null;
        try {
            property = MAX_CONNECTIONS;
            value = poolProperties.getProperty(property);
            if (value != null) {
                this.maxConnections = Integer.parseInt(value);
            }
            if ((value = poolProperties.getProperty(property = MAX_CONNECTIONS_FOR_EACH_ID)) != null) {
                this.maxConnectionsForEachID = Integer.parseInt(value);
            }
            if ((value = poolProperties.getProperty(property = LIVE_AND_UNUSED_TIME)) != null) {
                this.liveAndUnusedTime = Integer.parseInt(value);
            }
            if ((value = poolProperties.getProperty(property = WAIT_FOR_SOURCE_TIME)) != null) {
                this.waitForSourceTime = Integer.parseInt(value);
            }
            if ((value = poolProperties.getProperty(property = CLEANING_INTERVAL)) != null) {
                this.cleaningInterval = Integer.parseInt(value);
            }
            this.cleaningThread = new CleanUpThread(this.cleaningInterval * 1000);
            this.cleaningThread.setDaemon(true);
            this.cleaningThread.start();
            property = ENABLE_SHRINKING;
            value = poolProperties.getProperty(property);
            if (value != null) {
                this.enableShrinking = Boolean.valueOf(value);
            }
            value = poolProperties.getProperty("SourceConnectionTestInterval", "600");
            this.testConnectInterval = Integer.parseInt(value) * 1000;
            DataPlugin.Util.log(1, DataPlugin.Util.getString("ConnectionPool.Connection_pool_created_1"));
        }
        catch (NumberFormatException nfe) {
            throw new ConnectionPoolException(DataPlugin.Util.getString("ConnectionPool.The_value__6", (Object)value, (Object)new Integer(MAX_CONNECTIONS)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SourceConnection obtain(SecurityContext securityContext) throws ConnectionPoolException {
        long startTime = System.currentTimeMillis();
        ConnectorIdentity id = null;
        try {
            id = this.connectionFactory.createIdentity(securityContext);
            while (System.currentTimeMillis() - startTime <= (long)this.waitForSourceTime) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.shuttingDownPool) {
                        throw new ConnectionPoolException(DataPlugin.Util.getString("ConnectionPool.No_connection_pool_available._8"));
                    }
                    LinkedList[] connLists = (LinkedList[])this.idConnections.get(id);
                    if (connLists == null) {
                        connLists = new LinkedList[]{new LinkedList(), new LinkedList()};
                        this.idConnections.put(id, connLists);
                    }
                    if (connLists[0].size() > 0) {
                        ConnectionWrapper conn = (ConnectionWrapper)connLists[0].removeFirst();
                        if (conn.originalConnection.isAlive()) {
                            connLists[1].addLast(conn.originalConnection);
                            return conn.originalConnection;
                        }
                        --this.totalConnectionCount;
                        this.closeSourceConnection(conn.originalConnection, id);
                    } else if (this.totalConnectionCount < this.maxConnections && connLists[0].size() + connLists[1].size() < this.maxConnectionsForEachID) {
                        this.lastConnectionAttemptFailed = true;
                        SourceConnection connection = this.connectionFactory.createConnection(id);
                        this.lastConnectionAttemptFailed = false;
                        this.reverseIdConnections.put(connection, id);
                        ++this.totalConnectionCount;
                        connLists[1].addLast(connection);
                        if (LogManager.isMessageToBeRecorded((String)CTX_CONNECTOR, (int)6)) {
                            LogManager.logTrace((String)CTX_CONNECTOR, (String)DataPlugin.Util.getString("ConnectionPool.New_conn", (Object)id));
                        }
                        if (this.totalConnectionCount == this.maxConnections) {
                            DataPlugin.Util.log(2, DataPlugin.Util.getString("ConnectionPool.Max_conn_reached"));
                        } else {
                            if (connLists[0].size() + connLists[1].size() != this.maxConnectionsForEachID) return connection;
                            DataPlugin.Util.log(2, DataPlugin.Util.getString("ConnectionPool.Max_conn_per_id_reached"));
                        }
                        return connection;
                    }
                    try {
                        this.lock.wait(this.waitForSourceTime);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                }
            }
        }
        catch (ConnectorException e3) {
            this.lastConnectionAttemptException = e3;
            this.lastConnectionAttemptDate = new Date();
            throw new ConnectionPoolException((Throwable)e3);
        }
        String msg = null;
        if (this.totalConnectionCount >= this.maxConnectionsForEachID) {
            msg = DataPlugin.Util.getString("ConnectionPool.ExceededConnections", (Object)id, (Object)new Integer(this.maxConnectionsForEachID));
            throw new ConnectionPoolException(msg);
        }
        msg = DataPlugin.Util.getString("ConnectionPool.ExceededWait", (Object)id, (Object)new Integer(this.waitForSourceTime));
        throw new ConnectionPoolException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(SourceConnection connection) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.shuttingDownPool) {
                    return;
                }
                ConnectorIdentity id = (ConnectorIdentity)this.reverseIdConnections.get(connection);
                LinkedList[] connLists = (LinkedList[])this.idConnections.get(id);
                int releaseConnIndex = connLists[1].indexOf(connection);
                if (releaseConnIndex != -1) {
                    ConnectionWrapper conn = new ConnectionWrapper((SourceConnection)connLists[1].remove(releaseConnIndex));
                    connLists[0].addLast(conn);
                }
            }
            finally {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(SourceConnection connection) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.shuttingDownPool) {
                    return;
                }
                ConnectorIdentity id = (ConnectorIdentity)this.reverseIdConnections.get(connection);
                LinkedList[] connLists = (LinkedList[])this.idConnections.get(id);
                int errorConnIndex = connLists[1].indexOf(connection);
                if (errorConnIndex != -1) {
                    --this.totalConnectionCount;
                    SourceConnection conn = (SourceConnection)connLists[1].remove(errorConnIndex);
                    this.reverseIdConnections.remove(connection);
                    this.closeSourceConnection(conn, id);
                }
            }
            finally {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionStatus getStatus() {
        AliveStatus poolStatus;
        Object object = this.lock;
        synchronized (object) {
            try {
                poolStatus = this.checkStatusOfUsedConnections();
                if (poolStatus.equals((Object)AliveStatus.UNKNOWN)) {
                    poolStatus = this.checkStatusOfUnusedConnections();
                }
                if (poolStatus.equals((Object)AliveStatus.UNKNOWN)) {
                    poolStatus = this.testGetConnection();
                }
            }
            finally {
                this.lock.notifyAll();
            }
        }
        if (poolStatus.equals((Object)AliveStatus.UNKNOWN) && this.lastConnectionAttemptFailed) {
            poolStatus = AliveStatus.DEAD;
        }
        if (poolStatus.equals((Object)AliveStatus.DEAD) && !this.connectionFactory.isSingleIdentity()) {
            poolStatus = AliveStatus.UNKNOWN;
        }
        return new ConnectionStatus(poolStatus, this.getTotalConnectionCount(), this.lastConnectionAttemptException, this.lastConnectionAttemptDate);
    }

    private AliveStatus checkStatusOfUsedConnections() {
        Iterator connectionIDItr = this.idConnections.values().iterator();
        while (connectionIDItr.hasNext()) {
            LinkedList[] connLists = (LinkedList[])connectionIDItr.next();
            if (connLists[1].size() <= 0) continue;
            return AliveStatus.ALIVE;
        }
        return AliveStatus.UNKNOWN;
    }

    private AliveStatus checkStatusOfUnusedConnections() {
        Iterator connectionIDItr = this.idConnections.values().iterator();
        while (connectionIDItr.hasNext()) {
            LinkedList[] connLists = (LinkedList[])connectionIDItr.next();
            Iterator unusedConnItr = connLists[0].iterator();
            while (unusedConnItr.hasNext()) {
                SourceConnection theConn = ((ConnectionWrapper)unusedConnItr.next()).originalConnection;
                if (theConn.isAlive()) {
                    return AliveStatus.ALIVE;
                }
                if (!theConn.isFailed()) continue;
                return AliveStatus.DEAD;
            }
        }
        return AliveStatus.UNKNOWN;
    }

    private AliveStatus testGetConnection() {
        long time;
        if (this.connectionFactory.isSingleIdentity() && (time = System.currentTimeMillis()) - this.lastTestConnectTime > (long)this.testConnectInterval) {
            this.lastTestConnectTime = time;
            try {
                SourceConnection connection = this.obtain(null);
                boolean alive = connection.isAlive();
                this.release(connection);
                return alive ? AliveStatus.ALIVE : AliveStatus.DEAD;
            }
            catch (ConnectionPoolException e2) {
                return AliveStatus.DEAD;
            }
        }
        return AliveStatus.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        if (LogManager.isMessageToBeRecorded((String)CTX_CONNECTOR, (int)6)) {
            LogManager.logTrace((String)CTX_CONNECTOR, (String)DataPlugin.Util.getString("ConnectionPool.Shut_down"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.shuttingDownPool = true;
            this.lock.notifyAll();
        }
        this.cleaningThread.stopCleanup();
        this.cleaningThread.interrupt();
        Iterator iter = this.idConnections.values().iterator();
        while (iter.hasNext()) {
            LinkedList[] connLists = (LinkedList[])iter.next();
            Iterator iter2 = connLists[0].iterator();
            while (iter2.hasNext()) {
                ConnectionWrapper unusedConnection = (ConnectionWrapper)iter2.next();
                this.reverseIdConnections.remove(unusedConnection.originalConnection);
                try {
                    unusedConnection.originalConnection.closeSource();
                }
                catch (Exception e2) {}
            }
            iter2 = connLists[1].iterator();
            while (iter2.hasNext()) {
                SourceConnection usedConnection = (SourceConnection)iter2.next();
                try {
                    usedConnection.closeSource();
                }
                catch (Exception e3) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.shuttingDownPool) {
                    return;
                }
                Iterator iter = this.idConnections.values().iterator();
                while (iter.hasNext()) {
                    LinkedList[] connLists = (LinkedList[])iter.next();
                    Iterator iter2 = connLists[0].iterator();
                    while (iter2.hasNext()) {
                        ConnectionWrapper unusedConnection = (ConnectionWrapper)iter2.next();
                        if ((!this.enableShrinking || unusedConnection.getIdelTime() < this.liveAndUnusedTime) && unusedConnection.originalConnection.isAlive()) continue;
                        iter2.remove();
                        ConnectorIdentity id = (ConnectorIdentity)this.reverseIdConnections.remove(unusedConnection.originalConnection);
                        --this.totalConnectionCount;
                        this.closeSourceConnection(unusedConnection.originalConnection, id);
                    }
                }
            }
            finally {
                this.lock.notifyAll();
            }
        }
    }

    private boolean closeSourceConnection(SourceConnection connection, ConnectorIdentity id) {
        try {
            connection.closeSource();
            if (LogManager.isMessageToBeRecorded((String)CTX_CONNECTOR, (int)6)) {
                LogManager.logTrace((String)CTX_CONNECTOR, (String)DataPlugin.Util.getString("ConnectionPool.Removed_conn", (Object)id));
            }
            return true;
        }
        catch (Exception e2) {
            DataPlugin.Util.log(4, DataPlugin.Util.getString("ConnectionPool.Failed_close_a_connection__2", (Object)id));
            return false;
        }
    }

    final List getUsedConnections(SourceConnection connection) {
        ConnectorIdentity id = (ConnectorIdentity)this.reverseIdConnections.get(connection);
        LinkedList[] connLists = (LinkedList[])this.idConnections.get(id);
        if (connLists != null) {
            return connLists[1];
        }
        return Collections.EMPTY_LIST;
    }

    final List getUnusedConnections(SourceConnection connection) {
        ConnectorIdentity id = (ConnectorIdentity)this.reverseIdConnections.get(connection);
        LinkedList[] connLists = (LinkedList[])this.idConnections.get(id);
        if (connLists != null) {
            ArrayList<SourceConnection> result = new ArrayList<SourceConnection>();
            for (int i2 = 0; i2 < connLists[0].size(); ++i2) {
                result.add(((ConnectionWrapper)connLists[0].get(i2)).originalConnection);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    int getTotalConnectionCount() {
        return this.totalConnectionCount;
    }

    class CleanUpThread
    extends Thread {
        private long sleepTime;
        private boolean continueChecks = true;

        CleanUpThread(long sleepTime) {
            super("CleanUpThread");
            this.sleepTime = sleepTime;
        }

        public void stopCleanup() {
            this.continueChecks = false;
        }

        public void run() {
            while (this.continueChecks) {
                try {
                    CleanUpThread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ConnectionPool.this.cleanUp();
            }
        }
    }

    static class ConnectionWrapper {
        private SourceConnection originalConnection;
        private long timeReturnedToPool;

        ConnectionWrapper(SourceConnection originalConn) {
            this.originalConnection = originalConn;
            this.timeReturnedToPool = System.currentTimeMillis();
        }

        int getIdelTime() {
            return (int)(System.currentTimeMillis() - this.timeReturnedToPool) / 1000;
        }
    }
}

