/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.xml.factory;

import com.metamatrix.metamodels.internal.xml.XmlDocumentBuilderImpl;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.metamodels.xml.XmlDocumentFactory;
import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.XmlFragment;
import com.metamatrix.metamodels.xml.XmlRoot;
import com.metamatrix.metamodels.xml.util.XmlDocumentUtil;
import com.metamatrix.metamodels.xsd.XsdUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.mapping.factory.MappingClassFactory;
import com.metamatrix.modeler.internal.mapping.factory.ModelMapperFactory;
import com.metamatrix.modeler.internal.xml.factory.IDocumentsAndFragmentsPopulator;
import com.metamatrix.modeler.mapping.factory.ITreeToRelationalMapper;
import com.metamatrix.modeler.mapping.factory.MappingClassBuilderStrategy;
import com.metamatrix.modeler.xml.PluginConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class VirtualDocumentModelPopulator
implements IDocumentsAndFragmentsPopulator,
PluginConstants {
    private static final XmlFragment[] EMPTY_DOC_ARRAY = new XmlFragment[0];
    private static final String TXN_NAME = PluginConstants.Util.getString("VirtualDocumentModelPopulator.transactionName");
    private static final String DOCUMENT = PluginConstants.Util.getString("VirtualDocumentModelPopulator.document");
    private static final String FRAGMENT = PluginConstants.Util.getString("VirtualDocumentModelPopulator.fragment");
    private static final String DOC_ERROR_MSG = PluginConstants.Util.getString("VirtualDocumentModelPopulator.documentErrorMessage");
    private static final String FRAG_ERROR_MSG = PluginConstants.Util.getString("VirtualDocumentModelPopulator.fragmentErrorMessage");
    private IFile schemaModel;
    private Collection unhandledModelImports = new HashSet();
    private Collection allRootElements = new ArrayList();
    private Collection selectedRootElements = new ArrayList();
    private Collection allComplexTypes = new ArrayList();
    private Collection selectedComplexTypes = new ArrayList();
    private Set accumulatedDatatypes = new HashSet();
    private int estimatedNodeCount;
    private boolean doNotBuildDuplicates = false;

    public VirtualDocumentModelPopulator(IFile schemaModel) {
        this.schemaModel = schemaModel;
        this.populateLists();
    }

    public VirtualDocumentModelPopulator(List initialRootElements) {
        if (initialRootElements != null && !initialRootElements.isEmpty()) {
            EObject firstRoot = (EObject)initialRootElements.get(0);
            ModelResource mr = null;
            try {
                mr = ModelUtil.getModel((Object)firstRoot);
                if (mr != null) {
                    this.schemaModel = (IFile)mr.getUnderlyingResource();
                }
            }
            catch (ModelWorkspaceException theException) {
                // empty catch block
            }
        }
        this.setSelectedDocuments(initialRootElements);
    }

    private void populateLists() {
        try {
            URI uri = URI.createFileURI((String)this.schemaModel.getRawLocation().toString());
            Resource resource = ModelerCore.getModelContainer().getResource(uri, true);
            Iterator iter = resource.getContents().iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof XSDSchema)) continue;
                EList elements = ((XSDSchema)obj).getElementDeclarations();
                Iterator elemIter = elements.iterator();
                while (elemIter.hasNext()) {
                    XSDElementDeclaration elemDecl = (XSDElementDeclaration)elemIter.next();
                    this.allRootElements.add(elemDecl);
                }
                EList types = ((XSDSchema)obj).getTypeDefinitions();
                Iterator typeIter = types.iterator();
                while (typeIter.hasNext()) {
                    XSDTypeDefinition typeDefn = (XSDTypeDefinition)typeIter.next();
                    if (!(typeDefn instanceof XSDComplexTypeDefinition)) continue;
                    this.allComplexTypes.add(typeDefn);
                }
            }
        }
        catch (Exception e) {
            PluginConstants.Util.log((Throwable)e);
        }
    }

    public Object getItem() {
        return this.schemaModel;
    }

    public String getItemName() {
        return this.schemaModel.getFullPath().toOSString();
    }

    public Collection getInitialAvailableDocuments() {
        return this.allRootElements;
    }

    public Collection getSelectedDocuments() {
        return this.selectedRootElements;
    }

    public Collection getInitialAvailableFragments() {
        return this.allComplexTypes;
    }

    public Collection getSelectedFragments() {
        return this.selectedComplexTypes;
    }

    public void setSelectedDocuments(Collection selectedItems) {
        this.selectedRootElements = selectedItems;
    }

    public void setAccumulatedDatatypes(Set accumulatedDatatypes) {
        this.accumulatedDatatypes = accumulatedDatatypes;
    }

    public Set getAccumulatedDatatypes() {
        if (this.accumulatedDatatypes != null) {
            return this.accumulatedDatatypes;
        }
        return new HashSet(0);
    }

    public void setSelectedFragments(Collection selectedItems) {
        this.selectedComplexTypes = selectedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlFragment[] buildModel(ModelResource modelResource, boolean buildEntireDocument, boolean buildMappingClasses, MappingClassBuilderStrategy strategy, IProgressMonitor progressMonitor) {
        XmlDocumentBuilderImpl builder;
        IProgressMonitor monitor;
        ArrayList<Object> rv;
        block31: {
            block32: {
                block33: {
                    rv = new ArrayList<Object>(this.selectedComplexTypes.size() + this.selectedRootElements.size());
                    this.estimatedNodeCount = 0;
                    monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
                    try {
                        URI uri = URI.createFileURI((String)this.schemaModel.getRawLocation().toString());
                        Resource xsdResource = ModelerCore.getModelContainer().getResource(uri, true);
                        if (xsdResource != null) {
                            XsdUtil.resolveSchemaDirectives((Resource)xsdResource);
                        }
                    }
                    catch (Exception e) {
                        PluginConstants.Util.log((Throwable)e);
                    }
                    builder = new XmlDocumentBuilderImpl();
                    XmlDocumentFactory factory = XmlDocumentFactory.eINSTANCE;
                    ArrayList<XmlRoot> fragmentRoots = new ArrayList<XmlRoot>();
                    boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)TXN_NAME, (Object)this);
                    boolean succeeded = false;
                    try {
                        try {
                            String message;
                            XmlDocument document;
                            XmlRoot docRoot;
                            String suggestedName;
                            Resource resource = modelResource != null ? modelResource.getEmfResource() : null;
                            Iterator iter = this.selectedComplexTypes.iterator();
                            while (iter.hasNext() && !monitor.isCanceled()) {
                                XSDComplexTypeDefinition schemaComplexType = (XSDComplexTypeDefinition)iter.next();
                                try {
                                    suggestedName = schemaComplexType.getName() + FRAGMENT;
                                    if (this.shouldBuildDocument(modelResource, suggestedName)) {
                                        XmlFragment fragment = factory.createXmlFragment();
                                        fragment.setName(schemaComplexType.getName() + FRAGMENT);
                                        if (resource != null) {
                                            resource.getContents().add((Object)fragment);
                                        }
                                        docRoot = factory.createXmlRoot();
                                        docRoot.setName(schemaComplexType.getName());
                                        docRoot.setXsdComponent((XSDComponent)schemaComplexType);
                                        fragment.setRoot(docRoot);
                                        if (buildEntireDocument) {
                                            this.estimatedNodeCount += builder.buildDocument((XmlElement)docRoot, monitor);
                                            fragmentRoots.add(docRoot);
                                            if (buildMappingClasses) {
                                                this.buildMappingClasses(fragment, strategy);
                                                System.gc();
                                                Thread.yield();
                                            }
                                        } else {
                                            XmlDocumentUtil.setIncomplete((Object)docRoot, (boolean)true);
                                            ++this.estimatedNodeCount;
                                        }
                                        rv.add(fragment);
                                        continue;
                                    }
                                    document = this.getExistingDocument(modelResource, suggestedName);
                                    if (document == null) continue;
                                    rv.add(document);
                                }
                                catch (Exception e) {
                                    message = FRAG_ERROR_MSG + '\n' + schemaComplexType.getName();
                                    PluginConstants.Util.log(4, (Throwable)e, message);
                                }
                            }
                            System.gc();
                            Thread.yield();
                            iter = this.selectedRootElements.iterator();
                            while (iter.hasNext() && !monitor.isCanceled()) {
                                XSDElementDeclaration schemaRootElement = (XSDElementDeclaration)iter.next();
                                try {
                                    suggestedName = schemaRootElement.getName() + DOCUMENT;
                                    if (this.shouldBuildDocument(modelResource, suggestedName)) {
                                        document = factory.createXmlDocument();
                                        document.setName(schemaRootElement.getName() + DOCUMENT);
                                        if (resource != null) {
                                            ModelerCore.getModelEditor().addValue((Object)resource, (Object)document, resource.getContents());
                                        }
                                        docRoot = factory.createXmlRoot();
                                        docRoot.setName(schemaRootElement.getName());
                                        docRoot.setXsdComponent((XSDComponent)schemaRootElement);
                                        document.setRoot(docRoot);
                                        if (buildEntireDocument) {
                                            this.estimatedNodeCount += builder.buildDocument((XmlElement)docRoot, monitor);
                                            if (buildMappingClasses) {
                                                this.buildMappingClasses((XmlFragment)document, strategy);
                                                System.gc();
                                                Thread.yield();
                                            }
                                        } else {
                                            XmlDocumentUtil.setIncomplete((Object)docRoot, (boolean)true);
                                            ++this.estimatedNodeCount;
                                        }
                                        rv.add(document);
                                        continue;
                                    }
                                    document = this.getExistingDocument(modelResource, suggestedName);
                                    if (document == null) continue;
                                    rv.add(document);
                                }
                                catch (Exception e) {
                                    message = DOC_ERROR_MSG + '\n' + schemaRootElement.getName();
                                    PluginConstants.Util.log(4, (Throwable)e, message);
                                }
                            }
                            System.gc();
                            Thread.yield();
                            succeeded = true;
                        }
                        catch (ModelWorkspaceException e) {
                            PluginConstants.Util.log((Throwable)e);
                            Object var20_25 = null;
                            if (startedTxn) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            monitor.done();
                            System.gc();
                            Thread.yield();
                            break block31;
                        }
                        Object var20_24 = null;
                        if (!startedTxn) break block32;
                        if (!succeeded) break block33;
                    }
                    catch (Throwable throwable) {
                        Object var20_26 = null;
                        if (startedTxn) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        monitor.done();
                        System.gc();
                        Thread.yield();
                        throw throwable;
                    }
                    ModelerCore.commitTxn();
                    break block32;
                }
                ModelerCore.rollbackTxn();
            }
            monitor.done();
            System.gc();
            Thread.yield();
        }
        this.unhandledModelImports = builder.getUnhandledModelImports();
        builder = null;
        if (modelResource == null) return rv.toArray(EMPTY_DOC_ARRAY);
        try {
            modelResource.save(monitor, true);
            modelResource.getEmfResource().setModified(false);
            System.gc();
            Thread.yield();
            return rv.toArray(EMPTY_DOC_ARRAY);
        }
        catch (ModelWorkspaceException e) {
            PluginConstants.Util.log((Throwable)e);
        }
        return rv.toArray(EMPTY_DOC_ARRAY);
    }

    public Collection getUnhandledModelImports() {
        if (this.unhandledModelImports == null) {
            this.unhandledModelImports = new HashSet();
        }
        return this.unhandledModelImports;
    }

    public void buildMappingClasses(XmlFragment treeNode, MappingClassBuilderStrategy strategy) {
        XmlRoot docRoot = treeNode.getRoot();
        ITreeToRelationalMapper mapper = ModelMapperFactory.createModelMapper((EObject)treeNode);
        this.getAccumulatedDatatypes().addAll(new MappingClassFactory(mapper).generateMappingClasses((EObject)docRoot, strategy, true));
    }

    public int getLastEstimatedNodeCount() {
        return this.estimatedNodeCount;
    }

    public void setDoNotBuildDuplicates(boolean theDoNotBuildDuplicates) {
        this.doNotBuildDuplicates = theDoNotBuildDuplicates;
    }

    private boolean shouldBuildDocument(ModelResource modelResource, String newDocName) {
        if (newDocName != null && this.doNotBuildDuplicates) {
            List rootObjs = null;
            try {
                rootObjs = modelResource.getAllRootEObjects();
            }
            catch (ModelWorkspaceException theException) {
                PluginConstants.Util.log((Throwable)theException);
            }
            if (rootObjs != null && !rootObjs.isEmpty()) {
                Iterator iter = rootObjs.iterator();
                Object nextObj = null;
                while (iter.hasNext()) {
                    String docName;
                    nextObj = iter.next();
                    if (!(nextObj instanceof XmlDocument) || (docName = ModelerCore.getModelEditor().getName((EObject)nextObj)) == null || !docName.equalsIgnoreCase(newDocName)) continue;
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private XmlDocument getExistingDocument(ModelResource modelResource, String newDocName) {
        if (newDocName != null && this.doNotBuildDuplicates) {
            List rootObjs = null;
            try {
                rootObjs = modelResource.getAllRootEObjects();
            }
            catch (ModelWorkspaceException theException) {
                PluginConstants.Util.log((Throwable)theException);
            }
            if (rootObjs != null && !rootObjs.isEmpty()) {
                Iterator iter = rootObjs.iterator();
                Object nextObj = null;
                while (iter.hasNext()) {
                    String docName;
                    nextObj = iter.next();
                    if (!(nextObj instanceof XmlDocument) || (docName = ModelerCore.getModelEditor().getName((EObject)nextObj)) == null || !docName.equalsIgnoreCase(newDocName)) continue;
                    return nextObj;
                }
            }
        }
        return null;
    }
}

