/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class ElementOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";
    public static final String ANNOTATION_SOURCE__KEYWORDS = "keywords";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private ElementOperations() {
    }

    public static boolean validateNotOwnSelf(Element element, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (element.allOwnedElements().contains(element)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 1, UML2Plugin.INSTANCE.getString("_UI_Element_NotOwnSelf_diagnostic", ElementOperations.getMessageSubstitutions(context, element)), new Object[]{element}));
            }
        }
        return result;
    }

    public static boolean validateHasOwner(Element element, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (element.mustBeOwned() && element.getOwner() == null) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 2, UML2Plugin.INSTANCE.getString("_UI_Element_HasOwner_diagnostic", ElementOperations.getMessageSubstitutions(context, element)), new Object[]{element}));
            }
        }
        return result;
    }

    public static Set allOwnedElements(Element element) {
        EList ownedElements = element.getOwnedElements();
        HashSet allOwnedElements = new HashSet(ownedElements);
        Iterator i = ownedElements.iterator();
        while (i.hasNext()) {
            allOwnedElements.addAll(((Element)i.next()).allOwnedElements());
        }
        return Collections.unmodifiableSet(allOwnedElements);
    }

    public static boolean mustBeOwned(Element element) {
        return true;
    }

    public static Model getModel(Element element) {
        block12: {
            block11: {
                if (element == null) break block11;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.uml2.Model");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isInstance(element)) break block12;
            }
            return (Model)element;
        }
        EObject eContainer = element.eContainer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.uml2.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.isInstance(eContainer) ? ElementOperations.getModel((Element)eContainer) : null;
    }

    public static Package getNearestPackage(Element element) {
        block12: {
            block11: {
                if (element == null) break block11;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.uml2.Package");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isInstance(element)) break block12;
            }
            return (Package)element;
        }
        EObject eContainer = element.eContainer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.uml2.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.isInstance(eContainer) ? ElementOperations.getNearestPackage((Element)eContainer) : null;
    }

    public static void destroy(Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.valueOf(element));
        }
        Resource resource = element.eResource();
        if (resource != null) {
            ResourceSet resourceSet = resource.getResourceSet();
            UML2Operations.FilteredUsageCrossReferencer.Filter filter = new UML2Operations.FilteredUsageCrossReferencer.Filter(){

                public boolean accept(EStructuralFeature eStructuralFeature) {
                    return eStructuralFeature.isChangeable();
                }
            };
            TreeIterator allContents = ElementOperations.getAllContents((EObject)element, true, true);
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                Iterator settings = resourceSet == null ? UML2Operations.FilteredUsageCrossReferencer.find(eObject, resource, filter).iterator() : UML2Operations.FilteredUsageCrossReferencer.find(eObject, resourceSet, filter).iterator();
                while (settings.hasNext()) {
                    EcoreUtil.remove((EStructuralFeature.Setting)((EStructuralFeature.Setting)settings.next()), (Object)eObject);
                }
            }
        }
        EcoreUtil.remove((EObject)element);
    }

    public static Set getKeywords(Element element) {
        if (element == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(ElementOperations.safeGetEAnnotation(element, ANNOTATION_SOURCE__KEYWORDS).getDetails().keySet());
    }

    public static boolean hasKeyword(Element element, String keyword) {
        if (element == null) {
            return false;
        }
        if (ElementOperations.isEmpty(keyword)) {
            return false;
        }
        return ElementOperations.safeGetEAnnotation(element, ANNOTATION_SOURCE__KEYWORDS).getDetails().containsKey((Object)keyword);
    }

    public static void addKeyword(Element element, String keyword) {
        if (element == null) {
            throw new IllegalArgumentException(String.valueOf(element));
        }
        if (ElementOperations.isEmpty(keyword)) {
            throw new IllegalArgumentException(String.valueOf(keyword));
        }
        ElementOperations.getEAnnotation(element, ANNOTATION_SOURCE__KEYWORDS, true).getDetails().put((Object)keyword, null);
    }

    public static void removeKeyword(Element element, String keyword) {
        if (element == null) {
            throw new IllegalArgumentException(String.valueOf(element));
        }
        if (!ElementOperations.hasKeyword(element, keyword)) {
            throw new IllegalArgumentException(String.valueOf(keyword));
        }
        ElementOperations.safeGetEAnnotation(element, ANNOTATION_SOURCE__KEYWORDS).getDetails().removeKey((Object)keyword);
    }
}

