/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.dqp.internal.process.PreparedPlanCache;
import com.metamatrix.dqp.internal.process.QueryMetadataWrapper;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import com.metamatrix.dqp.message.MetaDataMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.metadata.ResultsMetadataConstants;
import com.metamatrix.dqp.metadata.ResultsMetadataDefaults;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.query.d.b;
import com.metamatrix.query.d.e;
import com.metamatrix.query.m.c;
import com.metamatrix.query.o.h.g;
import com.metamatrix.query.o.i.a;
import com.metamatrix.query.o.i.d;
import com.metamatrix.query.o.i.j;
import com.metamatrix.query.o.i.s;
import com.metamatrix.query.o.j.ag;
import com.metamatrix.query.o.j.f;
import com.metamatrix.query.o.j.l;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MetaDataProcessor {
    private MetadataService metadataService;
    private RequestManager requestManager;
    private com.metamatrix.query.m.e metadata;
    private PreparedPlanCache planCache;
    private ApplicationEnvironment env;
    private MetaDataMessage metadataMsg;
    private MetaDataMessage resolvedMsg;
    static /* synthetic */ Class class$com$metamatrix$common$types$XMLType;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public MetaDataProcessor(MetadataService metadataService, RequestManager requestManager, PreparedPlanCache planCache, ApplicationEnvironment env) {
        this.metadataService = metadataService;
        this.requestManager = requestManager;
        this.planCache = planCache;
        this.env = env;
    }

    MetaDataMessage processMessage(MetaDataMessage metadataMsg) throws QueryParserException, QueryResolverException, MetaMatrixComponentException {
        this.metadataMsg = metadataMsg;
        String vdbVersion = metadataMsg.getVdbVersion();
        String vdbName = metadataMsg.getVdbName();
        VDBService vdbService = (VDBService)this.env.findService("dqp.vdb");
        com.metamatrix.query.m.e md = this.metadataService.lookupMetadata(vdbName, vdbVersion);
        this.metadata = new QueryMetadataWrapper(md, vdbName, vdbVersion, vdbService);
        List multiModels = vdbService.getMultiSourceModels(vdbName, vdbVersion);
        if (multiModels != null && multiModels.size() > 0) {
            this.metadata = new MultiSourceMetadataWrapper(this.metadata, (Collection)multiModels);
        }
        this.resolvedMsg = new MetaDataMessage();
        if (metadataMsg.getPreparedSql() == null) {
            this.obtainMetadataForExistingCommand();
        } else {
            this.obtainMetadataForPreparedSql();
        }
        return this.resolvedMsg;
    }

    private void obtainMetadataForExistingCommand() throws MetaMatrixComponentException {
        RequestID requestID = this.metadataMsg.getRequestID();
        l originalCommand = this.requestManager.getOriginalCommand(requestID);
        this.getMetadataForCommand(originalCommand);
    }

    private void getMetadataForCommand(l originalCommand) throws MetaMatrixComponentException {
        Map[] columnMetadata = null;
        switch (originalCommand.gm()) {
            case 1: {
                if (originalCommand instanceof ag) {
                    if (((ag)originalCommand).jl()) {
                        columnMetadata = new Map[]{this.createXMLColumnMetadata((ag)originalCommand)};
                        break;
                    }
                    if (((ag)originalCommand).jw() != null) {
                        columnMetadata = this.createUpdateMetadata();
                        break;
                    }
                    columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
                    break;
                }
                columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
                break;
            }
            case 6: {
                columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                columnMetadata = this.createUpdateMetadata();
                break;
            }
            case 8: {
                columnMetadata = new Map[]{this.createXQueryColumnMetadata((f)originalCommand)};
                break;
            }
            default: {
                columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
            }
        }
        this.resolvedMsg.setMetadataMap(columnMetadata);
        this.resolvedMsg.setParameterCount(g.eu((com.metamatrix.query.o.d)originalCommand).size());
    }

    private Map[] createProjectedSymbolMetadata(l originalCommand) throws MetaMatrixComponentException {
        Map tempMetadata = originalCommand.f3();
        if (tempMetadata != null && tempMetadata.size() > 0) {
            com.metamatrix.query.m.g tempFacade = new com.metamatrix.query.m.g(this.metadata, new c(tempMetadata));
            this.metadata = tempFacade;
        }
        List projectedSymbols = originalCommand.gf();
        Map[] columnMetadata = new Map[projectedSymbols.size()];
        Iterator symbolIter = projectedSymbols.iterator();
        int i2 = 0;
        while (symbolIter.hasNext()) {
            j symbol = (j)symbolIter.next();
            String shortColumnName = symbol.a3();
            if (symbol instanceof d) {
                symbol = ((d)symbol).a4();
            }
            try {
                columnMetadata[i2] = this.createColumnMetadata(shortColumnName, symbol);
            }
            catch (QueryMetadataException e2) {
                throw new MetaMatrixComponentException((Throwable)e2);
            }
            ++i2;
        }
        return columnMetadata;
    }

    private void obtainMetadataForPreparedSql() throws QueryParserException, QueryResolverException, MetaMatrixComponentException {
        String sql = this.metadataMsg.getPreparedSql();
        l command = null;
        PreparedPlanCache.PreparedPlan plan = this.planCache.getPreparedPlan(this.metadataMsg.getClientConnection(), sql);
        if (plan != null) {
            command = plan.getCommand();
        } else {
            b parser = new b();
            e info = new e();
            info.b = this.metadataMsg.isDoubleQuotedVariablesAllowed();
            command = parser.d(sql, info);
            com.metamatrix.query.f.b.a(command, Collections.EMPTY_MAP, false, this.metadata, com.metamatrix.query.k.b.e());
        }
        this.getMetadataForCommand(command);
    }

    private Map createXMLColumnMetadata(ag xmlCommand) throws MetaMatrixComponentException {
        com.metamatrix.query.o.i.f doc = (com.metamatrix.query.o.i.f)xmlCommand.jy().f0().get(0);
        Map xmlMetadata = this.getDefaultColumn(this.metadataMsg.getVdbName(), this.metadataMsg.getVdbVersion(), doc.ak(), "xml", class$com$metamatrix$common$types$XMLType == null ? (class$com$metamatrix$common$types$XMLType = MetaDataProcessor.class$("com.metamatrix.common.types.XMLType")) : class$com$metamatrix$common$types$XMLType);
        xmlMetadata.put(ResultsMetadataConstants.DISPLAY_SIZE, ResultsMetadataDefaults.XML_COLUMN_LENGTH);
        return xmlMetadata;
    }

    private Map createXQueryColumnMetadata(f xqueryCommand) throws MetaMatrixComponentException {
        Map xqueryMetadata = this.getDefaultColumn(this.metadataMsg.getVdbName(), this.metadataMsg.getVdbVersion(), null, "xml", class$java$lang$String == null ? (class$java$lang$String = MetaDataProcessor.class$("java.lang.String")) : class$java$lang$String);
        xqueryMetadata.put(ResultsMetadataConstants.DISPLAY_SIZE, ResultsMetadataDefaults.XML_COLUMN_LENGTH);
        return xqueryMetadata;
    }

    private Map createColumnMetadata(String shortColumnName, j symbol) throws QueryMetadataException, MetaMatrixComponentException {
        if (symbol instanceof a) {
            return this.createElementMetadata(shortColumnName, (a)symbol);
        }
        if (symbol instanceof com.metamatrix.query.o.i.l) {
            return this.createAggregateMetadata(shortColumnName, (com.metamatrix.query.o.i.l)symbol);
        }
        return this.createTypedMetadata(shortColumnName, symbol);
    }

    private Map createElementMetadata(String shortColumnName, a symbol) throws QueryMetadataException, MetaMatrixComponentException {
        Object elementID = symbol.bf();
        HashMap<Integer, Object> column = new HashMap<Integer, Object>();
        column.put(ResultsMetadataConstants.AUTO_INCREMENTING, this.metadata.elementSupports(elementID, 8));
        column.put(ResultsMetadataConstants.CASE_SENSITIVE, this.metadata.elementSupports(elementID, 9));
        column.put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        Class type = symbol.ag();
        column.put(ResultsMetadataConstants.DATA_TYPE, DataTypeManager.getDataTypeName((Class)type));
        column.put(ResultsMetadataConstants.ELEMENT_LABEL, shortColumnName);
        column.put(ResultsMetadataConstants.ELEMENT_NAME, shortColumnName);
        com.metamatrix.query.o.i.f group = symbol.bc();
        if (group == null) {
            column.put(ResultsMetadataConstants.GROUP_NAME, null);
        } else {
            column.put(ResultsMetadataConstants.GROUP_NAME, this.metadata.getFullName(group.aq()));
        }
        boolean allowsNull = this.metadata.elementSupports(elementID, 4);
        boolean unknown = this.metadata.elementSupports(elementID, 10);
        Integer nullable = null;
        nullable = unknown ? ResultsMetadataConstants.NULL_TYPES.UNKNOWN : (allowsNull ? ResultsMetadataConstants.NULL_TYPES.NULLABLE : ResultsMetadataConstants.NULL_TYPES.NOT_NULL);
        column.put(ResultsMetadataConstants.NULLABLE, nullable);
        column.put(ResultsMetadataConstants.RADIX, new Integer(this.metadata.getRadix(elementID)));
        column.put(ResultsMetadataConstants.SCALE, new Integer(this.metadata.getScale(elementID)));
        int precision = this.getColumnPrecision(type, elementID);
        column.put(ResultsMetadataConstants.PRECISION, new Integer(precision));
        column.put(ResultsMetadataConstants.DISPLAY_SIZE, this.getColumnDisplaySize(precision, type, elementID));
        boolean comparable = this.metadata.elementSupports(elementID, 2);
        boolean likable = this.metadata.elementSupports(elementID, 1);
        Integer searchable = null;
        searchable = comparable ? (likable ? ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE : ResultsMetadataConstants.SEARCH_TYPES.ALLEXCEPTLIKE) : (likable ? ResultsMetadataConstants.SEARCH_TYPES.LIKE_ONLY : ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE);
        column.put(ResultsMetadataConstants.SEARCHABLE, searchable);
        column.put(ResultsMetadataConstants.SIGNED, new Boolean(this.metadata.elementSupports(elementID, 11)));
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, this.metadataMsg.getVdbName());
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION, this.metadataMsg.getVdbVersion());
        column.put(ResultsMetadataConstants.WRITABLE, new Boolean(this.metadata.elementSupports(elementID, 5)));
        return column;
    }

    private Map createAggregateMetadata(String shortColumnName, com.metamatrix.query.o.i.l symbol) throws QueryMetadataException, MetaMatrixComponentException {
        s expression = symbol.a6();
        String function = symbol.a8();
        if ((function.equals("MIN") || function.equals("MAX")) && expression instanceof a) {
            return this.createColumnMetadata(shortColumnName, (j)((a)expression));
        }
        return this.createTypedMetadata(shortColumnName, (j)symbol);
    }

    private Map createTypedMetadata(String shortColumnName, j symbol) throws MetaMatrixComponentException {
        return this.getDefaultColumn(this.metadataMsg.getVdbName(), this.metadataMsg.getVdbVersion(), null, shortColumnName, symbol.ag());
    }

    private Map[] createUpdateMetadata() {
        Map[] metadata = new Map[]{new HashMap()};
        metadata[0].put(ResultsMetadataConstants.AUTO_INCREMENTING, Boolean.FALSE);
        metadata[0].put(ResultsMetadataConstants.CASE_SENSITIVE, Boolean.FALSE);
        metadata[0].put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        metadata[0].put(ResultsMetadataConstants.DATA_TYPE, "integer");
        metadata[0].put(ResultsMetadataConstants.DISPLAY_SIZE, ResultsMetadataDefaults.getMaxDisplaySize((String)"integer"));
        metadata[0].put(ResultsMetadataConstants.ELEMENT_LABEL, null);
        metadata[0].put(ResultsMetadataConstants.ELEMENT_NAME, "count");
        metadata[0].put(ResultsMetadataConstants.GROUP_NAME, null);
        metadata[0].put(ResultsMetadataConstants.NULLABLE, ResultsMetadataConstants.NULL_TYPES.NOT_NULL);
        metadata[0].put(ResultsMetadataConstants.PRECISION, ResultsMetadataDefaults.getDefaultPrecision((String)"integer"));
        metadata[0].put(ResultsMetadataConstants.RADIX, new Integer(10));
        metadata[0].put(ResultsMetadataConstants.SCALE, new Integer(0));
        metadata[0].put(ResultsMetadataConstants.SEARCHABLE, ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE);
        metadata[0].put(ResultsMetadataConstants.SIGNED, Boolean.TRUE);
        metadata[0].put(ResultsMetadataConstants.WRITABLE, Boolean.FALSE);
        metadata[0].put(ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, this.metadataMsg.getVdbName());
        metadata[0].put(ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION, this.metadataMsg.getVdbVersion());
        return metadata;
    }

    private int getColumnPrecision(Class dataType, Object elementID) throws QueryMetadataException, MetaMatrixComponentException {
        if (!(class$java$lang$Number == null ? (class$java$lang$Number = MetaDataProcessor.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(dataType)) {
            int length = this.metadata.getElementLength(elementID);
            if (length > 0) {
                return length;
            }
        } else {
            int precision = this.metadata.getPrecision(elementID);
            if (precision > 0) {
                return precision;
            }
        }
        return ResultsMetadataDefaults.getDefaultPrecision((Class)dataType);
    }

    private Integer getColumnDisplaySize(int precision, Class dataType, Object elementID) throws QueryMetadataException, MetaMatrixComponentException {
        int length;
        if (elementID != null && dataType.equals(DataTypeManager.DefaultDataClasses.STRING)) {
            int length2 = this.metadata.getElementLength(elementID);
            if (length2 > 0) {
                return new Integer(length2);
            }
        } else if ((class$java$lang$Number == null ? (class$java$lang$Number = MetaDataProcessor.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(dataType)) {
            if (precision > 0) {
                int displayLength = precision;
                displayLength = precision + 1;
                if (dataType.equals(DataTypeManager.DefaultDataClasses.FLOAT) || dataType.equals(DataTypeManager.DefaultDataClasses.DOUBLE) || dataType.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
                    ++displayLength;
                }
                return new Integer(displayLength);
            }
        } else if (elementID != null && (dataType.equals(DataTypeManager.DefaultDataClasses.CLOB) || dataType.equals(DataTypeManager.DefaultDataClasses.BLOB) || dataType.equals(DataTypeManager.DefaultDataClasses.OBJECT)) && (length = this.metadata.getElementLength(elementID)) > 0) {
            return new Integer(length);
        }
        return ResultsMetadataDefaults.getMaxDisplaySize((Class)dataType);
    }

    public Map getDefaultColumn(String vdbName, String vdbVersion, String tableName, String columnName, Class javaType) throws MetaMatrixComponentException {
        HashMap<Integer, Object> column = new HashMap<Integer, Object>();
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, vdbName);
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION, vdbVersion);
        column.put(ResultsMetadataConstants.GROUP_NAME, tableName);
        column.put(ResultsMetadataConstants.ELEMENT_NAME, columnName);
        column.put(ResultsMetadataConstants.ELEMENT_LABEL, columnName);
        column.put(ResultsMetadataConstants.AUTO_INCREMENTING, Boolean.FALSE);
        column.put(ResultsMetadataConstants.CASE_SENSITIVE, Boolean.FALSE);
        column.put(ResultsMetadataConstants.NULLABLE, ResultsMetadataConstants.NULL_TYPES.NULLABLE);
        column.put(ResultsMetadataConstants.SEARCHABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE);
        column.put(ResultsMetadataConstants.WRITABLE, Boolean.TRUE);
        column.put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        column.put(ResultsMetadataConstants.DATA_TYPE, DataTypeManager.getDataTypeName((Class)javaType));
        column.put(ResultsMetadataConstants.RADIX, ResultsMetadataDefaults.DEFAULT_RADIX);
        column.put(ResultsMetadataConstants.SCALE, ResultsMetadataDefaults.DEFAULT_SCALE);
        column.put(ResultsMetadataConstants.SIGNED, Boolean.TRUE);
        column.put(ResultsMetadataConstants.PRECISION, ResultsMetadataDefaults.getDefaultPrecision((Class)javaType));
        column.put(ResultsMetadataConstants.DISPLAY_SIZE, ResultsMetadataDefaults.getMaxDisplaySize((Class)javaType));
        return column;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

