/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.tools.textimport.ui.wizards;

import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.UUID;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.NewModelProjectWorker;
import com.metamatrix.modeler.tools.textimport.ui.UiConstants;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractObjectProcessor
implements UiConstants {
    private static final String XMI_EXTENSION = "xmi";
    private static final String I18N_PREFIX = "AbstractObjectProcessor";
    private static final String SEPARATOR = ".";
    private static final String ADD_VALUE_ERROR = "AbstractObjectProcessor.addValueError";
    private static final String GET_MODEL_CONTENTS_ERROR = "AbstractObjectProcessor.getModelContentsError";
    private static final String MODEL_OBJ_NOTFOUND_ERROR = "AbstractObjectProcessor.modelObjectNotFound";
    private static final String MANY_ROWS_TITLE = AbstractObjectProcessor.getString("manyRowsTitle");
    private static final String MANY_ROWS_MESSAGE_KEY = "manyRowsMessage";
    private static final String COULD_NOT_PARSE_KEY = "couldNotParse.message";
    public static final String FINISHED = AbstractObjectProcessor.getString("finished");
    private static boolean isTransactionable = ModelerCore.getPlugin() != null;

    private static String getString(String id) {
        return UiConstants.Util.getString("AbstractObjectProcessor." + id);
    }

    private static String getString(String id, Object obj) {
        return UiConstants.Util.getString("AbstractObjectProcessor." + id, obj);
    }

    private static String getString(String key, Object value, Object value2) {
        return UiConstants.Util.getString(key, value, value2);
    }

    public boolean confirmLargeImport(Shell shell, int nRows, int threshold) {
        if (nRows > threshold) {
            String iSize = Integer.toString(nRows);
            return MessageDialog.openQuestion((Shell)shell, (String)MANY_ROWS_TITLE, (String)AbstractObjectProcessor.getString(MANY_ROWS_MESSAGE_KEY, iSize));
        }
        return true;
    }

    public void logParsingError(String rowString) {
        UiConstants.Util.log(2, AbstractObjectProcessor.getString(COULD_NOT_PARSE_KEY, rowString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection loadLinesFromFile(String fileStr) {
        ArrayList<String> rows = new ArrayList<String>();
        if (fileStr != null && fileStr.length() > 0) {
            FileReader fr = null;
            BufferedReader in = null;
            rows = new ArrayList();
            try {
                String str;
                fr = new FileReader(fileStr);
                in = new BufferedReader(fr);
                while ((str = in.readLine()) != null) {
                    if (str.length() <= 1) continue;
                    rows.add(str);
                }
            }
            catch (Exception e) {
                UiConstants.Util.log(4, (Throwable)e, AbstractObjectProcessor.getString("problemLoadingFileContentsMessage", fileStr));
            }
            finally {
                try {
                    fr.close();
                }
                catch (IOException e) {}
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return rows;
    }

    public void organizeImports(ModelResource modelResource) {
        if (modelResource != null) {
            ModelUtilities.rebuildImports((ModelResource)modelResource, (Object)this);
        }
    }

    public void addValue(Object owner, Object value, EList feature) {
        try {
            if (isTransactionable) {
                ModelerCore.getModelEditor().addValue(owner, value, feature);
            } else {
                feature.add(value);
            }
        }
        catch (ModelerCoreException err) {
            UiConstants.Util.log(4, (Throwable)err, AbstractObjectProcessor.getString(ADD_VALUE_ERROR, value, owner));
        }
    }

    public EList getModelResourceContents(ModelResource resource) {
        EList eList = null;
        try {
            eList = resource.getEmfResource().getContents();
        }
        catch (ModelWorkspaceException e) {
            UiConstants.Util.log(4, (Throwable)e, AbstractObjectProcessor.getString(GET_MODEL_CONTENTS_ERROR, resource));
        }
        return eList;
    }

    protected EObject getEObject(String modelObjectIdentifier) {
        EObject result = null;
        if (modelObjectIdentifier != null) {
            if (AbstractObjectProcessor.isStringifiedUUID(modelObjectIdentifier)) {
                result = this.lookupEObject(modelObjectIdentifier);
            } else if (!this.isModelResourcePath(modelObjectIdentifier)) {
                Path fullObjectPath = new Path(modelObjectIdentifier);
                ModelResource mr = this.findModelResource((IPath)fullObjectPath);
                int modelSegIndex = this.getExistingModelPathIndex(modelObjectIdentifier);
                if (mr != null) {
                    IPath relativePath = null;
                    try {
                        relativePath = fullObjectPath.removeFirstSegments(modelSegIndex);
                        result = ModelerCore.getModelEditor().findObjectByPath(mr, relativePath);
                    }
                    catch (ModelWorkspaceException err) {
                        UiConstants.Util.log(2, AbstractObjectProcessor.getString(MODEL_OBJ_NOTFOUND_ERROR, modelObjectIdentifier));
                    }
                }
            }
        }
        return result;
    }

    protected int getExistingModelPathIndex(String pathStr) {
        int modelIndex = -1;
        ModelResource mr = null;
        Path path = new Path(pathStr);
        int nSegs = path.segmentCount();
        if (nSegs > 1) {
            String projSeg = path.segment(0);
            IProject existProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projSeg);
            if (!existProj.exists()) {
                return -1;
            }
            if (existProj.exists()) {
                if (!existProj.isOpen()) {
                    try {
                        existProj.open((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        UiConstants.Util.log((Throwable)e);
                    }
                }
                for (int i = nSegs; i > 1; --i) {
                    IPath workingPath = path.uptoSegment(i);
                    String osPathStr = workingPath.toOSString();
                    if (osPathStr != null && osPathStr.length() > 0) {
                        mr = this.getModelResource(osPathStr);
                    }
                    if (mr == null) continue;
                    modelIndex = i;
                    break;
                }
            }
        }
        return modelIndex;
    }

    private EObject lookupEObject(String uuidString) {
        EObject result = null;
        if (uuidString != null) {
            try {
                result = (EObject)ModelerCore.getModelContainer().getEObjectFinder().find((Object)uuidString);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return result;
    }

    protected static boolean isStringifiedUUID(String str) {
        boolean result = false;
        String string = str;
        try {
            int index = string.indexOf("mmuuid:");
            if (index == -1 && (index = string.indexOf("mmuuid".toUpperCase() + ':')) != -1) {
                string = string.toLowerCase();
            }
            if (index != -1) {
                string = string.substring(index += "mmuuid:".length());
                UUID.stringToObject((String)string);
                result = true;
            } else {
                result = false;
            }
        }
        catch (InvalidIDException e) {
            result = false;
        }
        return result;
    }

    protected boolean isModelResourcePath(String location) {
        Path objectPath = new Path(location);
        IFile modelFile = ModelerCore.getWorkspace().getRoot().getFile((IPath)objectPath);
        IPath nextPath = null;
        if (modelFile != null && AbstractObjectProcessor.isModelProjectResource((IResource)modelFile) && !(modelFile instanceof IFolder)) {
            nextPath = objectPath.addFileExtension(XMI_EXTENSION);
            modelFile = ModelerCore.getWorkspace().getRoot().getFile(nextPath);
            ModelResource mr = ModelerCore.getModelWorkspace().findModelResource((IResource)modelFile);
            if (mr != null) {
                return true;
            }
        }
        return false;
    }

    protected ModelResource getModelResource(String location) {
        Path objectPath = new Path(location);
        IFile modelFile = ModelerCore.getWorkspace().getRoot().getFile((IPath)objectPath);
        IPath nextPath = null;
        if (modelFile != null && AbstractObjectProcessor.isModelProjectResource((IResource)modelFile) && !(modelFile instanceof IFolder)) {
            nextPath = objectPath.addFileExtension(XMI_EXTENSION);
            modelFile = ModelerCore.getWorkspace().getRoot().getFile(nextPath);
            ModelResource mr = ModelerCore.getModelWorkspace().findModelResource((IResource)modelFile);
            if (mr != null) {
                return mr;
            }
        }
        return null;
    }

    protected ModelResource findModelResource(IPath objectPath) {
        ModelResource mr = null;
        int nSeg = objectPath.segmentCount();
        IPath nextPath = null;
        for (int i = 0; i < nSeg - 1 && mr == null; ++i) {
            try {
                nextPath = objectPath.removeLastSegments(i + 1);
                IFile modelFile = ModelerCore.getWorkspace().getRoot().getFile(nextPath);
                if (modelFile == null || !AbstractObjectProcessor.isModelProjectResource((IResource)modelFile) || modelFile instanceof IFolder) continue;
                nextPath = nextPath.addFileExtension(XMI_EXTENSION);
                modelFile = ModelerCore.getWorkspace().getRoot().getFile(nextPath);
                mr = ModelerCore.getModelWorkspace().findModelResource((IResource)modelFile);
                continue;
            }
            catch (IllegalArgumentException ex) {
                String msg = AbstractObjectProcessor.getString("modelNotFound", objectPath);
                UiConstants.Util.log(2, msg);
            }
        }
        return mr;
    }

    private static boolean isModelProjectResource(IResource resource) {
        IProject proj;
        return resource != null && (proj = resource.getProject()) != null && ModelerCore.hasModelNature((IProject)proj);
    }

    protected IProject createProject(IProject nonExistingProject, IProgressMonitor monitor) {
        NewModelProjectWorker worker = new NewModelProjectWorker();
        if (!nonExistingProject.exists()) {
            return worker.createNewProject(null, nonExistingProject.getName(), monitor);
        }
        UiConstants.Util.log((Object)AbstractObjectProcessor.getString("projectExists", nonExistingProject.getName()));
        return null;
    }
}

