/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.impl;

import com.metamatrix.common.buffer.impl.ManagedBatch;
import com.metamatrix.common.log.LogManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BufferStats {
    public long memoryUsed;
    public long memoryFree;
    public int numTupleSources;
    public int numPersistentBatches;
    public int numPinnedBatches;
    public int numUnpinnedBatches;
    public long freeDiskSpace;
    public String sLocalDrive;
    public int pinRequests;
    public int pinSuccesses;
    public int pinnedFromMemory;
    public int numCleanings;
    public long totalCleaned;
    public List pinnedManagedBatches = new LinkedList();

    BufferStats() {
    }

    void log() {
        LogManager.logInfo("BUFFER_MGR", "\n");
        LogManager.logInfo("BUFFER_MGR", "BUFFER MANAGER STATS");
        LogManager.logInfo("BUFFER_MGR", "    memoryFree = " + this.memoryFree);
        LogManager.logInfo("BUFFER_MGR", "    memoryUsed = " + this.memoryUsed);
        LogManager.logInfo("BUFFER_MGR", "    numTupleSources = " + this.numTupleSources);
        LogManager.logInfo("BUFFER_MGR", "    numPersistentBatches = " + this.numPersistentBatches);
        LogManager.logInfo("BUFFER_MGR", "    numPinnedBatches = " + this.numPinnedBatches);
        LogManager.logInfo("BUFFER_MGR", "    numUnpinnedBatches = " + this.numUnpinnedBatches);
        LogManager.logInfo("BUFFER_MGR", "    pinRequests = " + this.pinRequests);
        double pinSuccessRate = this.pinRequests > 0 ? (double)this.pinSuccesses / (double)this.pinRequests * 100.0 : 100.0;
        LogManager.logInfo("BUFFER_MGR", "    pinSuccessRate = " + pinSuccessRate);
        double memoryHitRate = this.pinRequests > 0 ? (double)this.pinnedFromMemory / (double)this.pinRequests * 100.0 : 100.0;
        LogManager.logInfo("BUFFER_MGR", "    memoryHitRate = " + memoryHitRate);
        LogManager.logInfo("BUFFER_MGR", "    numCleanings = " + this.numCleanings);
        long avgCleaned = this.numCleanings > 0 ? this.totalCleaned / (long)this.numCleanings : 0L;
        LogManager.logInfo("BUFFER_MGR", "    avgCleaned = " + avgCleaned);
        if (this.freeDiskSpace > -1L) {
            LogManager.logInfo("BUFFER_MGR", "    free disk space (Kb) = " + this.freeDiskSpace);
        } else {
            LogManager.logInfo("BUFFER_MGR", "    free disk space UNKNOWN");
        }
        if (LogManager.isMessageToBeRecorded("BUFFER_MGR", 6)) {
            HashMap<List, Integer> stackTraces = new HashMap<List, Integer>();
            if (this.pinnedManagedBatches.isEmpty()) {
                return;
            }
            LogManager.logTrace("BUFFER_MGR", "\n");
            LogManager.logTrace("BUFFER_MGR", "    =========== Pinned Batch Details: ===========");
            int stackNumber = 1;
            Iterator it = this.pinnedManagedBatches.iterator();
            while (it.hasNext()) {
                ManagedBatch batch = (ManagedBatch)it.next();
                LogManager.logTrace("BUFFER_MGR", "    TupleSourceID: " + batch.getTupleSourceID() + " Begin: " + batch.getBeginRow() + " End: " + batch.getEndRow());
                Integer stackKey = (Integer)stackTraces.get(batch.getParentage());
                boolean isFirst = false;
                if (stackKey == null) {
                    isFirst = true;
                    stackKey = new Integer(stackNumber++);
                    stackTraces.put(batch.getParentage(), stackKey);
                }
                LogManager.logTrace("BUFFER_MGR", "        Pinned at: " + batch.getCallStackTimeStamp() + " by call# " + stackKey);
                if (!isFirst) continue;
                Iterator j = batch.getParentage().iterator();
                while (j.hasNext()) {
                    LogManager.logTrace("BUFFER_MGR", "        " + j.next());
                }
            }
        }
    }
}

