/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SPParameter
implements Serializable,
Cloneable {
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int INOUT = 3;
    public static final int RETURN_VALUE = 4;
    public static final int RESULT_SET = 5;
    private String name;
    private int parameterType = 1;
    private Class classType;
    private Expression expression;
    private int index;
    private List resultSetColumns;
    private List resultSetIDs;
    private Object metadataID;
    private boolean usingDefault;
    private int indexInSql = -1;

    public SPParameter(int index, Expression expression) {
        this.setIndex(index);
        this.setExpression(expression);
    }

    public SPParameter(int index, int parameterType, String name) {
        this.setIndex(index);
        this.setParameterType(parameterType);
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameterType(int parameterType) {
        if (parameterType < 1 || parameterType > 5) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0006", parameterType));
        }
        this.parameterType = parameterType;
    }

    public int getParameterType() {
        return this.parameterType;
    }

    public void setClassType(Class classType) {
        this.classType = classType;
    }

    public Class getClassType() {
        return this.classType;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Object getValue() {
        if (this.expression == null) {
            return null;
        }
        try {
            return ExpressionEvaluator.evaluate((Expression)this.expression, null, null);
        }
        catch (MetaMatrixException err) {
            throw new MetaMatrixRuntimeException((Throwable)err);
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void addResultSetColumn(String name, Class type, Object id) {
        if (this.resultSetColumns == null) {
            this.resultSetColumns = new ArrayList();
            this.resultSetIDs = new ArrayList();
        }
        ElementSymbol rsColumn = new ElementSymbol(name);
        rsColumn.setType(type);
        rsColumn.setMetadataID(id);
        this.resultSetColumns.add(rsColumn);
        this.resultSetIDs.add(id);
    }

    public List getResultSetColumns() {
        if (this.resultSetColumns == null) {
            return Collections.EMPTY_LIST;
        }
        return this.resultSetColumns;
    }

    public List getResultSetIDs() {
        if (this.resultSetIDs == null) {
            return Collections.EMPTY_LIST;
        }
        return this.resultSetIDs;
    }

    public ElementSymbol getResultSetColumn(int position) {
        if (this.resultSetColumns == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0009"));
        }
        if (--position >= 0 && position < this.resultSetColumns.size()) {
            return (ElementSymbol)this.resultSetColumns.get(position);
        }
        throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0010", (Object)new Integer(position + 1)));
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    public void setMetadataID(Object metadataID) {
        this.metadataID = metadataID;
    }

    public boolean isInternal() {
        return this.parameterType == 4 || this.parameterType == 5;
    }

    public void setIndexInSql(int index) {
        this.indexInSql = index;
    }

    public int getIndexInSql() {
        return this.indexInSql;
    }

    public ElementSymbol getParameterSymbol() {
        ElementSymbol symbol = new ElementSymbol(this.name);
        symbol.setType(this.classType);
        symbol.setMetadataID(this.metadataID);
        return symbol;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SPParameter)) {
            return false;
        }
        SPParameter other = (SPParameter)obj;
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getMetadataID() != null && other.getMetadataID() != null) {
            return this.getMetadataID().equals(other.getMetadataID());
        }
        return true;
    }

    public int hashCode() {
        return this.index;
    }

    public Object clone() {
        SPParameter copy = new SPParameter(this.index, this.parameterType, this.name);
        copy.setClassType(this.classType);
        if (this.expression != null) {
            copy.setExpression((Expression)this.expression.clone());
        }
        if (this.indexInSql != -1) {
            copy.setIndexInSql(this.indexInSql);
        }
        if (this.resultSetColumns != null) {
            Iterator iter = this.resultSetColumns.iterator();
            Iterator idIter = this.resultSetIDs.iterator();
            while (iter.hasNext()) {
                ElementSymbol column = (ElementSymbol)iter.next();
                copy.addResultSetColumn(column.getName(), column.getType(), idIter.next());
            }
        }
        copy.setMetadataID(this.getMetadataID());
        copy.setUsingDefault(this.usingDefault);
        return copy;
    }

    public String toString() {
        if (this.expression != null) {
            return this.expression.toString();
        }
        return "?";
    }

    public boolean isUsingDefault() {
        return this.usingDefault;
    }

    public void setUsingDefault(boolean usingDefault) {
        this.usingDefault = usingDefault;
    }
}

