/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.builder.translator;

import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.builder.BuilderConstants;
import com.metamatrix.metamodels.builder.MetamodelBuilderPlugin;
import com.metamatrix.metamodels.builder.MetamodelEntityRecord;
import com.metamatrix.metamodels.builder.ModelRecord;
import com.metamatrix.metamodels.builder.translator.ResultSetTranslator;
import com.metamatrix.metamodels.internal.builder.util.BuilderUtil;
import com.metamatrix.metamodels.internal.builder.util.MetaClassUriHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;

public class RecordGenerator
implements BuilderConstants {
    private static final String MODEL_TYPE = "ModelType";
    private static final String MODEL_SUBTYPE = "SubType";
    private static final String MODEL_NAME = "Name";
    private static final String MODEL_NAME_IN_SOURCE = "NameInSource";
    private static final String MODEL_DESC = "Description";
    private static final String MODEL_EXT_PACKAGE = "ExtPackage";
    private static final String METACLASS_URI = "MetaClassUri";
    private static final String PARENT_PATH = "ParentPath";
    private static final String PARENT_METACLASS_URI = "ParentMetaClassUri";
    private static final String ENTITY_NAME = "name";
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$metamodels$builder$translator$RecordGenerator == null ? (class$com$metamatrix$metamodels$builder$translator$RecordGenerator = RecordGenerator.class$("com.metamatrix.metamodels.builder.translator.RecordGenerator")) : class$com$metamatrix$metamodels$builder$translator$RecordGenerator));
    static /* synthetic */ Class class$com$metamatrix$metamodels$builder$translator$RecordGenerator;

    private static String getString(String id) {
        return BuilderConstants.UTIL.getString(I18N_PREFIX + id);
    }

    private static String getString(String id, Object param1, Object param2) {
        return BuilderConstants.UTIL.getString(I18N_PREFIX + id, param1, param2);
    }

    public static List generateModelRecords(ResultSet resultSet, String locationPathStr, MultiStatus status, IProgressMonitor monitor) throws SQLException {
        boolean builderDebugEnabled = MetamodelBuilderPlugin.Util.isDebugEnabled("metamodelBuilder");
        List mapList = ResultSetTranslator.translate((ResultSet)resultSet);
        ArrayList<ModelRecord> recordList = new ArrayList<ModelRecord>(mapList.size());
        Iterator iter = mapList.iterator();
        while (iter.hasNext()) {
            ModelRecord record;
            block7: {
                Map recordMap = (Map)iter.next();
                String modelType = (String)recordMap.get(MODEL_TYPE);
                String subType = (String)recordMap.get(MODEL_SUBTYPE);
                String name = (String)recordMap.get(MODEL_NAME);
                String nameInSource = (String)recordMap.get(MODEL_NAME_IN_SOURCE);
                String desc = (String)recordMap.get(MODEL_DESC);
                String extPackage = (String)recordMap.get(MODEL_EXT_PACKAGE);
                record = null;
                if (modelType == null || name == null) {
                    String msg = RecordGenerator.getString("unableToCreateModelRecord");
                    BuilderUtil.addStatus((MultiStatus)status, (int)2, (String)msg);
                    if (builderDebugEnabled) {
                        MetamodelBuilderPlugin.Util.log(2, msg);
                    }
                } else {
                    try {
                        record = new ModelRecord(modelType, subType, name, nameInSource, desc, extPackage);
                    }
                    catch (IllegalArgumentException ex) {
                        String msg = RecordGenerator.getString("unableToCreateModelRecord");
                        BuilderUtil.addStatus((MultiStatus)status, (int)2, (String)msg, (Throwable)ex);
                        if (!builderDebugEnabled) break block7;
                        MetamodelBuilderPlugin.Util.log(2, msg);
                    }
                }
            }
            if (record != null) {
                record.setLocationPath(locationPathStr);
                recordList.add(record);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        return recordList;
    }

    public static List generateEntityRecords(ResultSet resultSet, MultiStatus status, IProgressMonitor monitor) throws SQLException {
        boolean builderDebugEnabled = MetamodelBuilderPlugin.Util.isDebugEnabled("metamodelBuilder");
        List mapList = ResultSetTranslator.translate((ResultSet)resultSet);
        ArrayList<MetamodelEntityRecord> recordList = new ArrayList<MetamodelEntityRecord>(mapList.size());
        Iterator iter = mapList.iterator();
        while (iter.hasNext()) {
            MetamodelEntityRecord record;
            block9: {
                Map recordMap = (Map)iter.next();
                String metaClassUri = (String)recordMap.remove(METACLASS_URI);
                String parentPath = (String)recordMap.remove(PARENT_PATH);
                String parentMetaclassUri = (String)recordMap.remove(PARENT_METACLASS_URI);
                String name = (String)recordMap.get(ENTITY_NAME);
                record = null;
                if (metaClassUri == null || parentPath == null) {
                    String metaClass = "NullMetaClass";
                    if (metaClassUri != null) {
                        metaClass = MetaClassUriHelper.getEClassName((String)metaClassUri);
                    }
                    String msg = RecordGenerator.getString("unableToCreateEntityRecord", metaClass, name);
                    BuilderUtil.addStatus((MultiStatus)status, (int)2, (String)msg);
                    if (builderDebugEnabled) {
                        MetamodelBuilderPlugin.Util.log(2, msg);
                    }
                } else {
                    try {
                        record = new MetamodelEntityRecord(metaClassUri, parentPath, parentMetaclassUri, recordMap);
                    }
                    catch (IllegalArgumentException ex) {
                        String metaClass = "NullMetaClass";
                        if (metaClassUri != null) {
                            metaClass = MetaClassUriHelper.getEClassName((String)metaClassUri);
                        }
                        String msg = RecordGenerator.getString("unableToCreateEntityRecord", metaClass, name);
                        BuilderUtil.addStatus((MultiStatus)status, (int)2, (String)msg, (Throwable)ex);
                        if (!builderDebugEnabled) break block9;
                        MetamodelBuilderPlugin.Util.log(2, msg);
                    }
                }
            }
            if (record != null) {
                recordList.add(record);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        return recordList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

