/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.Dependency;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Namespace;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class NamedElementOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";
    protected static final String LABEL_KEY_PREFIX = "_label_";

    private NamedElementOperations() {
    }

    public static boolean validateNoName(NamedElement namedElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (NamedElementOperations.isEmpty(namedElement.getName())) {
            result = NamedElementOperations.isEmpty(namedElement.qualifiedName());
        } else {
            Iterator allNamespaces = namedElement.allNamespaces().iterator();
            while (allNamespaces.hasNext()) {
                if (!NamedElementOperations.isEmpty(((Namespace)allNamespaces.next()).getName())) continue;
                result = NamedElementOperations.isEmpty(namedElement.qualifiedName());
                break;
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 8, UML2Plugin.INSTANCE.getString("_UI_NamedElement_NoName_diagnostic", NamedElementOperations.getMessageSubstitutions(context, namedElement)), new Object[]{namedElement}));
        }
        return result;
    }

    public static boolean validateQualifiedName(NamedElement namedElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        String name = namedElement.getName();
        if (!NamedElementOperations.isEmpty(name)) {
            StringBuffer qualifiedName = new StringBuffer(name);
            Iterator allNamespaces = namedElement.allNamespaces().iterator();
            while (allNamespaces.hasNext()) {
                String namespaceName = ((Namespace)allNamespaces.next()).getName();
                if (NamedElementOperations.isEmpty(namespaceName)) {
                    return result;
                }
                qualifiedName.insert(0, namedElement.separator());
                qualifiedName.insert(0, namespaceName);
            }
            if (!qualifiedName.toString().equals(namedElement.qualifiedName())) {
                result = false;
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 8, UML2Plugin.INSTANCE.getString("_UI_NamedElement_QualifiedName_diagnostic", NamedElementOperations.getMessageSubstitutions(context, namedElement)), new Object[]{namedElement}));
                }
            }
        }
        return result;
    }

    public static List allNamespaces(NamedElement namedElement) {
        ArrayList<Namespace> allNamespaces = new ArrayList<Namespace>();
        Namespace namespace = namedElement.getNamespace();
        if (namespace != null) {
            allNamespaces.addAll(namespace.allNamespaces());
            allNamespaces.add(0, namespace);
        }
        return Collections.unmodifiableList(allNamespaces);
    }

    public static boolean isDistinguishableFrom(NamedElement namedElement, NamedElement n, Namespace ns) {
        EClass eClass = namedElement.eClass();
        EClass nEClass = n.eClass();
        if (nEClass.isSuperTypeOf(eClass) || eClass.isSuperTypeOf(nEClass)) {
            Iterator namesOfMember = ns.getNamesOfMember(namedElement).iterator();
            while (namesOfMember.hasNext()) {
                if (!ns.getNamesOfMember(n).contains(namesOfMember.next())) continue;
                return false;
            }
        }
        return true;
    }

    public static String separator(NamedElement namedElement) {
        return "::";
    }

    public static String qualifiedName(NamedElement namedElement) {
        String name = namedElement.getName();
        if (NamedElementOperations.isEmpty(name)) {
            return "";
        }
        StringBuffer qualifiedName = new StringBuffer(name);
        Iterator allNamespaces = namedElement.allNamespaces().iterator();
        while (allNamespaces.hasNext()) {
            String namespaceName = ((Namespace)allNamespaces.next()).getName();
            if (NamedElementOperations.isEmpty(namespaceName)) {
                return "";
            }
            qualifiedName.insert(0, namedElement.separator());
            qualifiedName.insert(0, namespaceName);
        }
        return qualifiedName.toString();
    }

    public static boolean validateVisibilityNeedsOwnership(NamedElement namedElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (namedElement.getNamespace() == null && namedElement.eIsSet((EStructuralFeature)UML2Package.eINSTANCE.getNamedElement_Visibility())) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 10, UML2Plugin.INSTANCE.getString("_UI_NamedElement_VisibilityNeedsOwnership_diagnostic", NamedElementOperations.getMessageSubstitutions(context, namedElement)), new Object[]{namedElement}));
            }
        }
        return result;
    }

    public static String getLabel(NamedElement namedElement) {
        return NamedElementOperations.getLabel(namedElement, true);
    }

    public static String getLabel(NamedElement namedElement, boolean localize) {
        String label = "";
        if (namedElement != null) {
            label = UML2Operations.getString((EObject)namedElement, LABEL_KEY_PREFIX + NamedElementOperations.getValidIdentifier(namedElement.getQualifiedName().replace(':', '_')), namedElement.getName(), localize);
        }
        return label;
    }

    public static Dependency createDependency(NamedElement client, NamedElement supplier) {
        if (client == null) {
            throw new IllegalArgumentException(String.valueOf(client));
        }
        Package package_ = client.getNearestPackage();
        if (package_ == null) {
            throw new IllegalArgumentException(String.valueOf(client));
        }
        if (supplier == null) {
            throw new IllegalArgumentException(String.valueOf(supplier));
        }
        Dependency dependency = (Dependency)package_.createOwnedMember(UML2Package.eINSTANCE.getDependency());
        dependency.getClients().add((Object)client);
        dependency.getSuppliers().add((Object)supplier);
        return dependency;
    }
}

